/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientPartitionAdvisor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.SingleHopQuarterPartitionResolver;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FixedPRSinglehopDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    private static final String PR_NAME = "fixed_single_hop_pr";
    private static Cache cache = null;
    private static Locator locator = null;
    private static Region region = null;
    private static final Date q1dateJan1 = new Date(2010, 0, 1);
    private static final Date q1dateFeb1 = new Date(2010, 1, 1);
    private static final Date q1dateMar1 = new Date(2010, 2, 1);
    private static final Date q2dateApr1 = new Date(2010, 3, 1);
    private static final Date q2dateMay1 = new Date(2010, 4, 1);
    private static final Date q2dateJun1 = new Date(2010, 5, 1);
    private static final Date q3dateJuly1 = new Date(2010, 6, 1);
    private static final Date q3dateAug1 = new Date(2010, 7, 1);
    private static final Date q3dateSep1 = new Date(2010, 8, 1);
    private static final Date q4dateOct1 = new Date(2010, 9, 1);
    private static final Date q4dateNov1 = new Date(2010, 10, 1);
    private static final Date q4dateDec1 = new Date(2010, 11, 1);

    public FixedPRSinglehopDUnitTest(String name) {
        super(name);
    }

    public void testNoClientConnected() {
        Host host = Host.getHost(0);
        VM accessorServer = host.getVM(0);
        VM datastoreServer = host.getVM(1);
        VM peer1 = host.getVM(2);
        VM peer2 = host.getVM(3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (int)3));
        datastoreServer.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{false, fpaList});
        fpaList.clear();
        accessorServer.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{true, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (int)3));
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "createPeer", new Object[]{false, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (int)3));
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "createPeer", new Object[]{false, fpaList});
        datastoreServer.invoke(FixedPRSinglehopDUnitTest.class, "putIntoPartitionedRegions");
        accessorServer.invoke(FixedPRSinglehopDUnitTest.class, "putIntoPartitionedRegions");
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "putIntoPartitionedRegions");
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "putIntoPartitionedRegions");
        datastoreServer.invoke(FixedPRSinglehopDUnitTest.class, "getFromPartitionedRegions");
        accessorServer.invoke(FixedPRSinglehopDUnitTest.class, "getFromPartitionedRegions");
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "getFromPartitionedRegions");
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "getFromPartitionedRegions");
        datastoreServer.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyMetadata");
        accessorServer.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyMetadata");
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyMetadata");
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyMetadata");
        datastoreServer.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyStaticData");
        accessorServer.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyStaticData");
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyStaticData");
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "verifyEmptyStaticData");
    }

    public void testClientConnectedToAccessors() {
        Host host = Host.getHost(0);
        VM accessorServer1 = host.getVM(0);
        VM accessorServer2 = host.getVM(1);
        VM peer1 = host.getVM(2);
        VM peer2 = host.getVM(3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        Integer port0 = (Integer)accessorServer1.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{true, fpaList});
        Integer port1 = (Integer)accessorServer2.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{true, fpaList});
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3));
        peer1.invoke(FixedPRSinglehopDUnitTest.class, "createPeer", new Object[]{false, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3));
        peer2.invoke(FixedPRSinglehopDUnitTest.class, "createPeer", new Object[]{false, fpaList});
        FixedPRSinglehopDUnitTest.createClient(port0, port1);
        FixedPRSinglehopDUnitTest.putIntoPartitionedRegions();
        FixedPRSinglehopDUnitTest.getFromPartitionedRegions();
        FixedPRSinglehopDUnitTest.verifyEmptyMetadata();
        FixedPRSinglehopDUnitTest.verifyEmptyStaticData();
    }

    public void test_MetadataContents() {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)false, (int)3));
        Integer port1 = (Integer)server1.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{false, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)false, (int)3));
        Integer port2 = (Integer)server2.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{false, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)false, (int)3));
        Integer port3 = (Integer)server3.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{false, fpaList});
        fpaList.clear();
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)true, (int)3));
        fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)false, (int)3));
        Integer port4 = (Integer)server4.invoke(FixedPRSinglehopDUnitTest.class, "createServer", new Object[]{false, fpaList});
        FixedPRSinglehopDUnitTest.createClient(port1, port2, port3, port4);
        FixedPRSinglehopDUnitTest.putIntoPartitionedRegions();
        FixedPRSinglehopDUnitTest.getFromPartitionedRegions();
        server1.invoke(FixedPRSinglehopDUnitTest.class, "printView");
        server2.invoke(FixedPRSinglehopDUnitTest.class, "printView");
        server3.invoke(FixedPRSinglehopDUnitTest.class, "printView");
        server4.invoke(FixedPRSinglehopDUnitTest.class, "printView");
        int totalBucketOnServer = 0;
        totalBucketOnServer += ((Integer)server1.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
        totalBucketOnServer += ((Integer)server2.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
        totalBucketOnServer += ((Integer)server3.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
        this.verifyMetadata(totalBucketOnServer += ((Integer)server4.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue(), 2);
        FixedPRSinglehopDUnitTest.updateIntoSinglePR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_FPAmetadataFetch() {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        Boolean simpleFPR = false;
        int portLocator = AvailablePort.getRandomAvailablePort((int)0);
        String hostLocator = FixedPRSinglehopDUnitTest.getServerHostName(server1.getHost());
        String locator = hostLocator + "[" + portLocator + "]";
        server3.invoke(FixedPRSinglehopDUnitTest.class, "startLocatorInVM", new Object[]{portLocator});
        try {
            ArrayList<FixedPartitionAttributes> fpaList = new ArrayList<FixedPartitionAttributes>();
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)true, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)false, (int)3));
            Integer port1 = (Integer)server1.invoke(FixedPRSinglehopDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, fpaList, simpleFPR});
            fpaList.clear();
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)true, (int)3));
            Integer port2 = (Integer)server2.invoke(FixedPRSinglehopDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, fpaList, simpleFPR});
            fpaList.clear();
            FixedPRSinglehopDUnitTest.createClientWithLocator(hostLocator, portLocator);
            FixedPRSinglehopDUnitTest.putIntoPartitionedRegionsThreeQs();
            FixedPRSinglehopDUnitTest.getFromPartitionedRegionsFor3Qs();
            FixedPRSinglehopDUnitTest.pause(2000);
            server1.invoke(FixedPRSinglehopDUnitTest.class, "printView");
            server2.invoke(FixedPRSinglehopDUnitTest.class, "printView");
            int totalBucketOnServer = 0;
            totalBucketOnServer += ((Integer)server1.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
            int currentRedundancy = 1;
            this.verifyMetadata(totalBucketOnServer += ((Integer)server2.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue(), currentRedundancy);
            FixedPRSinglehopDUnitTest.updateIntoSinglePRFor3Qs();
            fpaList.clear();
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q4", (boolean)true, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q2", (boolean)true, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q1", (boolean)false, (int)3));
            fpaList.add(FixedPartitionAttributes.createFixedPartition((String)"Q3", (boolean)false, (int)3));
            Integer port4 = (Integer)server4.invoke(FixedPRSinglehopDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, fpaList, simpleFPR});
            FixedPRSinglehopDUnitTest.pause(2000);
            FixedPRSinglehopDUnitTest.putIntoPartitionedRegions();
            FixedPRSinglehopDUnitTest.getFromPartitionedRegions();
            FixedPRSinglehopDUnitTest.pause(2000);
            server1.invoke(FixedPRSinglehopDUnitTest.class, "printView");
            server2.invoke(FixedPRSinglehopDUnitTest.class, "printView");
            server4.invoke(FixedPRSinglehopDUnitTest.class, "printView");
            totalBucketOnServer = 0;
            totalBucketOnServer += ((Integer)server1.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
            totalBucketOnServer += ((Integer)server2.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
            totalBucketOnServer += ((Integer)server4.invoke(FixedPRSinglehopDUnitTest.class, "totalNumBucketsCreated")).intValue();
            FixedPRSinglehopDUnitTest.updateIntoSinglePR();
        }
        finally {
            server3.invoke(FixedPRSinglehopDUnitTest.class, "stopLocator");
        }
    }

    public static int createServer(boolean isAccessor, List<FixedPartitionAttributes> fpaList) {
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            FixedPRSinglehopDUnitTest.fail("Failed to start server ", e);
        }
        if (!fpaList.isEmpty() || isAccessor) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(1).setTotalNumBuckets(12);
            if (isAccessor) {
                paf.setLocalMaxMemory(0);
            }
            for (FixedPartitionAttributes fpa : fpaList) {
                paf.addFixedPartitionAttributes(fpa);
            }
            paf.setPartitionResolver((PartitionResolver)new SingleHopQuarterPartitionResolver());
            AttributesFactory attr = new AttributesFactory();
            attr.setPartitionAttributes(paf.create());
            region = cache.createRegion(PR_NAME, attr.create());
            FixedPRSinglehopDUnitTest.assertNotNull((Object)region);
            FixedPRSinglehopDUnitTest.getLogWriter().info("Partitioned Region fixed_single_hop_pr created Successfully :" + region.toString());
        }
        return port;
    }

    public static int createServerWithLocator(String locator, boolean isAccessor, List<FixedPartitionAttributes> fpaList, boolean simpleFPR) {
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("locators", locator);
        InternalDistributedSystem ds = test.getSystem(props);
        new CacheFactory(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            FixedPRSinglehopDUnitTest.fail("Failed to start server ", e);
        }
        if (!fpaList.isEmpty() || isAccessor) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(1).setTotalNumBuckets(12);
            if (isAccessor) {
                paf.setLocalMaxMemory(0);
            }
            for (FixedPartitionAttributes fpa : fpaList) {
                paf.addFixedPartitionAttributes(fpa);
            }
            paf.setPartitionResolver((PartitionResolver)new QuarterPartitionResolver());
            AttributesFactory attr = new AttributesFactory();
            attr.setPartitionAttributes(paf.create());
            region = cache.createRegion(PR_NAME, attr.create());
            FixedPRSinglehopDUnitTest.assertNotNull((Object)region);
            FixedPRSinglehopDUnitTest.getLogWriter().info("Partitioned Region fixed_single_hop_pr created Successfully :" + region.toString());
        }
        return port;
    }

    public static void startLocatorInVM(int locatorPort) {
        File logFile = new File("locator-" + locatorPort + ".log");
        Properties props = new Properties();
        try {
            locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, null, (Properties)props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void stopLocator() {
        locator.stop();
    }

    public static int totalNumBucketsCreated() {
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion(PR_NAME);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)pr);
        return pr.getLocalPrimaryBucketsListTestOnly().size();
    }

    public static void createPeer(boolean isAccessor, List<FixedPartitionAttributes> fpaList) {
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        cache = test.getCache();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(12);
        if (isAccessor) {
            paf.setLocalMaxMemory(0);
        }
        for (FixedPartitionAttributes fpa : fpaList) {
            paf.addFixedPartitionAttributes(fpa);
        }
        paf.setPartitionResolver((PartitionResolver)new SingleHopQuarterPartitionResolver());
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        FixedPRSinglehopDUnitTest.assertNotNull((Object)region);
        FixedPRSinglehopDUnitTest.getLogWriter().info("Partitioned Region fixed_single_hop_pr created Successfully :" + region.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        FixedPRSinglehopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0, int port1) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).addServer("localhost", port1).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        FixedPRSinglehopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocator(String host, int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        FixedPRSinglehopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0, int port1, int port2, int port3) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        FixedPRSinglehopDUnitTest test = new FixedPRSinglehopDUnitTest("FixedPRSinglehopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).addServer("localhost", port1).addServer("localhost", port2).addServer("localhost", port3).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        FixedPRSinglehopDUnitTest.createRegionsInClientCache(p.getName());
    }

    private static void createRegionsInClientCache(String poolName) {
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(PR_NAME, attrs);
        FixedPRSinglehopDUnitTest.assertNotNull((Object)region);
        FixedPRSinglehopDUnitTest.getLogWriter().info("Distributed Region fixed_single_hop_pr created Successfully :" + region.toString());
    }

    public static void putIntoPartitionedRegions() {
        region.put((Object)q1dateJan1, (Object)"create0");
        region.put((Object)q2dateApr1, (Object)"create1");
        region.put((Object)q3dateJuly1, (Object)"create2");
        region.put((Object)q4dateOct1, (Object)"create3");
        region.put((Object)q1dateFeb1, (Object)"create4");
        region.put((Object)q2dateMay1, (Object)"create5");
        region.put((Object)q3dateAug1, (Object)"create6");
        region.put((Object)q4dateNov1, (Object)"create7");
        region.put((Object)q1dateMar1, (Object)"create8");
        region.put((Object)q2dateJun1, (Object)"create9");
        region.put((Object)q3dateSep1, (Object)"create10");
        region.put((Object)q4dateDec1, (Object)"create11");
        region.put((Object)q1dateJan1, (Object)"update0");
        region.put((Object)q2dateApr1, (Object)"update1");
        region.put((Object)q3dateJuly1, (Object)"update2");
        region.put((Object)q4dateOct1, (Object)"update3");
        region.put((Object)q1dateFeb1, (Object)"update4");
        region.put((Object)q2dateMay1, (Object)"update5");
        region.put((Object)q3dateAug1, (Object)"update6");
        region.put((Object)q4dateNov1, (Object)"update7");
        region.put((Object)q1dateMar1, (Object)"update8");
        region.put((Object)q2dateJun1, (Object)"update9");
        region.put((Object)q3dateSep1, (Object)"update10");
        region.put((Object)q4dateDec1, (Object)"update11");
        region.put((Object)q1dateJan1, (Object)"update00");
        region.put((Object)q2dateApr1, (Object)"update11");
        region.put((Object)q3dateJuly1, (Object)"update22");
        region.put((Object)q4dateOct1, (Object)"update33");
        region.put((Object)q1dateFeb1, (Object)"update44");
        region.put((Object)q2dateMay1, (Object)"update55");
        region.put((Object)q3dateAug1, (Object)"update66");
        region.put((Object)q4dateNov1, (Object)"update77");
        region.put((Object)q1dateMar1, (Object)"update88");
        region.put((Object)q2dateJun1, (Object)"update99");
        region.put((Object)q3dateSep1, (Object)"update1010");
        region.put((Object)q4dateDec1, (Object)"update1111");
    }

    public static void putIntoPartitionedRegionsThreeQs() {
        region.put((Object)q1dateJan1, (Object)"create0");
        region.put((Object)q2dateApr1, (Object)"create1");
        region.put((Object)q3dateJuly1, (Object)"create2");
        region.put((Object)q1dateFeb1, (Object)"create4");
        region.put((Object)q2dateMay1, (Object)"create5");
        region.put((Object)q3dateAug1, (Object)"create6");
        region.put((Object)q1dateMar1, (Object)"create8");
        region.put((Object)q2dateJun1, (Object)"create9");
        region.put((Object)q3dateSep1, (Object)"create10");
        region.put((Object)q1dateJan1, (Object)"update0");
        region.put((Object)q2dateApr1, (Object)"update1");
        region.put((Object)q3dateJuly1, (Object)"update2");
        region.put((Object)q1dateFeb1, (Object)"update4");
        region.put((Object)q2dateMay1, (Object)"update5");
        region.put((Object)q3dateAug1, (Object)"update6");
        region.put((Object)q1dateMar1, (Object)"update8");
        region.put((Object)q2dateJun1, (Object)"update9");
        region.put((Object)q3dateSep1, (Object)"update10");
        region.put((Object)q1dateJan1, (Object)"update00");
        region.put((Object)q2dateApr1, (Object)"update11");
        region.put((Object)q3dateJuly1, (Object)"update22");
        region.put((Object)q1dateFeb1, (Object)"update44");
        region.put((Object)q2dateMay1, (Object)"update55");
        region.put((Object)q3dateAug1, (Object)"update66");
        region.put((Object)q1dateMar1, (Object)"update88");
        region.put((Object)q2dateJun1, (Object)"update99");
        region.put((Object)q3dateSep1, (Object)"update1010");
    }

    public static void getFromPartitionedRegions() {
        region.get((Object)q1dateJan1, (Object)"create0");
        region.get((Object)q2dateApr1, (Object)"create1");
        region.get((Object)q3dateJuly1, (Object)"create2");
        region.get((Object)q4dateOct1, (Object)"create3");
        region.get((Object)q1dateJan1, (Object)"update0");
        region.get((Object)q2dateApr1, (Object)"update1");
        region.get((Object)q3dateJuly1, (Object)"update2");
        region.get((Object)q4dateOct1, (Object)"update3");
        region.get((Object)q1dateJan1, (Object)"update00");
        region.get((Object)q2dateApr1, (Object)"update11");
        region.get((Object)q3dateJuly1, (Object)"update22");
        region.get((Object)q4dateOct1, (Object)"update33");
    }

    public static void getFromPartitionedRegionsFor3Qs() {
        region.get((Object)q1dateJan1, (Object)"create0");
        region.get((Object)q2dateApr1, (Object)"create1");
        region.get((Object)q3dateJuly1, (Object)"create2");
        region.get((Object)q1dateJan1, (Object)"update0");
        region.get((Object)q2dateApr1, (Object)"update1");
        region.get((Object)q3dateJuly1, (Object)"update2");
        region.get((Object)q1dateJan1, (Object)"update00");
        region.get((Object)q2dateApr1, (Object)"update11");
        region.get((Object)q3dateJuly1, (Object)"update22");
    }

    public static void putIntoSinglePR() {
        region.put((Object)q1dateJan1, (Object)"create0");
        region.put((Object)q2dateApr1, (Object)"create1");
        region.put((Object)q3dateJuly1, (Object)"create2");
        region.put((Object)q4dateOct1, (Object)"create3");
    }

    public static void getDataFromSinglePR() {
        for (int i = 0; i < 10; ++i) {
            region.get((Object)q1dateJan1);
            region.get((Object)q2dateApr1);
            region.get((Object)q3dateJuly1);
            region.get((Object)q4dateOct1);
        }
    }

    public static void updateIntoSinglePR() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)q1dateJan1, (Object)"update0");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q1dateFeb1, (Object)"update00");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q1dateMar1, (Object)"update000");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateApr1, (Object)"update1");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateMay1, (Object)"update11");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateJun1, (Object)"update111");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateJuly1, (Object)"update2");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateAug1, (Object)"update22");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateSep1, (Object)"update2222");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q4dateOct1, (Object)"update3");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q4dateNov1, (Object)"update33");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q4dateDec1, (Object)"update3333");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
    }

    public static void updateIntoSinglePRFor3Qs() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)q1dateJan1, (Object)"update0");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q1dateFeb1, (Object)"update00");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q1dateMar1, (Object)"update000");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateApr1, (Object)"update1");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateMay1, (Object)"update11");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q2dateJun1, (Object)"update111");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateJuly1, (Object)"update2");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateAug1, (Object)"update22");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)q3dateSep1, (Object)"update2222");
        FixedPRSinglehopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
    }

    public static void verifyEmptyMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        FixedPRSinglehopDUnitTest.assertTrue((boolean)cms.getClientPRMetadata_TEST_ONLY().isEmpty());
    }

    public static void verifyEmptyStaticData() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        FixedPRSinglehopDUnitTest.assertTrue((boolean)cms.getClientPartitionAttributesMap().isEmpty());
    }

    public static void verifyNonEmptyMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        FixedPRSinglehopDUnitTest.assertTrue((!cms.getClientPRMetadata_TEST_ONLY().isEmpty() ? 1 : 0) != 0);
        FixedPRSinglehopDUnitTest.assertTrue((!cms.getClientPartitionAttributesMap().isEmpty() ? 1 : 0) != 0);
    }

    public static void printMetadata() {
        if (cache != null) {
            ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
            ((GemFireCacheImpl)cache).getLogger().info("Metadata is " + cms.getClientPRMetadata_TEST_ONLY());
        }
    }

    public static void printView() {
        PartitionedRegion pr = (PartitionedRegion)region;
        if (pr.cache != null) {
            ((GemFireCacheImpl)cache).getLogger().info("Primary Bucket view of server0  " + pr.getDataStore().getLocalPrimaryBucketsListTestOnly());
            ((GemFireCacheImpl)cache).getLogger().info("Secondary Bucket view of server0  " + pr.getDataStore().getLocalNonPrimaryBucketsListTestOnly());
        }
    }

    private void verifyMetadata(int totalBuckets, int currentRedundancy) {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        FixedPRSinglehopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        FixedPRSinglehopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        FixedPRSinglehopDUnitTest.assertEquals((int)totalBuckets, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            FixedPRSinglehopDUnitTest.assertEquals((int)currentRedundancy, (int)((List)entry.getValue()).size());
        }
    }

    public static void clearMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPartitionAttributesMap().clear();
        cms.getClientPRMetadata_TEST_ONLY().clear();
    }
}

