/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.BridgeServerAdvisor;
import com.gemstone.gemfire.internal.cache.ControllerAdvisor;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class GridAdvisorDUnitTest
extends DistributedTestCase {
    public GridAdvisorDUnitTest(String name) {
        super(name);
    }

    public void test2by2() throws Exception {
        GridAdvisorDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        List<AvailablePort.Keeper> freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPortKeepers(6);
        AvailablePort.Keeper keeper1 = freeTCPPorts.get(0);
        final int port1 = keeper1.getPort();
        AvailablePort.Keeper keeper2 = freeTCPPorts.get(1);
        final int port2 = keeper2.getPort();
        AvailablePort.Keeper bsKeeper1 = freeTCPPorts.get(2);
        final int bsPort1 = bsKeeper1.getPort();
        AvailablePort.Keeper bsKeeper2 = freeTCPPorts.get(3);
        final int bsPort2 = bsKeeper2.getPort();
        AvailablePort.Keeper bsKeeper3 = freeTCPPorts.get(4);
        final int bsPort3 = bsKeeper3.getPort();
        AvailablePort.Keeper bsKeeper4 = freeTCPPorts.get(5);
        final int bsPort4 = bsKeeper4.getPort();
        String host0 = GridAdvisorDUnitTest.getServerHostName(host);
        final String locators = host0 + "[" + port1 + "]" + "," + host0 + "[" + port2 + "]";
        final Properties dsProps = new Properties();
        dsProps.setProperty("locators", locators);
        dsProps.setProperty("mcast-port", "0");
        dsProps.setProperty("log-level", GridAdvisorDUnitTest.getDUnitLogLevel());
        keeper1.release();
        vm0.invoke(new SerializableRunnable("Start locator on " + port1){

            @Override
            public void run() {
                File logFile = new File(GridAdvisorDUnitTest.this.getUniqueName() + "-locator" + port1 + ".log");
                try {
                    Locator.startLocatorAndDS((int)port1, (File)logFile, null, (Properties)dsProps, (boolean)true, (boolean)true, null);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port1, ex);
                }
            }
        });
        keeper2.release();
        vm3.invoke(new SerializableRunnable("Start locators on " + port2){

            @Override
            public void run() {
                File logFile = new File(GridAdvisorDUnitTest.this.getUniqueName() + "-locator" + port2 + ".log");
                try {
                    Locator.startLocatorAndDS((int)port2, (File)logFile, null, (Properties)dsProps, (boolean)true, (boolean)true, (String)"locator2HNFC");
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port2, ex);
                }
            }
        });
        SerializableRunnable connect = new SerializableRunnable("Connect to " + locators){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", locators);
                dsProps.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                CacheFactory.create((DistributedSystem)DistributedSystem.connect((Properties)props));
            }
        };
        vm1.invoke(connect);
        vm2.invoke(connect);
        SerializableRunnable startBS1 = new SerializableRunnable("start bridgeServer on " + bsPort1){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort1);
                    bs.setGroups(new String[]{"bs1Group1", "bs1Group2"});
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        SerializableRunnable startBS3 = new SerializableRunnable("start bridgeServer on " + bsPort3){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort3);
                    bs.setGroups(new String[]{"bs3Group1", "bs3Group2"});
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        bsKeeper1.release();
        vm1.invoke(startBS1);
        bsKeeper3.release();
        vm1.invoke(startBS3);
        bsKeeper2.release();
        vm2.invoke(new SerializableRunnable("start bridgeServer on " + bsPort2){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort2);
                    bs.setGroups(new String[]{"bs2Group1", "bs2Group2"});
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        });
        bsKeeper4.release();
        vm2.invoke(new SerializableRunnable("start bridgeServer on " + bsPort4){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort4);
                    bs.setGroups(new String[]{"bs4Group1", "bs4Group2"});
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Verify other locator on " + port2){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port2, (int)cp.getPort());
                TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs3Group1", "bs3Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs4Group1", "bs4Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm3.invoke(new SerializableRunnable("Verify other locator on " + port1){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port1, (int)cp.getPort());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs3Group1", "bs3Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs4Group1", "bs4Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify bridge server view on " + bsPort1 + " and on " + bsPort3){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchBridgeServers();
                    DistributedTestCase.getLogWriter().info("found these bridgeservers in " + advisee + ": " + others);
                    TestCase.assertEquals((int)3, (int)others.size());
                    others = bsa.fetchControllers();
                    TestCase.assertEquals((int)2, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port1) continue;
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        vm2.invoke(new SerializableRunnable("Verify bridge server view on " + bsPort2 + " and on " + bsPort4){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchBridgeServers();
                    DistributedTestCase.getLogWriter().info("found these bridgeservers in " + advisee + ": " + others);
                    TestCase.assertEquals((int)3, (int)others.size());
                    others = bsa.fetchControllers();
                    TestCase.assertEquals((int)2, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port1) continue;
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        SerializableRunnable stopBS = new SerializableRunnable("stop bridge server"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                BridgeServer bs = (BridgeServer)bslist.get(0);
                bs.stop();
            }
        };
        vm1.invoke(stopBS);
        vm0.invoke(new SerializableRunnable("Verify other locator on " + port2){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port2, (int)cp.getPort());
                TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)3, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs3Group1", "bs3Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs4Group1", "bs4Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm3.invoke(new SerializableRunnable("Verify other locator on " + port1){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port1, (int)cp.getPort());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)3, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs3Group1", "bs3Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs4Group1", "bs4Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", locators);
                DistributedSystem.connect((Properties)props).disconnect();
            }
        };
        SerializableRunnable stopLocator = new SerializableRunnable("Stop locator"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                Locator.getLocator().stop();
                TestCase.assertFalse((boolean)Locator.hasLocator());
            }
        };
        vm0.invoke(stopLocator);
        vm3.invoke(new SerializableRunnable("Verify locator stopped "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)0, (int)others.size());
            }
        });
        vm2.invoke(new SerializableRunnable("Verify bridge server saw locator stop"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchControllers();
                    TestCase.assertEquals((int)1, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify bridge server saw locator stop"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    if (i == 0) continue;
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchControllers();
                    TestCase.assertEquals((int)1, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        SerializableRunnable restartBS = new SerializableRunnable("restart bridge server"){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    List bslist = c.getBridgeServers();
                    TestCase.assertEquals((int)2, (int)bslist.size());
                    BridgeServer bs = (BridgeServer)bslist.get(0);
                    bs.setHostnameForClients("nameForClients");
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        vm1.invoke(restartBS);
        vm3.invoke(new SerializableRunnable("Verify bridge server restart "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                TestCase.assertEquals((int)0, (int)ca.fetchControllers().size());
                List others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        TestCase.assertEquals((String)"nameForClients", (String)bsp.getHost());
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        TestCase.assertFalse((boolean)bsp.getHost().equals("nameForClients"));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs3Group1", "bs3Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs4Group1", "bs4Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm1.invoke(disconnect);
        vm2.invoke(disconnect);
        vm3.invoke(new SerializableRunnable("Verify locator stopped "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                TestCase.assertEquals((int)0, (int)ca.fetchControllers().size());
                TestCase.assertEquals((int)0, (int)ca.fetchBridgeServers().size());
            }
        });
        vm3.invoke(stopLocator);
    }

    public void test2by2usingGroups() throws Exception {
        GridAdvisorDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        List<AvailablePort.Keeper> freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPortKeepers(6);
        AvailablePort.Keeper keeper1 = freeTCPPorts.get(0);
        final int port1 = keeper1.getPort();
        AvailablePort.Keeper keeper2 = freeTCPPorts.get(1);
        final int port2 = keeper2.getPort();
        AvailablePort.Keeper bsKeeper1 = freeTCPPorts.get(2);
        final int bsPort1 = bsKeeper1.getPort();
        AvailablePort.Keeper bsKeeper2 = freeTCPPorts.get(3);
        final int bsPort2 = bsKeeper2.getPort();
        AvailablePort.Keeper bsKeeper3 = freeTCPPorts.get(4);
        final int bsPort3 = bsKeeper3.getPort();
        AvailablePort.Keeper bsKeeper4 = freeTCPPorts.get(5);
        final int bsPort4 = bsKeeper4.getPort();
        String host0 = GridAdvisorDUnitTest.getServerHostName(host);
        final String locators = host0 + "[" + port1 + "]" + "," + host0 + "[" + port2 + "]";
        final Properties dsProps = new Properties();
        dsProps.setProperty("locators", locators);
        dsProps.setProperty("mcast-port", "0");
        dsProps.setProperty("log-level", GridAdvisorDUnitTest.getDUnitLogLevel());
        keeper1.release();
        vm0.invoke(new SerializableRunnable("Start locators on " + port1){

            @Override
            public void run() {
                File logFile = new File(GridAdvisorDUnitTest.this.getUniqueName() + "-locator" + port1 + ".log");
                try {
                    Locator.startLocatorAndDS((int)port1, (File)logFile, null, (Properties)dsProps, (boolean)true, (boolean)true, null);
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port1, ex);
                }
            }
        });
        keeper2.release();
        vm3.invoke(new SerializableRunnable("Start locators on " + port2){

            @Override
            public void run() {
                File logFile = new File(GridAdvisorDUnitTest.this.getUniqueName() + "-locator" + port2 + ".log");
                try {
                    Locator.startLocatorAndDS((int)port2, (File)logFile, null, (Properties)dsProps, (boolean)true, (boolean)true, (String)"locator2HNFC");
                }
                catch (IOException ex) {
                    DistributedTestCase.fail("While starting locator on port " + port2, ex);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Connect to " + locators){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", locators);
                props.setProperty("groups", "bs1Group1, bs1Group2");
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                CacheFactory.create((DistributedSystem)DistributedSystem.connect((Properties)props));
            }
        });
        vm2.invoke(new SerializableRunnable("Connect to " + locators){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", locators);
                props.setProperty("groups", "bs2Group1, bs2Group2");
                props.setProperty("log-level", DistributedTestCase.getDUnitLogLevel());
                CacheFactory.create((DistributedSystem)DistributedSystem.connect((Properties)props));
            }
        });
        SerializableRunnable startBS1 = new SerializableRunnable("start bridgeServer on " + bsPort1){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort1);
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        SerializableRunnable startBS3 = new SerializableRunnable("start bridgeServer on " + bsPort3){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort3);
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        bsKeeper1.release();
        vm1.invoke(startBS1);
        bsKeeper3.release();
        vm1.invoke(startBS3);
        bsKeeper2.release();
        vm2.invoke(new SerializableRunnable("start bridgeServer on " + bsPort2){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort2);
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        });
        bsKeeper4.release();
        vm2.invoke(new SerializableRunnable("start bridgeServer on " + bsPort4){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    BridgeServer bs = c.addBridgeServer();
                    bs.setPort(bsPort4);
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Verify other locator on " + port2){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port2, (int)cp.getPort());
                TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm3.invoke(new SerializableRunnable("Verify other locator on " + port1){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port1, (int)cp.getPort());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify bridge server view on " + bsPort1 + " and on " + bsPort3){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchBridgeServers();
                    DistributedTestCase.getLogWriter().info("found these bridgeservers in " + advisee + ": " + others);
                    TestCase.assertEquals((int)3, (int)others.size());
                    others = bsa.fetchControllers();
                    TestCase.assertEquals((int)2, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port1) continue;
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        vm2.invoke(new SerializableRunnable("Verify bridge server view on " + bsPort2 + " and on " + bsPort4){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchBridgeServers();
                    DistributedTestCase.getLogWriter().info("found these bridgeservers in " + advisee + ": " + others);
                    TestCase.assertEquals((int)3, (int)others.size());
                    others = bsa.fetchControllers();
                    TestCase.assertEquals((int)2, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port1) continue;
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        SerializableRunnable stopBS = new SerializableRunnable("stop bridge server"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                BridgeServer bs = (BridgeServer)bslist.get(0);
                bs.stop();
            }
        };
        vm1.invoke(stopBS);
        vm0.invoke(new SerializableRunnable("Verify other locator on " + port2){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port2, (int)cp.getPort());
                TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)3, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm3.invoke(new SerializableRunnable("Verify other locator on " + port1){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)1, (int)others.size());
                ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(0);
                TestCase.assertEquals((int)port1, (int)cp.getPort());
                others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)3, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        SerializableRunnable disconnect = new SerializableRunnable("Disconnect from " + locators){

            @Override
            public void run() {
                InternalDistributedSystem.getAnyInstance().disconnect();
            }
        };
        SerializableRunnable stopLocator = new SerializableRunnable("Stop locator"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                Locator.getLocator().stop();
                TestCase.assertFalse((boolean)Locator.hasLocator());
            }
        };
        vm0.invoke(stopLocator);
        vm3.invoke(new SerializableRunnable("Verify locator stopped "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                List others = ca.fetchControllers();
                TestCase.assertEquals((int)0, (int)others.size());
            }
        });
        vm2.invoke(new SerializableRunnable("Verify bridge server saw locator stop"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchControllers();
                    TestCase.assertEquals((int)1, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify bridge server saw locator stop"){

            @Override
            public void run() {
                Cache c = CacheFactory.getAnyInstance();
                List bslist = c.getBridgeServers();
                TestCase.assertEquals((int)2, (int)bslist.size());
                for (int i = 0; i < bslist.size(); ++i) {
                    DistributionAdvisee advisee = (DistributionAdvisee)bslist.get(i);
                    if (i == 0) continue;
                    BridgeServerAdvisor bsa = (BridgeServerAdvisor)advisee.getDistributionAdvisor();
                    List others = bsa.fetchControllers();
                    TestCase.assertEquals((int)1, (int)others.size());
                    for (int j = 0; j < others.size(); ++j) {
                        ControllerAdvisor.ControllerProfile cp = (ControllerAdvisor.ControllerProfile)others.get(j);
                        if (cp.getPort() == port2) {
                            TestCase.assertEquals((String)"locator2HNFC", (String)cp.getHost());
                            continue;
                        }
                        TestCase.fail((String)("unexpected port " + cp.getPort() + " in " + cp));
                    }
                }
            }
        });
        SerializableRunnable restartBS = new SerializableRunnable("restart bridge server"){

            @Override
            public void run() {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    List bslist = c.getBridgeServers();
                    TestCase.assertEquals((int)2, (int)bslist.size());
                    BridgeServer bs = (BridgeServer)bslist.get(0);
                    bs.setHostnameForClients("nameForClients");
                    bs.start();
                }
                catch (IOException ex) {
                    RuntimeException re = new RuntimeException();
                    re.initCause(ex);
                    throw re;
                }
            }
        };
        vm1.invoke(restartBS);
        vm3.invoke(new SerializableRunnable("Verify bridge server restart "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                TestCase.assertEquals((int)0, (int)ca.fetchControllers().size());
                List others = ca.fetchBridgeServers();
                TestCase.assertEquals((int)4, (int)others.size());
                for (int j = 0; j < others.size(); ++j) {
                    BridgeServerAdvisor.BridgeServerProfile bsp = (BridgeServerAdvisor.BridgeServerProfile)others.get(j);
                    if (bsp.getPort() == bsPort1) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        TestCase.assertEquals((String)"nameForClients", (String)bsp.getHost());
                        continue;
                    }
                    if (bsp.getPort() == bsPort2) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        TestCase.assertFalse((boolean)bsp.getHost().equals("nameForClients"));
                        continue;
                    }
                    if (bsp.getPort() == bsPort3) {
                        TestCase.assertEquals(Arrays.asList("bs1Group1", "bs1Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    if (bsp.getPort() == bsPort4) {
                        TestCase.assertEquals(Arrays.asList("bs2Group1", "bs2Group2"), Arrays.asList(bsp.getGroups()));
                        continue;
                    }
                    TestCase.fail((String)("unexpected port " + bsp.getPort() + " in " + bsp));
                }
            }
        });
        vm1.invoke(disconnect);
        vm2.invoke(disconnect);
        vm3.invoke(new SerializableRunnable("Verify locator stopped "){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)Locator.hasLocator());
                InternalLocator l = (InternalLocator)Locator.getLocator();
                ServerLocator advisee = l.getServerLocatorAdvisee();
                ControllerAdvisor ca = (ControllerAdvisor)advisee.getDistributionAdvisor();
                TestCase.assertEquals((int)0, (int)ca.fetchControllers().size());
                TestCase.assertEquals((int)0, (int)ca.fetchBridgeServers().size());
            }
        });
        vm3.invoke(stopLocator);
    }
}

