/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.VMLRURegionMap;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import java.util.Set;

public class HAOverflowMemObjectSizerDUnitTest
extends DistributedTestCase {
    private static final int OVERHEAD_PER_ENTRY = 250;
    protected static InternalLocator locator;
    static Cache cache;
    static DistributedSystem ds;
    static String regionName;
    private static EnableLRU cc;
    static VM client;
    static VM serverVM;
    static Integer serverPort1;
    static Integer serverPort2;
    static String ePolicy;
    static int capacity;
    static Region region;

    public HAOverflowMemObjectSizerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        HAOverflowMemObjectSizerDUnitTest.disconnectAllFromDS();
        super.setUp();
        Host host = Host.getHost(0);
        client = host.getVM(1);
        serverVM = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        serverVM.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        client.invoke(HAOverflowMemObjectSizerDUnitTest.class, "closeCache");
        serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "closeCache");
    }

    public static void cleanUp(Long limit) {
        ConflationDUnitTest.unsetIsSlowStart();
        if (region != null) {
            Set entries = region.entrySet();
            entries = region.entrySet();
            long timeElapsed = 0L;
            long startTime = System.currentTimeMillis();
            while (entries.size() > 0 && timeElapsed <= limit) {
                try {
                    Thread.sleep(50L);
                    timeElapsed = System.currentTimeMillis() - startTime;
                }
                catch (InterruptedException e) {
                    HAOverflowMemObjectSizerDUnitTest.fail((String)"interrupted");
                }
                entries = region.entrySet();
            }
        }
    }

    public static Integer createCacheServer(Boolean notification) throws Exception {
        new HAOverflowMemObjectSizerDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.NORMAL);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(regionName, attrs);
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)region);
        BridgeServer server1 = cache.addBridgeServer();
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(notification.booleanValue());
        server1.getClientSubscriptionConfig().setCapacity(capacity);
        server1.getClientSubscriptionConfig().setEvictionPolicy(ePolicy);
        server1.start();
        HAOverflowMemObjectSizerDUnitTest.assertTrue((boolean)server1.isRunning());
        cc = ((VMLRURegionMap)((LocalRegion)HAOverflowMemObjectSizerDUnitTest.cache.getRegion((String)new StringBuilder().append((String)"/").append((String)BridgeServerImpl.generateNameForClientMsgsRegion((int)port)).toString())).entries)._getCCHelper();
        return new Integer(server1.getPort());
    }

    public static void createCacheClient(Integer port1, String host) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HAOverflowMemObjectSizerDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.NORMAL);
        BridgeTestCase.configureConnectionPool(factory, host, port1, -1, true, -1, 2, null, -1, -1, false);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(regionName, attrs);
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)region);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public void testSizerImplementationofMemCapacityControllerWhenNotificationBySubscriptionIsTrue() {
        Integer port1;
        serverPort1 = port1 = (Integer)serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "createCacheServer", new Object[]{new Boolean(true)});
        serverVM.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"15000"});
        client.invoke(HAOverflowMemObjectSizerDUnitTest.class, "createCacheClient", new Object[]{port1, HAOverflowMemObjectSizerDUnitTest.getServerHostName(client.getHost())});
        serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "performPut", new Object[]{new Long(0L), new Long(100L)});
        serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "sizerTestForMemCapacityController", new Object[]{serverPort1});
    }

    public void testSizerImplementationofMemCapacityControllerWhenNotificationBySubscriptionIsFalse() {
        Integer port2;
        serverPort2 = port2 = (Integer)serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "createCacheServer", new Object[]{new Boolean(false)});
        serverVM.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"15000"});
        client.invoke(HAOverflowMemObjectSizerDUnitTest.class, "createCacheClient", new Object[]{port2, HAOverflowMemObjectSizerDUnitTest.getServerHostName(client.getHost())});
        serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "performPut", new Object[]{new Long(101L), new Long(200L)});
        serverVM.invoke(HAOverflowMemObjectSizerDUnitTest.class, "sizerTestForMemCapacityController", new Object[]{serverPort2});
    }

    public static void sizerTestForMemCapacityController(Integer port) {
        region = cache.getRegion("/" + BridgeServerImpl.generateNameForClientMsgsRegion((int)port));
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)region);
        Set entries = region.entrySet();
        HAOverflowMemObjectSizerDUnitTest.assertTrue((entries.size() > 0 ? 1 : 0) != 0);
        for (Region.Entry entry : entries) {
            ClientUpdateMessageImpl cum = (ClientUpdateMessageImpl)entry.getValue();
            HAOverflowMemObjectSizerDUnitTest.assertTrue((String)"cum size is not equal", (cc.entrySize(null, entry.getValue()) - 250 == cum.getSizeInBytes() ? 1 : 0) != 0);
        }
        cache.getLogger().fine("Test passed. Now, doing a cleanup job.");
        HAOverflowMemObjectSizerDUnitTest.cleanUp(new Long(20000L));
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)cache);
    }

    public static void closeCache() {
        try {
            if (cache != null && !cache.isClosed()) {
                cache.close();
                cache.getDistributedSystem().disconnect();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void performPut(Long lowerLimit, Long higerlimit) {
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)lowerLimit);
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)higerlimit);
        LocalRegion region = (LocalRegion)cache.getRegion("/" + regionName);
        HAOverflowMemObjectSizerDUnitTest.assertNotNull((Object)region);
        for (long i = lowerLimit.longValue(); i < higerlimit; ++i) {
            region.put((Object)new Long(i), (Object)new Long(i));
        }
    }

    static {
        ds = null;
        regionName = "HAOverflowMemObjectSizerDUnitTest-region";
        cc = null;
        client = null;
        serverVM = null;
        serverPort1 = null;
        serverPort2 = null;
        ePolicy = "mem";
        capacity = 1;
        region = null;
    }
}

