/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMLRURegionMap;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.lru.NewLRUClockHand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.HaHelper;
import hct.ha.HAClientQueueBB;
import hydra.Log;
import java.io.IOException;
import util.TestException;

public class LocalRegionHelper {
    public static boolean isInvalidToken(Object o) {
        return o == Token.INVALID || o == Token.LOCAL_INVALID;
    }

    public static boolean isLocalInvalidToken(Object o) {
        return o == Token.LOCAL_INVALID;
    }

    public static boolean isDestroyedToken(Object o) {
        return o == Token.DESTROYED;
    }

    public static Region createSubregion(Region root, String name, RegionAttributes attrs, InternalRegionArguments internalArgs) throws CacheException {
        if (internalArgs == null) {
            return root.createSubregion(name, attrs);
        }
        try {
            LocalRegion lr = (LocalRegion)root;
            return lr.createSubregion(name, attrs, internalArgs);
        }
        catch (IOException ioe) {
            AssertionError assErr = new AssertionError((Object)"unexpected exception");
            ((Throwable)((Object)assErr)).initCause(ioe);
            throw assErr;
        }
        catch (ClassNotFoundException cnfe) {
            AssertionError assErr = new AssertionError((Object)"unexpected exception");
            ((Throwable)((Object)assErr)).initCause(cnfe);
            throw assErr;
        }
    }

    public static void isHAOverflowFeaturedUsedInPrimaryPutOnShareBB() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        LRUStatistics lifoStats = null;
        NewLRUClockHand lifoClockHand = null;
        for (BridgeServerImpl server : cache.getBridgeServers()) {
            for (CacheClientProxy proxy : server.getAcceptor().getCacheClientNotifier().getClientProxies()) {
                if (!HaHelper.checkPrimary(proxy)) continue;
                Log.getLogWriter().info(" found primary :" + server);
                lifoClockHand = ((VMLRURegionMap)((LocalRegion)cache.getRegion((String)new StringBuilder().append((String)"/").append((String)BridgeServerImpl.generateNameForClientMsgsRegion((int)server.getPort())).toString())).entries)._getLruList();
                lifoStats = lifoClockHand.stats();
                int status = (int)HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.HA_OVERFLOW_STATUS);
                if (lifoStats.getEvictions() <= 0L && status != 1) continue;
                HAClientQueueBB.getBB().getSharedCounters().setIfLarger(HAClientQueueBB.HA_OVERFLOW_STATUS, 1L);
                Log.getLogWriter().info("eviction count : " + lifoStats.getEvictions() + "HA_OVERFLOW_STATUS : " + status);
            }
        }
    }

    public static void isOverflowUsedOnBridge() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        LRUStatistics lifoStats = null;
        NewLRUClockHand lifoClockHand = null;
        for (BridgeServerImpl server : cache.getCacheServers()) {
            lifoClockHand = ((VMLRURegionMap)((LocalRegion)cache.getRegion((String)new StringBuilder().append((String)"/").append((String)BridgeServerImpl.generateNameForClientMsgsRegion((int)server.getPort())).toString())).entries)._getLruList();
            lifoStats = lifoClockHand.stats();
            if (lifoStats.getEvictions() > 0L) {
                Log.getLogWriter().info("eviction count : " + lifoStats.getEvictions());
                continue;
            }
            throw new TestException("Test issue : Test need tuning - no overflow happened");
        }
    }
}

