/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GatewayHubStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class LondonToNewYorkDUnitTest
extends CacheTestCase {
    private static final String OVERFLOW_DIR = "_of";
    private static final String DISTRIBUTED_SYSTEM_PORT = "_DSPort";
    private static final String DYNAMIC_REGION_DIR = "_dynR";
    private static final String LONDON_CLIENT_NAME = "loCl";
    private static final String NYC_CLIENT_NAME = "nyCl";
    private static final String NYC_GATEWAY_NAME = "NYGW";
    private static final String LONDON_GATEWAY_NAME = "LoGW";
    protected static InternalLocator locator;
    private static final int BATCH_TIME_INTERVAL = 100;
    private static final Integer CLIENT_RETRY;

    public LondonToNewYorkDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        LondonToNewYorkDUnitTest.disconnectAllFromDS();
        this.cleanupAllLocators();
    }

    private void cleanupAllLocators() {
        Host host = Host.getHost(0);
        for (int i = 0; i < host.getVMCount(); ++i) {
            host.getVM(i).invoke(new SerializableRunnable("Stop locator"){

                @Override
                public void run() {
                    if (locator != null) {
                        locator.stop();
                        locator = null;
                    }
                }
            });
        }
    }

    private VM setupLondonGateway(final String dsName, final int bsPort, final int gwHubPort, final String remoteHubHost, final int remoteHubPort, final int batchSize) throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Set up LoGW"){

            @Override
            public void run2() throws CacheException {
                LondonToNewYorkDUnitTest.this.createServerDS(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME + "_vm0");
                CacheTestCase.beginCacheXml();
                if (LondonToNewYorkDUnitTest.this.getTestDynamicRegions()) {
                    CacheCreation cc = (CacheCreation)LondonToNewYorkDUnitTest.this.getCache();
                    File d = new File(dsName + LondonToNewYorkDUnitTest.DYNAMIC_REGION_DIR + ProcessMgr.getProcessId());
                    d.mkdirs();
                    cc.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(d, null));
                }
                LondonToNewYorkDUnitTest.this.createBridgeServer(bsPort);
                GatewayHub londonGatewayHub = LondonToNewYorkDUnitTest.this.getCache().setGatewayHub(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME, gwHubPort);
                Gateway gatewayToNYC = londonGatewayHub.addGateway(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME);
                gatewayToNYC.addEndpoint(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME + "Endpoint", remoteHubHost, remoteHubPort);
                File d = new File(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME + LondonToNewYorkDUnitTest.OVERFLOW_DIR + ProcessMgr.getProcessId());
                GatewayQueueAttributes LondonGatewayQueueAttributes = new GatewayQueueAttributes(d.toString(), 100, batchSize, 100, false, false, true, 0);
                LondonToNewYorkDUnitTest.setDiskStoreForGateway(LondonToNewYorkDUnitTest.this.getCache(), d.toString(), LondonGatewayQueueAttributes);
                gatewayToNYC.setQueueAttributes(LondonGatewayQueueAttributes);
                LondonToNewYorkDUnitTest.this.createParentRegion(dsName, true);
                LondonToNewYorkDUnitTest.this.finishCacheXml(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME);
            }
        });
        return vm0;
    }

    private VM setupLondonClient(final String dsName, String bsHost, final int[] bsPorts) throws Exception {
        final Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("Set up loCl"){

            @Override
            public void run2() throws CacheException {
                LondonToNewYorkDUnitTest.this.createLonerDS(dsName + "_loner_ " + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME + "_vm1");
                CacheTestCase.beginCacheXml();
                PoolImpl pi = null;
                if (LondonToNewYorkDUnitTest.this.getTestDynamicRegions()) {
                    CacheCreation cc = (CacheCreation)LondonToNewYorkDUnitTest.this.getCache();
                    pi = (PoolImpl)BridgeTestCase.configureConnectionPoolWithNameAndFactory(null, DistributedTestCase.getServerHostName(host), bsPorts, true, -1, -1, null, "testPool", cc.createPoolFactory());
                    File d = new File(dsName + LondonToNewYorkDUnitTest.DYNAMIC_REGION_DIR + ProcessMgr.getProcessId());
                    d.mkdirs();
                    cc.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(d, pi.getName(), false, true));
                } else {
                    pi = (PoolImpl)BridgeTestCase.configureConnectionPool(null, DistributedTestCase.getServerHostName(host), bsPorts, true, -1, -1, null);
                }
                LondonToNewYorkDUnitTest.this.createParentRegionOnClient(dsName, false, pi);
                LondonToNewYorkDUnitTest.this.finishCacheXml(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME);
                Region r = LondonToNewYorkDUnitTest.this.getCache().getRegion(dsName);
                r.registerInterestRegex(".*");
            }
        });
        return vm1;
    }

    private VM setupNYCGateway(final String dsName, final int bsPort, final int gwHubPort, final String remoteHubHost, final int remoteHubPort, final int batchSize) throws Exception {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        vm2.invoke(new CacheSerializableRunnable("Set up NYGW"){

            @Override
            public void run2() throws CacheException {
                try {
                    LondonToNewYorkDUnitTest.this.createServerDS(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME + "_vm2");
                    CacheTestCase.beginCacheXml();
                    if (LondonToNewYorkDUnitTest.this.getTestDynamicRegions()) {
                        CacheCreation cc = (CacheCreation)LondonToNewYorkDUnitTest.this.getCache();
                        File d = new File(dsName + LondonToNewYorkDUnitTest.DYNAMIC_REGION_DIR + ProcessMgr.getProcessId());
                        d.mkdirs();
                        cc.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(d, null));
                    }
                    LondonToNewYorkDUnitTest.this.createBridgeServer(bsPort);
                    Cache cache = LondonToNewYorkDUnitTest.this.getCache();
                    GatewayHub londonClientHub = cache.setGatewayHub(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME, gwHubPort);
                    Gateway gatewayToLondon = londonClientHub.addGateway(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME);
                    gatewayToLondon.addEndpoint(dsName + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME + "Endpoint", remoteHubHost, remoteHubPort);
                    File gwdir = new File(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME + LondonToNewYorkDUnitTest.OVERFLOW_DIR + ProcessMgr.getProcessId());
                    GatewayQueueAttributes londonClientQueueAttributes = new GatewayQueueAttributes(gwdir.toString(), 100, batchSize, 100, false, false, true, 0);
                    LondonToNewYorkDUnitTest.setDiskStoreForGateway(LondonToNewYorkDUnitTest.this.getCache(), gwdir.toString(), londonClientQueueAttributes);
                    gatewayToLondon.setQueueAttributes(londonClientQueueAttributes);
                    LondonToNewYorkDUnitTest.this.createParentRegion(dsName, true);
                    LondonToNewYorkDUnitTest.this.finishCacheXml(dsName + "_" + LondonToNewYorkDUnitTest.NYC_GATEWAY_NAME);
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable t) {
                    throw new CacheException("Found throwable", t){};
                }
            }
        });
        return vm2;
    }

    private VM setupNYCClient(final String dsName, String bsHost, final int[] bsPorts) throws Exception {
        final Host host = Host.getHost(0);
        VM vm3 = host.getVM(3);
        vm3.invoke(new CacheSerializableRunnable("Set up nyCl"){

            @Override
            public void run2() throws CacheException {
                LondonToNewYorkDUnitTest.this.createLonerDS(dsName + "_loner_" + LondonToNewYorkDUnitTest.NYC_CLIENT_NAME + "_vm3");
                CacheTestCase.beginCacheXml();
                PoolImpl pi = null;
                if (LondonToNewYorkDUnitTest.this.getTestDynamicRegions()) {
                    CacheCreation cc = (CacheCreation)LondonToNewYorkDUnitTest.this.getCache();
                    pi = (PoolImpl)BridgeTestCase.configureConnectionPoolWithNameAndFactory(null, DistributedTestCase.getServerHostName(host), bsPorts, true, -1, -1, null, "testPool", cc.createPoolFactory());
                    File d = new File(dsName + LondonToNewYorkDUnitTest.DYNAMIC_REGION_DIR + ProcessMgr.getProcessId());
                    d.mkdirs();
                    cc.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(d, pi.getName(), false, true));
                } else {
                    pi = (PoolImpl)BridgeTestCase.configureConnectionPool(null, DistributedTestCase.getServerHostName(host), bsPorts, true, -1, -1, null);
                }
                LondonToNewYorkDUnitTest.this.createParentRegionOnClient(dsName, false, pi);
                LondonToNewYorkDUnitTest.this.finishCacheXml(dsName + "_" + LondonToNewYorkDUnitTest.NYC_CLIENT_NAME);
                Region r = LondonToNewYorkDUnitTest.this.getCache().getRegion(dsName);
                r.registerInterestRegex(".*");
            }
        });
        return vm3;
    }

    protected InternalDistributedSystem createLonerDS(String dsName) {
        LondonToNewYorkDUnitTest.disconnectFromDS();
        Properties lonerProps = new Properties();
        lonerProps.setProperty("name", dsName);
        lonerProps.setProperty("mcast-port", "0");
        lonerProps.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(lonerProps);
        LondonToNewYorkDUnitTest.assertEquals((int)0, (int)ds.getDistributionManager().getOtherDistributionManagerIds().size());
        return ds;
    }

    protected InternalDistributedSystem createServerDS(String dsName) {
        int port = -1;
        try {
            File dsFile = new File(dsName + DISTRIBUTED_SYSTEM_PORT + ".obj");
            if (dsFile.exists()) {
                Integer i = (Integer)new ObjectInputStream(new FileInputStream(dsFile)).readObject();
                port = i;
            } else {
                port = AvailablePort.getRandomAvailablePort((int)1);
                new ObjectOutputStream(new FileOutputStream(dsFile)).writeObject(new Integer(port));
            }
        }
        catch (ClassNotFoundException dsFile) {
        }
        catch (IOException ioe) {
            LondonToNewYorkDUnitTest.fail("Problem reading or writing ds port", ioe);
        }
        Properties p = new Properties();
        p.setProperty("mcast-port", Integer.toString(port));
        p.setProperty("mcast-ttl", "0");
        p.setProperty("locators", "");
        p.setProperty("name", dsName);
        InternalDistributedSystem ids = this.getSystem(p);
        LondonToNewYorkDUnitTest.assertEquals((int)0, (int)ids.getDistributionManager().getOtherDistributionManagerIds().size());
        return ids;
    }

    protected Region createParentRegionOnClient(String name, boolean wanEnable, PoolImpl pool) throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setEnableGateway(wanEnable);
        factory.setPoolName(pool.getName());
        factory.addCacheListener((CacheListener)new AtlanticTestCacheListener());
        Region r = this.createRootRegion(name, factory.create());
        return r;
    }

    protected Region createParentRegion(String name, boolean wanEnable) throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        this.setParentRegionScope(factory);
        this.setStoragePolicy(factory);
        factory.setEnableGateway(wanEnable);
        factory.addCacheListener((CacheListener)new AtlanticTestCacheListener());
        Region r = this.createRootRegion(name, factory.create());
        return r;
    }

    void setStoragePolicy(AttributesFactory factory) {
        factory.setDataPolicy(DataPolicy.REPLICATE);
    }

    void setParentRegionScope(AttributesFactory factory) {
        factory.setScope(Scope.DISTRIBUTED_ACK);
    }

    boolean getTestDynamicRegions() {
        return true;
    }

    protected void createBridgeServer(int port) {
        Cache c = this.getCache();
        BridgeServer bridge = c.addBridgeServer();
        bridge.setNotifyBySubscription(true);
        bridge.setPort(port);
        try {
            bridge.start();
        }
        catch (IOException ioe) {
            LondonToNewYorkDUnitTest.fail((String)("Could not start BridgeServer on port " + port));
        }
    }

    protected static void waitForGatewayInitialization(GatewayHubImpl ghi) {
        for (final Gateway gi : ghi.getGateways()) {
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return gi.isConnected();
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 5000L, 200L, true);
        }
    }

    protected static void waitForGatewayHubDistribution(GatewayHubImpl ghi, final int numEvents) {
        final GatewayHubStats ghs = ghi.getStatistics();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ghs.getEventsProcessed() >= numEvents;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        List gws = ghi.getGateways();
        LondonToNewYorkDUnitTest.assertEquals((int)1, (int)gws.size());
        for (final Gateway gwi : gws) {
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return gwi.getQueueSize() == 0;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 1000L, 200L, true);
        }
    }

    protected void waitForUpdates(Region r, final int num) {
        final AtlanticTestCacheListener atcl = (AtlanticTestCacheListener)r.getAttributes().getCacheListener();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return atcl.getMods() >= num;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 2000L, 200L, true);
        atcl.resetMods();
    }

    public void testLondonToNewYork() throws Exception {
        final String name = "LToNY" + Integer.toHexString(this.getClass().getName().hashCode());
        Host host = Host.getHost(0);
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(4);
        int londonGatewayBridgeServerPort = ports[0];
        int nycGatewayBridgeSeverPort = ports[1];
        int londonGatewayHubPort = ports[2];
        int nycGatewayHubPort = ports[3];
        int batchSize = 2;
        VM nGateway = this.setupNYCGateway(name, nycGatewayBridgeSeverPort, nycGatewayHubPort, LondonToNewYorkDUnitTest.getServerHostName(host), londonGatewayHubPort, 2);
        VM lGateway = this.setupLondonGateway(name, londonGatewayBridgeServerPort, londonGatewayHubPort, LondonToNewYorkDUnitTest.getServerHostName(nGateway.getHost()), nycGatewayHubPort, 2);
        VM lClient = this.setupLondonClient(name, LondonToNewYorkDUnitTest.getServerHostName(lGateway.getHost()), new int[]{londonGatewayBridgeServerPort});
        VM nClient = this.setupNYCClient(name, LondonToNewYorkDUnitTest.getServerHostName(nGateway.getHost()), new int[]{nycGatewayBridgeSeverPort});
        String lVal = "londonVal";
        String dynKey = "dynKey";
        String dynVal = "dynVal";
        lGateway.invoke(new CacheSerializableRunnable("Wait for gateway initialization"){

            @Override
            public void run2() throws CacheException {
                List hubs = LondonToNewYorkDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                LondonToNewYorkDUnitTest.waitForGatewayInitialization((GatewayHubImpl)hub);
            }
        });
        lClient.invoke(new CacheSerializableRunnable("Test London client"){

            @Override
            public void run2() throws CacheException {
                Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)r);
                for (int i = 2; i >= 0; --i) {
                    Key k = new Key(i);
                    r.put((Object)k, (Object)("londonVal" + i));
                }
            }
        });
        lGateway.invoke(new CacheSerializableRunnable("Test London gateway"){

            @Override
            public void run2() throws CacheException {
                Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)r);
                for (int i = 2; i >= 0; --i) {
                    Key k = new Key(i);
                    String v = "londonVal" + i;
                    if (r.getAttributes().getPartitionAttributes() == null) {
                        TestCase.assertNotNull((String)("london key " + k), (Object)r.getEntry((Object)k));
                        TestCase.assertEquals((String)v, (Object)v, (Object)r.getEntry((Object)k).getValue());
                        continue;
                    }
                    TestCase.assertEquals((String)v, (Object)v, (Object)r.get((Object)k));
                }
                List hubs = LondonToNewYorkDUnitTest.this.getCache().getGatewayHubs();
                GatewayHub hub = (GatewayHub)hubs.get(0);
                LondonToNewYorkDUnitTest.waitForGatewayHubDistribution((GatewayHubImpl)hub, 2);
            }
        });
        LondonToNewYorkDUnitTest.pause(2000);
        nGateway.invoke(new CacheSerializableRunnable("Test NYC gateway"){

            @Override
            public void run2() throws CacheException {
                Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)r);
                LondonToNewYorkDUnitTest.this.waitForUpdates(r, 2);
                for (int i = 2; i > 0; --i) {
                    Key k = new Key(i);
                    String v = "londonVal" + i;
                    if (r.getAttributes().getPartitionAttributes() == null) {
                        TestCase.assertNotNull((String)("london key " + k), (Object)r.getEntry((Object)k));
                        TestCase.assertEquals((String)v, (Object)v, (Object)r.getEntry((Object)k).getValue());
                        continue;
                    }
                    TestCase.assertEquals((String)v, (Object)v, (Object)r.get((Object)k));
                }
            }
        });
        nClient.invoke(new CacheSerializableRunnable("Test NYC client"){

            @Override
            public void run2() throws CacheException {
                Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)r);
                for (int i = 2; i > 2; --i) {
                    Key k = new Key(i);
                    String v = "londonVal" + i;
                    TestCase.assertNotNull((String)("london key " + k), (Object)r.getEntry((Object)k));
                    TestCase.assertEquals((String)v, (Object)v, (Object)r.getEntry((Object)k).getValue());
                }
            }
        });
        if (this.getTestDynamicRegions()) {
            final String dynamicRegionName = name + "-FromLondon";
            lClient.invoke(new CacheSerializableRunnable("Invoke dynamic region from London client"){

                @Override
                public void run2() throws CacheException {
                    Region dr = DynamicRegionFactory.get().createDynamicRegion(name, dynamicRegionName);
                    TestCase.assertNotNull((Object)dr);
                    dr.put((Object)"dynKey", (Object)"dynVal");
                }
            });
            CacheSerializableRunnable dynRegionTest = new CacheSerializableRunnable("Test dynamic region on host"){

                @Override
                public void run2() throws CacheException {
                    Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    Region dr = r.getSubregion(dynamicRegionName);
                    TestCase.assertNotNull((Object)dr);
                    TestCase.assertNotNull((Object)LondonToNewYorkDUnitTest.this.getCache().getRegion(name + "/" + dynamicRegionName));
                    TestCase.assertNotNull((String)"This assertion fails intermittently", (Object)dr.getEntry((Object)"dynKey"));
                    TestCase.assertEquals((Object)"dynVal", (Object)dr.getEntry((Object)"dynKey").getValue());
                }
            };
            lGateway.invoke(dynRegionTest);
            lGateway.invoke(new CacheSerializableRunnable("Wait for Gateway distribution"){

                @Override
                public void run2() throws CacheException {
                    List hubs = LondonToNewYorkDUnitTest.this.getCache().getGatewayHubs();
                    GatewayHub hub = (GatewayHub)hubs.get(0);
                    LondonToNewYorkDUnitTest.waitForGatewayHubDistribution((GatewayHubImpl)hub, 4);
                }
            });
            LondonToNewYorkDUnitTest.pause(2000);
            nGateway.invoke(dynRegionTest);
            nClient.invoke(dynRegionTest);
            lClient.invoke(new CacheSerializableRunnable("Test cache reload on london Client"){

                @Override
                public void run2() throws CacheException {
                    CacheTestCase.closeCache();
                    LondonToNewYorkDUnitTest.this.createLonerDS(name + "_loner_" + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME + "_vm1");
                    GemFireCacheImpl.testCacheXml = new File(name + "_" + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME + "-cache.xml");
                    LondonToNewYorkDUnitTest.this.getCache();
                }
            });
            lClient.invoke(dynRegionTest);
            nClient.invoke(new CacheSerializableRunnable("Test cache reload on nyc Client"){

                @Override
                public void run2() throws CacheException {
                    CacheTestCase.closeCache();
                    LondonToNewYorkDUnitTest.this.createLonerDS(name + "_loner_" + LondonToNewYorkDUnitTest.NYC_CLIENT_NAME + "_vm3");
                    GemFireCacheImpl.testCacheXml = new File(name + "_" + LondonToNewYorkDUnitTest.NYC_CLIENT_NAME + "-cache.xml");
                    LondonToNewYorkDUnitTest.this.getCache();
                }
            });
            nClient.invoke(dynRegionTest);
            lClient.invoke(CacheTestCase.class, "closeCache");
            lGateway.invoke(CacheTestCase.class, "closeCache");
            lGateway.invoke(new CacheSerializableRunnable("Test cache reload on london Gateway"){

                @Override
                public void run2() throws CacheException {
                    CacheTestCase.disconnectFromDS();
                    LondonToNewYorkDUnitTest.this.createServerDS(name + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME + "_vm0");
                    GemFireCacheImpl.testCacheXml = new File(name + "_" + LondonToNewYorkDUnitTest.LONDON_GATEWAY_NAME + "-cache.xml");
                    LondonToNewYorkDUnitTest.this.getCache();
                }
            });
            lClient.invoke(new CacheSerializableRunnable("Test cache reload on london Client again"){

                @Override
                public void run2() throws CacheException {
                    LondonToNewYorkDUnitTest.this.createLonerDS(name + "_loner_ " + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME + "_vm1");
                    GemFireCacheImpl.testCacheXml = new File(name + "_" + LondonToNewYorkDUnitTest.LONDON_CLIENT_NAME + "-cache.xml");
                    LondonToNewYorkDUnitTest.this.getCache();
                }
            });
            CacheSerializableRunnable confirmDynRegion = new CacheSerializableRunnable("Confirm dynamic region with no data on host"){

                @Override
                public void run2() throws CacheException {
                    Region r = LondonToNewYorkDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)r);
                    TestCase.assertEquals(AtlanticTestCacheListener.class, r.getAttributes().getCacheListener().getClass());
                    Region dr = r.getSubregion(dynamicRegionName);
                    TestCase.assertNotNull((Object)dr);
                    TestCase.assertEquals(AtlanticTestCacheListener.class, dr.getAttributes().getCacheListener().getClass());
                    TestCase.assertSame((Object)r.getAttributes().getCacheListener(), (Object)dr.getAttributes().getCacheListener());
                    TestCase.assertNotNull((Object)LondonToNewYorkDUnitTest.this.getCache().getRegion(name + "/" + dynamicRegionName));
                    TestCase.assertNull((Object)dr.getEntry((Object)"dynKey"));
                }
            };
            lGateway.invoke(confirmDynRegion);
            lClient.invoke(confirmDynRegion);
        }
        CacheSerializableRunnable destroyDynRegn = new CacheSerializableRunnable("Destroy Dynamic regions"){

            @Override
            public void run2() throws CacheException {
                Region dr = LondonToNewYorkDUnitTest.this.getCache().getRegion("__DynamicRegions");
                if (dr != null) {
                    dr.localDestroyRegion();
                }
            }
        };
        lGateway.invoke(destroyDynRegn);
        nGateway.invoke(destroyDynRegn);
        lClient.invoke(destroyDynRegn);
        nClient.invoke(destroyDynRegn);
    }

    static {
        CLIENT_RETRY = new Integer(250);
    }

    static class Key
    implements Serializable {
        int myValue;

        Key(int value) {
            this.myValue = value;
        }

        public String toString() {
            return "TestKey" + this.myValue;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }
    }

    public static class AtlanticTestCacheListener
    extends TestCacheListener
    implements Declarable2 {
        private int numMods = 0;

        @Override
        public synchronized void afterCreate2(EntryEvent event) {
            ++this.numMods;
        }

        @Override
        public synchronized void afterUpdate2(EntryEvent event) {
            ++this.numMods;
        }

        public synchronized int getMods() {
            return this.numMods;
        }

        public Properties getConfig() {
            return new Properties();
        }

        public void init(Properties props) {
        }

        public synchronized void resetMods() {
            this.numMods = 0;
        }
    }
}

