/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.SearchLoadAndWriteProcessor;
import com.gemstone.gemfire.internal.cache.Token;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class NetSearchMessagingDUnitTest
extends CacheTestCase {
    public NetSearchMessagingDUnitTest(String name) {
        super(name);
    }

    public void testOneMessageWithReplicates() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        this.createReplicate(vm0);
        this.createReplicate(vm1);
        this.createNormal(vm2);
        this.createEmpty(vm3);
        long vm0Count = this.getReceivedMessages(vm0);
        long vm1Count = this.getReceivedMessages(vm1);
        long vm2Count = this.getReceivedMessages(vm2);
        long vm3Count = this.getReceivedMessages(vm3);
        NetSearchMessagingDUnitTest.assertEquals(null, (Object)this.get(vm3, "a"));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm3Count + 1L), (long)this.getReceivedMessages(vm3));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm0Count + vm1Count + 1L), (long)(this.getReceivedMessages(vm0) + this.getReceivedMessages(vm1)));
        NetSearchMessagingDUnitTest.assertEquals((long)vm2Count, (long)this.getReceivedMessages(vm2));
        this.put(vm3, "a", "b");
        vm0Count = this.getReceivedMessages(vm0);
        vm1Count = this.getReceivedMessages(vm1);
        vm2Count = this.getReceivedMessages(vm2);
        vm3Count = this.getReceivedMessages(vm3);
        NetSearchMessagingDUnitTest.assertEquals((Object)"b", (Object)this.get(vm3, "a"));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm3Count + 1L), (long)this.getReceivedMessages(vm3));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm0Count + vm1Count + 1L), (long)(this.getReceivedMessages(vm0) + this.getReceivedMessages(vm1)));
        NetSearchMessagingDUnitTest.assertEquals((long)vm2Count, (long)this.getReceivedMessages(vm2));
    }

    public void testNetSearchNormals() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final VM vm3 = host.getVM(3);
        this.createNormal(vm0);
        this.createNormal(vm1);
        this.createNormal(vm2);
        this.createEmpty(vm3);
        long vm0Count = this.getReceivedMessages(vm0);
        long vm1Count = this.getReceivedMessages(vm1);
        long vm2Count = this.getReceivedMessages(vm2);
        final long vm3Count = this.getReceivedMessages(vm3);
        NetSearchMessagingDUnitTest.assertEquals(null, (Object)this.get(vm3, "a"));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm3Count + 3L), (long)this.getReceivedMessages(vm3));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm0Count + vm1Count + vm2Count + 3L), (long)(this.getReceivedMessages(vm0) + this.getReceivedMessages(vm1) + this.getReceivedMessages(vm2)));
        this.put(vm3, "a", "b");
        vm0Count = this.getReceivedMessages(vm0);
        vm1Count = this.getReceivedMessages(vm1);
        vm2Count = this.getReceivedMessages(vm2);
        vm3Count = this.getReceivedMessages(vm3);
        NetSearchMessagingDUnitTest.assertEquals((Object)"b", (Object)this.get(vm3, "a"));
        NetSearchMessagingDUnitTest.assertEquals((long)(vm2Count + 1L), (long)this.getReceivedMessages(vm2));
        DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return NetSearchMessagingDUnitTest.this.getReceivedMessages(vm3) == vm3Count + 3L;
            }

            @Override
            public String description() {
                return "expected " + (vm3Count + 3L) + " but was " + NetSearchMessagingDUnitTest.this.getReceivedMessages(vm3);
            }
        }, 2000L, 100L, true);
        NetSearchMessagingDUnitTest.assertEquals((long)(vm0Count + vm1Count + vm2Count + 3L), (long)(this.getReceivedMessages(vm0) + this.getReceivedMessages(vm1) + this.getReceivedMessages(vm2)));
    }

    public void testNetSearchNoLRU() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm1 = host.getVM(1);
        this.createOverflow(vm2, 5);
        this.createEmpty(vm1);
        this.put(vm2, "a", "1");
        this.put(vm2, "b", "2");
        this.put(vm2, "c", "3");
        this.put(vm2, "d", "4");
        this.put(vm2, "e", "5");
        this.put(vm2, "f", "6");
        SerializableCallable verifyEvicted = new SerializableCallable("verify eviction of 'a'"){

            public Object call() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                RegionEntry re = region.getRegionEntry((Object)"a");
                Object o = re.getValueInVM(null);
                DistributedTestCase.getLogWriter().info("key a=" + o);
                return o == null || o == Token.NOT_AVAILABLE;
            }
        };
        boolean evicted = (Boolean)vm2.invoke(verifyEvicted);
        NetSearchMessagingDUnitTest.assertTrue((String)"expected 'a' to be evicted", (boolean)evicted);
        Object value = this.get(vm1, "a");
        NetSearchMessagingDUnitTest.assertEquals((String)"expected to find '1' result from netSearch", (Object)"1", (Object)value);
        evicted = (Boolean)vm2.invoke(verifyEvicted);
        NetSearchMessagingDUnitTest.assertTrue((String)"expected 'a' to still be evicted", (boolean)evicted);
        vm2.invoke(new SerializableRunnable("verify other entries are not evicted"){

            @Override
            public void run() {
                String[] keys;
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                for (String key : keys = new String[]{"b", "c", "d", "e", "f"}) {
                    RegionEntry re = region.getRegionEntry((Object)key);
                    Object o = re.getValueInVM(null);
                    DistributedTestCase.getLogWriter().info("key " + key + "=" + o);
                    TestCase.assertTrue((String)("expected key " + key + " to not be evicted"), (o != null && o != Token.NOT_AVAILABLE ? 1 : 0) != 0);
                }
            }
        });
    }

    public void testNetSearchFailoverFromReplicate() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(new SerializableRunnable("Install listener"){

            @Override
            public void run() {
                DistributionMessageObserver ob = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof SearchLoadAndWriteProcessor.NetSearchRequestMessage) {
                            CacheTestCase.disconnectFromDS();
                        }
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)ob);
            }
        });
        this.createReplicate(vm0);
        this.createNormal(vm1);
        this.createNormal(vm2);
        this.createEmpty(vm3);
        this.put(vm3, "a", "b");
        long vm0Count = this.getReceivedMessages(vm0);
        long vm1Count = this.getReceivedMessages(vm1);
        long vm2Count = this.getReceivedMessages(vm2);
        long vm3Count = this.getReceivedMessages(vm3);
        NetSearchMessagingDUnitTest.assertEquals((Object)"b", (Object)this.get(vm3, "a"));
        vm0.invoke(new SerializableRunnable("check disconnected"){

            @Override
            public void run() {
                TestCase.assertNull((Object)GemFireCacheImpl.getInstance());
            }
        });
    }

    public void testNetSearchFailoverFromOneReplicateToAnother() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(new SerializableRunnable("Install listener"){

            @Override
            public void run() {
                DistributionMessageObserver ob = new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof SearchLoadAndWriteProcessor.NetSearchRequestMessage) {
                            CacheTestCase.disconnectFromDS();
                        }
                    }
                };
                DistributionMessageObserver.setInstance((DistributionMessageObserver)ob);
            }
        });
        this.createReplicate(vm0);
        this.createReplicate(vm1);
        this.createEmpty(vm3);
        this.put(vm3, "a", "b");
        boolean disconnected = false;
        while (!disconnected) {
            NetSearchMessagingDUnitTest.assertEquals((Object)"b", (Object)this.get(vm3, "a"));
            disconnected = (Boolean)vm0.invoke(new SerializableCallable("check disconnected"){

                public Object call() {
                    return GemFireCacheImpl.getInstance() == null;
                }
            });
        }
    }

    private Object put(VM vm, final String key, final String value) {
        return vm.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                Region region = cache.getRegion("region");
                DistributedTestCase.getLogWriter().info("putting key=" + key + "=" + value);
                Object result = region.put((Object)key, (Object)value);
                DistributedTestCase.getLogWriter().info("done putting key=" + key);
                return result;
            }
        });
    }

    private Object get(VM vm, final Object key) {
        return vm.invoke(new SerializableCallable("get " + key){

            public Object call() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                Region region = cache.getRegion("region");
                return region.get(key);
            }
        });
    }

    private long getReceivedMessages(VM vm) {
        return ((Long)vm.invoke(new SerializableCallable(){

            public Object call() {
                GemFireCacheImpl cache = (GemFireCacheImpl)NetSearchMessagingDUnitTest.this.getCache();
                cache.getDistributedSystem();
                return InternalDistributedSystem.getDMStats().getReceivedMessages();
            }
        })).intValue();
    }

    private void createEmpty(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.setConcurrencyChecksEnabled(false);
                rf.setDataPolicy(DataPolicy.EMPTY);
                rf.create("region");
            }
        });
    }

    private void createNormal(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.setConcurrencyChecksEnabled(false);
                rf.setDataPolicy(DataPolicy.NORMAL);
                rf.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                rf.create("region");
            }
        });
    }

    private void createOverflow(VM vm, final int count) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                rf.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)count, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                rf.create("region");
            }
        });
    }

    private void createReplicate(VM vm) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = NetSearchMessagingDUnitTest.this.getCache();
                RegionFactory rf = new RegionFactory();
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.setConcurrencyChecksEnabled(false);
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.create("region");
            }
        });
    }
}

