/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.EvictionDUnitTest;
import com.gemstone.gemfire.internal.cache.EvictionTestBase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import dunit.DistributedTestCase;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class OffHeapEvictionDUnitTest
extends EvictionDUnitTest {
    public OffHeapEvictionDUnitTest(String name) {
        super(name);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties properties = super.getDistributedSystemProperties();
        properties.setProperty("off-heap-memory-size", "200m");
        return properties;
    }

    @Override
    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            OffHeapEvictionDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(this.getDistributedSystemProperties());
            cache = CacheFactory.create((DistributedSystem)ds);
            OffHeapEvictionDUnitTest.assertNotNull((Object)cache);
            OffHeapEvictionDUnitTest.getLogWriter().info("cache= " + cache);
            OffHeapEvictionDUnitTest.getLogWriter().info("cache closed= " + cache.isClosed());
            cache.getResourceManager().setEvictionOffHeapPercentage(85.0f);
            ((GemFireCacheImpl)cache).getResourceManager().getOffHeapMonitor().stopMonitoring();
            OffHeapEvictionDUnitTest.getLogWriter().info("eviction= " + cache.getResourceManager().getEvictionOffHeapPercentage());
            OffHeapEvictionDUnitTest.getLogWriter().info("critical= " + cache.getResourceManager().getCriticalOffHeapPercentage());
        }
        catch (Exception e) {
            OffHeapEvictionDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    @Override
    public void raiseFakeNotification(VM vm, final String prName, final int noOfExpectedEvictions) {
        vm.invoke(new CacheSerializableRunnable("fakeNotification"){

            @Override
            public void run2() throws CacheException {
                final LocalRegion region = (LocalRegion)EvictionTestBase.cache.getRegion(prName);
                OffHeapEvictionDUnitTest.this.getEvictor().testAbortAfterLoopCount = 1;
                ((GemFireCacheImpl)EvictionTestBase.cache).getResourceManager().getOffHeapMonitor().updateStateAndSendEvent(0xB400000L);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        long currentEvictions = ((AbstractLRURegionMap)region.entries)._getLruList().stats().getEvictions();
                        if (Math.abs(currentEvictions - (long)noOfExpectedEvictions) <= 1L) {
                            return true;
                        }
                        if (currentEvictions > (long)noOfExpectedEvictions) {
                            TestCase.fail((String)this.description());
                        }
                        return false;
                    }

                    @Override
                    public String description() {
                        return "expected " + noOfExpectedEvictions + " evictions, but got " + ((AbstractLRURegionMap)region.entries)._getLruList().stats().getEvictions();
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
            }
        });
    }

    @Override
    public boolean getOffHeapEnabled() {
        return true;
    }

    @Override
    public HeapEvictor getEvictor() {
        return ((GemFireCacheImpl)cache).getOffHeapEvictor();
    }

    @Override
    public InternalResourceManager.ResourceType getResourceType() {
        return InternalResourceManager.ResourceType.OFFHEAP_MEMORY;
    }
}

