/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import delta.DeltaTestObj;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class P2PDeltaPropagationDUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static VM server2 = null;
    static VM server3 = null;
    private static Cache cache = null;
    private static int PORT1;
    private static int PORT2;
    private static final int NEW_INT = 11;
    private static final String NEW_STR = "DELTA";
    private static final int NUM_OF_CREATES = 3;
    static PoolImpl pool;
    private static final String REGION_NAME = "P2PDeltaPropagationDUnitTest_Region";
    private static int numOfUpdates;
    private static int hasDeltaBytes;
    private static boolean check;
    protected static Object waitLock;

    public P2PDeltaPropagationDUnitTest(String name) {
        super(name);
    }

    public void testP2PDeltaPropagationEnableScopeDAck() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
    }

    public void testP2PDeltaPropagationEnableScopeGlobal() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.GLOBAL, Boolean.FALSE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
    }

    public void testP2PDACKInvalidDeltaException() throws Exception {
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", new Object[]{Boolean.TRUE});
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", new Object[]{Boolean.TRUE});
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", new Object[]{Boolean.TRUE});
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "invalidate");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "destroy");
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "putDelta");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledWithInvalidate");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledWithDestroy");
    }

    public void testP2PDeltaPropagationEnableDirectAckTrue() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.NORMAL, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        ConnectionTable.threadWantsOwnResources();
        P2PDeltaPropagationDUnitTest.createServerCache(Boolean.TRUE, DataPolicy.NORMAL, Scope.DISTRIBUTED_ACK, Boolean.FALSE);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        P2PDeltaPropagationDUnitTest.put();
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
        ConnectionTable.threadWantsSharedResources();
    }

    public void testP2PDeltaPropagationEnableScopeDNoAck() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.NORMAL, Scope.DISTRIBUTED_NO_ACK, Boolean.FALSE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaDisabledServer");
    }

    public void testP2PDeltaPropagationDisable() throws Exception {
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE});
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", new Object[]{Boolean.FALSE});
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaDisabledServer");
    }

    public void testP2PDeltaPropagationEnableScopeDAckDataPolicyEmpty() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        Object[] args1 = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args1);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "getOnDeltaEnabledServer");
    }

    public void testP2PDeltaPropagationEnableScopeDAckDataPolicyEmptyWithRegionsCreateApi() throws Exception {
        Object[] args = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        Object[] args1 = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args1);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", args);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "create");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "verifyNoFailurePeer");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "verifyNoFailurePeer");
    }

    public void testPeerWithEmptyRegionIterestPolicyALLReceivesNoDelta() throws Exception {
        Object[] replicate = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        Object[] empty = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.TRUE, Boolean.TRUE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", replicate);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", replicate);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", empty);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "verifyDeltaReceived", new Object[]{3});
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "verifyNoDeltaReceived", new Object[]{3});
    }

    public void testPeerWithEmptyRegionDefaultIterestPolicyReceivesNoEvents() throws Exception {
        Object[] replicate = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        Object[] empty = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.TRUE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", replicate);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", replicate);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", empty);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "verifyDeltaReceived", new Object[]{3});
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "verifyNoDeltaReceived", new Object[]{0});
    }

    public void testPeerWithEmptyRegionAndNoCacheServerReceivesOnlyFullValue() throws Exception {
        int port1 = AvailablePort.getRandomAvailablePort((int)0);
        Object[] replicate = new Object[]{Boolean.TRUE, DataPolicy.REPLICATE, Scope.DISTRIBUTED_ACK, Boolean.FALSE};
        Object[] emptyWithServer = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.TRUE, Boolean.TRUE, port1};
        Object[] emptyWithoutServer = new Object[]{Boolean.TRUE, DataPolicy.EMPTY, Scope.DISTRIBUTED_ACK, Boolean.TRUE, Boolean.TRUE};
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", replicate);
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", emptyWithServer);
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "createServerCache", emptyWithoutServer);
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "put");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "verifyDeltaBytesReceived", new Object[]{2});
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "verifyDeltaBytesReceived", new Object[]{0});
    }

    public static void put() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        DeltaTestImpl test = new DeltaTestImpl();
        r1.put((Object)"KEY", (Object)test);
        test = new DeltaTestImpl();
        test.setIntVar(11);
        r1.put((Object)"KEY", (Object)test);
        test = new DeltaTestImpl();
        test.setStr(NEW_STR);
        r1.put((Object)"KEY", (Object)test);
    }

    public static void create() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        DeltaTestImpl test = new DeltaTestImpl();
        r1.create((Object)"KEY", (Object)test);
        test = new DeltaTestImpl();
        test.setIntVar(11);
        r1.create((Object)"KEY1", (Object)test);
        test = new DeltaTestImpl();
        test.setStr(NEW_STR);
        r1.create((Object)"KEY2", (Object)test);
    }

    public static void putDelta() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        DeltaTestImpl test = new DeltaTestImpl(9999, NEW_STR);
        test.setIntVar(11);
        r1.put((Object)"KEY", (Object)test);
    }

    public static void invalidate() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        r1.localInvalidate((Object)"KEY");
    }

    public static void destroy() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        r1.localDestroy((Object)"KEY");
    }

    public static void getOnDeltaEnabledWithInvalidate() throws Exception {
        P2PDeltaPropagationDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                Object val = r1.getEntry((Object)"KEY").getValue();
                return val instanceof DeltaTestImpl && ((DeltaTestImpl)val).getIntVar() == 11 && ((DeltaTestImpl)val).getStr().equals(P2PDeltaPropagationDUnitTest.NEW_STR);
            }

            @Override
            public String description() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                return "getOnDeltaEnabledWithInvalidate: current entry: " + r1.getEntry((Object)"KEY").getValue();
            }
        }, 30000L, 500L, true);
    }

    public static void getOnDeltaEnabledWithDestroy() throws Exception {
        P2PDeltaPropagationDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                return r1.getEntry((Object)"KEY") == null;
            }

            @Override
            public String description() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                return "getOnDeltaEnabledWithInvalidate: current entry: " + r1.getEntry((Object)"KEY").getValue();
            }
        }, 30000L, 500L, true);
    }

    public static void getOnDeltaEnabledServer() throws Exception {
        P2PDeltaPropagationDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                Object val = r1.getEntry((Object)"KEY").getValue();
                return val instanceof DeltaTestImpl && ((DeltaTestImpl)val).getIntVar() == 11 && ((DeltaTestImpl)val).getStr().equals(P2PDeltaPropagationDUnitTest.NEW_STR);
            }

            @Override
            public String description() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                return "getOnDeltaEnabledServer: current entry: " + r1.getEntry((Object)"KEY").getValue();
            }
        }, 30000L, 500L, true);
    }

    public static void getOnDeltaDisabledServer() throws Exception {
        P2PDeltaPropagationDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                Object val = r1.getEntry((Object)"KEY").getValue();
                return val instanceof DeltaTestImpl && ((DeltaTestImpl)val).getIntVar() != 11 && ((DeltaTestImpl)val).getStr().equals(P2PDeltaPropagationDUnitTest.NEW_STR);
            }

            @Override
            public String description() {
                Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
                return "getOnDeltaDisabledServer: current entry: " + r1.getEntry((Object)"KEY").getValue();
            }
        }, 30000L, 500L, true);
    }

    public static void checkForNoFullObjectResend() throws Exception {
        Region r1 = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        P2PDeltaPropagationDUnitTest.assertNull((Object)r1.getEntry((Object)"KEY").getValue());
    }

    public static void checkForFlag() throws Exception {
        P2PDeltaPropagationDUnitTest.assertFalse((boolean)check);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
        P2PDeltaPropagationDUnitTest.resetFlags();
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "resetFlags");
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    public static void createServerCache(Boolean flag) throws Exception {
        ConnectionTable.threadWantsSharedResources();
        P2PDeltaPropagationDUnitTest.createServerCache(flag, DataPolicy.DEFAULT, Scope.DISTRIBUTED_ACK, false);
    }

    public static void createServerCache(Boolean flag, DataPolicy policy, Scope scope, Boolean listener) throws Exception {
        P2PDeltaPropagationDUnitTest.createServerCache(flag, policy, scope, listener, Boolean.FALSE);
    }

    public static void createServerCache(Boolean flag, DataPolicy policy, Scope scope, Boolean listener, Boolean interestPolicyAll) throws Exception {
        P2PDeltaPropagationDUnitTest.createServerCache(flag, policy, scope, listener, interestPolicyAll, null);
    }

    public static void createServerCache(Boolean flag, DataPolicy policy, Scope scope, Boolean listener, Boolean interestPolicyAll, Integer port) throws Exception {
        P2PDeltaPropagationDUnitTest test = new P2PDeltaPropagationDUnitTest("temp");
        Properties props = new Properties();
        if (!flag.booleanValue()) {
            props.setProperty("delta-propagation", "false");
        }
        cache = test.createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        factory.setDataPolicy(policy);
        if (policy == DataPolicy.EMPTY && interestPolicyAll.booleanValue()) {
            factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
        }
        if (listener.booleanValue()) {
            factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterUpdate(EntryEvent event) {
                    numOfUpdates++;
                    cache.getLoggerI18n().fine("afterUpdate(): numOfUpdates = " + numOfUpdates);
                    cache.getLoggerI18n().fine("(key, val): " + event.getKey() + ", " + event.getNewValue());
                    if (event.getOldValue() != null && event.getOldValue() == event.getNewValue()) {
                        check = Boolean.TRUE;
                    }
                    if (((EntryEventImpl)event).getDeltaBytes() != null) {
                        cache.getLoggerI18n().fine("delta bytes received. " + hasDeltaBytes);
                        TestCase.assertTrue((String)("No full value received for event " + event), (((EntryEventImpl)event).getNewValue() != null ? 1 : 0) != 0);
                        hasDeltaBytes++;
                    } else {
                        cache.getLoggerI18n().fine("delta bytes not received.");
                    }
                }
            });
        }
        Region region = cache.createRegion(REGION_NAME, factory.create());
        if (!policy.isReplicate()) {
            region.create((Object)"KEY", (Object)"KEY");
        }
        if (port != null) {
            CacheServer server1 = cache.addCacheServer();
            server1.setPort(port.intValue());
            server1.start();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        P2PDeltaPropagationDUnitTest.closeCache();
        server1.invoke(P2PDeltaPropagationDUnitTest.class, "closeCache");
        server2.invoke(P2PDeltaPropagationDUnitTest.class, "closeCache");
        server3.invoke(P2PDeltaPropagationDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        check = false;
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void verifyNoFailurePeer() throws Exception {
        Region reg = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        long elapsed = 0L;
        long start = System.currentTimeMillis();
        while (elapsed < 10000L && reg.size() < 3) {
            try {
                elapsed = System.currentTimeMillis() - start;
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        P2PDeltaPropagationDUnitTest.assertTrue((String)"create's are missing", (reg.size() == 3 ? 1 : 0) != 0);
        CachePerfStats stats = ((DistributedRegion)cache.getRegion(REGION_NAME)).getCachePerfStats();
        long deltaFailures = stats.getDeltaFailedUpdates();
        P2PDeltaPropagationDUnitTest.assertTrue((String)"delta failures count is not zero", (deltaFailures == 0L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertTrue((String)"fromDelta invoked", (DeltaTestImpl.fromDeltaFeatureUsed() == false ? 1 : 0) != 0);
    }

    public static void verifyDeltaReceived(Integer updates) {
        Region region = cache.getRegion("/P2PDeltaPropagationDUnitTest_Region");
        CachePerfStats stats = ((DistributedRegion)cache.getRegion(REGION_NAME)).getCachePerfStats();
        long deltaFailures = stats.getDeltaFailedUpdates();
        long deltas = stats.getDeltaUpdates();
        P2PDeltaPropagationDUnitTest.assertTrue((String)"Failures while processing delta at receiver.", (deltaFailures == 0L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Expected 2 deltas to be processed at receiver but were " + deltas + " (statistics)"), (deltas == 2L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Expected 2 deltas to be processed at receiver but were " + DeltaTestImpl.getFromDeltaInvokations() + " (implementation counter)"), (DeltaTestImpl.getFromDeltaInvokations() == 2L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Expected " + updates + " updates but found " + numOfUpdates), (numOfUpdates == updates ? 1 : 0) != 0);
        DeltaTestImpl val = (DeltaTestImpl)region.getEntry((Object)"KEY").getValue();
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Latest value not received, found: " + val), (boolean)NEW_STR.equals(val.getStr()));
    }

    public static void verifyNoDeltaReceived(Integer updates) {
        CachePerfStats stats = ((DistributedRegion)cache.getRegion(REGION_NAME)).getCachePerfStats();
        long deltaFailures = stats.getDeltaFailedUpdates();
        long deltas = stats.getDeltaUpdates();
        P2PDeltaPropagationDUnitTest.assertTrue((String)"Failures while processing delta at receiver. But deltas were not expected.", (deltaFailures == 0L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertFalse((String)("Expected no deltas to be processed at receiver but processed were " + deltas + " (statistics)"), (deltas > 0L ? 1 : 0) != 0);
        P2PDeltaPropagationDUnitTest.assertFalse((String)("Expected no deltas to be processed at receiver but processed were " + DeltaTestImpl.getFromDeltaInvokations() + " (implementation counter)"), (boolean)DeltaTestImpl.fromDeltaFeatureUsed());
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Expected " + updates + " updates but found " + numOfUpdates), (numOfUpdates == updates ? 1 : 0) != 0);
    }

    public static void verifyDeltaBytesReceived(Integer num) {
        P2PDeltaPropagationDUnitTest.assertTrue((String)("Expected " + num + " events with delta bytes in it but found " + hasDeltaBytes), (hasDeltaBytes == num ? 1 : 0) != 0);
    }

    public static void resetFlags() {
        DeltaTestObj.resetDeltaInvokationCounters();
        numOfUpdates = 0;
        hasDeltaBytes = 0;
        check = false;
    }

    static {
        pool = null;
        numOfUpdates = 0;
        hasDeltaBytes = 0;
        check = false;
        waitLock = new Object();
    }
}

