/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.partition.PartitionListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionListenerDUnitTest
extends CacheTestCase {
    public PartitionListenerDUnitTest(String name) {
        super(name);
    }

    public void testAfterBucketRemovedCreated() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String regionName = this.getName() + "_region";
        this.createPR(vm1, regionName, false);
        this.createPR(vm2, regionName, false);
        this.createPR(vm0, regionName, true);
        this.createData(vm0, 0, 1000, "A", regionName);
        this.createPR(vm3, regionName, false);
        this.rebalance(vm3);
        HashMap<Integer, List<Integer>> allBucketsAndKeysRemoved = new HashMap<Integer, List<Integer>>();
        allBucketsAndKeysRemoved.putAll(this.getBucketsAndKeysRemoved(vm1, regionName));
        allBucketsAndKeysRemoved.putAll(this.getBucketsAndKeysRemoved(vm2, regionName));
        Map<Integer, List<Integer>> vm3BucketsAndKeysAdded = this.getBucketsAndKeysAdded(vm3, regionName);
        PartitionListenerDUnitTest.assertEquals(allBucketsAndKeysRemoved, vm3BucketsAndKeysAdded);
    }

    protected DistributedMember createPR(VM vm, final String regionName, final boolean isAccessor) throws Throwable {
        SerializableCallable createPrRegion = new SerializableCallable("createRegion"){

            public Object call() {
                Cache cache = PartitionListenerDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                if (isAccessor) {
                    paf.setLocalMaxMemory(0);
                }
                paf.addPartitionListener((PartitionListener)new TestPartitionListener());
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion(regionName, attr.create());
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke(createPrRegion);
    }

    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable("createData"){

            @Override
            public void run() {
                Cache cache = PartitionListenerDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    protected Map<Integer, List<Integer>> getBucketsAndKeysRemoved(VM vm, final String regionName) {
        SerializableCallable getBucketsAndKeysRemoved = new SerializableCallable("getBucketsAndKeysRemoved"){

            public Object call() {
                Cache cache = PartitionListenerDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                TestPartitionListener listener = (TestPartitionListener)region.getAttributes().getPartitionAttributes().getPartitionListeners()[0];
                return listener.getBucketsAndKeysRemoved();
            }
        };
        return (Map)vm.invoke(getBucketsAndKeysRemoved);
    }

    protected Map<Integer, List<Integer>> getBucketsAndKeysAdded(VM vm, final String regionName) {
        SerializableCallable getBucketsAndKeysAdded = new SerializableCallable("getBucketsAndKeysAdded"){

            public Object call() {
                Cache cache = PartitionListenerDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                TestPartitionListener listener = (TestPartitionListener)region.getAttributes().getPartitionAttributes().getPartitionListeners()[0];
                return listener.getBucketsAndKeysAdded();
            }
        };
        return (Map)vm.invoke(getBucketsAndKeysAdded);
    }

    protected void rebalance(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RebalanceOperation rebalance = PartitionListenerDUnitTest.this.getCache().getResourceManager().createRebalanceFactory().start();
                rebalance.getResults();
                return null;
            }
        });
    }

    protected static class TestPartitionListener
    extends PartitionListenerAdapter {
        private final Map<Integer, List<Integer>> bucketsAndKeysRemoved = new HashMap<Integer, List<Integer>>();
        private final Map<Integer, List<Integer>> bucketsAndKeysAdded = new HashMap<Integer, List<Integer>>();

        public Map<Integer, List<Integer>> getBucketsAndKeysRemoved() {
            return this.bucketsAndKeysRemoved;
        }

        public Map<Integer, List<Integer>> getBucketsAndKeysAdded() {
            return this.bucketsAndKeysAdded;
        }

        public void afterBucketRemoved(int bucketId, Iterable<?> keys) {
            Collection keysCol = (Collection)keys;
            if (!keysCol.isEmpty()) {
                ArrayList<Integer> keysList = new ArrayList<Integer>();
                for (Integer key : keysCol) {
                    keysList.add(key);
                }
                Collections.sort(keysList);
                this.bucketsAndKeysRemoved.put(bucketId, keysList);
            }
        }

        public void afterBucketCreated(int bucketId, Iterable<?> keys) {
            Collection keysCol = (Collection)keys;
            if (!keysCol.isEmpty()) {
                ArrayList<Integer> keysList = new ArrayList<Integer>();
                for (Integer key : keysCol) {
                    keysList.add(key);
                }
                Collections.sort(keysList);
                this.bucketsAndKeysAdded.put(bucketId, keysList);
            }
        }
    }
}

