/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionedRegionBucketCreationDistributionDUnitTest
extends PartitionedRegionDUnitTestCase {
    protected static String prPrefix = null;
    static final int MAX_REGIONS = 2;
    final int redundancy = 0;
    int localMaxMemory = 200;
    int totalBucketNumProperty = 11;
    VM[] vm = new VM[4];

    public PartitionedRegionBucketCreationDistributionDUnitTest(String name) {
        super(name);
    }

    public void testBucketCreationInMultiplePartitionRegion() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = this.getUniqueName();
        int startIndexForRegion = 0;
        int endIndexForRegion = 2;
        int startIndexForKey = 0;
        int endIndexForKey = 50;
        this.createMultiplePR(startIndexForRegion, endIndexForRegion);
        this.validateBucket2NodeBeforePutInMultiplePartitionedRegion(startIndexForRegion, endIndexForRegion);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Bucket2Node region of partition regions before any put() successfully validated ");
        this.putInMultiplePartitionedRegion(startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Put() operation successfully in partition regions");
        this.validateBucketsAfterPutInMultiplePartitionRegion(startIndexForRegion, endIndexForRegion);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Bucket regions of partition regions successfully validated");
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() Successfully completed");
    }

    public void testBucketCreationInPRPutFromOneNode() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testBucketCreationInPRFromOneNode";
        boolean startIndexForRegion = false;
        int endIndexForRegion = 2;
        long startIndexForKey = 0L;
        long endIndexForKey = this.totalBucketNumProperty;
        boolean startIndexForNode = false;
        int endIndexForNode = 4;
        List vmList = this.addNodeToList(0, 4);
        this.localMaxMemory = 200;
        this.createPartitionRegion(vmList, 0, 2, this.localMaxMemory, 0);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Partition Regions successfully created ");
        this.putInMultiplePartitionRegionFromOneVm(this.vm[0], 0, 2, 0L, endIndexForKey);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Put() Opereration done only from one VM ");
        int noBucketsExpectedOnEachNode = this.getNoBucketsExpectedOnEachNode();
        this.validateBucketsDistributionInMultiplePartitionRegion(0, 2, noBucketsExpectedOnEachNode);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Bucket regions are equally distributed");
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() successfully completed");
    }

    public void testBucketCreationInMultiplePartitionRegionFromAllNodes() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testBucketCreationInMultiplePartitionRegionFromAllNodes";
        int startIndexForRegion = 0;
        int endIndexForRegion = 2;
        long startIndexForKey = 0L;
        long endIndexForKey = this.totalBucketNumProperty;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 0);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Partition Regions successfully created ");
        this.putInMultiplePartitionedRegionFromAllVms(startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Put() Opereration done only from one VM ");
        int noBucketsExpectedOnEachNode = this.getNoBucketsExpectedOnEachNode() - 4;
        this.validateBucketsDistributionInMultiplePartitionRegion(startIndexForRegion, endIndexForRegion, noBucketsExpectedOnEachNode);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Bucket regions are equally distributed");
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() successfully created");
    }

    public void testBucketDistributionAfterNodeAdditionInPR() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testBucketDistributionAfterNodeAdditionInPR";
        int startIndexForRegion = 0;
        int endIndexForRegion = 2;
        int startIndexForKey = 0;
        int endIndexForKey = 5;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        List vmList = new ArrayList();
        startIndexForNode = 0;
        endIndexForNode = 3;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 0);
        startIndexForNode = 0;
        endIndexForNode = 3;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.putInMultiplePartitionedRegionFrom3Nodes(startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketDistributionAfterNodeAdditionInPR() - Put() operation successfully in partition regions on 3 Nodes");
        startIndexForNode = 3;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForKey, this.localMaxMemory, 0);
        startIndexForKey = 5;
        endIndexForKey = this.totalBucketNumProperty;
        this.putInMultiplePartitionedRegionFrom3Nodes(startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketDistributionAfterNodeAdditionInPR() - Put() operation successfully in partition regions on 4th node");
        this.validateBucketsOnAllNodes(startIndexForRegion, endIndexForRegion);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketDistributionAfterNodeAdditionInPR() - buckets on all the nodes are validated");
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketDistributionAfterNodeAdditionInPR() successfully created");
    }

    public void testTotalNumBucketProperty() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testTotalNumBucketProperty";
        int startIndexForRegion = 0;
        int endIndexForRegion = 1;
        int startIndexForKey = 0;
        int endIndexForKey = 20;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        boolean localRedundancy = true;
        this.createPRWithTotalNumPropSetList(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 1);
        this.putInMultiplePartitionRegionFromOneVm(this.vm[0], startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        int expectedNumBuckets = 11;
        this.validateTotalNumBuckets(prPrefix, vmList, startIndexForRegion, endIndexForRegion, expectedNumBuckets);
        startIndexForKey = 200;
        endIndexForKey = 400;
        this.putInMultiplePartitionedRegionFromAllVms(startIndexForRegion, endIndexForRegion, startIndexForKey, endIndexForKey);
        this.validateTotalNumBuckets(prPrefix, vmList, startIndexForRegion, endIndexForRegion, expectedNumBuckets);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testTotalNumBucketProperty() completed successfully");
    }

    public void _testLocalMaxMemoryInPartitionedRegion() throws Throwable {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = this.getUniqueName();
        int startIndexForRegion = 0;
        int endIndexForRegion = 1;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 1;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 0);
        this.putForLocalMaxMemoryInMultiplePR(prPrefix + 0);
    }

    public void testCompleteBucketAllocation() throws Exception {
        final String regionName = this.getUniqueName();
        int maxBuckets = 23;
        Host host = Host.getHost(0);
        this.createVMs(host);
        PartitionedRegionBucketCreationDistributionDUnitTest.invokeInEveryVM(new SerializableRunnable("Create PR"){

            @Override
            public void run() {
                PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache().createRegion(regionName, PartitionedRegionBucketCreationDistributionDUnitTest.this.createRegionAttrs(0, 10, 23));
            }
        });
        this.vm[0].invoke(new SerializableRunnable("Create keys"){

            @Override
            public void run() {
                Cache c = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                PartitionedRegion r = (PartitionedRegion)c.getRegion(regionName);
                int i = 0;
                do {
                    r.put((Object)new Integer(i), (Object)("v-" + Integer.toString(i)));
                } while (++i % 10 != 0 || r.getRegionAdvisor().getBucketSet().size() < 23);
            }
        });
    }

    private void destroyInMultiplePartitionedRegion(int startIndexForRegion, int endIndexForRegion, int startIndexForDestroy, int endIndexForDestroy) throws Throwable {
        int count;
        prPrefix = "testMemoryOfPartitionRegion";
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (endIndexForDestroy - startIndexForDestroy) / 4;
        async[0] = this.vm[0].invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, startIndexForDestroy, startIndexForDestroy + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, startIndexForDestroy + 1 * delta, startIndexForDestroy + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, startIndexForDestroy + 2 * delta, startIndexForDestroy + 3 * delta, startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, startIndexForDestroy + 3 * delta, endIndexForDestroy, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("Exception during " + count, async[count].getException());
        }
    }

    private void invalidateInMultiplePartitionedRegion(int startIndexForRegion, int endIndexForRegion, int startIndexForInvalidate, int endIndexForInvalidate) throws Throwable {
        int count;
        prPrefix = "testMemoryOfPartitionRegion";
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (endIndexForInvalidate - startIndexForInvalidate) / 4;
        async[0] = this.vm[0].invokeAsync(this.invalidatesInMultiplePartitionRegion(prPrefix, startIndexForInvalidate, startIndexForInvalidate + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.invalidatesInMultiplePartitionRegion(prPrefix, startIndexForInvalidate + 1 * delta, startIndexForInvalidate + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.invalidatesInMultiplePartitionRegion(prPrefix, startIndexForInvalidate + 2 * delta, startIndexForInvalidate + 3 * delta, startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.invalidatesInMultiplePartitionRegion(prPrefix, startIndexForInvalidate + 3 * delta, endIndexForInvalidate, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("Exception during " + count, async[count].getException());
        }
    }

    private void putInMultiplePartitionedRegionFrom3Nodes(int startIndexForRegion, int endIndexForRegion, int startIndexForKey, int endIndexForKey) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 3;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (endIndexForKey - startIndexForKey) / 3;
        async[0] = this.vm[0].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey, startIndexForKey + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey + 1 * delta, startIndexForKey + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey + 2 * delta, endIndexForKey, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("exception during" + count, async[count].getException());
        }
    }

    private void putInMultiplePartitionRegionFromOneVm(VM vm0, int startIndexForRegion, int endIndexForRegion, long startIndexForKey, long endIndexForKey) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 3;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.putFromOneVm(startIndexForKey, endIndexForKey, startIndexForRegion, endIndexForRegion));
        async[1] = vm0.invokeAsync(this.putFromOneVm(startIndexForKey + (long)this.totalBucketNumProperty, endIndexForKey + (long)this.totalBucketNumProperty, startIndexForRegion, endIndexForRegion));
        async[2] = vm0.invokeAsync(this.putFromOneVm(startIndexForKey + (long)(2 * this.totalBucketNumProperty), endIndexForKey + (long)(2 * this.totalBucketNumProperty), startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private CacheSerializableRunnable putFromOneVm(final long startIndexForKey, final long endIndexForKey, final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable putFromVm = new CacheSerializableRunnable("putFromOneVm"){
            String innerPrPrefix;
            {
                super(x0);
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((Object)pr);
                    for (long k = startIndexForKey; k < endIndexForKey; ++k) {
                        Long key = new Long(k);
                        pr.put((Object)key, (Object)(this.innerPrPrefix + k));
                    }
                }
            }
        };
        return putFromVm;
    }

    private void putInMultiplePartitionedRegion(int startIndexForRegion, int endIndexForRegion, int startIndexForKey, int endIndexForKey) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (endIndexForKey - startIndexForKey) / 4;
        async[0] = this.vm[0].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey, startIndexForKey + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey + 1 * delta, startIndexForKey + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey + 2 * delta, startIndexForKey + 3 * delta, startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.putInMultiplePartitionRegion(prPrefix, startIndexForKey + 3 * delta, endIndexForKey, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private void putInMultiplePartitionedRegionFromAllVms(int startIndexForRegion, int endIndexForRegion, long startIndexForKey, long endIndexForKey) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 8;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        long delta = (endIndexForKey - startIndexForKey) / 4L;
        async[0] = this.vm[0].invokeAsync(this.putFromOneVm(startIndexForKey, startIndexForKey + 1L * delta, startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.putFromOneVm(startIndexForKey + 1L * delta, startIndexForKey + 2L * delta, startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.putFromOneVm(startIndexForKey + 2L * delta, startIndexForKey + 3L * delta, startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.putFromOneVm(startIndexForKey + 3L * delta, endIndexForKey, startIndexForRegion, endIndexForRegion));
        delta = ((endIndexForKey += (long)this.totalBucketNumProperty) - (startIndexForKey += (long)this.totalBucketNumProperty)) / 4L;
        async[4] = this.vm[0].invokeAsync(this.putFromOneVm(startIndexForKey, startIndexForKey + 1L * delta, startIndexForRegion, endIndexForRegion));
        async[5] = this.vm[1].invokeAsync(this.putFromOneVm(startIndexForKey + 1L * delta, startIndexForKey + 2L * delta, startIndexForRegion, endIndexForRegion));
        async[6] = this.vm[2].invokeAsync(this.putFromOneVm(startIndexForKey + 2L * delta, startIndexForKey + 3L * delta, startIndexForRegion, endIndexForRegion));
        async[7] = this.vm[3].invokeAsync(this.putFromOneVm(startIndexForKey + 3L * delta, endIndexForKey, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private void validateBucket2NodeBeforePutInMultiplePartitionedRegion(int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = this.vm[0].invokeAsync(this.validateBucket2NodeBeforePut(startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.validateBucket2NodeBeforePut(startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.validateBucket2NodeBeforePut(startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.validateBucket2NodeBeforePut(startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().warning("Failure in async invocation on vm " + this.vm[count] + " with exception " + async[count].getException());
            throw async[count].getException();
        }
    }

    private void validateBucketsAfterPutInMultiplePartitionRegion(int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 8;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = this.vm[0].invokeAsync(this.validateBucketCreationAfterPut(startIndexForRegion, endIndexForRegion));
        async[1] = this.vm[1].invokeAsync(this.validateBucketCreationAfterPut(startIndexForRegion, endIndexForRegion));
        async[2] = this.vm[2].invokeAsync(this.validateBucketCreationAfterPut(startIndexForRegion, endIndexForRegion));
        async[3] = this.vm[3].invokeAsync(this.validateBucketCreationAfterPutForNode3(startIndexForRegion, endIndexForRegion));
        for (count = 0; count < 4; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < 4; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("got exception on " + count, async[count].getException());
        }
        async[4] = this.vm[0].invokeAsync(this.validateBucketScopeAfterPut(startIndexForRegion, endIndexForRegion));
        async[5] = this.vm[1].invokeAsync(this.validateBucketScopeAfterPut(startIndexForRegion, endIndexForRegion));
        async[6] = this.vm[2].invokeAsync(this.validateBucketScopeAfterPut(startIndexForRegion, endIndexForRegion));
        async[7] = this.vm[3].invokeAsync(this.validateBucketCreationAfterPutForNode3(startIndexForRegion, endIndexForRegion));
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().warning("Failure of async invocation on VM " + this.vm[count] + " exception thrown " + async[count].getException());
            throw async[count].getException();
        }
    }

    private void validateBucketsDistributionInMultiplePartitionRegion(int startIndexForRegion, int endIndexForRegion, int noBucketsExpectedOnEachNode) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = this.vm[0].invokeAsync(this.validateBucketsDistribution(startIndexForRegion, endIndexForRegion, noBucketsExpectedOnEachNode));
        async[1] = this.vm[1].invokeAsync(this.validateBucketsDistribution(startIndexForRegion, endIndexForRegion, noBucketsExpectedOnEachNode));
        async[2] = this.vm[2].invokeAsync(this.validateBucketsDistribution(startIndexForRegion, endIndexForRegion, noBucketsExpectedOnEachNode));
        async[3] = this.vm[3].invokeAsync(this.validateBucketsDistribution(startIndexForRegion, endIndexForRegion, noBucketsExpectedOnEachNode));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionBucketCreationDistributionDUnitTest.fail("Validation of bucket distribution failed on " + count, async[count].getException());
        }
    }

    private void validateBucketsOnAllNodes(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateAllNodes = new CacheSerializableRunnable("validateBucketsOnAllNodes"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                int threshold = 0;
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertNotNull((Object)pr.getDataStore());
                    TestCase.assertTrue((pr.getDataStore().localBucket2RegionMap.size() > threshold ? 1 : 0) != 0);
                }
            }
        };
        this.vm[0].invoke(validateAllNodes);
        this.vm[1].invoke(validateAllNodes);
        this.vm[2].invoke(validateAllNodes);
        this.vm[3].invoke(validateAllNodes);
    }

    private void validateRedundancy(VM vm0, final int startIndexForRegion, final int endIndexForRegion, final int redundancyManageFlag) {
        vm0.invoke(new CacheSerializableRunnable("validateRedundancy"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                for (int i = this.innerStartIndexForRegion; i < endIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((Object)pr);
                    Set bucketIds = pr.getDataStore().localBucket2RegionMap.keySet();
                    for (Integer bucketId : bucketIds) {
                        if (redundancyManageFlag == 0) {
                            if (pr.getRegionAdvisor().getBucketRedundancy(bucketId.intValue()) < 0) continue;
                            TestCase.fail((String)("Redundancy satisfied for the partition region " + pr.getName()));
                            continue;
                        }
                        if (pr.getRegionAdvisor().getBucketRedundancy(bucketId.intValue()) >= 0) continue;
                        TestCase.fail((String)("Redundancy not satisfied for the partition region " + pr.getName()));
                    }
                    if (redundancyManageFlag == 0) {
                        DistributedTestCase.getLogWriter().info("validateRedundancy() - Redundancy not satisfied for the partition region  : " + pr.getName());
                        continue;
                    }
                    DistributedTestCase.getLogWriter().info("validateRedundancy() - Redundancy satisfied for the partition region  : " + pr.getName());
                }
            }
        });
    }

    private CacheSerializableRunnable validateBucketCreationAfterPut(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateAfterPut = new CacheSerializableRunnable("validateAfterPut"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            int innerMidIndexForRegion;
            int innerQuarterIndex;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
                this.innerMidIndexForRegion = this.innerStartIndexForRegion + (endIndexForRegion - startIndexForRegion) / 2;
                this.innerQuarterIndex = this.innerStartIndexForRegion + (endIndexForRegion - startIndexForRegion) / 4;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                Region root = cache.getRegion("__PR");
                TestCase.assertNotNull((String)"Root regions is null", (Object)root);
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertTrue((pr.getRegionAdvisor().getBucketSet().size() > 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((String)("Size of local region map should be > 0 for region: " + pr.getFullPath()), (pr.getDataStore().localBucket2RegionMap.size() > 0 ? 1 : 0) != 0);
                    Set bucketIds = pr.getDataStore().localBucket2RegionMap.keySet();
                    for (Integer key : bucketIds) {
                        BucketRegion val = (BucketRegion)pr.getDataStore().localBucket2RegionMap.get(key);
                        Region bucketRegion = root.getSubregion(pr.getBucketName(key.intValue()));
                        TestCase.assertTrue((boolean)bucketRegion.getFullPath().equals(val.getFullPath()));
                        TestCase.assertNotNull((String)"Bucket region cannot be null", (Object)bucketRegion);
                        TestCase.assertEquals((String)"Parent region is not root", (Object)root, (Object)bucketRegion.getParentRegion());
                    }
                }
            }
        };
        return validateAfterPut;
    }

    private CacheSerializableRunnable validateBucketCreationAfterPutForNode3(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateAfterPut = new CacheSerializableRunnable("validateBucketCreationAfterPutForNode3"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((String)("This Partition Region is null " + pr.getName()), (Object)pr);
                    TestCase.assertNull((String)"DataStore should be null", (Object)pr.getDataStore());
                }
            }
        };
        return validateAfterPut;
    }

    private CacheSerializableRunnable validateBucketScopeAfterPut(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateAfterPut = new CacheSerializableRunnable("validateBucketScopeAfterPut"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            int innerMidIndexForRegion;
            int innerQuarterIndex;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
                this.innerMidIndexForRegion = this.innerStartIndexForRegion + (endIndexForRegion - startIndexForRegion) / 2;
                this.innerQuarterIndex = this.innerStartIndexForRegion + (endIndexForRegion - startIndexForRegion) / 4;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                Region root = cache.getRegion("__PR");
                TestCase.assertNotNull((String)"Root regions is null", (Object)root);
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertTrue((pr.getRegionAdvisor().getBucketSet().size() > 0 ? 1 : 0) != 0);
                    Set bucketIds = pr.getDataStore().localBucket2RegionMap.keySet();
                    for (Integer key : bucketIds) {
                        Region bucketRegion = root.getSubregion(pr.getBucketName(key.intValue()));
                        TestCase.assertNotNull((String)"Bucket region cannot be null", (Object)bucketRegion);
                        TestCase.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)bucketRegion.getAttributes().getScope());
                    }
                }
            }
        };
        return validateAfterPut;
    }

    private CacheSerializableRunnable validateBucket2NodeBeforePut(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateBucketBeforePut = new CacheSerializableRunnable("Bucket2NodeValidation"){
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            String innerPrPrefix;
            {
                super(x0);
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                Region root = cache.getRegion("__PR");
                TestCase.assertNotNull((String)"Root regions is null", (Object)root);
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertTrue((pr.getRegionAdvisor().getNumProfiles() > 0 ? 1 : 0) != 0);
                    TestCase.assertTrue((pr.getRegionAdvisor().getNumDataStores() > 0 ? 1 : 0) != 0);
                    int bucketSetSize = pr.getRegionAdvisor().getCreatedBucketsCount();
                    DistributedTestCase.getLogWriter().info("BucketSet size " + bucketSetSize);
                    if (bucketSetSize == 0) continue;
                    Set buckets = pr.getRegionAdvisor().getBucketSet();
                    Iterator it = buckets.iterator();
                    int numBucketsWithStorage = 0;
                    try {
                        while (true) {
                            Integer bucketId = (Integer)it.next();
                            pr.getRegionAdvisor().getBucket(bucketId.intValue()).getBucketAdvisor().dumpProfiles(pr.getCache().getLoggerI18n(), "Bucket owners for bucket " + pr.bucketStringForLogs(bucketId.intValue()));
                            ++numBucketsWithStorage;
                        }
                    }
                    catch (NoSuchElementException end) {
                        DistributedTestCase.getLogWriter().info("BucketSet iterations " + numBucketsWithStorage);
                        TestCase.fail((String)"There should be no buckets assigned");
                    }
                }
            }
        };
        return validateBucketBeforePut;
    }

    private CacheSerializableRunnable validateBucketsDistribution(final int startIndexForRegion, final int endIndexForRegion, final int noBucketsExpectedOnEachNode) {
        CacheSerializableRunnable validateBucketDist = new CacheSerializableRunnable("validateBucketsDistribution"){
            String innerPrPrefix;
            {
                super(x0);
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                final Region root = cache.getRegion("__PR");
                TestCase.assertNotNull((String)"Root regions is null", (Object)root);
                for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                    final PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((String)("This region can not be null" + pr.getName()), (Object)pr);
                    TestCase.assertNotNull((Object)pr.getDataStore());
                    short localBSize = pr.getDataStore().getBucketsManaged();
                    DistributedTestCase.getLogWriter().info("validateBucketsDistribution() - Number of bukctes for " + pr.getName() + " : " + localBSize);
                    TestCase.assertTrue((String)("Bucket Distribution for region = " + pr.getFullPath() + " is not correct for member " + pr.getDistributionManager().getId() + " existing size " + localBSize + " smaller than expected " + noBucketsExpectedOnEachNode), (localBSize >= noBucketsExpectedOnEachNode ? 1 : 0) != 0);
                    pr.getDataStore().visitBuckets(new PartitionedRegionDataStore.BucketVisitor(){

                        public void visit(Integer bucketId, Region r) {
                            Region bucketRegion = root.getSubregion(pr.getBucketName(bucketId.intValue()));
                            TestCase.assertEquals((String)bucketRegion.getFullPath(), (String)r.getFullPath());
                        }
                    });
                }
            }
        };
        return validateBucketDist;
    }

    private void createVMs(Host host) {
        for (int i = 0; i < 4; ++i) {
            this.vm[i] = host.getVM(i);
        }
    }

    private void createPartitionRegion(List vmList, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy) {
        for (VM vm : vmList) {
            vm.invoke(this.createMultiplePRWithTotalNumBucketPropSet(prPrefix, startIndexForRegion, endIndexForRegion, redundancy, localMaxMemory, 11));
        }
    }

    private void createPRWithTotalNumPropSetList(List vmList, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy) {
        for (VM vm : vmList) {
            vm.invoke(this.createMultiplePRWithTotalNumBucketPropSet(prPrefix, startIndexForRegion, endIndexForRegion, redundancy, localMaxMemory, 11));
        }
    }

    CacheSerializableRunnable createMultiplePRWithTotalNumBucketPropSet(final String prPrefix, final int startIndexForRegion, final int endIndexForRegion, final int redundancy, final int localMaxMem, final int numBuckets) {
        CacheSerializableRunnable createPRWithTotalNumBucketPropSet = new CacheSerializableRunnable("createPRWithTotalNumBucketPropSet"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                    cache.createRegion(prPrefix + i, PartitionedRegionBucketCreationDistributionDUnitTest.this.createRegionAttrs(redundancy, localMaxMem, numBuckets));
                }
                DistributedTestCase.getLogWriter().info("createMultiplePartitionRegion() - Partition Regions Successfully Completed ");
            }
        };
        return createPRWithTotalNumBucketPropSet;
    }

    private void validateTotalNumBuckets(String prPrefix, List vmList, int startIndexForRegion, int endIndexForRegion, int expectedNumBuckets) {
        for (VM vm : vmList) {
            vm.invoke(this.validateTotalNumberOfBuckets(prPrefix, expectedNumBuckets, startIndexForRegion, endIndexForRegion));
        }
    }

    CacheSerializableRunnable validateTotalNumberOfBuckets(final String prPrefix, final int expectedNumBuckets, final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateTotNumBuckets = new CacheSerializableRunnable("validateTotNumBuckets"){
            String innerPrPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            {
                super(x0);
                this.innerPrPrefix = prPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + i);
                    TestCase.assertNotNull((String)("This region is null " + pr.getName()), (Object)pr);
                    Set bucketsWithStorage = pr.getRegionAdvisor().getBucketSet();
                    TestCase.assertEquals((int)expectedNumBuckets, (int)bucketsWithStorage.size());
                }
                DistributedTestCase.getLogWriter().info("Total Number of buckets validated in partition region");
            }
        };
        return validateTotNumBuckets;
    }

    private List addNodeToList(int startIndexForNode, int endIndexForNode) {
        ArrayList<VM> localvmList = new ArrayList<VM>();
        for (int i = startIndexForNode; i < endIndexForNode; ++i) {
            localvmList.add(this.vm[i]);
        }
        return localvmList;
    }

    void createMultiplePR(int startIndexForRegion, int endIndexForRegion) {
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        int midIndexForRegion = (endIndexForRegion - startIndexForRegion) / 2;
        startIndexForNode = 0;
        endIndexForNode = 3;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.createPartitionRegion(vmList, startIndexForRegion, midIndexForRegion, this.localMaxMemory, 0);
        startIndexForNode = 3;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 0;
        this.createPartitionRegion(vmList, startIndexForRegion, midIndexForRegion, this.localMaxMemory, 0);
        startIndexForNode = 0;
        endIndexForNode = 3;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        boolean redundancyTwo = true;
        this.createPartitionRegion(vmList, midIndexForRegion, endIndexForNode, this.localMaxMemory, 1);
        startIndexForNode = 3;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 0;
        this.createPartitionRegion(vmList, midIndexForRegion, endIndexForNode, this.localMaxMemory, 1);
        PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().info("testBucketCerationInMultiPlePartitionRegion() - Partition Regions successfully created ");
    }

    private void calculateTotalMemoryOfPartitionRegion() {
        for (int i = 0; i < 4; ++i) {
            if (this.vm[i] == null) {
                PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter().fine("VM is null" + this.vm[i]);
            }
            this.vm[i].invoke(this.calculateMemoryOfPartitionRegion(i, i + 1));
        }
    }

    private void checkTotalMemoryOfPartitionRegion() {
        CacheSerializableRunnable testTotalMemory = new CacheSerializableRunnable("testTotalMemory"){
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            String innerPrPrefix;
            List sizeList;
            {
                this.innerStartIndexForKey = 0;
                this.innerEndIndexForKey = 4;
                this.innerPrPrefix = prPrefix;
                this.sizeList = new ArrayList();
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                this.innerPrPrefix = "createPRForStrorage";
                PartitionedRegion prForStorage = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + 0);
                for (int i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                    Object obj = prForStorage.get((Object)new Long(i));
                    this.sizeList.add(obj);
                }
                Iterator sizeItr = this.sizeList.iterator();
                Object objSize = sizeItr.next();
                while (sizeItr.hasNext()) {
                    TestCase.assertEquals(sizeItr.next(), objSize);
                }
                DistributedTestCase.getLogWriter().info("Size of partition region on each node is equal");
            }
        };
        this.vm[0].invoke(testTotalMemory);
    }

    private CacheSerializableRunnable calculateMemoryOfPartitionRegion(final int startIndexForKey, final int endIndexForKey) {
        CacheSerializableRunnable calulateTotalMemory = new CacheSerializableRunnable("calulateTotalMemory"){
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            String innerPrPrefix;
            {
                super(x0);
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/testMemoryOfPartitionRegion0");
                TestCase.assertNotNull((String)"pr can not be null", (Object)pr);
                TestCase.assertNotNull((String)"DataStore cannot be null", (Object)pr.getDataStore());
                long prMemory = pr.getDataStore().currentAllocatedMemory();
                this.innerPrPrefix = "createPRForStrorage";
                PartitionedRegion prForStorage = (PartitionedRegion)cache.getRegion("/" + this.innerPrPrefix + 0);
                for (int i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                    prForStorage.put((Object)new Long(i), (Object)new Long(prMemory));
                }
            }
        };
        return calulateTotalMemory;
    }

    private int getNoBucketsExpectedOnEachNode() {
        int noBucketsExpectedOnEachNode = this.totalBucketNumProperty / 4 - 1;
        return noBucketsExpectedOnEachNode;
    }

    protected RegionAttributes createRegionAttrs(int red, int localMaxMem, int numBuckets) {
        AttributesFactory attr = new AttributesFactory();
        attr.setMirrorType(MirrorType.NONE);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(red).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(numBuckets).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    private void putForLocalMaxMemoryInMultiplePR(String regionName) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[]{this.vm[0].invokeAsync(this.doPutForLocalMaxMemory(regionName, "vm0")), this.vm[1].invokeAsync(this.doPutForLocalMaxMemory(regionName, "vm1")), this.vm[2].invokeAsync(this.doPutForLocalMaxMemory(regionName, "vm2")), this.vm[3].invokeAsync(this.doPutForLocalMaxMemory(regionName, "vm3"))};
        for (count = 0; count < 4; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionBucketCreationDistributionDUnitTest.getLogWriter());
        }
        for (count = 0; count < 4; ++count) {
            PartitionedRegionBucketCreationDistributionDUnitTest.assertTrue((boolean)async[count].exceptionOccurred());
            PartitionedRegionBucketCreationDistributionDUnitTest.assertTrue((boolean)(async[count].getException() instanceof PartitionedRegionStorageException));
        }
    }

    private CacheSerializableRunnable doPutForLocalMaxMemory(final String regionName, final String key) throws Exception {
        CacheSerializableRunnable putForLocalMaxMemory = new CacheSerializableRunnable("putForLocalMaxMemory"){

            @Override
            public void run2() {
                int MAX_SIZE = 1024;
                Cache cache = PartitionedRegionBucketCreationDistributionDUnitTest.this.getCache();
                byte[] Obj = new byte[1024];
                Arrays.fill(Obj, (byte)65);
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + regionName);
                for (int i = 0; i < 2048; ++i) {
                    pr.put((Object)(key + i), (Object)Obj);
                    DistributedTestCase.getLogWriter().info("MAXSIZE : " + i);
                }
                DistributedTestCase.getLogWriter().info("Put successfully done for vm" + key);
            }
        };
        return putForLocalMaxMemory;
    }
}

