/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class PartitionedRegionCacheXMLExampleDUnitTest
extends PartitionedRegionDUnitTestCase {
    protected static Cache cache;

    public PartitionedRegionCacheXMLExampleDUnitTest(String name) {
        super(name);
    }

    public void testExampleWithBothRootRegion() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable createCache = new CacheSerializableRunnable("createCache"){

            @Override
            public void run2() throws CacheException {
                Properties props = new Properties();
                String xmlfilepath = System.getProperty("JTESTS") + "/com/gemstone/gemfire/internal/cache/PartitionRegionCacheExample1.xml";
                props.setProperty("cache-xml-file", xmlfilepath);
                PartitionedRegionCacheXMLExampleDUnitTest.this.getSystem(props);
                cache = PartitionedRegionCacheXMLExampleDUnitTest.this.getCache();
            }
        };
        CacheSerializableRunnable validateRegion = new CacheSerializableRunnable("validateRegion"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("/firstPartitionRegion");
                TestCase.assertNotNull((String)"Partiton region cannot be null", (Object)pr1);
                Object obj = pr1.get((Object)"1");
                TestCase.assertNotNull((String)"CacheLoader is not invoked", (Object)obj);
                pr1.put((Object)"key1", (Object)"value1");
                TestCase.assertEquals((Object)pr1.get((Object)"key1"), (Object)"value1");
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("/secondPartitionedRegion");
                TestCase.assertNotNull((String)"Partiton region cannot be null", (Object)pr2);
                pr2.put((Object)"key2", (Object)"value2");
                TestCase.assertEquals((Object)pr2.get((Object)"key2"), (Object)"value2");
            }
        };
        CacheSerializableRunnable disconnect = new CacheSerializableRunnable("disconnect"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.closeCache();
                CacheTestCase.disconnectFromDS();
            }
        };
        vm0.invoke(createCache);
        vm1.invoke(createCache);
        vm0.invoke(validateRegion);
        vm1.invoke(disconnect);
        vm1.invoke(createCache);
        vm1.invoke(validateRegion);
    }

    public void testExampleWithSubRegion() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createCacheSubregion = new CacheSerializableRunnable("createCacheSubregion"){

            @Override
            public void run2() throws CacheException {
                Properties props = new Properties();
                String xmlfilepath = System.getProperty("JTESTS") + "/com/gemstone/gemfire/internal/cache/PartitionRegionCacheExample2.xml";
                props.setProperty("cache-xml-file", xmlfilepath);
                PartitionedRegionCacheXMLExampleDUnitTest.this.getSystem(props);
                cache = PartitionedRegionCacheXMLExampleDUnitTest.this.getCache();
            }
        };
        CacheSerializableRunnable validateSubRegion = new CacheSerializableRunnable("validateRegion"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/root/PartitionedSubRegion");
                TestCase.assertNotNull((String)"Partiton region cannot be null", (Object)pr);
                TestCase.assertTrue((boolean)PartitionedRegionHelper.isSubRegion((String)pr.getFullPath()));
                Object obj = pr.get((Object)"1");
                TestCase.assertNotNull((String)"CacheLoader is not invoked", (Object)obj);
                pr.put((Object)"key1", (Object)"value1");
                TestCase.assertEquals((Object)pr.get((Object)"key1"), (Object)"value1");
            }
        };
        vm2.invoke(createCacheSubregion);
        vm3.invoke(createCacheSubregion);
        vm2.invoke(validateSubRegion);
    }
}

