/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class PartitionedRegionCreationDUnitTest
extends PartitionedRegionDUnitTestCase {
    static Properties props = new Properties();
    static final int MAX_REGIONS = 1;
    static final int totalNumBuckets = 7;
    SerializableRunnable createPrRegion = new CacheSerializableRunnable("createPrRegion"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            PartitionAttributes prAttr = paf.create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
            paf.setTotalNumBuckets(7);
            prAttr = paf.create();
            attr.setPartitionAttributes(prAttr);
            regionAttribs = attr.create();
            cache.createRegion("PR2", regionAttribs);
        }
    };
    SerializableRunnable createPrRegionOnlyAccessor = new CacheSerializableRunnable("createPrRegionOnlyAccessor"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            PartitionAttributes prAttr = paf.setLocalMaxMemory(0).create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            PartitionedRegion accessor = (PartitionedRegion)cache.createRegion("PR1", regionAttribs);
            DistributedTestCase.getLogWriter().info("Region created in VM1.");
            TestCase.assertEquals((int)accessor.getTotalNumberOfBuckets(), (int)113);
            try {
                cache.getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                accessor = (PartitionedRegion)cache.createRegion("PR2", regionAttribs);
                TestCase.fail((String)"Creation of a Partitioned Region was allowed with incompatible GLOBAL_MAX_BUCKETS setting");
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                cache.getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
            }
            Properties globalProps = new Properties();
            globalProps.setProperty("GLOBAL_MAX_BUCKETS", "7");
            paf.setGlobalProperties(globalProps);
            attr.setPartitionAttributes(paf.create());
            accessor = (PartitionedRegion)cache.createRegion("PR2", attr.create());
            TestCase.assertEquals((int)accessor.getTotalNumberOfBuckets(), (int)7);
        }
    };

    public PartitionedRegionCreationDUnitTest(String name) {
        super(name);
    }

    public void testSequentialCreation() throws Exception {
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****CREATION TEST ACK STARTED*****");
        String name = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        for (int cnt = 0; cnt < 1; ++cnt) {
            vm0.invoke(this.getCacheSerializableRunnableForPRCreate(name + String.valueOf(cnt), 0, 0, "NONE"));
            vm1.invoke(this.getCacheSerializableRunnableForPRCreate(name + String.valueOf(cnt), 0, 0, "NONE"));
            vm2.invoke(this.getCacheSerializableRunnableForPRCreate(name + String.valueOf(cnt), 0, 0, "NONE"));
            vm3.invoke(this.getCacheSerializableRunnableForPRCreate(name + String.valueOf(cnt), 0, 0, "NONE"));
        }
        vm0.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm1.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm2.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm3.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****CREATION TEST ACK ENDED*****");
    }

    public void testConcurrentCreation() throws Throwable {
        int count;
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****CREATION TEST NO_ACK STARTED*****");
        String name = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[1] = vm1.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[2] = vm2.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[3] = vm3.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm1.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm2.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        vm3.invoke(this.getCacheSerializableRunnableForPRValidate(name));
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****CREATION TEST NO_ACK ENDED*****");
    }

    public void testConcurrentCreation_2() throws Exception {
        int count;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int AsyncInvocationArrSize = 4;
        String regionNamePrefix = "PARTREG";
        String replRegion = "TESTREG";
        CacheSerializableRunnable createRepl = new CacheSerializableRunnable("Create Repl"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setScope(Scope.DISTRIBUTED_ACK);
                attr.setDataPolicy(DataPolicy.REPLICATE);
                cache.createRegion("TESTREG", attr.create());
            }
        };
        createRepl.run2();
        vm0.invoke(createRepl);
        vm1.invoke(createRepl);
        vm2.invoke(createRepl);
        vm3.invoke(createRepl);
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("Create PR"){

            @Override
            public void run2() throws CacheException {
                Region.Entry regEntry;
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(2).create());
                Region reg = cache.getRegion("TESTREG");
                while ((regEntry = reg.getEntry((Object)"start")) == null || regEntry.getValue() == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (int index = 0; index < 1; ++index) {
                    String regionName = "PARTREG" + String.valueOf(index);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                    TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                    TestCase.assertNotNull((String)("Cache does not contain PR " + regionName), (Object)cache.getRegion(regionName));
                    TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
                }
            }
        };
        CacheSerializableRunnable createAccessorPR = new CacheSerializableRunnable("Create Accessor PR"){

            @Override
            public void run2() throws CacheException {
                Region.Entry regEntry;
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(2).setLocalMaxMemory(0).create());
                Region reg = cache.getRegion("TESTREG");
                while ((regEntry = reg.getEntry((Object)"start")) == null || regEntry.getValue() == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (int index = 0; index < 1; ++index) {
                    String regionName = "PARTREG" + String.valueOf(index);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                    TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                    TestCase.assertNotNull((String)("Cache does not contain PR " + regionName), (Object)cache.getRegion(regionName));
                    TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
                }
            }
        };
        Thread th = new Thread(createAccessorPR);
        th.start();
        async[0] = vm0.invokeAsync(createPR);
        async[1] = vm1.invokeAsync(createPR);
        async[2] = vm2.invokeAsync(createPR);
        async[3] = vm3.invokeAsync(createPR);
        Region reg = this.getCache().getRegion("TESTREG");
        reg.put((Object)"start", (Object)"true");
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        th.join(30000L);
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        vm0.invoke(this.getCacheSerializableRunnableForPRValidate("PARTREG"));
        vm1.invoke(this.getCacheSerializableRunnableForPRValidate("PARTREG"));
        vm2.invoke(this.getCacheSerializableRunnableForPRValidate("PARTREG"));
        vm3.invoke(this.getCacheSerializableRunnableForPRValidate("PARTREG"));
    }

    public void testPartitionedRegionNameWithSpaces() throws Exception {
        final String rName = this.getUniqueName() + " with some spaces";
        CacheSerializableRunnable csr = new CacheSerializableRunnable("validateNoExceptionWhenUsingNameWithSpaces"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).create());
                partitionedregion = cache.createRegion(rName, attr.create());
                TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertNotNull((String)("Cache does not contain PR " + rName), (Object)cache.getRegion(rName));
                TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        Host.getHost(0).getVM(2).invoke(csr);
        Host.getHost(0).getVM(3).invoke(csr);
    }

    public void testPartitionedRegionRedundancyConflict() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String rName = this.getUniqueName();
        vm0.invoke(new CacheSerializableRunnable("validateNoException"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).create());
                partitionedregion = cache.createRegion(rName, attr.create());
                TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertNotNull((String)("Cache does not contain PR " + rName), (Object)cache.getRegion(rName));
                TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validatePRCreationException"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                try {
                    cache.getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    partitionedregion = cache.createRegion(rName, attr.create());
                    TestCase.fail((String)"Expected exception upon creation with invalid redundancy");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    cache.getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                TestCase.assertNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertNull((String)("Cache contains PR " + rName + "!!"), (Object)cache.getRegion(rName));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validatePRCreationException"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(2).create());
                try {
                    cache.getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    partitionedregion = cache.createRegion(rName, attr.create());
                    TestCase.fail((String)"Expected exception upon creation with invalid redundancy");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    cache.getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                TestCase.assertNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertNull((String)("Cache contains PR " + rName + "!!"), (Object)cache.getRegion(rName));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validatePRCreationException"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(3).create());
                try {
                    cache.getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    partitionedregion = cache.createRegion(rName, attr.create());
                    TestCase.fail((String)"Expected exception upon creation with invalid redundancy");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    cache.getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                TestCase.assertNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertNull((String)("Cache contains PR " + rName + "!!"), (Object)cache.getRegion(rName));
            }
        });
    }

    public void testPartitionRegionInitialization() throws Throwable {
        int count;
        String name = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****INITIALIZATION TEST STARTED*****");
        int AsyncInvocationArrSize = 8;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[1] = vm1.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[2] = vm2.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[3] = vm3.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        for (count = 0; count < 4; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        for (count = 0; count < 4; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        async[4] = vm0.invokeAsync(this.getCacheSerializableRunnableForPRInitialize());
        async[5] = vm1.invokeAsync(this.getCacheSerializableRunnableForPRInitialize());
        async[6] = vm2.invokeAsync(this.getCacheSerializableRunnableForPRInitialize());
        async[7] = vm3.invokeAsync(this.getCacheSerializableRunnableForPRInitialize());
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****INITIALIZATION TEST ENDED*****");
    }

    public void testPartitionRegionRegistration() throws Throwable {
        int count;
        String name = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****REGISTRATION TEST STARTED*****");
        int AsyncInvocationArrSize = 8;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[1] = vm1.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[2] = vm2.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        async[3] = vm3.invokeAsync(this.getCacheSerializableRunnableForPRCreate(name, 1, 0, "NONE"));
        for (count = 0; count < 4; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        for (count = 0; count < 4; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        async[4] = vm0.invokeAsync(this.getCacheSerializableRunnableForPRRegistration(name));
        async[5] = vm1.invokeAsync(this.getCacheSerializableRunnableForPRRegistration(name));
        async[6] = vm2.invokeAsync(this.getCacheSerializableRunnableForPRRegistration(name));
        async[7] = vm3.invokeAsync(this.getCacheSerializableRunnableForPRRegistration(name));
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionCreationDUnitTest.getLogWriter());
        }
        for (count = 4; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionCreationDUnitTest.fail("exception during " + count, async[count].getException());
        }
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****REGISTRATION TEST ENDED*****");
    }

    public void testPartitionRegionPersistenceConflicts() throws Throwable {
        String name = this.getUniqueName();
        Host host = Host.getHost(0);
        VM dataStore0 = host.getVM(0);
        VM dataStore1 = host.getVM(1);
        VM accessor0 = host.getVM(2);
        VM accessor1 = host.getVM(3);
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****PERSISTENCE CONFLICTS TEST STARTED*****");
        accessor0.invoke(this.getCacheSerializableRunnableForPRPersistence(name, 0, false, false));
        accessor1.invoke(this.getCacheSerializableRunnableForPRPersistence(name, 0, true, true));
        dataStore0.invoke(this.getCacheSerializableRunnableForPRPersistence(name, 100, true, false));
        dataStore1.invoke(this.getCacheSerializableRunnableForPRPersistence(name, 100, false, true));
        PartitionedRegionCreationDUnitTest.getLogWriter().info("*****PERSISTENCE CONFLICTS TEST ENDED*****");
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRInitialize() {
        CacheSerializableRunnable initializePrRegion = new CacheSerializableRunnable("initialize"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes regionAttribs;
                Scope scope;
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region root = cache.getRegion("__PR");
                if (root == null) {
                    TestCase.fail((String)"PartionedRegionInitializationDUnitTest() - the __PR do not exists");
                }
                if (!(scope = (regionAttribs = root.getAttributes()).getScope()).isDistributedAck()) {
                    TestCase.fail((String)"PartionedRegionInitializationDUnitTest() - the __PR scope is not distributedAck");
                }
                TestCase.assertEquals((String)("PartionedRegionInitializationTest() - the __PR does not have the proper data policy" + DataPolicy.REPLICATE), (Object)DataPolicy.REPLICATE, (Object)regionAttribs.getDataPolicy());
            }
        };
        return initializePrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRRegistration(final String rgionName) {
        CacheSerializableRunnable registerPrRegion = new CacheSerializableRunnable("register"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                LocalRegion root = PartitionedRegionHelper.getPRRoot((Cache)cache);
                for (int i = 0; i < 1; ++i) {
                    Region region = cache.getRegion("/" + rgionName + String.valueOf(i));
                    String name = ((PartitionedRegion)region).getRegionIdentifier();
                    PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get((Object)name);
                    if (prConfig != null) continue;
                    TestCase.fail((String)("PartionedRegionRegistrationTest() - PartionedRegion - " + name + " configs do not exists in  region - " + root.getName()));
                }
                DistributedTestCase.getLogWriter().info(" PartitionedRegionCreationTest PartionedRegionRegistrationTest() Successfully Complete ..  ");
            }
        };
        return registerPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCreate(final String regionName, final int cnt, final int redundancy, final String exceptionType) {
        CacheSerializableRunnable createPrRegion1 = cnt == 0 ? new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Region partitionedregion;
                Cache cache;
                block5: {
                    cache = PartitionedRegionCreationDUnitTest.this.getCache();
                    partitionedregion = null;
                    try {
                        AttributesFactory attr = new AttributesFactory();
                        PartitionAttributesFactory paf = new PartitionAttributesFactory();
                        if (redundancy != 0) {
                            paf.setRedundantCopies(redundancy);
                        }
                        PartitionAttributes prAttr = paf.create();
                        attr.setPartitionAttributes(prAttr);
                        partitionedregion = cache.createRegion(regionName, attr.create());
                    }
                    catch (IllegalStateException ex) {
                        PartitionedRegionCreationDUnitTest.this.getCache().getLogger().warning("Creation caught IllegalStateException", (Throwable)ex);
                        if (exceptionType.equals("GLOBAL")) {
                            DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for scope = GLOBAL");
                        }
                        if (exceptionType.equals("REDUNDANCY")) {
                            DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for 0 > redundancy  > 3  ");
                        }
                        if (!exceptionType.equals("DIFFREG")) break block5;
                        DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for regions with diff scope ");
                    }
                }
                TestCase.assertNotNull((String)("Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        } : new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                if (redundancy != 0) {
                    paf.setRedundantCopies(redundancy);
                }
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                Region partitionedregion = null;
                String rName = null;
                for (int i = 0; i < cnt; ++i) {
                    block6: {
                        try {
                            rName = regionName + i;
                            partitionedregion = cache.createRegion(rName, attr.create());
                        }
                        catch (IllegalStateException ex) {
                            PartitionedRegionCreationDUnitTest.this.getCache().getLogger().warning("Creation caught IllegalStateException", (Throwable)ex);
                            if (exceptionType.equals("GLOBAL")) {
                                DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for scope = GLOBAL");
                            }
                            if (exceptionType.equals("REDUNDANCY")) {
                                DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for 0 > redundancy  > 3  ");
                            }
                            if (!exceptionType.equals("DIFFREG")) break block6;
                            DistributedTestCase.getLogWriter().info("PartitionedRegionCreationDUnitTest:testPartitionedRegionCreationExceptions()  Got a Correct exception for regions with diff scope ");
                        }
                    }
                    TestCase.assertNotNull((String)("Partitioned Region " + rName + " not in cache"), (Object)cache.getRegion(rName));
                    TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                    TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
                }
            }
        };
        return createPrRegion1;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPersistence(final String regionName, final int localMaxMemory, final boolean isPersistent, final boolean expectException) {
        CacheSerializableRunnable createPrRegion1 = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                Region partitionedregion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(localMaxMemory);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    if (isPersistent) {
                        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    } else {
                        attr.setDataPolicy(DataPolicy.PARTITION);
                    }
                    partitionedregion = cache.createRegion(regionName, attr.create());
                    if (expectException) {
                        TestCase.fail((String)"Expect exception but it did not");
                    }
                    TestCase.assertNotNull((String)("Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                    TestCase.assertNotNull((String)"Partitioned Region ref null", (Object)partitionedregion);
                    TestCase.assertTrue((String)"Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
                }
                catch (IllegalStateException ex) {
                    if (localMaxMemory > 0) {
                        TestCase.assertTrue((boolean)ex.getMessage().contains("DataPolicy for Datastore members should all be persistent or not."));
                    }
                    TestCase.assertTrue((boolean)ex.getMessage().contains("Persistence is not allowed when local-max-memory is zero."));
                }
            }
        };
        return createPrRegion1;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRValidate(final String regionName) {
        CacheSerializableRunnable validatePrRegion = new CacheSerializableRunnable("validateRegionCreation"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCreationDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    String n = "/" + regionName + String.valueOf(i);
                    TestCase.assertNotNull((String)(n + " not created successfully"), (Object)cache.getRegion(n));
                }
            }
        };
        return validatePrRegion;
    }

    public void testTotalNumberOfBuckets() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.createPrRegion);
        vm1.invoke(this.createPrRegionOnlyAccessor);
    }
}

