/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionedRegionDelayedRecoveryDUnitTest
extends CacheTestCase {
    public PartitionedRegionDelayedRecoveryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PartitionedRegionDelayedRecoveryDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver(null);
            }
        });
        InternalResourceManager.setResourceObserver(null);
    }

    public void testNoRecovery() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegions = new SerializableRunnable("createRegions"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                paf.setRedundantCopies(1);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegions);
        vm1.invoke(createPrRegions);
        vm0.invoke(new SerializableRunnable("putData"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                region1.put((Object)"A", (Object)"B");
            }
        });
        vm2.invoke(createPrRegions);
        vm1.invoke(new SerializableRunnable("Destroy region"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                region1.localDestroyRegion();
            }
        });
        SerializableRunnable checkNoBucket = new SerializableRunnable("Check for bucket"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals((int)0, (int)region1.getDataStore().getBucketsManaged());
            }
        };
        Thread.sleep(1000L);
        vm2.invoke(checkNoBucket);
        vm1.invoke(createPrRegions);
        Thread.sleep(1000L);
        vm1.invoke(checkNoBucket);
        vm2.invoke(checkNoBucket);
    }

    public void testDelay() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegions = new SerializableRunnable("createRegions"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final CountDownLatch rebalancingFinished = new CountDownLatch(1);
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new InternalResourceManager.ResourceObserverAdapter(){

                    public void rebalancingOrRecoveryFinished(Region region) {
                        rebalancingFinished.countDown();
                    }
                });
                try {
                    Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRecoveryDelay(5000L);
                    paf.setRedundantCopies(1);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    cache.createRegion("region1", attr.create());
                    if (!rebalancingFinished.await(60000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"Redundancy recovery did not happen within 60 seconds");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
                finally {
                    InternalResourceManager.setResourceObserver(null);
                }
            }
        };
        vm0.invoke(createPrRegions);
        vm1.invoke(createPrRegions);
        vm0.invoke(new SerializableRunnable("putData"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                region1.put((Object)"A", (Object)"B");
            }
        });
        vm2.invoke(createPrRegions);
        vm1.invoke(new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                cache.close();
            }
        });
        long elapsed = this.waitForBucketRecovery(vm2, 1);
        PartitionedRegionDelayedRecoveryDUnitTest.assertTrue((String)("Did not wait at least 5 seconds to create the bucket. Elapsed=" + elapsed), (elapsed >= 5000L ? 1 : 0) != 0);
    }

    public void testStartupDelay() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegions = new SerializableRunnable("createRegions"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setStartupRecoveryDelay(5000L);
                paf.setRedundantCopies(1);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegions);
        vm1.invoke(createPrRegions);
        vm0.invoke(new SerializableRunnable("putData"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                region1.put((Object)1, (Object)"B");
                region1.put((Object)2, (Object)"B");
                region1.put((Object)3, (Object)"B");
                region1.put((Object)4, (Object)"B");
            }
        });
        vm1.invoke(new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                cache.close();
            }
        });
        long begin = System.currentTimeMillis();
        vm2.invoke(createPrRegions);
        long elapsed = System.currentTimeMillis() - begin;
        PartitionedRegionDelayedRecoveryDUnitTest.assertTrue((String)("Create region should not have waited to recover redundancy. Elapsed=" + elapsed), (elapsed < 5000L ? 1 : 0) != 0);
        elapsed = this.waitForBucketRecovery(vm2, 4);
        PartitionedRegionDelayedRecoveryDUnitTest.assertTrue((String)("Did not wait at least 5 seconds to create the bucket. Elapsed=" + elapsed), (elapsed >= 5000L ? 1 : 0) != 0);
        vm2.invoke(new SerializableCallable("wait for primary move"){

            public Object call() throws Exception {
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                observer.waitForRecovery(30L, TimeUnit.SECONDS);
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals((int)2, (int)region1.getDataStore().getNumberOfPrimaryBucketsManaged());
                return null;
            }
        });
    }

    private long waitForBucketRecovery(VM vm2, final int numBuckets) {
        final long begin = System.currentTimeMillis();
        Long elapsed = (Long)vm2.invoke(new SerializableCallable("putData"){

            public Object call() {
                short bucketsManaged;
                Cache cache = PartitionedRegionDelayedRecoveryDUnitTest.this.getCache();
                PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                while (System.currentTimeMillis() - begin < 30000L && (bucketsManaged = region1.getDataStore().getBucketsManaged()) != numBuckets) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                TestCase.assertEquals((String)"Did not start managing the bucket within 30 seconds", (int)numBuckets, (int)region1.getDataStore().getBucketsManaged());
                long elapsed = System.currentTimeMillis() - begin;
                return elapsed;
            }
        });
        return elapsed;
    }

    private static class MyResourceObserver
    extends InternalResourceManager.ResourceObserverAdapter {
        CountDownLatch recoveryComplete = new CountDownLatch(1);

        private MyResourceObserver() {
        }

        public void waitForRecovery(long time, TimeUnit unit) throws InterruptedException {
            this.recoveryComplete.await(time, unit);
        }

        public void rebalancingOrRecoveryFinished(Region region) {
            this.recoveryComplete.countDown();
        }
    }
}

