/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionEntryCountDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 19808034671087558L;

    public PartitionedRegionEntryCountDUnitTest(String name) {
        super(name);
    }

    public void testTotalEntryCountAfterLocalDestroyEviction() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        VM vm3 = host.getVM(2);
        boolean redundantCopies = true;
        int maxEntriesForVm1 = 100;
        int maxEntriesForOtherVm = 2000;
        String name = "PR_TEMP";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region having max entries 100"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEntryCountDUnitTest.this.createRootRegion("PR_TEMP", factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm1.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with local destroy on a partitioned Region having max entries 2000"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)2000, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEntryCountDUnitTest.this.createRootRegion("PR_TEMP", factory.create());
                    TestCase.assertNotNull((Object)pr);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm2.invoke(create2);
        vm3.invoke(create2);
        SerializableRunnable putData = new SerializableRunnable("Puts Data"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEntryCountDUnitTest.this.getRootRegion("PR_TEMP");
                TestCase.assertNotNull((Object)pr);
                for (int counter = 1; counter <= 600; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[1]);
                }
            }
        };
        vm1.invoke(putData);
        SerializableCallable getTotalEntryCount = new SerializableCallable("Get total entry count"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEntryCountDUnitTest.this.getRootRegion("PR_TEMP");
                TestCase.assertNotNull((Object)pr);
                Integer n = pr.entryCount(false);
                return n;
            }
        };
        Integer v1T = (Integer)vm1.invoke(getTotalEntryCount);
        Integer v2T = (Integer)vm2.invoke(getTotalEntryCount);
        Integer v3T = (Integer)vm3.invoke(getTotalEntryCount);
        PartitionedRegionEntryCountDUnitTest.assertEquals((Object)v1T, (Object)v2T);
        PartitionedRegionEntryCountDUnitTest.assertEquals((Object)v1T, (Object)v3T);
        PartitionedRegionEntryCountDUnitTest.assertEquals((Object)v2T, (Object)v3T);
        SerializableCallable getLocalEntryCount = new SerializableCallable("Get local entry count"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEntryCountDUnitTest.this.getRootRegion("PR_TEMP");
                TestCase.assertNotNull((Object)pr);
                Integer n = pr.entryCount(pr.getTXState(), pr.getDataStore().getAllLocalPrimaryBucketIds());
                return n;
            }
        };
        Integer v1L = (Integer)vm1.invoke(getLocalEntryCount);
        Integer v2L = (Integer)vm2.invoke(getLocalEntryCount);
        Integer v3L = (Integer)vm3.invoke(getLocalEntryCount);
        Integer total = v1L + v2L + v3L;
        PartitionedRegionEntryCountDUnitTest.assertEquals((Object)v1T, (Object)total);
    }
}

