/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedCacheTestCase;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventListenersBlackboard;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import java.io.Serializable;
import junit.framework.TestCase;

public class PartitionedRegionEventsDUnitTest
extends DistributedCacheTestCase {
    static final String REGION_NAME = "PREventsDUnitTest";
    static volatile Object newValue;
    static volatile Object oldValue;
    static volatile boolean callbackFailure;
    volatile int expectedCreateInv;
    volatile int expectedUpdateInv;

    public PartitionedRegionEventsDUnitTest(String name) {
        super(name);
    }

    protected static void callbackAssertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        callbackFailure = true;
        PartitionedRegionEventsDUnitTest.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    protected static void callbackAssertTrue(String msg, boolean cond) {
        if (cond) {
            return;
        }
        callbackFailure = true;
        PartitionedRegionEventsDUnitTest.assertTrue((String)msg, (boolean)cond);
    }

    protected static void callbackAssertNull(String msg, Object val) {
        if (val == null) {
            return;
        }
        callbackFailure = true;
        PartitionedRegionEventsDUnitTest.assertNull((String)msg, (Object)val);
    }

    public void testObjectAddedReplaced() throws CacheException, InterruptedException {
        Object vmNewValue;
        int i;
        String name = "testObjectAddedReplaced";
        int numVMs = Host.getHost(0).getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; event=" + event);
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Callback arguments not equal", event.getCallbackArgument(), event.getDistributedMember());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Operation not a create", Operation.CREATE, event.getOperation());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("newValue is wrong", new Integer(0), event.getNewValue());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("oldValue not null: " + event.getOldValue(), null, event.getOldValue());
            }

            @Override
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterUpdate on listener; name=" + event.getKey());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Callback argument incorrect", event.getCallbackArgument(), event.getDistributedMember());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Operation not update", Operation.UPDATE, event.getOperation());
                if (((EntryEventImpl)event).getInvokePRCallbacks()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertTrue("Old value should not be null", event.getOldValue() != null);
                }
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations2();
                DistributedTestCase.getLogWriter().info("update event new value is: " + newValue);
                DistributedTestCase.getLogWriter().info("update event old value is: " + oldValue);
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.ALL), listener};
        this.expectedCreateInv = 1;
        this.expectedUpdateInv = 0;
        LogWriter log = PartitionedRegionEventsDUnitTest.getLogWriter();
        log.info("TESTOBJECTADDEDREPLACED: creating entry in controller");
        PartitionedRegionEventsDUnitTest.createEntry(name, (SubscriptionAttributes)args[1], listener);
        log.info("TESTOBJECTADDEDREPLACED: done creating entry in controller");
        CacheSerializableRunnable verify = new CacheSerializableRunnable("verify"){

            @Override
            public void run2() {
                TestCase.assertEquals((String)"Wrong number of 'afterCreate' listener invocations", (long)PartitionedRegionEventsDUnitTest.this.expectedCreateInv, (long)PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations1());
                TestCase.assertEquals((String)"Wrong number of 'afterUpdate' listener invocations", (long)PartitionedRegionEventsDUnitTest.this.expectedUpdateInv, (long)PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations2());
            }
        };
        log.info("TESTOBJECTADDEDREPLACED: verifying");
        verify.runRepeatingIfNecessary(5000L);
        log.info("TESTOBJECTADDEDREPLACED: done verifying");
        Host host = Host.getHost(0);
        int vmCount = host.getVMCount();
        for (int i2 = 0; i2 < vmCount; ++i2) {
            log.info("TESTOBJECTADDEDREPLACED: invoking update in VM " + i2);
            host.getVM(i2).invoke(this.getClass(), "updateEntry", args);
            log.info("TESTOBJECTADDEDREPLACED: done with update in VM " + i2);
            this.expectedUpdateInv += i2 + 2;
            log.info("TESTOBJECTADDEDREPLACED: verifying callbacks for VM " + i2);
            verify.runRepeatingIfNecessary(5000L);
            log.info("TESTOBJECTADDEDREPLACED: done verifying callbacks for VM " + i2);
        }
        PartitionedRegionEventsDUnitTest.assertEquals((String)"newValue is wrong", (Object)new Integer(0), (Object)newValue);
        int replaceValue = 1;
        PartitionedRegionEventsDUnitTest.replaceEntry(name, new Integer(replaceValue));
        this.expectedUpdateInv += numVMs;
        verify.runRepeatingIfNecessary(5000L);
        PartitionedRegionEventsDUnitTest.assertEquals((String)"newValue is wrong", (Object)new Integer(replaceValue), (Object)PartitionedRegionEventsDUnitTest.getNewValue());
        for (i = 0; i < vmCount; ++i) {
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)new Integer(replaceValue), (Object)vmNewValue);
        }
        host.getVM(0).invoke(this.getClass(), "replaceEntry", new Object[]{name, new Integer(++replaceValue)});
        this.expectedUpdateInv += numVMs;
        verify.runRepeatingIfNecessary(5000L);
        try {
            PartitionedRegionEventsDUnitTest.assertEquals((String)"newValue is wrong", (Object)new Integer(replaceValue), (Object)PartitionedRegionEventsDUnitTest.getNewValue());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Error e) {
            PartitionedRegionEventsDUnitTest.getLogWriter().severe((Throwable)e);
            throw e;
        }
        for (i = 0; i < vmCount; ++i) {
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)new Integer(replaceValue), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testUpdateIsCreate() throws CacheException, InterruptedException {
        String name = "testUpdateIsCreate";
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; event=" + event);
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong callback argument", event.getCallbackArgument(), event.getDistributedMember());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Operation not create", Operation.CREATE, event.getOperation());
                if (!((EntryEventImpl)event).getInvokePRCallbacks()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertEquals("Old value should be NOT_AVAILABLE", null, event.getOldValue());
                    TestCase.assertEquals((String)"Old value should be NOT_AVAILABLE", (boolean)false, (boolean)event.isOldValueAvailable());
                } else {
                    PartitionedRegionEventsDUnitTest.callbackAssertNull("the oldValue should be null", event.getOldValue());
                }
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("newValue is wrong", new Integer(0), event.getNewValue());
            }

            @Override
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterUpdate on listener; name=" + event.getKey());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Operation not an update", Operation.UPDATE, event.getOperation());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations2();
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.ALL), listener};
        LogWriter log = PartitionedRegionEventsDUnitTest.getLogWriter();
        log.info(name + ": creating region in controller");
        PartitionedRegionEventsDUnitTest.createRegion(name, (SubscriptionAttributes)args[1], listener);
        log.info(name + ": done creating region in controller");
        Host host = Host.getHost(0);
        int vmCount = host.getVMCount();
        for (int i = 1; i < vmCount; ++i) {
            log.info(name + ": invoking region creation in VM " + i);
            host.getVM(i).invoke(this.getClass(), "createRegion", args);
            log.info(name + ": done with region creation in VM " + i);
        }
        this.expectedCreateInv = vmCount + 1;
        this.expectedUpdateInv = 0;
        host.getVM(0).invoke(this.getClass(), "updateNewEntry", args);
        PartitionedRegionEventsDUnitTest.assertEquals((String)"wrong number of 'afterUpdate' listener invocations", (long)this.expectedUpdateInv, (long)this.getBlackboard().getNumInvocations2());
        PartitionedRegionEventsDUnitTest.assertEquals((String)"wrong number of 'afterCreate' listener invocations", (long)this.expectedCreateInv, (long)this.getBlackboard().getNumInvocations1());
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testObjectInvalidated() throws CacheException, InterruptedException {
        int ttl = 0;
        String name = "testObjectInvalidated";
        Host host = Host.getHost(0);
        final int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterInvalidate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking tests invalidated listener");
                if (event.isOriginRemote()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong distributed member", !event.getDistributedMember().equals(PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember()));
                } else {
                    PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong distributed member", PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember(), event.getDistributedMember());
                }
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong operation", Operation.INVALIDATE, event.getOperation());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.ALL), listener};
        PartitionedRegionEventsDUnitTest.createEntry(name, ttl, ExpirationAction.INVALIDATE, new SubscriptionAttributes(InterestPolicy.ALL), listener);
        this.forEachVMInvoke("createSubregion", args);
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        PartitionedRegionEventsDUnitTest.getLogWriter().info("About to invalidate " + name);
        sub.invalidate((Object)name);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations1() >= (long)numVMs;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        PartitionedRegionEventsDUnitTest.assertNull((Object)PartitionedRegionEventsDUnitTest.getRegion().getSubregion(name).get((Object)name));
        PartitionedRegionEventsDUnitTest.assertNull((Object)newValue);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testObjectDestroyed() throws CacheException, InterruptedException {
        int ttl = 0;
        String name = "testObjectDestroyed";
        Host host = Host.getHost(0);
        final int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }

            @Override
            public void afterDestroy(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking objectDestroyed listener");
                if (event.isOriginRemote()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong distributed member", !event.getDistributedMember().equals(PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember()));
                } else {
                    PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong distributed member", PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember(), event.getDistributedMember());
                }
                PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong operation", event.getOperation().isDestroy());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.ALL), listener, new Integer(ttl), ExpirationAction.DESTROY};
        PartitionedRegionEventsDUnitTest.createEntry(name, ttl, ExpirationAction.DESTROY, new SubscriptionAttributes(InterestPolicy.ALL), listener);
        this.forEachVMInvoke("createSubregionWhenDestroy", args);
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        sub.destroy((Object)name);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations1() >= (long)numVMs;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        PartitionedRegionEventsDUnitTest.assertNull((Object)newValue);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testObjectAddedReplacedCACHECONTENT() throws CacheException, InterruptedException {
        Object vmNewValue;
        Object vmOldValue;
        Object id;
        int i;
        String name = "testObjectAddedReplaced";
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                TestCase.assertEquals((Object)Operation.CREATE, (Object)event.getOperation());
                PartitionedRegionEventsDUnitTest.callbackAssertTrue("Old value not null", event.getOldValue() == null);
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("newValue is wrong", new Integer(0), event.getNewValue());
                PartitionedRegionEventsDUnitTest.callbackAssertNull("oldValue not null", event.getOldValue());
            }

            @Override
            public void afterUpdate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterUpdate on listener; name=" + event.getKey());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong callback argument", event.getCallbackArgument(), event.getDistributedMember());
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong operation", Operation.UPDATE, event.getOperation());
                PartitionedRegionEventsDUnitTest.callbackAssertTrue("Old value is null", event.getOldValue() != null);
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations2();
                DistributedTestCase.getLogWriter().info("update event new value is: " + newValue);
                DistributedTestCase.getLogWriter().info("update event old value is: " + oldValue);
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT), listener};
        this.expectedCreateInv = 1;
        this.expectedUpdateInv = 0;
        LogWriter log = PartitionedRegionEventsDUnitTest.getLogWriter();
        log.info("TESTOBJECTADDEDREPLACED: creating entry in controller");
        PartitionedRegionEventsDUnitTest.createEntry(name, (SubscriptionAttributes)args[1], listener);
        log.info("TESTOBJECTADDEDREPLACED: done creating entry in controller");
        CacheSerializableRunnable verify = new CacheSerializableRunnable("verify"){

            @Override
            public void run2() {
                TestCase.assertEquals((String)"Wrong number of 'afterCreate' listener invocations", (long)PartitionedRegionEventsDUnitTest.this.expectedCreateInv, (long)PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations1());
                TestCase.assertEquals((String)"Wrong number of 'afterUpdate' listener invocations", (long)PartitionedRegionEventsDUnitTest.this.expectedUpdateInv, (long)PartitionedRegionEventsDUnitTest.this.getBlackboard().getNumInvocations2());
            }
        };
        log.info("TESTOBJECTADDEDREPLACED: verifying");
        verify.runRepeatingIfNecessary(5000L);
        log.info("TESTOBJECTADDEDREPLACED: done verifying");
        Host host = Host.getHost(0);
        int vmCount = host.getVMCount();
        for (int i2 = 0; i2 < vmCount; ++i2) {
            log.info("TESTOBJECTADDEDREPLACED: invoking update in VM " + i2);
            host.getVM(i2).invoke(this.getClass(), "updateEntry", args);
            log.info("TESTOBJECTADDEDREPLACED: done create in VM " + i2);
            ++this.expectedUpdateInv;
            log.info("TESTOBJECTADDEDREPLACED: verifying callbacks for VM " + i2);
            verify.runRepeatingIfNecessary(5000L);
            log.info("TESTOBJECTADDEDREPLACED: done verifying callbacks for VM " + i2);
        }
        PartitionedRegionEventsDUnitTest.assertEquals((String)"newValue is wrong", (Object)new Integer(0), (Object)newValue);
        int replaceValue = 1;
        Integer iReplaceValue = new Integer(replaceValue);
        PartitionedRegionEventsDUnitTest.replaceEntry(name, iReplaceValue);
        ++this.expectedUpdateInv;
        verify.runRepeatingIfNecessary(5000L);
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        PartitionedRegionEventsDUnitTest.assertEquals((String)"newValue is wrong", (Object)iReplaceValue, (Object)PartitionedRegionEventsDUnitTest.getNewValue());
        DistributedMember bucketOwner = ((PartitionedRegion)sub).getMemberOwning((Object)name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)bucketOwner);
        for (i = 0; i < vmCount; ++i) {
            id = host.getVM(i).invoke(this.getClass(), "getMemberId");
            if (!bucketOwner.equals(id)) continue;
            vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(replaceValue - 1), (Object)vmOldValue);
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)iReplaceValue, (Object)vmNewValue);
        }
        iReplaceValue = new Integer(++replaceValue);
        host.getVM(0).invoke(this.getClass(), "replaceEntry", new Object[]{name, iReplaceValue});
        ++this.expectedUpdateInv;
        verify.runRepeatingIfNecessary(5000L);
        bucketOwner = ((PartitionedRegion)sub).getMemberOwning((Object)name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)bucketOwner);
        for (i = 0; i < vmCount; ++i) {
            id = host.getVM(i).invoke(this.getClass(), "getMemberId");
            if (!bucketOwner.equals(id)) continue;
            vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(replaceValue - 1), (Object)vmOldValue);
            PartitionedRegionEventsDUnitTest.assertEquals((String)("newValue is wrong in vm " + i), (Object)new Integer(replaceValue), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testObjectInvalidatedCACHECONTENT() throws CacheException, InterruptedException {
        int ttl = 0;
        String name = "testObjectInvalidated";
        Host host = Host.getHost(0);
        int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterInvalidate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking tests invalidated listener");
                if (event.isOriginRemote()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong event member", !event.getDistributedMember().equals(PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember()));
                } else {
                    PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong event member", PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember(), event.getDistributedMember());
                }
                PartitionedRegionEventsDUnitTest.callbackAssertEquals("Wrong operation", Operation.INVALIDATE, event.getOperation());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT), listener};
        PartitionedRegionEventsDUnitTest.createEntry(name, ttl, ExpirationAction.INVALIDATE, (SubscriptionAttributes)args[1], listener);
        this.forEachVMInvoke("createSubregion", args);
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        PartitionedRegionEventsDUnitTest.getLogWriter().info("About to invalidate " + name);
        sub.invalidate((Object)name);
        int maxRetries = 100;
        while (this.getBlackboard().getNumInvocations1() < (long)numVMs && --maxRetries > 0) {
            Thread.sleep(100L);
        }
        PartitionedRegionEventsDUnitTest.assertEquals((String)"objectInvalidated invocations wrong", (long)1L, (long)this.getBlackboard().getNumInvocations1());
        PartitionedRegionEventsDUnitTest.assertNull((Object)PartitionedRegionEventsDUnitTest.getRegion().getSubregion(name).get((Object)name));
        DistributedMember bucketOwner = ((PartitionedRegion)sub).getMemberOwning((Object)name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)bucketOwner);
        int vmCount = numVMs - 1;
        for (int i = 0; i < vmCount; ++i) {
            Object id = host.getVM(i).invoke(this.getClass(), "getMemberId");
            if (!bucketOwner.equals(id)) continue;
            Object vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(0), (Object)vmOldValue);
            PartitionedRegionEventsDUnitTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    public void testObjectDestroyedCACHECONTENT() throws CacheException, InterruptedException {
        int ttl = 0;
        String name = "testObjectDestroyed";
        Host host = Host.getHost(0);
        int numVMs = host.getVMCount() + 1;
        this.getBlackboard().initNumInvocations();
        callbackFailure = false;
        GenericListener listener = new GenericListener(){

            @Override
            public void afterCreate(EntryEvent event) {
            }

            @Override
            public void afterUpdate(EntryEvent event) {
            }

            @Override
            public void afterDestroy(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking objectDestroyed listener");
                if (event.isOriginRemote()) {
                    PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong event member", !event.getDistributedMember().equals(PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember()));
                } else {
                    TestCase.assertEquals((String)"Wrong event member", (Object)PartitionedRegionEventsDUnitTest.this.getSystem().getDistributedMember(), (Object)event.getDistributedMember());
                }
                PartitionedRegionEventsDUnitTest.callbackAssertTrue("Wrong operation", event.getOperation().isDestroy());
                PartitionedRegionEventsDUnitTest.this.getBlackboard().incNumInvocations1();
                newValue = event.getNewValue();
                oldValue = event.getOldValue();
            }
        };
        Object[] args = new Object[]{name, new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT), listener, new Integer(ttl), ExpirationAction.DESTROY};
        PartitionedRegionEventsDUnitTest.createEntry(name, ttl, ExpirationAction.DESTROY, (SubscriptionAttributes)args[1], listener);
        this.forEachVMInvoke("createSubregionWhenDestroy", args);
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        sub.destroy((Object)name);
        int maxRetries = 100;
        while (this.getBlackboard().getNumInvocations1() < (long)numVMs && --maxRetries > 0) {
            Thread.sleep(100L);
        }
        PartitionedRegionEventsDUnitTest.assertEquals((long)1L, (long)this.getBlackboard().getNumInvocations1());
        DistributedMember bucketOwner = ((PartitionedRegion)sub).getMemberOwning((Object)name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)bucketOwner);
        for (int i = 0; i < host.getVMCount(); ++i) {
            Object id = host.getVM(i).invoke(this.getClass(), "getMemberId");
            if (!bucketOwner.equals(id)) continue;
            Object vmOldValue = host.getVM(i).invoke(this.getClass(), "getOldValue");
            Object vmNewValue = host.getVM(i).invoke(this.getClass(), "getNewValue");
            PartitionedRegionEventsDUnitTest.assertEquals((String)("oldValue is wrong in vm " + i), (Object)new Integer(0), (Object)vmOldValue);
            PartitionedRegionEventsDUnitTest.assertNull((String)("newValue is wrong in vm " + i), (Object)vmNewValue);
        }
        PartitionedRegionEventsDUnitTest.assertFalse((String)"Errors in callbacks; check logs for details", (boolean)callbackFailure);
    }

    protected static void createSubregion(String name, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setSubscriptionAttributes(subAttrs);
        factory.addCacheListener((CacheListener)l);
        factory.setPartitionAttributes(new PartitionAttributesFactory().create());
        region.createSubregion(name, factory.create());
    }

    protected static void createSubregionWhenDestroy(String name, SubscriptionAttributes subAttrs, GenericListener l, Integer ttl, ExpirationAction action) throws CacheException {
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setSubscriptionAttributes(subAttrs);
        factory.setEntryTimeToLive(new ExpirationAttributes(ttl.intValue(), action));
        factory.addCacheListener((CacheListener)l);
        factory.setPartitionAttributes(new PartitionAttributesFactory().create());
        region.createSubregion(name, factory.create());
    }

    private static void createEntry(String name, int ttl, ExpirationAction action, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        Region sub = PartitionedRegionEventsDUnitTest._createRegion(name, ttl, action, subAttrs, l);
        sub.create((Object)name, (Object)new Integer(0), (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static Region _createRegion(String name, int ttl, ExpirationAction action, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        factory.setEntryTimeToLive(new ExpirationAttributes(ttl, action));
        factory.setSubscriptionAttributes(subAttrs);
        factory.addCacheListener((CacheListener)l);
        factory.setPartitionAttributes(new PartitionAttributesFactory().create());
        Region sub = region.createSubregion(name, factory.create());
        return sub;
    }

    private static void createRegion(String name, int ttl, ExpirationAction action, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        PartitionedRegionEventsDUnitTest._createRegion(name, ttl, action, subAttrs, l);
    }

    private static void createEntry(String name, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        PartitionedRegionEventsDUnitTest.createEntry(name, 0, ExpirationAction.INVALIDATE, subAttrs, l);
    }

    private static void createRegion(String name, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        PartitionedRegionEventsDUnitTest.createRegion(name, 0, ExpirationAction.INVALIDATE, subAttrs, l);
    }

    private static void updateEntry(String name, int ttl, ExpirationAction action, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        Region sub = PartitionedRegionEventsDUnitTest._createRegion(name, ttl, action, subAttrs, l);
        sub.put((Object)name, (Object)new Integer(0), (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    protected static void updateEntry(String name, SubscriptionAttributes subAttr, GenericListener l) throws CacheException {
        PartitionedRegionEventsDUnitTest.updateEntry(name, 0, ExpirationAction.INVALIDATE, subAttr, l);
    }

    protected static void updateNewEntry(String name, SubscriptionAttributes subAttrs, GenericListener l) throws CacheException {
        Region sub = PartitionedRegionEventsDUnitTest._createRegion(name, 0, ExpirationAction.INVALIDATE, subAttrs, l);
        sub.put((Object)name, (Object)new Integer(0), (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static void replaceEntry(String name, Object value) throws CacheException {
        Region region = PartitionedRegionEventsDUnitTest.getRegion();
        Region sub = region.getSubregion(name);
        PartitionedRegionEventsDUnitTest.assertNotNull((Object)sub);
        sub.put((Object)name, value, (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static Object getNewValue() {
        return newValue;
    }

    protected static DistributedMember getMemberId() throws CacheException {
        return PartitionedRegionEventsDUnitTest.getRegion().getCache().getDistributedSystem().getDistributedMember();
    }

    private static Region getRegion() throws CacheException {
        Region root = PartitionedRegionEventsDUnitTest.getRootRegion();
        Region region = root.getSubregion(REGION_NAME);
        if (region == null) {
            AttributesFactory factory = new AttributesFactory();
            region = root.createSubregion(REGION_NAME, factory.create());
        }
        return region;
    }

    protected EventListenersBlackboard getBlackboard() {
        return EventListenersBlackboard.getInstance();
    }

    public static class GenericListener
    extends CacheListenerAdapter
    implements Serializable {
        public void close() {
        }

        public void afterCreate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterCreate");
        }

        public void afterInvalidate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterInvalidated");
        }

        public void afterDestroy(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterDestroy");
        }

        public void afterUpdate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterUpdate");
        }

        public void afterRegionInvalidate(RegionEvent revt) {
            TestCase.fail((String)"Unexpected listener callback: afterRegionInvalidate");
        }

        public void afterRegionDestroy(RegionEvent revt) {
        }
    }
}

