/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.util.ObjectSizerImpl;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionedRegionEvictionDUnitTest
extends CacheTestCase {
    public PartitionedRegionEvictionDUnitTest(String name) {
        super(name);
    }

    public void testHeapLRUWithOverflowToDisk() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String uniqName = this.getUniqueName();
        float heapPercentage = 50.9f;
        boolean redundantCopies = true;
        int evictorInterval = 100;
        final String name = uniqName + "-PR";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Heap LRU with Overflow to disk partitioned Region"){

            @Override
            public void run2() {
                System.setProperty("gemfire.topUpHeapEvictionPercentage", Float.toString(0.0f));
                PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.9f);
                Properties sp = System.getProperties();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                factory.setDiskSynchronous(true);
                DiskStoreFactory dsf = PartitionedRegionEvictionDUnitTest.this.getCache().createDiskStoreFactory();
                File[] diskDirs = new File[]{new File("overflowDir/" + uniqName + "_" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                dsf.setDiskDirs(diskDirs);
                DiskStore ds = dsf.create(name);
                factory.setDiskStoreName(ds.getName());
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm3.invoke(create);
        vm2.invoke(create);
        int bucketsToCreate = 3;
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.9f);
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int i = 0; i < 3; ++i) {
                    pr.put((Object)new Integer(i), (Object)"value0");
                    pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets()), (Object)"value1");
                    pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets() * 2), (Object)"value2");
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                try {
                    PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.9f);
                    Properties sp = System.getProperties();
                    int expectedInvocations = 10;
                    int maximumWaitSeconds = 60;
                    int pollWaitMillis = 200;
                    TestCase.assertTrue((200L < TimeUnit.SECONDS.toMillis(60L) * 4L ? 1 : 0) != 0);
                    final PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)pr);
                    for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                        BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                        if (bucketRegion == null) continue;
                        TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUHeap());
                        TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isOverflowToDisk());
                    }
                    PartitionedRegionEvictionDUnitTest.this.raiseFakeNotification();
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                        String excuse;

                        @Override
                        public boolean done() {
                            return pr.getDiskRegionStats().getNumOverflowOnDisk() == 9L;
                        }

                        @Override
                        public String description() {
                            return this.excuse;
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
                    int entriesEvicted = 0;
                    entriesEvicted = (int)((long)entriesEvicted + pr.getDiskRegionStats().getNumOverflowOnDisk());
                    Integer n = new Integer(entriesEvicted);
                    return n;
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.cleanUpAfterFakeNotification();
                }
            }
        };
        Integer v2i = (Integer)vm2.invoke(assertBucketAttributesAndEviction);
        Integer v3i = (Integer)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = v2i + v3i;
        PartitionedRegionEvictionDUnitTest.assertEquals((int)18, (int)totalEvicted);
    }

    protected void raiseFakeNotification() {
        ((GemFireCacheImpl)this.getCache()).getHeapEvictor().testAbortAfterLoopCount = 1;
        HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)true);
        System.setProperty("gemfire.memoryEventTolerance", "0");
        this.setEvictionPercentage(85.0f);
        HeapMemoryMonitor hmm = ((GemFireCacheImpl)this.getCache()).getResourceManager().getHeapMonitor();
        hmm.setTestMaxMemoryBytes(100L);
        hmm.updateStateAndSendEvent(90L);
    }

    protected void cleanUpAfterFakeNotification() {
        ((GemFireCacheImpl)this.getCache()).getHeapEvictor().testAbortAfterLoopCount = Integer.MAX_VALUE;
        HeapMemoryMonitor.setTestDisableMemoryUpdates((boolean)false);
        System.clearProperty("gemfire.memoryEventTolerance");
    }

    public void testHeapLRUWithLocalDestroy() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String uniqName = this.getUniqueName();
        float heapPercentage = 50.9f;
        boolean redundantCopies = true;
        int evictorInterval = 100;
        final String name = uniqName + "-PR";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Heap LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                System.setProperty("gemfire.topUpHeapEvictionPercentage", Float.toString(0.0f));
                PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.9f);
                Properties sp = System.getProperties();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm3.invoke(create);
        vm2.invoke(create);
        int bucketsToCreate = 3;
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int i = 0; i < 3; ++i) {
                    pr.put((Object)new Integer(i), (Object)"value0");
                    pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets()), (Object)"value1");
                    pr.put((Object)new Integer(i + pr.getPartitionAttributes().getTotalNumBuckets() * 2), (Object)"value2");
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                try {
                    Properties sp = System.getProperties();
                    int expectedInvocations = 10;
                    int maximumWaitSeconds = 60;
                    int pollWaitMillis = 200;
                    TestCase.assertTrue((200L < TimeUnit.SECONDS.toMillis(60L) * 4L ? 1 : 0) != 0);
                    final PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                    TestCase.assertNotNull((Object)pr);
                    long entriesEvicted = 0L;
                    for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                        BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                        if (bucketRegion == null) continue;
                        TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUHeap());
                        TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isLocalDestroy());
                    }
                    PartitionedRegionEvictionDUnitTest.this.raiseFakeNotification();
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                        String excuse;

                        @Override
                        public boolean done() {
                            return ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions() == 9L;
                        }

                        @Override
                        public String description() {
                            return this.excuse;
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
                    entriesEvicted = ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions();
                    Long l = new Long(entriesEvicted);
                    return l;
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.cleanUpAfterFakeNotification();
                }
            }
        };
        Long v2i = (Long)vm2.invoke(assertBucketAttributesAndEviction);
        Long v3i = (Long)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = v2i.intValue() + v3i.intValue();
        PartitionedRegionEvictionDUnitTest.assertEquals((int)18, (int)totalEvicted);
    }

    public void testMemoryLRUWithOverflowToDisk() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        VM vm0 = host.getVM(0);
        final String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxBuckets = 8;
        int localMaxMem = 16;
        int halfKb = 512;
        int justShyOfTwoMb = 2096640;
        final String name = uniqName + "-PR";
        SerializableRunnable create = new SerializableRunnable("Create Memory LRU with Overflow to disk partitioned Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                    factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(16).setTotalNumBuckets(8).create());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)new ObjectSizerImpl(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    factory.setDiskSynchronous(true);
                    DiskStoreFactory dsf = PartitionedRegionEvictionDUnitTest.this.getCache().createDiskStoreFactory();
                    File[] diskDirs = new File[]{new File("overflowDir/" + uniqName + "_" + OSProcess.getId())};
                    diskDirs[0].mkdirs();
                    dsf.setDiskDirs(diskDirs);
                    DiskStore ds = dsf.create(name);
                    factory.setDiskStoreName(ds.getName());
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.assertNotNull((Object)pr);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm3.invoke(create);
        vm2.invoke(create);
        int extraEntries = 4;
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int counter = 1; counter <= 20; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                TestCase.assertNull((Object)pr.getDiskRegion());
                TestCase.assertNotNull((Object)pr.getEvictionController());
                long entriesEvicted = 0L;
                for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                    BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                    if (bucketRegion == null) continue;
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUMemory());
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isOverflowToDisk());
                }
                return new Long(entriesEvicted += pr.getDiskRegionStats().getNumOverflowOnDisk());
            }
        };
        Long vm2i = (Long)vm2.invoke(assertBucketAttributesAndEviction);
        Long vm3i = (Long)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = vm2i.intValue() + vm3i.intValue();
        PartitionedRegionEvictionDUnitTest.assertTrue((8 <= totalEvicted ? 1 : 0) != 0);
        vm0.invoke(create);
        vm0.invoke(new SerializableRunnable("Test to see that we can get keys"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                for (int counter = 1; counter <= 20; ++counter) {
                    TestCase.assertNotNull((Object)pr.get((Object)new Integer(counter)));
                }
            }
        });
    }

    public void testMemoryLRUWithLocalDestroy() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxBuckets = 8;
        int localMaxMem = 16;
        int halfKb = 512;
        int justShyOfTwoMb = 2096640;
        final String name = uniqName + "-PR";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Memory LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(16).setTotalNumBuckets(8).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)new ObjectSizerImpl(), (EvictionAction)EvictionAction.LOCAL_DESTROY));
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm3.invoke(create);
        vm2.invoke(create);
        int extraEntries = 4;
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int counter = 1; counter <= 20; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                long entriesEvicted = 0L;
                for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                    BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                    if (bucketRegion == null) continue;
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUMemory());
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isLocalDestroy());
                }
                entriesEvicted = ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions();
                Long l = new Long(entriesEvicted);
                return l;
            }
        };
        Long v2i = (Long)vm2.invoke(assertBucketAttributesAndEviction);
        Long v3i = (Long)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = v2i.intValue() + v3i.intValue();
        PartitionedRegionEvictionDUnitTest.assertTrue((8 <= totalEvicted ? 1 : 0) != 0);
    }

    public void testEntryLRUWithOverflowToDisk() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxBuckets = 8;
        int maxEntries = 16;
        final String name = uniqName + "-PR";
        SerializableRunnable create = new SerializableRunnable("Create Entry LRU with Overflow to disk partitioned Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                    factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(8).create());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)16, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    factory.setDiskSynchronous(true);
                    DiskStoreFactory dsf = PartitionedRegionEvictionDUnitTest.this.getCache().createDiskStoreFactory();
                    File[] diskDirs = new File[]{new File("overflowDir/" + uniqName + "_" + OSProcess.getId())};
                    diskDirs[0].mkdirs();
                    dsf.setDiskDirs(diskDirs);
                    DiskStore ds = dsf.create(name);
                    factory.setDiskStoreName(ds.getName());
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.assertNotNull((Object)pr);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm3.invoke(create);
        vm2.invoke(create);
        int extraEntries = 4;
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int counter = 1; counter <= 20; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                int entriesEvicted = 0;
                for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                    BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                    if (bucketRegion == null) continue;
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUEntry());
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isOverflowToDisk());
                }
                entriesEvicted = (int)((long)entriesEvicted + pr.getDiskRegionStats().getNumOverflowOnDisk());
                return new Integer(entriesEvicted);
            }
        };
        Integer vm2i = (Integer)vm2.invoke(assertBucketAttributesAndEviction);
        Integer vm3i = (Integer)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = vm2i + vm3i;
        PartitionedRegionEvictionDUnitTest.assertEquals((int)8, (int)totalEvicted);
    }

    public void testEntryLRUWithLocalDestroy() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxBuckets = 8;
        int maxEntries = 16;
        final String name = uniqName + "-PR";
        int extraEntries = 4;
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(8).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)16, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                factory.addCacheListener((CacheListener)new VerifiableCacheListener(){
                    private long evictionDestroyEvents = 0L;

                    public void afterDestroy(EntryEvent e) {
                        System.out.println("EEEEEEEEEEEEEE key:" + e.getKey());
                        EntryEventImpl eei = (EntryEventImpl)e;
                        if (Operation.EVICT_DESTROY.equals(eei.getOperation())) {
                            ++this.evictionDestroyEvents;
                        }
                    }

                    @Override
                    public boolean verify(long expectedEntries) {
                        return expectedEntries == this.evictionDestroyEvents;
                    }
                });
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm3.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                    factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(8).create());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)16));
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.assertNotNull((Object)pr);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm2.invoke(create2);
        SerializableRunnable createBuckets = new SerializableRunnable("Create Buckets"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int counter = 1; counter <= 20; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
                }
            }
        };
        vm3.invoke(createBuckets);
        SerializableCallable assertBucketAttributesAndEviction = new SerializableCallable("Assert bucket attributes and eviction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                long entriesEvicted = 0L;
                for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
                    BucketRegion bucketRegion = (BucketRegion)entry.getValue();
                    if (bucketRegion == null) continue;
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUEntry());
                    TestCase.assertTrue((boolean)bucketRegion.getAttributes().getEvictionAttributes().getAction().isLocalDestroy());
                }
                entriesEvicted = ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions();
                Long l = new Long(entriesEvicted);
                return l;
            }
        };
        Long v2i = (Long)vm2.invoke(assertBucketAttributesAndEviction);
        Long v3i = (Long)vm3.invoke(assertBucketAttributesAndEviction);
        int totalEvicted = v2i.intValue() + v3i.intValue();
        PartitionedRegionEvictionDUnitTest.assertEquals((int)8, (int)totalEvicted);
        SerializableCallable assertListenerCount = new SerializableCallable("Assert that the number of listener invocations matches the expected total"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                RegionAttributes attrs = pr.getAttributes();
                TestCase.assertNotNull((Object)attrs);
                long entriesEvicted = ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getEvictions();
                VerifiableCacheListener verifyMe = null;
                for (CacheListener listener : attrs.getCacheListeners()) {
                    if (!(listener instanceof VerifiableCacheListener)) continue;
                    verifyMe = (VerifiableCacheListener)listener;
                }
                TestCase.assertNotNull(verifyMe);
                return verifyMe.verify(entriesEvicted);
            }
        };
        PartitionedRegionEvictionDUnitTest.assertTrue((boolean)((Boolean)vm3.invoke(assertListenerCount)));
    }

    public void testEvictionValidationForLRUEntry() {
        Host host = Host.getHost(0);
        VM testAccessor = host.getVM(1);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                int buks = 11;
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(11).setRedundantCopies(0).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5));
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                Integer key = new Integer(1);
                pr.put((Object)key, (Object)"testval");
                try {
                    BucketRegion b = pr.getDataStore().getInitializedBucketForId((Object)key, new Integer(PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)key, null, null)));
                }
                catch (ForceReattemptException e) {
                    TestCase.fail();
                }
                pr.destroyRegion();
                AttributesFactory factory2 = new AttributesFactory();
                factory2.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory2.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory2.setEvictionAttributes(firstEvictionAttrs);
                Region pr2 = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory2.create());
                TestCase.assertNotNull((Object)pr2);
            }
        };
        firstDatastore.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with Overflow to disk partitioned Region"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EvictionAttributes illegalEa;
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((!firstEvictionAttrs.getAlgorithm().isLRUHeap() ? 1 : 0) != 0);
                    illegalEa = EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)firstEvictionAttrs.getAction());
                    TestCase.assertTrue((!firstEvictionAttrs.equals((Object)illegalEa) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(illegalEa);
                    PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.0f);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Creating LRU Entry Count Eviction Attribute");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((boolean)firstEvictionAttrs.getAlgorithm().isLRUEntry());
                    TestCase.assertTrue((!firstEvictionAttrs.getAction().isOverflowToDisk() ? 1 : 0) != 0);
                    illegalEa = EvictionAttributes.createLRUEntryAttributes((int)firstEvictionAttrs.getMaximum(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    TestCase.assertTrue((!firstEvictionAttrs.equals((Object)illegalEa) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(illegalEa);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Creating LRU Entry Count Eviction Attribute");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                TestCase.assertTrue((boolean)firstEvictionAttrs.getAlgorithm().isLRUEntry());
                EvictionAttributes brokenEa = EvictionAttributes.createLRUEntryAttributes((int)(firstEvictionAttrs.getMaximum() + 1), (EvictionAction)firstEvictionAttrs.getAction());
                TestCase.assertTrue((!firstEvictionAttrs.equals((Object)brokenEa) ? 1 : 0) != 0);
                factory.setEvictionAttributes(brokenEa);
                PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
            }
        };
        testDatastore.invoke(create2);
        testAccessor.invoke(new CacheSerializableRunnable("Create an Accessor with and without eviction attributes"){

            @Override
            public void run2() throws CacheException {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(50.0f);
                Region r1 = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)r1);
                TestCase.assertEquals((Object)firstEvictionAttrs, (Object)r1.getAttributes().getEvictionAttributes());
            }
        });
    }

    public void testEvictionValidationForLRUAction() {
        Host host = Host.getHost(0);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEa = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(firstEa);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((Object)firstEa, (Object)pr.getAttributes().getEvictionAttributes());
            }
        };
        firstDatastore.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with Overflow to disk partitioned Region"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((boolean)firstEa.getAlgorithm().isLRUEntry());
                    TestCase.assertTrue((!firstEa.getAction().isOverflowToDisk() ? 1 : 0) != 0);
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Test to validate the Eviction Attribute : LRU Action");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((boolean)firstEa.getAlgorithm().isLRUEntry());
                    TestCase.assertTrue((!firstEa.getAction().isNone() ? 1 : 0) != 0);
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.NONE));
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Test to validate the Eviction Attribute : LRU Action");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                factory.setEvictionAttributes(firstEa);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((Object)firstEa, (Object)pr.getAttributes().getEvictionAttributes());
            }
        };
        testDatastore.invoke(create2);
    }

    public void testEvictionValidationForLRUMaximum() {
        Host host = Host.getHost(0);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttributes = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
            }
        };
        firstDatastore.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with Overflow to disk partitioned Region"){

            @Override
            public void run() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                EvictionAttributes ea = EvictionAttributes.createLRUEntryAttributes((int)(firstEvictionAttributes.getMaximum() + 10), (EvictionAction)firstEvictionAttributes.getAction());
                factory.setEvictionAttributes(ea);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        testDatastore.invoke(create2);
    }

    public void testEvictionValidationForLRUHeap() {
        Host host = Host.getHost(0);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        final String name = uniqName + "-PR";
        int heapPercentage = 66;
        int evictorInterval = 100;
        final EvictionAttributes firstEvictionAttributes = EvictionAttributes.createLRUHeapAttributes();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                PartitionedRegionEvictionDUnitTest.this.getCache().getResourceManager().setEvictionHeapPercentage(66.0f);
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
            }
        };
        firstDatastore.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with Overflow to disk partitioned Region"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EvictionAttributes invalidEa;
                PartitionedRegionEvictionDUnitTest.this.setEvictionPercentage(66.0f);
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((!firstEvictionAttributes.getAlgorithm().isLRUEntry() ? 1 : 0) != 0);
                    invalidEa = EvictionAttributes.createLRUEntryAttributes();
                    TestCase.assertTrue((!invalidEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(invalidEa);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Expected an IllegalStateException");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((boolean)firstEvictionAttributes.getAlgorithm().isLRUHeap());
                    TestCase.assertTrue((!firstEvictionAttributes.getAction().isOverflowToDisk() ? 1 : 0) != 0);
                    invalidEa = EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    TestCase.assertTrue((!invalidEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(invalidEa);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Expected an IllegalStateException");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertEquals((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
            }
        };
        testDatastore.invoke(create2);
    }

    public void testEvictionValidationWhenInitializedByAccessor() {
        Host host = Host.getHost(0);
        VM testDatastore = host.getVM(2);
        VM accessor = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        final String name = uniqName;
        final EvictionAttributes firstEvictionAttributes = EvictionAttributes.createLRUMemoryAttributes((int)113);
        accessor.invoke(new CacheSerializableRunnable("Create an Accessor which sets the first PR eviction attrs"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(0).setRedundantCopies(1).create());
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertNotSame((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
                TestCase.assertEquals((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
                TestCase.assertEquals((int)113, (int)pr.getAttributes().getEvictionAttributes().getMaximum());
            }
        });
        testDatastore.invoke(new SerializableRunnable("Create a datastore to test existing eviction attributes"){

            @Override
            public void run() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
                TestCase.assertNotSame((Object)firstEvictionAttributes, (Object)pr.getAttributes().getEvictionAttributes());
                TestCase.assertNotSame((Object)113, (Object)pr.getAttributes().getEvictionAttributes().getMaximum());
                TestCase.assertEquals((int)pr.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)pr.getAttributes().getEvictionAttributes().getMaximum());
            }
        });
    }

    public void testEvictionValidationForLRUMemory() {
        Host host = Host.getHost(0);
        VM firstDatastore = host.getVM(1);
        VM testDatastore = host.getVM(2);
        VM testAccessor = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttributes = EvictionAttributes.createLRUMemoryAttributes((int)226);
        firstDatastore.invoke(new CacheSerializableRunnable("First datastore setting LRU memory eviction attrs"){

            @Override
            public void run2() {
                int totalNumBuckets = 11;
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(11).setRedundantCopies(0).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)5));
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                Integer key = new Integer(1);
                pr.put((Object)key, (Object)"testval");
                try {
                    BucketRegion b = pr.getDataStore().getInitializedBucketForId((Object)key, new Integer(PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)key, null, null)));
                }
                catch (ForceReattemptException e) {
                    TestCase.fail();
                }
                pr.destroyRegion();
                AttributesFactory factory2 = new AttributesFactory();
                factory2.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory2.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory2.setEvictionAttributes(firstEvictionAttributes);
                Region pr2 = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory2.create());
                TestCase.assertNotNull((Object)pr2);
                TestCase.assertNotSame((Object)firstEvictionAttributes, (Object)pr2.getAttributes().getEvictionAttributes());
                TestCase.assertNotSame((Object)113, (Object)pr2.getAttributes().getEvictionAttributes().getMaximum());
                TestCase.assertEquals((int)pr2.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)pr2.getAttributes().getEvictionAttributes().getMaximum());
            }
        });
        class PRLRUMemoryRunnable
        extends CacheSerializableRunnable {
            private static final long serialVersionUID = 1L;
            final boolean isAccessor;

            public PRLRUMemoryRunnable(boolean accessor) {
                super("Test LRU memory eviction attrs on a " + (accessor ? " accessor" : " datastore"));
                this.isAccessor = accessor;
            }

            public PartitionAttributes createPartitionAttributes(int localMaxMemory) {
                if (this.isAccessor) {
                    return new PartitionAttributesFactory().setLocalMaxMemory(0).setRedundantCopies(1).create();
                }
                return new PartitionAttributesFactory().setLocalMaxMemory(localMaxMemory).setRedundantCopies(1).create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                EvictionAttributes badEa;
                RegionAttributes attrs;
                PartitionAttributes pra = this.createPartitionAttributes(firstEvictionAttributes.getMaximum());
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    attrs = factory.create();
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, attrs);
                    TestCase.fail((String)"Expected a IllegalStateException to be thrown");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((!((EvictionAttributesImpl)firstEvictionAttributes).isLIFOMemory() ? 1 : 0) != 0);
                    badEa = EvictionAttributesImpl.createLIFOMemoryAttributes((int)100, (EvictionAction)EvictionAction.LOCAL_DESTROY);
                    TestCase.assertTrue((!badEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(badEa);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Test to validate the Eviction Attribute : HeapLRU Interval");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                try {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
                    TestCase.assertTrue((!firstEvictionAttributes.getAction().isOverflowToDisk() ? 1 : 0) != 0);
                    TestCase.assertTrue((boolean)firstEvictionAttributes.getAlgorithm().isLRUMemory());
                    badEa = EvictionAttributes.createLRUMemoryAttributes((int)firstEvictionAttributes.getMaximum(), (ObjectSizer)firstEvictionAttributes.getObjectSizer(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    TestCase.assertTrue((!badEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                    factory.setEvictionAttributes(badEa);
                    PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.fail((String)"Test to validate the Eviction Attribute : HeapLRU Interval");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains(" is incompatible with other VMs which have EvictionAttributes "));
                }
                finally {
                    PartitionedRegionEvictionDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
                }
                TestCase.assertTrue((boolean)firstEvictionAttributes.getAlgorithm().isLRUMemory());
                EvictionAttributes okEa = EvictionAttributes.createLRUMemoryAttributes((int)(firstEvictionAttributes.getMaximum() - 1), (ObjectSizer)firstEvictionAttributes.getObjectSizer(), (EvictionAction)firstEvictionAttributes.getAction());
                if (!this.isAccessor) {
                    TestCase.assertTrue((okEa.getMaximum() < pra.getLocalMaxMemory() ? 1 : 0) != 0);
                }
                TestCase.assertTrue((!okEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                factory.setEvictionAttributes(okEa);
                RegionAttributes attrs2 = factory.create();
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, attrs2);
                TestCase.assertNotNull((Object)pr);
                TestCase.assertNotSame((Object)okEa, (Object)pr.getAttributes().getEvictionAttributes());
                TestCase.assertEquals((int)firstEvictionAttributes.getMaximum(), (int)pr.getAttributes().getEvictionAttributes().getMaximum());
                pr.localDestroyRegion();
                TestCase.assertTrue((boolean)firstEvictionAttributes.getAlgorithm().isLRUMemory());
                okEa = EvictionAttributes.createLRUMemoryAttributes((int)(firstEvictionAttributes.getMaximum() + 1), (ObjectSizer)firstEvictionAttributes.getObjectSizer(), (EvictionAction)firstEvictionAttributes.getAction());
                TestCase.assertTrue((!okEa.equals((Object)firstEvictionAttributes) ? 1 : 0) != 0);
                if (!this.isAccessor) {
                    TestCase.assertEquals((int)okEa.getMaximum(), (int)(pra.getLocalMaxMemory() + 1));
                }
                factory.setEvictionAttributes(okEa);
                attrs2 = factory.create();
                pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, attrs2);
                TestCase.assertNotNull((Object)pr);
                TestCase.assertNotSame((Object)okEa, (Object)pr.getAttributes().getEvictionAttributes());
                TestCase.assertEquals((int)firstEvictionAttributes.getMaximum(), (int)pr.getAttributes().getEvictionAttributes().getMaximum());
                pr.localDestroyRegion();
                pra = this.createPartitionAttributes(firstEvictionAttributes.getMaximum() - 1);
                factory.setPartitionAttributes(pra);
                if (!this.isAccessor) {
                    TestCase.assertTrue((firstEvictionAttributes.getMaximum() > pra.getLocalMaxMemory() ? 1 : 0) != 0);
                }
                factory.setEvictionAttributes(firstEvictionAttributes);
                attrs = factory.create();
                Region pr2 = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, attrs);
                TestCase.assertNotNull((Object)pr2);
                if (!this.isAccessor) {
                    TestCase.assertEquals((int)pr2.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)pr2.getAttributes().getEvictionAttributes().getMaximum());
                }
                pr2.localDestroyRegion();
                factory.setEvictionAttributes(firstEvictionAttributes);
                Region pr3 = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr3);
                TestCase.assertNotSame((Object)firstEvictionAttributes, (Object)pr3.getAttributes().getEvictionAttributes());
                TestCase.assertEquals((int)pr3.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)pr3.getAttributes().getEvictionAttributes().getMaximum());
                pr3.localDestroyRegion();
            }
        }
        testDatastore.invoke(new PRLRUMemoryRunnable(false));
    }

    public void testEvictionValidationForLRUEntry_AccessorFirst() {
        Host host = Host.getHost(0);
        VM firstAccessor = host.getVM(0);
        VM testAccessor = host.getVM(1);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        final EvictionAttributes secondEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        CacheSerializableRunnable createFirstAccessor = new CacheSerializableRunnable("Create an accessor without eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createFirstDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondAccessor = new CacheSerializableRunnable("Create an accessor with incorrect eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(secondEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        firstAccessor.invoke(createFirstAccessor);
        firstDatastore.invoke(createFirstDataStore);
        testAccessor.invoke(createSecondAccessor);
        testDatastore.invoke(createSecondDataStore);
    }

    public void testEvictionValidationForLRUEntry_DatastoreFirst() {
        Host host = Host.getHost(0);
        VM firstAccessor = host.getVM(0);
        VM testAccessor = host.getVM(1);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        final EvictionAttributes secondEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
        CacheSerializableRunnable createFirstAccessor = new CacheSerializableRunnable("Create an accessor without eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createFirstDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondAccessor = new CacheSerializableRunnable("Create an accessor with incorrect eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(secondEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        firstDatastore.invoke(createFirstDataStore);
        firstAccessor.invoke(createFirstAccessor);
        testDatastore.invoke(createSecondDataStore);
        testAccessor.invoke(createSecondAccessor);
    }

    public void testEvictionValidationForLRUEntry_TwoAccessors() {
        Host host = Host.getHost(0);
        VM firstAccessor = host.getVM(0);
        VM testAccessor = host.getVM(1);
        VM testDatastore = host.getVM(2);
        VM firstDatastore = host.getVM(3);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = true;
        int maxEntries = 226;
        final String name = uniqName + "-PR";
        final EvictionAttributes firstEvictionAttrs = EvictionAttributes.createLRUEntryAttributes((int)226, (EvictionAction)EvictionAction.LOCAL_DESTROY);
        CacheSerializableRunnable createFirstAccessor = new CacheSerializableRunnable("Create an accessor without eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createFirstDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondAccessor = new CacheSerializableRunnable("Create an accessor with correct eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        CacheSerializableRunnable createSecondDataStore = new CacheSerializableRunnable("Create a data store with eviction attributes"){

            @Override
            public void run2() {
                PartitionAttributes pra = new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(pra);
                factory.setEvictionAttributes(firstEvictionAttrs);
                Region pr = PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        firstAccessor.invoke(createFirstAccessor);
        testAccessor.invoke(createSecondAccessor);
        firstDatastore.invoke(createFirstDataStore);
        testDatastore.invoke(createSecondDataStore);
    }

    public void testEntryLRUDeadlock() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        String uniqName = this.getUniqueName();
        boolean redundantCopies = false;
        int maxBuckets = 8;
        int maxEntries = 16;
        final String name = uniqName + "-PR";
        int extraEntries = 4;
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(8).create());
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)16, (EvictionAction)EvictionAction.LOCAL_DESTROY));
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm0.invoke(create);
        SerializableRunnable create2 = new SerializableRunnable("Create Entry LRU with local destroy on a partitioned Region"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory = new AttributesFactory();
                    factory.setEnableOffHeapMemory(PartitionedRegionEvictionDUnitTest.this.isOffHeap());
                    factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(0).setLocalMaxMemory(0).setTotalNumBuckets(8).create());
                    factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)16));
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                    factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

                        public void afterCreate(EntryEvent event) {
                            Region region = event.getRegion();
                            Object key = event.getKey();
                            region.get(key);
                        }
                    });
                    PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.createRootRegion(name, factory.create());
                    TestCase.assertNotNull((Object)pr);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating Partitioned region", ex);
                }
            }
        };
        vm1.invoke(create2);
        SerializableRunnable doPuts = new SerializableRunnable("Do Puts"){

            @Override
            public void run() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionEvictionDUnitTest.this.getRootRegion(name);
                TestCase.assertNotNull((Object)pr);
                for (int counter = 0; counter <= 20; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)"value");
                }
            }
        };
        vm0.invoke(doPuts);
    }

    protected void setEvictionPercentage(float percentage) {
        this.getCache().getResourceManager().setEvictionHeapPercentage(percentage);
    }

    protected boolean isOffHeap() {
        return false;
    }

    protected InternalResourceManager.ResourceType getMemoryType() {
        return InternalResourceManager.ResourceType.HEAP_MEMORY;
    }

    protected HeapEvictor getEvictor(Region region) {
        return ((GemFireCacheImpl)region.getRegionService()).getHeapEvictor();
    }

    private static class VerifiableCacheListener
    extends CacheListenerAdapter
    implements Serializable {
        private VerifiableCacheListener() {
        }

        public boolean verify(long expectedEvictions) {
            return false;
        }
    }
}

