/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionMultipleDUnitTest
extends PartitionedRegionDUnitTestCase {
    protected static String prPrefix = null;
    static int MAX_REGIONS = 1;
    int startIndexForDestroy = 20;
    int endIndexForDestroy = 40;
    int startIndexForKey = 0;
    int endIndexForKey = 50;
    final int redundancy = 0;
    int localMaxMemory = 200;

    public PartitionedRegionMultipleDUnitTest(String name) {
        super(name);
    }

    public void testPartitionedRegionPutAndGet() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        prPrefix = "testPartitionedRegionPutAndGet";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        this.createMultiplePartitionRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionPutAndGet() - Partition Regions Successfully Created ");
        this.validateMultiplePartitionedRegions(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionPutAndGet() - Partition Regions Successfully Validated ");
        this.putInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionPutAndGet() - Put() Operation done Successfully in Partition Regions ");
        this.getInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionPutAndGet() - Partition Regions Successfully Validated ");
    }

    public void testPartitionedRegionDestroyKeys() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        prPrefix = "testPartitionedRegionDestroyKeys";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int afterPutFlag = 0;
        this.createMultiplePartitionRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Partition Regions Successfully Created ");
        this.validateMultiplePartitionedRegions(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Partition Regions Successfully Validated ");
        this.putInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Put() Operation done Successfully in Partition Regions ");
        this.destroyInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Destroy(Key) Operation done Successfully in Partition Regions ");
        this.getDestroyedEntryInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion, afterPutFlag);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Get() Operation after destoy keys done Successfully in Partition Regions ");
        this.putDestroyedEntryInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Put() Operation after destroy keys done Successfully in Partition Regions ");
        afterPutFlag = 1;
        this.getDestroyedEntryInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion, afterPutFlag);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyKeys() - Get() Operation after Put() done Successfully in Partition Regions ");
    }

    public void testPartitionedRegionDestroyAndContainsAPI() throws Throwable {
        int count;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        prPrefix = "testPartitionedRegionDestroyAndContainsAPI";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        this.createMultiplePartitionRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyAndContainsAPI() - Partition Regions Successfully Created ");
        this.validateMultiplePartitionedRegions(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyAndContainsAPI() - Partition Regions Successfully Validated ");
        this.putInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyAndContainsAPI() - Put() Operation done Successfully in Partition Regions ");
        this.destroyInMultiplePartitionedRegion(vm0, vm1, vm2, vm3, startIndexForRegion, endIndexForRegion);
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyAndContainsAPI() - Destroy(Key) Operation done Successfully in Partition Regions ");
        async[0] = vm0.invokeAsync(this.validateContainsAPIForPartitionRegion(startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.validateContainsAPIForPartitionRegion(startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.validateContainsAPIForPartitionRegion(startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.validateContainsAPIForPartitionRegion(startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 120000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
        PartitionedRegionMultipleDUnitTest.getLogWriter().info("testPartitionedRegionDestroyAndContainsAPI() - Validation of Contains APIs done Successfully in Partition Regions ");
    }

    private void createMultiplePartitionRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) {
        vm0.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, 0, this.localMaxMemory));
        vm1.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, 0, this.localMaxMemory));
        vm2.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, 0, this.localMaxMemory));
        vm3.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, 0, this.localMaxMemory));
    }

    private void validateMultiplePartitionedRegions(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.validateMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.validateMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.validateMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.validateMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private void putInMultiplePartitionedRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (this.endIndexForKey - this.startIndexForKey) / 4;
        async[0] = vm0.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForKey, this.startIndexForKey + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForKey + 1 * delta, this.startIndexForKey + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForKey + 2 * delta, this.startIndexForKey + 3 * delta, startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForKey + 3 * delta, this.endIndexForKey, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private void getInMultiplePartitionedRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.getInMultiplePartitionRegion(prPrefix, this.startIndexForKey, this.endIndexForKey, startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.getInMultiplePartitionRegion(prPrefix, this.startIndexForKey, this.endIndexForKey, startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.getInMultiplePartitionRegion(prPrefix, this.startIndexForKey, this.endIndexForKey, startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.getInMultiplePartitionRegion(prPrefix, this.startIndexForKey, this.endIndexForKey, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("Failed due to exception: " + async[count].getException(), async[count].getException());
        }
    }

    private void destroyInMultiplePartitionedRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (this.endIndexForDestroy - this.startIndexForDestroy) / 4;
        async[0] = vm0.invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.startIndexForDestroy + 1 * delta, startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + 1 * delta, this.startIndexForDestroy + 2 * delta, startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + 2 * delta, this.startIndexForDestroy + 3 * delta, startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.destroyInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + 3 * delta, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private CacheSerializableRunnable validateContainsAPIForPartitionRegion(final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateRegionAPIs = new CacheSerializableRunnable("validateInserts"){
            String innerprPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexForDestroy;
            int innerEndIndexForDestroy;
            {
                super(x0);
                this.innerprPrefix = prPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerStartIndexForKey = PartitionedRegionMultipleDUnitTest.this.startIndexForKey;
                this.innerEndIndexForKey = PartitionedRegionMultipleDUnitTest.this.endIndexForKey;
                this.innerStartIndexForDestroy = PartitionedRegionMultipleDUnitTest.this.startIndexForDestroy;
                this.innerEndIndexForDestroy = PartitionedRegionMultipleDUnitTest.this.endIndexForDestroy;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionMultipleDUnitTest.this.getCache();
                for (int j = this.innerStartIndexForRegion; j < this.innerEndIndexForRegion; ++j) {
                    int i;
                    Region pr = cache.getRegion("/" + this.innerprPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertEquals((String)pr.getName(), (String)(this.innerprPrefix + j));
                    for (i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                        Object val = null;
                        val = pr.get((Object)(j + this.innerprPrefix + i));
                        if (i >= this.innerStartIndexForDestroy && i < this.innerEndIndexForDestroy) {
                            TestCase.assertNull((Object)val);
                            continue;
                        }
                        if (val != null) {
                            TestCase.assertEquals((Object)val, (Object)(this.innerprPrefix + i));
                            TestCase.assertTrue((boolean)pr.containsValue((Object)(this.innerprPrefix + i)));
                            continue;
                        }
                        TestCase.fail((String)("Validation failed for key = " + j + this.innerprPrefix + i + "Value got = " + val));
                    }
                    DistributedTestCase.getLogWriter().info("validateContainsAPIForPartitionRegion() - Get() Validations done Successfully in Partition Region " + pr.getName());
                    for (i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                        boolean conKey = pr.containsKey((Object)(j + this.innerprPrefix + i));
                        if (i >= this.innerStartIndexForDestroy && i < this.innerEndIndexForDestroy) {
                            TestCase.assertFalse((boolean)conKey);
                            continue;
                        }
                        TestCase.assertTrue((boolean)conKey);
                    }
                    DistributedTestCase.getLogWriter().info("validateContainsAPIForPartitionRegion() - containsKey() Validations done Successfully in Partition Region " + pr.getName());
                    for (i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                        boolean conKey = pr.containsValueForKey((Object)(j + this.innerprPrefix + i));
                        if (i >= this.innerStartIndexForDestroy && i < this.innerEndIndexForDestroy) {
                            TestCase.assertFalse((boolean)conKey);
                            continue;
                        }
                        TestCase.assertTrue((boolean)conKey);
                    }
                    DistributedTestCase.getLogWriter().info("validateContainsAPIForPartitionRegion() - containsValueForKey() Validations done Successfully in Partition Region " + pr.getName());
                    for (i = this.innerStartIndexForKey; i < this.innerEndIndexForKey; ++i) {
                        boolean conKey = pr.containsValue((Object)(this.innerprPrefix + i));
                        if (i >= this.innerStartIndexForDestroy && i < this.innerEndIndexForDestroy) {
                            TestCase.assertFalse((boolean)conKey);
                            continue;
                        }
                        TestCase.assertTrue((boolean)conKey);
                    }
                    DistributedTestCase.getLogWriter().info("validateContainsAPIForPartitionRegion() - containsValue() Validations done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return validateRegionAPIs;
    }

    private void getDestroyedEntryInMultiplePartitionedRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion, int afterPutFlag) throws Throwable {
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = vm0.invokeAsync(this.getRemovedOrDestroyedInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion, afterPutFlag));
        async[1] = vm1.invokeAsync(this.getRemovedOrDestroyedInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion, afterPutFlag));
        async[2] = vm2.invokeAsync(this.getRemovedOrDestroyedInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion, afterPutFlag));
        async[3] = vm3.invokeAsync(this.getRemovedOrDestroyedInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion, afterPutFlag));
        for (int count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }

    private void putDestroyedEntryInMultiplePartitionedRegion(VM vm0, VM vm1, VM vm2, VM vm3, int startIndexForRegion, int endIndexForRegion) throws Throwable {
        int count;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int delta = (this.endIndexForDestroy - this.startIndexForDestroy) / 4;
        async[0] = vm0.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy, this.startIndexForDestroy + delta * 1, startIndexForRegion, endIndexForRegion));
        async[1] = vm1.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + delta * 1, this.startIndexForDestroy + delta * 2, startIndexForRegion, endIndexForRegion));
        async[2] = vm2.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + delta * 2, this.startIndexForDestroy + delta * 3, startIndexForRegion, endIndexForRegion));
        async[3] = vm3.invokeAsync(this.putInMultiplePartitionRegion(prPrefix, this.startIndexForDestroy + delta * 3, this.endIndexForDestroy, startIndexForRegion, endIndexForRegion));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionMultipleDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionMultipleDUnitTest.fail("exception during " + count, async[count].getException());
        }
    }
}

