/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegionEvictionDUnitTest;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.OffHeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.lru.HeapEvictor;
import java.util.Properties;

public class PartitionedRegionOffHeapEvictionDUnitTest
extends PartitionedRegionEvictionDUnitTest {
    public PartitionedRegionOffHeapEvictionDUnitTest(String name) {
        super(name);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties properties = super.getDistributedSystemProperties();
        properties.setProperty("off-heap-memory-size", "100m");
        return properties;
    }

    @Override
    protected void setEvictionPercentage(float percentage) {
        this.getCache().getResourceManager().setEvictionOffHeapPercentage(percentage);
    }

    @Override
    protected boolean isOffHeap() {
        return true;
    }

    @Override
    protected InternalResourceManager.ResourceType getMemoryType() {
        return InternalResourceManager.ResourceType.OFFHEAP_MEMORY;
    }

    @Override
    protected HeapEvictor getEvictor(Region region) {
        return ((GemFireCacheImpl)region.getRegionService()).getOffHeapEvictor();
    }

    @Override
    protected void raiseFakeNotification() {
        ((GemFireCacheImpl)this.getCache()).getOffHeapEvictor().testAbortAfterLoopCount = 1;
        this.setEvictionPercentage(85.0f);
        OffHeapMemoryMonitor ohmm = ((GemFireCacheImpl)this.getCache()).getResourceManager().getOffHeapMonitor();
        ohmm.stopMonitoring();
        ohmm.updateStateAndSendEvent(0x5A00000L);
    }

    @Override
    protected void cleanUpAfterFakeNotification() {
        ((GemFireCacheImpl)this.getCache()).getOffHeapEvictor().testAbortAfterLoopCount = Integer.MAX_VALUE;
    }
}

