/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class PartitionedRegionRedundancyZoneDUnitTest
extends CacheTestCase {
    public PartitionedRegionRedundancyZoneDUnitTest(String name) {
        super(name);
    }

    public void testNotEnoughZones() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.setRedundancyZone(vm0, "A");
        this.setRedundancyZone(vm1, "A");
        this.setRedundancyZone(vm2, "B");
        this.createPR(vm0, 2);
        this.createPR(vm1, 2);
        this.createPR(vm2, 2);
        this.createData(vm0, 0, 6, "A");
        int vm0Count = this.getBucketCount(vm0);
        int vm1Count = this.getBucketCount(vm1);
        int vm2Count = this.getBucketCount(vm2);
        String counts = "vm0=" + vm0Count + ",vm1=" + vm1Count + ",vm2=" + vm2Count;
        PartitionedRegionRedundancyZoneDUnitTest.assertEquals((String)counts, (int)6, (int)(vm0Count + vm1Count));
        PartitionedRegionRedundancyZoneDUnitTest.assertEquals((String)counts, (int)6, (int)vm2Count);
        PartitionedRegionRedundancyZoneDUnitTest.assertTrue((String)counts, (vm0Count >= 2 && vm1Count >= 2 ? 1 : 0) != 0);
    }

    protected void checkBucketCount(VM vm0, final int numLocalBuckets) {
        vm0.invoke(new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionRedundancyZoneDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                TestCase.assertEquals((int)numLocalBuckets, (int)region.getLocalBucketsListTestOnly().size());
            }
        });
    }

    protected int getBucketCount(VM vm0) {
        return (Integer)vm0.invoke(new SerializableCallable("checkLowRedundancy"){

            public Object call() {
                Cache cache = PartitionedRegionRedundancyZoneDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                return region.getLocalBucketsListTestOnly().size();
            }
        });
    }

    protected DistributedMember createPR(VM vm, int redundancy) throws Throwable {
        SerializableCallable createPrRegion = new SerializableCallable("createRegion"){

            public Object call() {
                Cache cache = PartitionedRegionRedundancyZoneDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke(createPrRegion);
    }

    protected DistributedMember setRedundancyZone(VM vm, final String zone) {
        return (DistributedMember)vm.invoke(new SerializableCallable("set redundancy zone"){

            public Object call() {
                Properties props = new Properties();
                props.setProperty("redundancy-zone", zone);
                InternalDistributedSystem system = PartitionedRegionRedundancyZoneDUnitTest.this.getSystem(props);
                return system.getDistributedMember();
            }
        });
    }

    protected void createData(VM vm, int startKey, int endKey, String value) {
        this.createData(vm, startKey, endKey, value, "region1");
    }

    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable("createData"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionRedundancyZoneDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }
}

