/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientPartitionAdvisor;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketServerLocation66;
import com.gemstone.gemfire.internal.cache.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;

public class PartitionedRegionSingleHopDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    private static final String PR_NAME = "single_hop_pr";
    VM member0 = null;
    VM member1 = null;
    VM member2 = null;
    VM member3 = null;
    private static Region region = null;
    private static Region customerRegion = null;
    private static Region orderRegion = null;
    private static Region shipmentRegion = null;
    private static Region replicatedRegion = null;
    private static Cache cache = null;
    private static Locator locator = null;

    public PartitionedRegionSingleHopDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.member0 = host.getVM(0);
        this.member1 = host.getVM(1);
        this.member2 = host.getVM(2);
        this.member3 = host.getVM(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown2() throws Exception {
        try {
            this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
            this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
            this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
            this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
            PartitionedRegionSingleHopDUnitTest.closeCache();
            super.tearDown2();
            this.member0 = null;
            this.member1 = null;
            this.member2 = null;
            this.member3 = null;
        }
        finally {
            PartitionedRegionSingleHopDUnitTest.unregisterAllDataSerializersFromAllVms();
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void stopServer() {
        for (CacheServer cacheServer : cache.getCacheServers()) {
            cacheServer.stop();
        }
    }

    public static void startLocatorInVM(int locatorPort) {
        File logFile = new File("locator-" + locatorPort + ".log");
        Properties props = new Properties();
        try {
            locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, null, (Properties)props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void stopLocator() {
        locator.stop();
    }

    public static int createServerWithLocator(String locString, int redundantCopies, int totalNoofBuckets) {
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("locators", locString);
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        return port;
    }

    public static void clearMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPartitionAttributesMap().clear();
        cms.getClientPRMetadata_TEST_ONLY().clear();
    }

    public void test_NoClient() {
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        PartitionedRegionSingleHopDUnitTest.createAccessorServer();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "clearMetadata");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "clearMetadata");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "clearMetadata");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "clearMetadata");
        PartitionedRegionSingleHopDUnitTest.clearMetadata();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoPartitionedRegions");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoPartitionedRegions");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoPartitionedRegions");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoPartitionedRegions");
        PartitionedRegionSingleHopDUnitTest.putIntoPartitionedRegions();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "getFromPartitionedRegions");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "getFromPartitionedRegions");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "getFromPartitionedRegions");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "getFromPartitionedRegions");
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyMetadata");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyMetadata");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyMetadata");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyMetadata");
        PartitionedRegionSingleHopDUnitTest.verifyEmptyMetadata();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyStaticData");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyStaticData");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyStaticData");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyEmptyStaticData");
        PartitionedRegionSingleHopDUnitTest.verifyEmptyStaticData();
    }

    public void test_ClientConnectedToAccessors() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createAccessorServer");
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createAccessorServer");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1);
        PartitionedRegionSingleHopDUnitTest.putIntoPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.verifyEmptyMetadata();
        PartitionedRegionSingleHopDUnitTest.verifyEmptyStaticData();
    }

    public void test_ClientConnectedTo1Server() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPeer");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createAccessorServer");
        PartitionedRegionSingleHopDUnitTest.createClient(port0);
        PartitionedRegionSingleHopDUnitTest.putIntoPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.verifyEmptyMetadata();
        PartitionedRegionSingleHopDUnitTest.verifyEmptyStaticData();
    }

    public void test_MetadataContents() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        PartitionedRegionSingleHopDUnitTest.putIntoPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.verifyMetadata();
        PartitionedRegionSingleHopDUnitTest.updateIntoSinglePR();
    }

    public void DISABLED_49657_test_MetadataServiceCallAccuracy() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClient", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClient(port1);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        final ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cms.isRefreshMetadataTestOnly();
            }

            @Override
            public String description() {
                return "expected metadataservice to be called atleast once, but it was not called";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return !cms.isRefreshMetadataTestOnly();
            }

            @Override
            public String description() {
                return "expected no metadata to be refreshed";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public void test_MetadataServiceCallAccuracy_FromDestroyOp() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClient", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClient(port1);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        final ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.destroy((Object)new Integer(0));
        region.destroy((Object)new Integer(1));
        region.destroy((Object)new Integer(2));
        region.destroy((Object)new Integer(3));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cms.isRefreshMetadataTestOnly();
            }

            @Override
            public String description() {
                return "expected metadataservice to be called atleast once, but it was not called";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public void test_MetadataServiceCallAccuracy_FromGetOp() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClient", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClient(port1);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        final ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cms.isRefreshMetadataTestOnly();
            }

            @Override
            public String description() {
                return "expected metadataservice to be called atleast once, but it was not called";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        PartitionedRegionSingleHopDUnitTest.printMetadata();
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)cms.isRefreshMetadataTestOnly());
    }

    public void test_SingleHopWithHA() {
        int i;
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 8});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 8});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 8});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 8});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        final ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        for (i = 1; i <= 16; ++i) {
            region.put((Object)new Integer(i), (Object)new Integer(i));
        }
        for (i = 1; i <= 16; ++i) {
            region.put((Object)new Integer(i), (Object)new Integer(i + 1));
        }
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cms.isRefreshMetadataTestOnly();
            }

            @Override
            public String description() {
                return "expected metadataservice to be called atleast once, but it was not called";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        for (int i2 = 1; i2 <= 16; ++i2) {
            region.put((Object)new Integer(i2), (Object)new Integer(i2 + 10));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithHAWithLocator() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            int i;
            Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServerWithLocator", new Object[]{locator, 0, 8});
            Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServerWithLocator", new Object[]{locator, 0, 8});
            Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServerWithLocator", new Object[]{locator, 0, 8});
            PartitionedRegionSingleHopDUnitTest.createClientWithLocator(host0, port3);
            for (i = 1; i <= 16; ++i) {
                region.put((Object)new Integer(i), (Object)new Integer(i));
            }
            for (i = 1; i <= 16; ++i) {
                region.put((Object)new Integer(i), (Object)new Integer(i + 1));
            }
            this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
            for (i = 1; i <= 16; ++i) {
                region.put((Object)new Integer(i), (Object)new Integer(i + 10));
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopLocator");
        }
    }

    public void test_NoMetadataServiceCall_ForGetOp() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClientWithoutPRSingleHopEnabled", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClientWithoutPRSingleHopEnabled(port1);
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)cms.isRefreshMetadataTestOnly());
        PartitionedRegionSingleHopDUnitTest.printMetadata();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)cms.isRefreshMetadataTestOnly());
    }

    public void test_NoMetadataServiceCall() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{1, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClientWithoutPRSingleHopEnabled", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClientWithoutPRSingleHopEnabled(port1);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        region.put((Object)new Integer(0), (Object)"create0");
        boolean metadataRefreshed_get1 = cms.isRefreshMetadataTestOnly();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(1), (Object)"create1");
        boolean metadataRefreshed_get2 = cms.isRefreshMetadataTestOnly();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(2), (Object)"create2");
        boolean metadataRefreshed_get3 = cms.isRefreshMetadataTestOnly();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(3), (Object)"create3");
        boolean metadataRefreshed_get4 = cms.isRefreshMetadataTestOnly();
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((metadataRefreshed_get1 || metadataRefreshed_get2 || metadataRefreshed_get3 || metadataRefreshed_get4 ? 1 : 0) != 0);
        PartitionedRegionSingleHopDUnitTest.printMetadata();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)cms.isRefreshMetadataTestOnly());
    }

    public void test_NoMetadataServiceCall_ForDestroyOp() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{0, 4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createClientWithoutPRSingleHopEnabled", new Object[]{port0});
        PartitionedRegionSingleHopDUnitTest.createClientWithoutPRSingleHopEnabled(port1);
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoSinglePR");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "printView");
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.destroy((Object)new Integer(0));
        region.destroy((Object)new Integer(1));
        region.destroy((Object)new Integer(2));
        region.destroy((Object)new Integer(3));
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)cms.isRefreshMetadataTestOnly());
    }

    public void testServerLocationRemovalThroughPing() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        PartitionedRegionSingleHopDUnitTest.putIntoPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion.getFullPath()));
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(orderRegion.getFullPath()));
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(shipmentRegion.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)((List)entry.getValue()).size());
        }
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        PartitionedRegionSingleHopDUnitTest.pause(5000);
        PartitionedRegionSingleHopDUnitTest.getFromPartitionedRegions();
        this.verifyDeadServer(regionMetaData, customerRegion, port0, port1);
        this.verifyDeadServer(regionMetaData, region, port0, port1);
    }

    public void testMetadataFetchOnlyThroughFunctions() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        PartitionedRegionSingleHopDUnitTest.executeFunctions();
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
    }

    public void testMetadataFetchOnlyThroughputAll() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        PartitionedRegionSingleHopDUnitTest.putAll();
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
    }

    public void DISABLED_BUG47950_testMetadataIsSameOnAllServersAndClients() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{3, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        PartitionedRegionSingleHopDUnitTest.put();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPRMetadata((LocalRegion)region);
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        Map clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)((List)entry.getValue()).size());
        }
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "startServerOnPort", new Object[]{port0});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "startServerOnPort", new Object[]{port1});
        PartitionedRegionSingleHopDUnitTest.put();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                TestCase.assertEquals((int)1, (int)regionMetaData.size());
                TestCase.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                Map clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
                TestCase.assertEquals((int)4, (int)clientMap.size());
                boolean finished = true;
                for (Map.Entry entry : clientMap.entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.size() >= 4) continue;
                    DistributedTestCase.getLogWriter().info("still waiting for 4 bucket owners in " + entry.getKey() + ": " + list);
                    finished = false;
                    break;
                }
                return finished;
            }

            @Override
            public String description() {
                return "bucket copies are not created";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 400L, true);
        cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPRMetadata((LocalRegion)region);
        regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)((List)entry.getValue()).size());
        }
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        PartitionedRegionSingleHopDUnitTest.put();
        this.member2.invoke(new CacheSerializableRunnable("aba"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)region;
                ConcurrentHashMap serverMap = pr.getRegionAdvisor().getAllClientBucketProfilesTest();
            }
        });
        this.member3.invoke(new CacheSerializableRunnable("aba"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)region;
                ConcurrentHashMap serverMap = pr.getRegionAdvisor().getAllClientBucketProfilesTest();
            }
        });
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPRMetadata((LocalRegion)region);
        regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)2, (int)((List)entry.getValue()).size());
        }
        final Map fclientMap = clientMap;
        PartitionedRegionSingleHopDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                try {
                    PartitionedRegionSingleHopDUnitTest.this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{fclientMap});
                    PartitionedRegionSingleHopDUnitTest.this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{fclientMap});
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().info("verification failed", (Throwable)e);
                    return false;
                }
                return true;
            }

            @Override
            public String description() {
                return "verification of metadata on all members";
            }
        }, 20000L, 2000L, true);
    }

    public void testMetadataIsSameOnAllServersAndClientsHA() {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{2, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createServer", new Object[]{2, 4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port0, port1);
        PartitionedRegionSingleHopDUnitTest.put();
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPRMetadata((LocalRegion)region);
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        this.member0.invoke(new CacheSerializableRunnable("aba"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)region;
                ConcurrentHashMap serverMap = pr.getRegionAdvisor().getAllClientBucketProfilesTest();
            }
        });
        this.member1.invoke(new CacheSerializableRunnable("aba"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr = (PartitionedRegion)region;
                ConcurrentHashMap serverMap = pr.getRegionAdvisor().getAllClientBucketProfilesTest();
            }
        });
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        Map clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("The clientMap is " + clientMap);
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)2, (int)((List)entry.getValue()).size());
        }
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "verifyMetadata", new Object[]{clientMap});
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "stopServer");
        PartitionedRegionSingleHopDUnitTest.put();
        cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.getClientPRMetadata((LocalRegion)region);
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)clientMap.size());
        for (Map.Entry entry : clientMap.entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)((List)entry.getValue()).size());
        }
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            private int bucketId;
            private int size;
            List globalList = new ArrayList();

            @Override
            public boolean done() {
                ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
                Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
                TestCase.assertEquals((int)1, (int)regionMetaData.size());
                TestCase.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
                ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
                Map clientMap = prMetaData.getBucketServerLocationsMap_TEST_ONLY();
                TestCase.assertEquals((int)4, (int)clientMap.size());
                boolean finished = true;
                for (Map.Entry entry : clientMap.entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.size() == 1) continue;
                    this.size = list.size();
                    this.globalList = list;
                    this.bucketId = (Integer)entry.getKey();
                    finished = false;
                }
                return finished;
            }

            @Override
            public String description() {
                return "bucket copies are not created, the locations size for bucket id : " + this.bucketId + " size : " + this.size + " the list is " + this.globalList;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 400L, true);
    }

    public void _testClientMetadataForPersistenetPrs() throws Exception {
        Integer port0 = (Integer)this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServer", new Object[]{3, 4});
        Integer port1 = (Integer)this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServer", new Object[]{3, 4});
        Integer port2 = (Integer)this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServer", new Object[]{3, 4});
        Integer port3 = (Integer)this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServer", new Object[]{3, 4});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "putIntoPartitionedRegions");
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "waitForLocalBucketsCreattion", new Object[]{4});
        PartitionedRegionSingleHopDUnitTest.createClient(port0, port1, port2, port3);
        this.fetchAndValidateMetadata();
        this.member0.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        this.member1.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        this.member2.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        this.member3.invoke(PartitionedRegionSingleHopDUnitTest.class, "closeCache");
        PartitionedRegionSingleHopDUnitTest.pause(1000);
        AsyncInvocation m3 = this.member3.invokeAsync(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServerOnPort", new Object[]{3, 4, port3});
        AsyncInvocation m2 = this.member2.invokeAsync(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServerOnPort", new Object[]{3, 4, port2});
        AsyncInvocation m1 = this.member1.invokeAsync(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServerOnPort", new Object[]{3, 4, port1});
        AsyncInvocation m0 = this.member0.invokeAsync(PartitionedRegionSingleHopDUnitTest.class, "createPersistentPrsAndServerOnPort", new Object[]{3, 4, port0});
        m3.join();
        m2.join();
        m1.join();
        m0.join();
        this.fetchAndValidateMetadata();
    }

    private void fetchAndValidateMetadata() {
        ClientMetadataService service = ((GemFireCacheImpl)cache).getClientMetadataService();
        service.getClientPRMetadata((LocalRegion)region);
        HashMap servers = service.groupByServerToAllBuckets(region, true);
        if (servers == null) {
            PartitionedRegionSingleHopDUnitTest.fail((String)("The client metadata contains no servers for region " + region.getFullPath()));
        } else {
            region.getCache().getLogger().fine("The client metadata contains the following " + servers.size() + " servers for region " + region.getFullPath() + ":");
            for (Map.Entry entry : servers.entrySet()) {
                region.getCache().getLogger().fine(entry.getKey() + "->" + entry.getValue());
            }
            if (servers.size() < 4) {
                PartitionedRegionSingleHopDUnitTest.fail((String)("Servers size is " + servers.size() + " less than expected 4."));
            }
        }
    }

    public static void verifyMetadata(Map<Integer, List<BucketServerLocation66>> clientMap) {
        PartitionedRegion pr = (PartitionedRegion)region;
        ConcurrentHashMap serverMap = pr.getRegionAdvisor().getAllClientBucketProfilesTest();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)clientMap.size(), (int)serverMap.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)clientMap.keySet().containsAll(serverMap.keySet()));
        for (Map.Entry<Integer, List<BucketServerLocation66>> entry : clientMap.entrySet()) {
            int bucketId = entry.getKey();
            List<BucketServerLocation66> list = entry.getValue();
            BucketServerLocation66 primaryBSL = null;
            int primaryCnt = 0;
            for (BucketServerLocation66 bsl : list) {
                if (!bsl.isPrimary()) continue;
                primaryBSL = bsl;
                ++primaryCnt;
            }
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)primaryCnt);
            Set set = (Set)serverMap.get(bucketId);
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)list.size(), (int)set.size());
            primaryCnt = 0;
            for (BucketAdvisor.ServerBucketProfile bp : set) {
                ServerLocation sl = (ServerLocation)bp.bucketServerLocations.toArray()[0];
                PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)list.contains(sl));
                if (!bp.isPrimary) continue;
                ++primaryCnt;
                PartitionedRegionSingleHopDUnitTest.assertEquals((Object)primaryBSL, (Object)sl);
            }
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)1, (int)primaryCnt);
        }
    }

    public static void waitForLocalBucketsCreattion(final int numBuckets) {
        final PartitionedRegion pr = (PartitionedRegion)region;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pr.getDataStore().getAllLocalBuckets().size() == numBuckets;
            }

            @Override
            public String description() {
                return "bucket copies are not created, the total number of buckets expected are " + numBuckets + " but the total num of buckets are " + pr.getDataStore().getAllLocalBuckets().size();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 400L, true);
    }

    public static void waitForBucketsCreattion() {
        final PartitionedRegion pr = (PartitionedRegion)region;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return pr.getDataStore().getAllLocalBuckets().size() == 2;
            }

            @Override
            public String description() {
                return "bucket copies are not created";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 400L, true);
    }

    private void verifyDeadServer(Map<String, ClientPartitionAdvisor> regionMetaData, Region region, int port0, int port1) {
        ServerLocation sl0 = new ServerLocation("localhost", port0);
        ServerLocation sl1 = new ServerLocation("localhost", port1);
        ClientPartitionAdvisor prMetaData = regionMetaData.get(region.getFullPath());
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            List servers = (List)entry.getValue();
            PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)servers.contains(sl0));
            PartitionedRegionSingleHopDUnitTest.assertFalse((boolean)servers.contains(sl1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithoutPRSingleHopEnabled(int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).setPRSingleHopEnabled(false).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopDUnitTest.createRegionsInClientCache(p.getName());
    }

    public static int createAccessorServer() {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setLocalMaxMemory(0);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setLocalMaxMemory(0).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setLocalMaxMemory(0).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setLocalMaxMemory(0).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
        return port;
    }

    public static int createServer(int redundantCopies, int totalNoofBuckets) {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
        return port;
    }

    public static int createPersistentPrsAndServer(int redundantCopies, int totalNoofBuckets) {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        DiskStore disk = cache.findDiskStore("disk");
        if (disk == null) {
            disk = cache.createDiskStoreFactory().setDiskDirs(PartitionedRegionSingleHopDUnitTest.getDiskDirs()).create("disk");
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        return port;
    }

    public static int createPersistentPrsAndServerOnPort(int redundantCopies, int totalNoofBuckets, int port) {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        DiskStore disk = cache.findDiskStore("disk");
        if (disk == null) {
            disk = cache.createDiskStoreFactory().setDiskDirs(PartitionedRegionSingleHopDUnitTest.getDiskDirs()).create("disk");
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        attr.setDiskStoreName("disk");
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
        CacheServer server = cache.addCacheServer();
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        return port;
    }

    public static void createServerOnPort(int redundantCopies, int totalNoofBuckets, int port) {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
    }

    public static void startServerOnPort(int port) {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopDUnitTest.fail("Failed to start server ", e);
        }
    }

    public static void createPeer() {
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        cache = test.getCache();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        customerRegion = cache.createRegion("CUSTOMER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setColocatedWith("CUSTOMER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        orderRegion = cache.createRegion("ORDER", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1).setTotalNumBuckets(4).setColocatedWith("ORDER").setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        attr.setConcurrencyChecksEnabled(true);
        shipmentRegion = cache.createRegion("SHIPMENT", attr.create());
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        replicatedRegion = cache.createRegion("rr", new AttributesFactory().create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0, int port1) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).addServer("localhost", port1).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocator(String host, int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClient(int port0, int port1, int port2, int port3) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopDUnitTest test = new PartitionedRegionSingleHopDUnitTest("PartitionedRegionSingleHopDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer("localhost", port0).addServer("localhost", port1).addServer("localhost", port2).addServer("localhost", port3).setPingInterval(100L).setSubscriptionEnabled(false).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopDUnitTest.createRegionsInClientCache(p.getName());
    }

    private static void createRegionsInClientCache(String poolName) {
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(PR_NAME, attrs);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Distributed Region single_hop_pr created Successfully :" + region.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        attrs = factory.create();
        customerRegion = cache.createRegion("CUSTOMER", attrs);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Distributed Region CUSTOMER created Successfully :" + customerRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        attrs = factory.create();
        orderRegion = cache.createRegion("ORDER", attrs);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Distributed Region ORDER created Successfully :" + orderRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        attrs = factory.create();
        shipmentRegion = cache.createRegion("SHIPMENT", attrs);
        PartitionedRegionSingleHopDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopDUnitTest.getLogWriter().info("Distributed Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        factory.setPoolName(poolName);
        replicatedRegion = cache.createRegion("rr", factory.create());
    }

    public static void putIntoPartitionedRegions() {
        for (int i = 0; i <= 3; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            customerRegion.put((Object)custid, (Object)customer);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                orderRegion.put((Object)orderId, (Object)order);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    shipmentRegion.put((Object)shipmentId, (Object)shipment);
                }
            }
        }
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        region.put((Object)new Integer(0), (Object)"update0");
        region.put((Object)new Integer(1), (Object)"update1");
        region.put((Object)new Integer(2), (Object)"update2");
        region.put((Object)new Integer(3), (Object)"update3");
        region.put((Object)new Integer(0), (Object)"update00");
        region.put((Object)new Integer(1), (Object)"update11");
        region.put((Object)new Integer(2), (Object)"update22");
        region.put((Object)new Integer(3), (Object)"update33");
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        replicatedRegion.putAll(map);
    }

    public static void executeFunctions() {
        HashSet<Integer> filter = new HashSet<Integer>();
        filter.add(0);
        FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)new MyFunctionAdapter()).getResult();
        filter.add(1);
        FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)new MyFunctionAdapter()).getResult();
        filter.add(2);
        filter.add(3);
        FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)new MyFunctionAdapter()).getResult();
        FunctionService.onRegion((Region)region).execute((Function)new MyFunctionAdapter()).getResult();
    }

    public static void putAll() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(0, 0);
        map.put(1, 1);
        map.put(2, 2);
        map.put(3, 3);
        region.putAll(map);
        region.putAll(map);
        region.putAll(map);
        region.putAll(map);
    }

    public static void put() {
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        for (int i = 0; i < 40; ++i) {
            region.put((Object)new Integer(i), (Object)("create" + i));
        }
    }

    public static void getFromPartitionedRegions() {
        for (int i = 0; i <= 3; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            customerRegion.get((Object)custid, (Object)customer);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                orderRegion.get((Object)orderId, (Object)order);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    shipmentRegion.get((Object)shipmentId, (Object)shipment);
                }
            }
        }
        region.get((Object)new Integer(0), (Object)"create0");
        region.get((Object)new Integer(1), (Object)"create1");
        region.get((Object)new Integer(2), (Object)"create2");
        region.get((Object)new Integer(3), (Object)"create3");
        region.get((Object)new Integer(0), (Object)"update0");
        region.get((Object)new Integer(1), (Object)"update1");
        region.get((Object)new Integer(2), (Object)"update2");
        region.get((Object)new Integer(3), (Object)"update3");
        region.get((Object)new Integer(0), (Object)"update00");
        region.get((Object)new Integer(1), (Object)"update11");
        region.get((Object)new Integer(2), (Object)"update22");
        region.get((Object)new Integer(3), (Object)"update33");
    }

    public static void putIntoSinglePR() {
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
    }

    public static void getDataFromSinglePR() {
        for (int i = 0; i < 10; ++i) {
            region.get((Object)new Integer(0));
            region.get((Object)new Integer(1));
            region.get((Object)new Integer(2));
            region.get((Object)new Integer(3));
        }
    }

    public static void updateIntoSinglePR() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        cms.satisfyRefreshMetadata_TEST_ONLY(false);
        region.put((Object)new Integer(0), (Object)"update0");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(1), (Object)"update1");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(2), (Object)"update2");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(3), (Object)"update3");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(0), (Object)"update00");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(1), (Object)"update11");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(2), (Object)"update22");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
        region.put((Object)new Integer(3), (Object)"update33");
        PartitionedRegionSingleHopDUnitTest.assertEquals((boolean)false, (boolean)cms.isRefreshMetadataTestOnly());
    }

    public static void verifyEmptyMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)cms.getClientPRMetadata_TEST_ONLY().isEmpty());
    }

    public static void verifyEmptyStaticData() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)cms.getClientPartitionAttributesMap().isEmpty());
    }

    public static void verifyNonEmptyMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        PartitionedRegionSingleHopDUnitTest.assertTrue((!cms.getClientPRMetadata_TEST_ONLY().isEmpty() ? 1 : 0) != 0);
        PartitionedRegionSingleHopDUnitTest.assertTrue((!cms.getClientPartitionAttributesMap().isEmpty() ? 1 : 0) != 0);
    }

    public static void printMetadata() {
        if (cache != null) {
            ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
            ((GemFireCacheImpl)cache).getLogger().info("Metadata is " + cms.getClientPRMetadata_TEST_ONLY());
        }
    }

    public static void printView() {
        PartitionedRegion pr = (PartitionedRegion)region;
        if (pr.cache != null) {
            ((GemFireCacheImpl)cache).getLogger().info("Primary Bucket view of server0  " + pr.getDataStore().getLocalPrimaryBucketsListTestOnly());
            ((GemFireCacheImpl)cache).getLogger().info("Secondary Bucket view of server0  " + pr.getDataStore().getLocalNonPrimaryBucketsListTestOnly());
        }
    }

    private void verifyMetadata() {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)regionMetaData.size());
        PartitionedRegionSingleHopDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        PartitionedRegionSingleHopDUnitTest.assertEquals((int)4, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopDUnitTest.assertEquals((int)2, (int)((List)entry.getValue()).size());
        }
    }

    static class MyFunctionAdapter
    extends FunctionAdapter {
        MyFunctionAdapter() {
        }

        public String getId() {
            return "fid";
        }

        public void execute(FunctionContext context) {
            System.out.println("YOGS function called");
            RegionFunctionContext rc = (RegionFunctionContext)context;
            Region r = rc.getDataSet();
            Set filter = rc.getFilter();
            if (rc.getFilter() == null) {
                for (int i = 0; i < 200; ++i) {
                    r.put((Object)i, (Object)i);
                }
            } else {
                for (Object key : filter) {
                    r.put(key, key);
                }
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public boolean isHA() {
            return false;
        }

        public boolean optimizeForWrite() {
            return true;
        }
    }
}

