/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import junit.framework.TestCase;

public class PartitionedRegionSizeDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    static final Boolean value = new Boolean(true);
    static final int MAX_REGIONS = 1;
    static final int cnt = 100;
    final int totalNumBuckets = 5;

    public PartitionedRegionSizeDUnitTest(String name) {
        super(name);
    }

    public void sizeOpsForDistAckSync() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion("PRDistAckSync" + i, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 200));
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion("PRDistAckSync" + i, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm2.invoke(createPRs);
        vm3.invoke(createAccessor);
        vm3.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                int oldLevel = PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), 900);
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSync" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 100; ++k) {
                        Integer key = new Integer(k);
                        pr.put((Object)key, (Object)value);
                    }
                }
                PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), oldLevel);
            }
        });
        vm3.invoke(new CacheSerializableRunnable("validateSize"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSync" + j);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertEquals((String)"size not matching=", (int)100, (int)pr.size());
                }
            }
        });
        vm3.invoke(new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSync" + j);
                    TestCase.assertNotNull((Object)pr);
                    pr.destroyRegion();
                }
            }
        });
    }

    public void sizeOpsForDistAckASync() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion("PRDistAckASync" + i, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 200));
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion("PRDistAckASync" + i, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm2.invoke(createPRs);
        vm3.invoke(createAccessor);
        AsyncInvocation async0 = vm3.invokeAsync(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                int oldLevel = PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), 900);
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckASync" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 100; ++k) {
                        Integer key = new Integer(k);
                        pr.put((Object)key, (Object)value);
                    }
                }
                PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), oldLevel);
            }
        });
        DistributedTestCase.join(async0, 30000L, PartitionedRegionSizeDUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            PartitionedRegionSizeDUnitTest.fail("Exception during async0", async0.getException());
        }
        vm3.invoke(new CacheSerializableRunnable("validateSize"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckASync" + j);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertEquals((String)"size not matching=", (int)100, (int)pr.size());
                }
            }
        });
        vm3.invoke(new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckASync" + j);
                    TestCase.assertNotNull((Object)pr);
                    pr.destroyRegion();
                }
            }
        });
    }

    public void sizeOpsForDistAckSyncChangingVMCount() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion("PRDistAckSyncChangingVMCount" + i, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(2, 200));
                }
            }
        };
        CacheSerializableRunnable disconnectVM = new CacheSerializableRunnable("disconnectVM"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                DistributedSystem ds = cache.getDistributedSystem();
                ds.disconnect();
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm0.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                int oldLevel = PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), 900);
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSyncChangingVMCount" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 100; ++k) {
                        Integer key = new Integer(k);
                        pr.put((Object)key, (Object)value);
                    }
                }
                PartitionedRegionDUnitTestCase.setLogLevel(DistributedTestCase.getLogWriter(), oldLevel);
            }
        });
        vm2.invoke(createPRs);
        vm3.invoke(createPRs);
        vm3.invoke(new CacheSerializableRunnable("validateSize"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSyncChangingVMCount" + j);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertEquals((String)"size not matching=", (int)100, (int)pr.size());
                }
            }
        });
        vm0.invoke(disconnectVM);
        vm3.invoke(disconnectVM);
        vm1.invoke(new CacheSerializableRunnable("validateSize"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PRDistAckSyncChangingVMCount" + j);
                    TestCase.assertNotNull((Object)pr);
                    TestCase.assertEquals((String)"size not matching=", (int)100, (int)pr.size());
                }
            }
        });
    }

    public void testSize() throws Throwable {
        this.sizeOpsForDistAckSync();
        this.sizeOpsForDistAckASync();
    }

    public void testBug39868() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createPRs = new SerializableRunnable("createPrRegion"){

            @Override
            public void run() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                Region partitionedregion = cache.createRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 200));
            }
        };
        vm0.invoke(createPRs);
        vm0.invoke(new SerializableRunnable("create data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                Region partitionedregion = cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                for (int i = 0; i < 100; ++i) {
                    partitionedregion.put((Object)(Integer.valueOf(i) * 5), (Object)new byte[100]);
                }
            }
        });
        vm1.invoke(createPRs);
        vm0.invoke(new SerializableRunnable("delete data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                Region partitionedregion = cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                for (int i = 0; i < 100; ++i) {
                    partitionedregion.destroy((Object)(Integer.valueOf(i) * 5));
                }
            }
        });
        vm1.invoke(new SerializableRunnable("check size"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                PartitionedRegion partitionedregion = (PartitionedRegion)cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                long bytes = partitionedregion.getDataStore().currentAllocatedMemory();
                TestCase.assertEquals((long)0L, (long)bytes);
            }
        });
    }

    public void testByteSize() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPRs = new SerializableRunnable("createPrRegion"){

            @Override
            public void run() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                Region partitionedregion = cache.createRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 200));
            }
        };
        final long oneItemSize = this.runProportionalSize(createPRs);
        SerializableRunnable checkMemSize = new SerializableRunnable("checkMemSize"){

            @Override
            public void run() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                PartitionedRegion partitionedregion = (PartitionedRegion)cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                PartitionedRegionDataStore dataStore = partitionedregion.getDataStore();
                TestCase.assertEquals((long)(50L * oneItemSize), (long)dataStore.currentAllocatedMemory());
            }
        };
    }

    public void testByteSizeWithEviction() throws Exception {
        Host host = Host.getHost(0);
        final String uniqueName = this.getUniqueName();
        SerializableRunnable createPRs = new SerializableRunnable("createPrRegion"){

            @Override
            public void run() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.setRedundantCopies(1).setLocalMaxMemory(200).setTotalNumBuckets(5).create();
                attr.setPartitionAttributes(prAttr);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)2, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                File[] diskDirs = new File[]{new File("overflowDir/" + uniqueName + "_" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                attr.setDiskSynchronous(true);
                attr.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(diskDirs).create("PartitionedRegionSizeDUnitTest").getName());
                Region partitionedregion = cache.createRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX, PartitionedRegionSizeDUnitTest.this.createRegionAttributesForPR(1, 200));
            }
        };
        final long oneItemSize = this.runProportionalSize(createPRs);
        SerializableRunnable checkMemSize = new SerializableRunnable("checkMemSize"){

            @Override
            public void run() throws CacheException {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                PartitionedRegion partitionedregion = (PartitionedRegion)cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                PartitionedRegionDataStore dataStore = partitionedregion.getDataStore();
                TestCase.assertEquals((long)(2L * oneItemSize), (long)dataStore.currentAllocatedMemory());
                partitionedregion.get((Object)410L);
                TestCase.assertEquals((long)(2L * oneItemSize), (long)dataStore.currentAllocatedMemory());
                TestCase.assertEquals((long)(50L * oneItemSize), (long)dataStore.getBucketSize(0));
            }
        };
    }

    public long runProportionalSize(SerializableRunnable createPRs) throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        final Long oneItemSize = (Long)vm0.invoke(new SerializableCallable("create data"){

            public Object call() {
                int i;
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                PartitionedRegion partitionedregion = (PartitionedRegion)cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                PartitionedRegionDataStore dataStore = partitionedregion.getDataStore();
                partitionedregion.put((Object)0, (Object)new byte[100]);
                long oneItemSize = dataStore.getBucketSize(0);
                for (i = 1; i < 100; ++i) {
                    partitionedregion.put((Object)(i * 5), (Object)new byte[100]);
                }
                TestCase.assertEquals((int)1, (int)dataStore.getBucketsManaged());
                TestCase.assertEquals((long)(100L * oneItemSize), (long)dataStore.getBucketSize(0));
                for (i = 0; i < 25; ++i) {
                    partitionedregion.destroy((Object)(i * 5));
                }
                for (i = 25; i < 50; ++i) {
                    partitionedregion.invalidate((Object)(i * 5));
                }
                TestCase.assertEquals((long)(50L * oneItemSize), (long)dataStore.getBucketSize(0));
                for (i = 50; i < 75; ++i) {
                    partitionedregion.put((Object)(i * 5), (Object)new byte[150]);
                }
                for (i = 75; i < 100; ++i) {
                    partitionedregion.put((Object)(i * 5), (Object)new byte[50]);
                }
                TestCase.assertEquals((long)(50L * oneItemSize), (long)dataStore.getBucketSize(0));
                return oneItemSize;
            }
        });
        vm1.invoke(new SerializableRunnable("check size"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionSizeDUnitTest.this.getCache();
                PartitionedRegion partitionedregion = (PartitionedRegion)cache.getRegion(PartitionedRegionSizeDUnitTest.PR_PREFIX);
                long bytes = partitionedregion.getDataStore().getBucketSize(0);
                TestCase.assertEquals((long)(50L * oneItemSize), (long)bytes);
            }
        });
        return oneItemSize;
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }
}

