/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionStatsDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    static final int cnt = 10;
    final int PUT = 1;
    final int GET = 2;
    final int CONTAINS_KEY = 3;
    final int CONTAINS_VALUE_FOR_KEY = 4;
    final int INVALIDATE = 5;
    final int DESTROY = 6;
    final int CREATE = 7;
    final int GET_ENTRY = 8;
    final int totalNumBuckets = 5;
    static final int REDUNDANT_COPIES = 1;

    public PartitionedRegionStatsDUnitTest(String name) {
        super(name);
    }

    public void testClose() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                cache.createRegion(PartitionedRegionStatsDUnitTest.PR_PREFIX, PartitionedRegionStatsDUnitTest.this.createRegionAttributesForPR(1, 200));
                cache.createRegion("PR1", PartitionedRegionStatsDUnitTest.this.createRegionAttributesForPR(1, 200));
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                cache.createRegion(PartitionedRegionStatsDUnitTest.PR_PREFIX, PartitionedRegionStatsDUnitTest.this.createRegionAttributesForPR(1, 0));
                cache.createRegion("PR1", PartitionedRegionStatsDUnitTest.this.createRegionAttributesForPR(1, 0));
            }
        };
        CacheSerializableRunnable doRegionOps = new CacheSerializableRunnable("doRegionOps"){

            @Override
            public void run2() {
            }

            public void doOps(Integer opTypeInteger) throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                int opType = opTypeInteger;
                Region pr = cache.getRegion("/PR");
                TestCase.assertNotNull((Object)pr);
                this.doRegionOpsOnPR(pr, opType);
                pr = cache.getRegion("/PR1");
                TestCase.assertNotNull((Object)pr);
                this.doRegionOpsOnPR(pr, opType);
            }

            private void doRegionOpsOnPR(Region pr, int opType) throws CacheException {
                switch (opType) {
                    case 1: {
                        for (int k = 0; k < 10; ++k) {
                            pr.put((Object)("" + k), (Object)("" + k));
                        }
                        break;
                    }
                    case 2: {
                        for (int k = 0; k < 10; ++k) {
                            pr.get((Object)("" + k));
                        }
                        break;
                    }
                    case 3: {
                        for (int k = 0; k < 10; ++k) {
                            pr.containsKey((Object)("" + k));
                        }
                        break;
                    }
                    case 4: {
                        for (int k = 0; k < 10; ++k) {
                            pr.containsValueForKey((Object)("" + k));
                        }
                        break;
                    }
                    case 5: {
                        for (int k = 0; k < 10; ++k) {
                            pr.invalidate((Object)("" + k));
                        }
                        break;
                    }
                    case 6: {
                        for (int k = 0; k < 10; ++k) {
                            pr.destroy((Object)("" + k));
                        }
                        break;
                    }
                    case 7: {
                        for (int k = 0; k < 10; ++k) {
                            pr.create((Object)("1" + k), (Object)("1" + k));
                        }
                        break;
                    }
                    case 8: {
                        for (int k = 0; k < 10; ++k) {
                            pr.getEntry((Object)Integer.toString(k));
                        }
                        break;
                    }
                }
            }
        };
        CacheSerializableRunnable disconnectVM = new CacheSerializableRunnable("disconnectVM"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                DistributedSystem ds = cache.getDistributedSystem();
                ds.disconnect();
            }
        };
        CacheSerializableRunnable validateRedundantCopiesStats = new CacheSerializableRunnable("validateStats"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR");
                TestCase.assertNotNull((Object)pr);
                Statistics stats = pr.getPrStats().getStats();
                int minRedundantCopies = stats.get("minRedundantCopies").intValue();
                int maxRedundantCopies = stats.get("maxRedundantCopies").intValue();
                int avgRedundantCopies = stats.get("avgRedundantCopies").intValue();
                TestCase.assertEquals((int)minRedundantCopies, (int)1);
                TestCase.assertEquals((int)maxRedundantCopies, (int)1);
                TestCase.assertEquals((int)avgRedundantCopies, (int)1);
            }
        };
        CacheSerializableRunnable validateRedundantCopiesStatsAfterDisconnect = new CacheSerializableRunnable("validateRedundantCopiesStatsAfterDisconnect"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR");
                TestCase.assertNotNull((Object)pr);
                Statistics stats = pr.getPrStats().getStats();
                int minRedundantCopies = stats.get("minRedundantCopies").intValue();
                int maxRedundantCopies = stats.get("maxRedundantCopies").intValue();
                int avgRedundantCopies = stats.get("avgRedundantCopies").intValue();
                TestCase.assertEquals((int)minRedundantCopies, (int)1);
                TestCase.assertEquals((int)maxRedundantCopies, (int)1);
                TestCase.assertEquals((int)avgRedundantCopies, (int)1);
            }
        };
        CacheSerializableRunnable validatePartitionedRegionOpsStats = new CacheSerializableRunnable("validatePartitionedRegionOpsStats"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR");
                TestCase.assertNotNull((Object)pr);
                pr = (PartitionedRegion)cache.getRegion("/PR");
                TestCase.assertNotNull((Object)pr);
                Statistics stats = pr.getPrStats().getStats();
                int putsCompleted = stats.get("putsCompleted").intValue();
                int getsCompleted = stats.get("getsCompleted").intValue();
                int getEntrysCompleted = stats.get("getEntryCompleted").intValue();
                int createsCompleted = stats.get("createsCompleted").intValue();
                int containsKeyCompleted = stats.get("containsKeyCompleted").intValue();
                int containsValueForKeyCompleted = stats.get("containsValueForKeyCompleted").intValue();
                int invalidatesCompleted = stats.get("invalidatesCompleted").intValue();
                int destroysCompleted = stats.get("destroysCompleted").intValue();
                TestCase.assertEquals((int)10, (int)putsCompleted);
                TestCase.assertEquals((int)10, (int)getsCompleted);
                TestCase.assertEquals((int)10, (int)getEntrysCompleted);
                TestCase.assertEquals((int)0, (int)createsCompleted);
                TestCase.assertEquals((int)10, (int)containsKeyCompleted);
                TestCase.assertEquals((int)10, (int)containsValueForKeyCompleted);
                TestCase.assertEquals((int)10, (int)invalidatesCompleted);
                TestCase.assertEquals((int)10, (int)destroysCompleted);
            }
        };
        vm0.invoke(createPR);
        vm1.invoke(createPR);
        vm2.invoke(createPR);
        vm3.invoke(createAccessor);
        Object[] put = new Object[]{new Integer(1)};
        vm0.invoke(doRegionOps, "doOps", put);
        Object[] get = new Object[]{new Integer(2)};
        vm0.invoke(doRegionOps, "doOps", get);
        Object[] getEntry = new Object[]{new Integer(8)};
        vm0.invoke(doRegionOps, "doOps", getEntry);
        Object[] containsKey = new Object[]{new Integer(3)};
        vm0.invoke(doRegionOps, "doOps", containsKey);
        Object[] containsValueForKey = new Object[]{new Integer(4)};
        vm0.invoke(doRegionOps, "doOps", containsValueForKey);
        Object[] invalidate = new Object[]{new Integer(5)};
        vm0.invoke(doRegionOps, "doOps", invalidate);
        Object[] destroy = new Object[]{new Integer(6)};
        vm0.invoke(doRegionOps, "doOps", destroy);
        vm0.invoke(validatePartitionedRegionOpsStats);
        CacheSerializableRunnable destroyRegion = new CacheSerializableRunnable("destroyRegion"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR1");
                TestCase.assertNotNull((String)("Null region is " + pr.getName()), (Object)pr);
                pr.destroyRegion();
                pr = (PartitionedRegion)cache.getRegion("/PR");
                TestCase.assertNotNull((String)("Null region is " + pr.getName()), (Object)pr);
                pr.destroyRegion();
            }
        };
        vm0.invoke(destroyRegion);
    }

    public void testDataStoreEntryCountWithRebalance() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
                RebalanceOperation op = cache.getResourceManager().createRebalanceFactory().start();
                try {
                    RebalanceResults rebalanceResults = op.getResults();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("ex", e);
                }
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)0L, (Object)"A");
                region.put((Object)1L, (Object)"A");
                region.put((Object)113L, (Object)"A");
                region.put((Object)114L, (Object)"A");
                region.destroy((Object)0L);
                region.destroy((Object)1L);
            }
        });
        vm1.invoke(createPrRegion);
        this.validateEntryCount(vm0, 1L);
        this.validateEntryCount(vm1, 1L);
    }

    public void testDataStoreEntryCount2WithRebalance() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
                RebalanceOperation op = cache.getResourceManager().createRebalanceFactory().start();
                try {
                    RebalanceResults rebalanceResults = op.getResults();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("ex", e);
                }
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)0L, (Object)"A");
                region.put((Object)1L, (Object)"A");
                region.put((Object)2L, (Object)"A");
                region.put((Object)3L, (Object)"A");
                region.put((Object)4L, (Object)"A");
                region.put((Object)5L, (Object)"A");
            }
        });
        vm1.invoke(createPrRegion);
        this.validateEntryCount(vm0, 3L);
        this.validateEntryCount(vm1, 3L);
    }

    public void testDataStoreEntryCount() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(2);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)0L, (Object)"A");
                region.put((Object)1L, (Object)"A");
                region.put((Object)113L, (Object)"A");
                region.put((Object)226L, (Object)"A");
            }
        });
        this.validateEntryCount(vm0, 4L);
        this.validateEntryCount(vm1, 4L);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.destroy((Object)0L);
            }
        });
        this.validateEntryCount(vm0, 3L);
        this.validateEntryCount(vm1, 3L);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.destroy((Object)113L);
                region.put((Object)113L, (Object)"B");
            }
        });
        this.validateEntryCount(vm0, 3L);
        this.validateEntryCount(vm1, 3L);
        vm2.invoke(createPrRegion);
        vm2.invoke(new SerializableRunnable("validate stats"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                final PartitionedRegionStats stats = region.getPrStats();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return stats.getLowRedundancyBucketCount() == 0;
                    }

                    @Override
                    public String description() {
                        return "Redundancy was not satisfied " + stats.getLowRedundancyBucketCount();
                    }
                }, 20000L, 100L, true);
            }
        });
        this.validateEntryCount(vm2, 3L);
        vm0.invoke(new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)PartitionedRegionStatsDUnitTest.this.getCache();
                TombstoneService tombstoneService = cache.getTombstoneService();
                try {
                    tombstoneService.forceBatchExpirationForTests(1);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        });
        this.validateEntryCount(vm0, 3L);
        this.validateEntryCount(vm1, 3L);
        this.validateEntryCount(vm2, 3L);
    }

    public void testTotalNumBuckets() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(2);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        SerializableRunnable putDataInRegion = new SerializableRunnable("Put some data"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)0L, (Object)"A");
                region.put((Object)1L, (Object)"A");
                region.put((Object)113L, (Object)"A");
                region.put((Object)226L, (Object)"A");
            }
        };
        vm0.invoke(putDataInRegion);
        vm1.invoke(putDataInRegion);
        int expectedBucketCount = 113;
        this.validateTotalNumBucketsCount(vm0, expectedBucketCount);
        this.validateTotalNumBucketsCount(vm1, expectedBucketCount);
    }

    private void validateEntryCount(VM vm0, final long expectedCount) {
        SerializableRunnable validateStats = new SerializableRunnable("validate stats"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                PartitionedRegionStats stats = region.getPrStats();
                CachePerfStats cachePerfStats = region.getCachePerfStats();
                TestCase.assertEquals((long)expectedCount, (long)stats.getDataStoreEntryCount());
                TestCase.assertEquals((long)expectedCount, (long)cachePerfStats.getEntries());
            }
        };
        vm0.invoke(validateStats);
    }

    private void validateTotalNumBucketsCount(VM vm0, final long expectedCount) {
        SerializableRunnable validateStats = new SerializableRunnable("validate stats"){

            @Override
            public void run() {
                Cache cache = PartitionedRegionStatsDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                PartitionedRegionStats stats = region.getPrStats();
                CachePerfStats cachePerfStats = region.getCachePerfStats();
                TestCase.assertEquals((long)expectedCount, (long)stats.getTotalNumBuckets());
            }
        };
        vm0.invoke(validateStats);
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }
}

