/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.GsRandom;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionedRegionTestUtilsDUnitTest
extends PartitionedRegionDUnitTestCase {
    final int totalNumBuckets = 5;

    public PartitionedRegionTestUtilsDUnitTest(String name) {
        super(name);
    }

    public void testGetKeys() throws Exception {
        final String r = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("CreatePartitionedRegion"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).create());
                Region p = cache.createRegion(r, attr.create());
                TestCase.assertNotNull((Object)p);
                TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                TestCase.assertNull((Object)p.get((Object)"Key"));
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("GetSomeKeys"){

            @Override
            public void run2() throws CacheException {
                int i;
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(r);
                GsRandom rand = new GsRandom(123L);
                for (int i2 = 0; i2 < 5; ++i2) {
                    DistributedTestCase.getLogWriter().info("Invocation " + i2 + " of getSomeKeys");
                    try {
                        Set s = null;
                        s = pr.getSomeKeys((Random)rand);
                        TestCase.assertNotNull((Object)s);
                        TestCase.assertTrue((boolean)s.isEmpty());
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        DistributedTestCase.fail("GetSomeKeys failed with ClassNotFoundException", cnfe);
                        continue;
                    }
                    catch (IOException ioe) {
                        DistributedTestCase.fail("GetSomeKeys failed with IOException", ioe);
                    }
                }
                int MAXKEYS = 50;
                for (i = 0; i < 50; ++i) {
                    pr.put((Object)("testKey" + i), (Object)new Integer(i));
                }
                for (i = 0; i < 5; ++i) {
                    DistributedTestCase.getLogWriter().info("Invocation " + i + " of getSomeKeys");
                    try {
                        Set s = null;
                        s = pr.getSomeKeys((Random)rand);
                        TestCase.assertNotNull((Object)s);
                        TestCase.assertFalse((boolean)s.isEmpty());
                        DistributedTestCase.getLogWriter().info("Invocation " + i + " got " + s.size() + " keys");
                        for (Object key : s) {
                            DistributedTestCase.getLogWriter().info("Key: " + key);
                            Integer val = (Integer)pr.get(key);
                            TestCase.assertNotNull((Object)val);
                            TestCase.assertTrue((val >= 0 ? 1 : 0) != 0);
                            TestCase.assertTrue((val < 50 ? 1 : 0) != 0);
                        }
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        DistributedTestCase.fail("GetSomeKeys failed with ClassNotFoundException", cnfe);
                        continue;
                    }
                    catch (IOException ioe) {
                        DistributedTestCase.fail("GetSomeKeys failed with IOException", ioe);
                    }
                }
            }
        });
    }

    public void testGetNodes() throws Exception {
        final String r = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM validator = host.getVM(2);
        CacheSerializableRunnable createAndTest = new CacheSerializableRunnable("CreatePRAndTestGetAllNodes"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).create());
                PartitionedRegion p = (PartitionedRegion)cache.createRegion(r, attr.create());
                TestCase.assertNotNull((Object)p);
                TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                Integer i = (Integer)p.get((Object)"Counter");
                i = i == null ? new Integer(0) : new Integer(i + 1);
                Integer keyHash = i;
                p.put((Object)"Counter", (Object)i);
                p.put((Object)new TestGetNodesKey(keyHash), (Object)i);
                Set allN = p.getAllNodes();
                TestCase.assertNotNull((Object)allN);
                TestCase.assertTrue((!allN.isEmpty() ? 1 : 0) != 0);
            }
        };
        validator.invoke(createAndTest);
        validator.invoke(new CacheSerializableRunnable("AssertGetNodesCreation1"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(r);
                TestCase.assertNotNull((Object)p);
                TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                Set allN = p.getAllNodes();
                TestCase.assertNotNull((Object)allN);
                TestCase.assertEquals((int)1, (int)allN.size());
            }
        });
        vm0.invoke(createAndTest);
        validator.invoke(new CacheSerializableRunnable("AssertGetNodesCreation2"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(r);
                TestCase.assertNotNull((Object)p);
                TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                Set allN = p.getAllNodes();
                TestCase.assertNotNull((Object)allN);
                TestCase.assertEquals((int)2, (int)allN.size());
            }
        });
        vm1.invoke(createAndTest);
        validator.invoke(new CacheSerializableRunnable("AssertGetNodesCreation3"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(r);
                TestCase.assertNotNull((Object)p);
                TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                Set allN = p.getAllNodes();
                TestCase.assertNotNull((Object)allN);
                TestCase.assertEquals((int)3, (int)allN.size());
            }
        });
    }

    public void testLocalCacheOps() throws Exception {
        final String r = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("CreatePR"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setLocalMaxMemory(8).create());
                PartitionedRegion p = (PartitionedRegion)cache.createRegion(r, attr.create());
                TestCase.assertNotNull((Object)p);
            }
        });
        vm2.invoke(new CacheSerializableRunnable("CreatePRWithNoLocalCacheAndTestOps"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setLocalMaxMemory(0).create());
                PartitionedRegion p = (PartitionedRegion)cache.createRegion(r, attr.create());
                TestCase.assertNotNull((Object)p);
                String key3 = "lcKey3";
                String val3 = "lcVal3";
                String key4 = "lcKey4";
                String val4 = "lcVal4";
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey3"));
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey4"));
                p.put((Object)"lcKey3", (Object)"lcVal3");
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey3"));
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey4"));
                TestCase.assertEquals((Object)"lcVal3", (Object)p.get((Object)"lcKey3"));
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey3"));
                TestCase.assertFalse((boolean)p.localCacheContainsKey((Object)"lcKey4"));
                Set lset = p.localCacheKeySet();
                TestCase.assertFalse((boolean)lset.contains("lcKey3"));
                TestCase.assertFalse((boolean)lset.contains("lcKey4"));
                TestCase.assertNull((String)"lcVal3", (Object)p.localCacheGet((Object)"lcKey3"));
                TestCase.assertNull((Object)p.localCacheGet((Object)"lcKey4"));
                p.put((Object)"lcKey4", (Object)"lcVal4");
                TestCase.assertNull((Object)p.localCacheGet((Object)"lcKey4"));
                TestCase.assertEquals((Object)"lcVal4", (Object)p.get((Object)"lcKey4"));
                TestCase.assertNull((Object)p.localCacheGet((Object)"lcKey4"));
            }
        });
    }

    public void testGetBucketKeys() throws Exception {
        int i;
        final String r = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        CacheSerializableRunnable create = new CacheSerializableRunnable("CreatePR"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).create());
                PartitionedRegion p = (PartitionedRegion)cache.createRegion(r, attr.create());
                TestCase.assertNotNull((Object)p);
            }
        };
        vm2.invoke(create);
        vm3.invoke(create);
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(5).setLocalMaxMemory(0).create());
        PartitionedRegion p = (PartitionedRegion)cache.createRegion(r, attr.create());
        PartitionedRegionTestUtilsDUnitTest.assertNotNull((Object)p);
        int totalBucks = p.getTotalNumberOfBuckets();
        for (int i2 = totalBucks - 1; i2 >= 0; --i2) {
            Set s = p.getBucketKeys(i2);
            PartitionedRegionTestUtilsDUnitTest.assertTrue((boolean)s.isEmpty());
        }
        class TestPRKey
        implements Serializable {
            int hashCode;
            int differentiator;

            TestPRKey(int hash, int differentiator) {
                this.hashCode = hash;
                this.differentiator = differentiator;
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TestPRKey)) {
                    return false;
                }
                return ((TestPRKey)obj).differentiator == this.differentiator;
            }

            public String toString() {
                return "TestPRKey " + this.hashCode + " diff " + this.differentiator;
            }
        }
        p.put((Object)new TestPRKey(0, 1), (Object)new Integer(0));
        p.put((Object)new TestPRKey(0, 2), (Object)new Integer(1));
        p.put((Object)new TestPRKey(0, 3), (Object)new Integer(2));
        Set s = p.getBucketKeys(0);
        PartitionedRegionTestUtilsDUnitTest.assertEquals((int)3, (int)s.size());
        PartitionedRegionTestUtilsDUnitTest.assertEquals((int)0, (int)((TestPRKey)s.iterator().next()).hashCode());
        PartitionedRegionTestUtilsDUnitTest.assertEquals((int)0, (int)((TestPRKey)s.iterator().next()).hashCode());
        PartitionedRegionTestUtilsDUnitTest.assertEquals((int)0, (int)((TestPRKey)s.iterator().next()).hashCode());
        for (i = totalBucks - 1; i > 0; --i) {
            TestPRKey key = new TestPRKey(i, 0);
            Integer val = new Integer(i);
            p.put((Object)key, (Object)val);
        }
        for (i = 1; i < totalBucks; ++i) {
            s = p.getBucketKeys(i);
            PartitionedRegionTestUtilsDUnitTest.assertEquals((int)s.size(), (int)1);
            TestPRKey key = (TestPRKey)s.iterator().next();
            PartitionedRegionTestUtilsDUnitTest.assertEquals((int)i, (int)key.hashCode());
        }
    }

    public void testGetBucketOwners() throws Exception {
        final String rName0 = this.getUniqueName() + "-r0";
        final String rName1 = this.getUniqueName() + "-r1";
        final String rName2 = this.getUniqueName() + "-r2";
        final String[] regions = new String[]{rName0, rName1, rName2};
        int numBuckets = 3;
        Host host = Host.getHost(0);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        VM datastore3 = host.getVM(0);
        VM accessor = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("CreatePR"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory().setTotalNumBuckets(3);
                for (int redundancy = 0; redundancy < regions.length; ++redundancy) {
                    paf.setRedundantCopies(redundancy);
                    attr.setPartitionAttributes(paf.create());
                    PartitionedRegion p = (PartitionedRegion)cache.createRegion(regions[redundancy], attr.create());
                    TestCase.assertNotNull((Object)p);
                    TestCase.assertEquals((int)0, (int)p.size());
                }
            }
        };
        datastore1.invoke(create);
        datastore2.invoke(create);
        datastore3.invoke(create);
        accessor.invoke(new CacheSerializableRunnable("CreateAccessorPR"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionTestUtilsDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory().setTotalNumBuckets(3).setLocalMaxMemory(0);
                for (int redundancy = 0; redundancy < regions.length; ++redundancy) {
                    paf.setRedundantCopies(redundancy);
                    attr.setPartitionAttributes(paf.create());
                    PartitionedRegion p = (PartitionedRegion)cache.createRegion(regions[redundancy], attr.create());
                    TestCase.assertNotNull((Object)p);
                    TestCase.assertEquals((int)0, (int)p.size());
                }
            }
        });
        CacheSerializableRunnable noBucketOwners = new CacheSerializableRunnable("AssertNoBucketOwners"){

            @Override
            public void run2() throws CacheException {
                String[] regions = new String[]{rName0, rName1, rName2};
                for (int rs = 0; rs < regions.length; ++rs) {
                    PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(regions[rs]);
                    TestCase.assertNotNull((Object)p);
                    TestCase.assertTrue((!p.isDestroyed() ? 1 : 0) != 0);
                    TestCase.assertEquals((int)3, (int)p.getTotalNumberOfBuckets());
                    try {
                        for (int i = 0; i < p.getTotalNumberOfBuckets(); ++i) {
                            TestCase.assertEquals((int)0, (int)p.getRegionAdvisor().getBucketOwners(i).size());
                            TestCase.assertEquals((int)0, (int)p.getBucketOwnersForValidation(i).size());
                        }
                        continue;
                    }
                    catch (ForceReattemptException noGood) {
                        DistributedTestCase.fail("Unexpected force retry", noGood);
                    }
                }
            }
        };
        datastore1.invoke(noBucketOwners);
        datastore2.invoke(noBucketOwners);
        datastore3.invoke(noBucketOwners);
        accessor.invoke(noBucketOwners);
        accessor.invoke(new CacheSerializableRunnable("CreateOneBucket"){

            @Override
            public void run2() throws CacheException {
                for (int rs = 0; rs < regions.length; ++rs) {
                    PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(regions[rs]);
                    TestCase.assertNotNull((Object)p);
                    TestCase.assertEquals((int)3, (int)p.getTotalNumberOfBuckets());
                    p.put((Object)new Integer(0), (Object)"zero");
                    TestCase.assertEquals((int)1, (int)p.getRegionAdvisor().getCreatedBucketsCount());
                }
            }
        });
        CacheSerializableRunnable oneBucketOwner = new CacheSerializableRunnable("AssertSingleBucketPrimary"){

            @Override
            public void run2() throws CacheException {
                for (int rs = 0; rs < regions.length; ++rs) {
                    PartitionedRegion p = (PartitionedRegion)PartitionedRegionTestUtilsDUnitTest.this.getCache().getRegion(regions[rs]);
                    try {
                        for (Integer bid : p.getRegionAdvisor().getBucketSet()) {
                            TestCase.assertEquals((int)(p.getRedundantCopies() + 1), (int)p.getRegionAdvisor().getBucketOwners(bid.intValue()).size());
                            List prims = p.getBucketOwnersForValidation(bid.intValue());
                            TestCase.assertEquals((int)(p.getRedundantCopies() + 1), (int)prims.size());
                            int primCount = 0;
                            for (Object[] memAndBoolean : prims) {
                                TestCase.assertEquals((int)3, (int)memAndBoolean.length);
                                TestCase.assertTrue((boolean)(memAndBoolean[0] instanceof DistributedMember));
                                TestCase.assertEquals(Boolean.class, memAndBoolean[1].getClass());
                                Boolean isPrimary = (Boolean)memAndBoolean[1];
                                if (!isPrimary.booleanValue()) continue;
                                ++primCount;
                            }
                            TestCase.assertEquals((int)1, (int)primCount);
                        }
                        continue;
                    }
                    catch (ForceReattemptException noGood) {
                        DistributedTestCase.fail("Unexpected force retry", noGood);
                    }
                }
            }
        };
        accessor.invoke(oneBucketOwner);
        datastore1.invoke(oneBucketOwner);
        datastore2.invoke(oneBucketOwner);
        datastore3.invoke(oneBucketOwner);
    }

    public static class TestGetNodesKey
    implements DataSerializable {
        int hc;

        public TestGetNodesKey(int hc) {
            this.hc = hc;
        }

        public TestGetNodesKey() {
        }

        public int hashCode() {
            return this.hc;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.hc);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.hc = in.readInt();
        }
    }
}

