/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class RemoveDAckDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static CacheTransactionManager cacheTxnMgr;
    static volatile boolean IsBeforeDestroy;
    static boolean flag;

    public RemoveDAckDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(RemoveDAckDUnitTest.class, "createCacheVM0");
        vm1.invoke(RemoveDAckDUnitTest.class, "createCacheVM1");
        RemoveDAckDUnitTest.getLogWriter().fine("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(RemoveDAckDUnitTest.class, "closeCache");
        vm1.invoke(RemoveDAckDUnitTest.class, "closeCache");
    }

    public static void createCacheVM0() {
        try {
            ds = new RemoveDAckDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createCacheVM1() {
        try {
            ds = new RemoveDAckDUnitTest("temp").getSystem(props);
            AttributesFactory factory = new AttributesFactory();
            cache = CacheFactory.create((DistributedSystem)ds);
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testRemoveMultiVM() {
        int i;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Object[] objArr = new Object[1];
        for (i = 1; i < 5; ++i) {
            objArr[0] = new Integer(i);
            vm0.invoke(RemoveDAckDUnitTest.class, "putMethod", objArr);
        }
        vm1.invoke(new CacheSerializableRunnable("get object"){

            @Override
            public void run2() throws CacheException {
                for (int i = 1; i < 5; ++i) {
                    region.get((Object)new Integer(i));
                }
            }
        });
        i = 2;
        objArr[0] = new Integer(i);
        vm0.invoke(RemoveDAckDUnitTest.class, "removeMethod", objArr);
        int Regsize = vm1.invokeInt(RemoveDAckDUnitTest.class, "sizeMethod");
        RemoveDAckDUnitTest.assertEquals((int)3, (int)Regsize);
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveDAckDUnitTest.fail("Failed while region.put", ex);
        }
        return obj;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            RemoveDAckDUnitTest.fail("Failed while region.size", ex);
        }
        return i;
    }

    public static Object removeMethod(Object obR) {
        Object objR = null;
        try {
            if (obR != null) {
                objR = region.remove(obR);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveDAckDUnitTest.fail("Failed while region.remove", ex);
        }
        return objR;
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        IsBeforeDestroy = false;
        flag = false;
    }
}

