/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.admin.remote.ShutdownAllRequest;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.File;
import java.util.Properties;

public class RunCacheInOldGemfire {
    public static final String diskStoreName1 = "ds1";
    public static final String diskStoreName2 = "ds2";
    public static final String regionName1 = "region1";
    public static final String regionName2 = "region2";
    public static final int maxOplogSize = 1;
    public static final int entrySize = 1024;
    public static final int numOfKeys = 1024;

    protected Cache createCache(String mcastPort, String bindAddress) {
        Properties config = new Properties();
        config.setProperty("mcast-port", mcastPort);
        config.setProperty("locators", "");
        if (bindAddress != null) {
            config.setProperty("bind-address", bindAddress);
        }
        config.setProperty("log-file", "oldgemfire.log");
        InternalDistributedSystem localsystem = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        Cache cache = CacheFactory.create((DistributedSystem)localsystem);
        return cache;
    }

    protected DiskStore createDiskStore(Cache cache, String diskStoreName, String dirName) {
        File dir = new File(dirName);
        dir.mkdirs();
        DiskStore ds = cache.findDiskStore(diskStoreName);
        if (ds == null) {
            ds = cache.createDiskStoreFactory().setDiskDirs(new File[]{dir}).setMaxOplogSize(1L).create(diskStoreName);
        }
        return ds;
    }

    protected Region createPersistentRegion(Cache cache, String regionName, String diskStoreName, boolean isPR) {
        RegionFactory factory;
        if (isPR) {
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setRedundantCopies(1);
            factory = cache.createRegionFactory().setDiskStoreName(diskStoreName).setDataPolicy(DataPolicy.PERSISTENT_PARTITION).setPartitionAttributes(paf.create());
        } else {
            factory = cache.createRegionFactory().setDiskStoreName(diskStoreName).setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        }
        return factory.create(regionName);
    }

    public static void main(String[] args) {
        block16: {
            if (args.length != 5) {
                System.out.println("Usage: java -cp gemfire.jar:$JTESTS com.gemstone.gemfire.internal.cache.RunCacheInOldGemfire mcastPort diskdir isPR doOps(true or false) isShutDownAll");
            }
            String mcastPort = args[0];
            String diskdir = args[1];
            boolean isPR = Boolean.valueOf(args[2]);
            boolean doOps = Boolean.valueOf(args[3]);
            boolean isShutDownAll = Boolean.valueOf(args[4]);
            String bindAddress = args[5];
            RunCacheInOldGemfire test = new RunCacheInOldGemfire();
            Cache cache = test.createCache(mcastPort, bindAddress);
            test.createDiskStore(cache, diskStoreName1, diskdir);
            test.createDiskStore(cache, diskStoreName2, diskdir);
            Region region1 = test.createPersistentRegion(cache, regionName1, diskStoreName1, isPR);
            Region region2 = test.createPersistentRegion(cache, regionName2, diskStoreName2, isPR);
            if (doOps) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (Region region : new Region[]{region1, region2}) {
                    region.put((Object)"key1", (Object)"value1");
                    for (int i = 0; i < 1024; ++i) {
                        byte[] value = new byte[1024];
                        region.put((Object)("" + i), (Object)value);
                    }
                    region.put((Object)"key2", (Object)"value2");
                    region.put((Object)"key3", (Object)"value3");
                    region.put((Object)"key4", (Object)"value4");
                    region.put((Object)"key5", (Object)"value5");
                    region.destroy((Object)"key1");
                    region.destroy((Object)"key2");
                    region.invalidate((Object)"key3");
                    region.put((Object)"key5", (Object)"value6");
                }
            }
            try {
                if (isShutDownAll) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
                    ShutdownAllRequest.send((DM)gfc.getDistributedSystem().getDistributionManager(), (long)0L);
                    break block16;
                }
                long tilt = System.currentTimeMillis() + 60000L;
                while (true) {
                    long timeLeft;
                    String value1 = (String)region1.get((Object)"key5");
                    String value2 = (String)region2.get((Object)"key5");
                    if (!(value1 != null && value2 != null && value1.equals("value6") && value2.equals("value6") || (timeLeft = tilt - System.currentTimeMillis()) <= 0L)) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                boolean ignore = false;
                if (t instanceof Error && t.getMessage().contains("Maximum permit count exceeded")) {
                    System.out.println("Known issue caused by jdk1.6, ignored for the test:" + t.getMessage());
                    ignore = true;
                }
                if (ignore) break block16;
                throw new RuntimeException(t);
            }
        }
    }
}

