/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TestDelta;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

public class SizingFlagDUnitTest
extends CacheTestCase {
    public SizingFlagDUnitTest(String name) {
        super(name);
    }

    public void testRRMemLRU() {
        this.doRRMemLRUTest();
    }

    public void testRRMemLRUDeltaAndFlag() {
        this.doRRMemLRUDeltaTest(true);
    }

    public void testRRMemLRUDelta() {
        this.doRRMemLRUDeltaTest(false);
    }

    public void testRRListener() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createRR(vm0);
        this.createRR(vm1);
        this.addListener(vm0);
        this.addListener(vm1);
        this.doListenerTestRR(vm0, vm1);
    }

    public void testPRMemLRU() {
        this.doPRMemLRUTest();
    }

    public void testPRMemLRUAndFlagDeltaPutOnPrimary() {
        this.doPRDeltaTestLRU(false, false, true, false);
    }

    public void testPRMemLRUDeltaPutOnPrimary() {
        this.doPRDeltaTestLRU(false, false, true, false);
    }

    public void testPRMemLRUAndFlagDeltaPutOnSecondary() {
        this.doPRDeltaTestLRU(false, false, false, true);
    }

    public void testPRMemLRUDeltaPutOnSecondary() {
        this.doPRDeltaTestLRU(false, false, false, true);
    }

    public void testPRNoLRUDelta() {
        this.doPRNoLRUDeltaTest(false);
    }

    public void testPRNoLRUAndFlagDelta() {
        this.doPRNoLRUDeltaTest(true);
    }

    public void testPRListener() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, true);
        this.createPR(vm1, true);
        this.addListener(vm0);
        this.addListener(vm1);
        this.doListenerTestPR(vm0, vm1);
    }

    public void testPRHeapLRU() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPRHeapLRU(vm0);
        this.createPRHeapLRU(vm1);
        this.put(vm0, new TestKey("a"), new TestObject(100, 1000));
        this.assertValueType(vm0, new TestKey("a"), ValueType.CD_SERIALIZED);
        this.assertValueType(vm1, new TestKey("a"), ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        long origSize0 = this.getSizeFromPRStats(vm0);
        SizingFlagDUnitTest.assertTrue((String)("Size was " + origSize0), (1000L > origSize0 ? 1 : 0) != 0);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
        long origSize1 = this.getSizeFromPRStats(vm1);
        SizingFlagDUnitTest.assertTrue((String)("Size was " + origSize1), (1000L > origSize1 ? 1 : 0) != 0);
        this.get(vm0, new TestKey("a"), new TestObject(100, 1000));
        this.assertValueType(vm0, new TestKey("a"), ValueType.CD_DESERIALIZED);
        this.assertValueType(vm1, new TestKey("a"), ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)3, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
    }

    public void testRRHeapLRU() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createRRHeapLRU(vm0);
        this.createRRHeapLRU(vm1);
        this.put(vm0, "a", new TestObject(100, 1000));
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        this.get(vm1, "a", new TestObject(100, 1000));
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
    }

    public void testPRHeapLRUDeltaWithFlagPutOnPrimary() {
        this.doPRDeltaTestLRU(false, true, true, false);
    }

    public void testPRHeapLRUDeltaPutOnPrimary() {
        this.doPRDeltaTestLRU(false, true, true, false);
    }

    public void testPRHeapLRUDeltaWithFlagPutOnSecondary() {
        this.doPRDeltaTestLRU(false, true, false, true);
    }

    public void testPRHeapLRUDeltaPutOnSecondary() {
        this.doPRDeltaTestLRU(false, true, false, true);
    }

    public void testLargeDelta() {
        VM secondaryVm;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.setDeltaRecalculatesSize(vm0, false);
        this.setDeltaRecalculatesSize(vm1, false);
        this.createPR(vm0, false);
        this.createPR(vm1, false);
        int BIG_DELTA_SIZE = 65536;
        StringBuilder sb = new StringBuilder(BIG_DELTA_SIZE);
        for (int i = 0; i < BIG_DELTA_SIZE; ++i) {
            sb.append('7');
        }
        TestDelta delta1 = new TestDelta(true, sb.toString());
        this.assignPRBuckets(vm0);
        boolean vm0isPrimary = this.prHostsBucketForKey(vm0, 0);
        if (!vm0isPrimary) {
            SizingFlagDUnitTest.assertEquals((boolean)true, (boolean)this.prHostsBucketForKey(vm1, 0));
        }
        if (vm0isPrimary) {
            VM primaryVm = vm0;
            secondaryVm = vm1;
        } else {
            VM primaryVm = vm1;
            secondaryVm = vm0;
        }
        this.put(secondaryVm, 0, delta1);
    }

    void doPRDeltaTestLRU(boolean shouldSizeChange, boolean heapLRU, boolean putOnPrimary, boolean wasDelta) {
        VM secondaryVm;
        VM primaryVm;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.setDeltaRecalculatesSize(vm0, shouldSizeChange);
        this.setDeltaRecalculatesSize(vm1, shouldSizeChange);
        if (heapLRU) {
            this.createPRHeapLRU(vm0);
            this.createPRHeapLRU(vm1);
        } else {
            this.createPR(vm0, true);
            this.createPR(vm1, true);
        }
        this.assignPRBuckets(vm0);
        boolean vm0isPrimary = this.prHostsBucketForKey(vm0, 0);
        if (!vm0isPrimary) {
            SizingFlagDUnitTest.assertEquals((boolean)true, (boolean)this.prHostsBucketForKey(vm1, 0));
        }
        if (vm0isPrimary) {
            primaryVm = vm0;
            secondaryVm = vm1;
        } else {
            primaryVm = vm1;
            secondaryVm = vm0;
        }
        TestDelta delta1 = new TestDelta(false, "12345");
        if (putOnPrimary) {
            this.put(primaryVm, 0, delta1);
        } else {
            this.put(secondaryVm, 0, delta1);
        }
        if (putOnPrimary) {
            this.assertValueType(primaryVm, 0, ValueType.CD_DESERIALIZED);
            SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(primaryVm));
        } else {
            this.assertValueType(primaryVm, 0, ValueType.CD_SERIALIZED);
            SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(primaryVm));
        }
        this.assertValueType(secondaryVm, 0, ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(secondaryVm));
        long origEvictionSize0 = this.getSizeFromEvictionStats(primaryVm);
        long origEvictionSize1 = this.getSizeFromEvictionStats(secondaryVm);
        long origPRSize0 = this.getSizeFromPRStats(primaryVm);
        long origPRSize1 = this.getSizeFromPRStats(secondaryVm);
        delta1.info = "1234567890";
        delta1.hasDelta = true;
        if (putOnPrimary) {
            this.put(primaryVm, 0, delta1);
        } else {
            this.put(secondaryVm, 0, delta1);
        }
        this.assertValueType(primaryVm, 0, ValueType.CD_DESERIALIZED);
        this.assertValueType(secondaryVm, 0, ValueType.CD_DESERIALIZED);
        if (shouldSizeChange) {
            SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(primaryVm));
            SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(secondaryVm));
        } else if (wasDelta) {
            SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(primaryVm));
            SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(secondaryVm));
        } else {
            SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(primaryVm));
            SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(secondaryVm));
        }
        long finalEvictionSize0 = this.getSizeFromEvictionStats(primaryVm);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(secondaryVm);
        long finalPRSize0 = this.getSizeFromPRStats(primaryVm);
        long finalPRSize1 = this.getSizeFromPRStats(secondaryVm);
        if (shouldSizeChange) {
            SizingFlagDUnitTest.assertTrue((finalEvictionSize0 - origEvictionSize0 != 0L ? 1 : 0) != 0);
            SizingFlagDUnitTest.assertTrue((finalPRSize0 - origPRSize0 != 0L ? 1 : 0) != 0);
            SizingFlagDUnitTest.assertTrue((finalEvictionSize1 - origEvictionSize1 != 0L ? 1 : 0) != 0);
            SizingFlagDUnitTest.assertTrue((finalPRSize1 - origPRSize1 != 0L ? 1 : 0) != 0);
        } else {
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalEvictionSize1 - origEvictionSize1));
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalPRSize0 - origPRSize0));
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalPRSize1 - origPRSize1));
        }
    }

    private void addListener(VM vm) {
        vm.invoke(new SerializableRunnable("Add listener"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                Region region = cache.getRegion("region");
                try {
                    region.getAttributesMutator().addCacheListener((CacheListener)new TestCacheListener());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("couldn't create index", e);
                }
            }
        });
    }

    private void doListenerTestRR(VM vm0, VM vm1) {
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        this.put(vm0, "a", new TestObject(100, 100000));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
        long origEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long origEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertTrue((origEvictionSize0 >= 100000L ? 1 : 0) != 0);
        SizingFlagDUnitTest.assertTrue((origEvictionSize1 >= 100000L ? 1 : 0) != 0);
        this.put(vm0, "a", new TestObject(200, 200000));
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm1));
        long finalEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertEquals((long)100000L, (long)(finalEvictionSize0 - origEvictionSize0));
        SizingFlagDUnitTest.assertEquals((long)100000L, (long)(finalEvictionSize1 - origEvictionSize1));
    }

    private void doListenerTestPR(VM vm0, VM vm1) {
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        this.put(vm0, "a", new TestObject(100, 100000));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
        long origEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long origEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        long origPRSize0 = this.getSizeFromPRStats(vm1);
        long origPRSize1 = this.getSizeFromPRStats(vm1);
        this.assertValueType(vm0, "a", ValueType.CD_DESERIALIZED);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertTrue((origEvictionSize1 >= 100000L ? 1 : 0) != 0);
        SizingFlagDUnitTest.assertTrue((origEvictionSize0 >= 100000L ? 1 : 0) != 0);
        SizingFlagDUnitTest.assertTrue((origPRSize0 <= 500L ? 1 : 0) != 0);
        SizingFlagDUnitTest.assertTrue((origPRSize1 <= 500L ? 1 : 0) != 0);
        this.put(vm0, "a", new TestObject(200, 200000));
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm1));
        long finalEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        long finalPRSize0 = this.getSizeFromPRStats(vm0);
        long finalPRSize1 = this.getSizeFromPRStats(vm1);
        this.assertValueType(vm0, "a", ValueType.CD_DESERIALIZED);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertEquals((long)100000L, (long)(finalEvictionSize0 - origEvictionSize0));
        SizingFlagDUnitTest.assertEquals((long)100000L, (long)(finalEvictionSize1 - origEvictionSize1));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalPRSize0 - origPRSize0));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalPRSize1 - origPRSize1));
    }

    private void doRRMemLRUTest() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createRR(vm0);
        this.createRR(vm1);
        this.put(vm0, "a", new TestObject(100, 100000));
        long origEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long origEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        this.put(vm0, "a", new TestObject(200, 200000));
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm0));
        long finalEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        SizingFlagDUnitTest.assertEquals((long)100000L, (long)(finalEvictionSize0 - origEvictionSize0));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalEvictionSize1 - origEvictionSize1));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        TestObject v = new TestObject(200, 200000);
        this.get(vm1, "a", v);
        int vSize = CachedDeserializableFactory.calcSerializedMemSize((Object)v);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        long evictionSizeAfterGet = this.getSizeFromEvictionStats(vm1);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
        SizingFlagDUnitTest.assertEquals((long)(200000 + CachedDeserializableFactory.overhead() - vSize), (long)(evictionSizeAfterGet - finalEvictionSize1));
        this.put(vm0, "b", new TestObject(100, 1000000));
        SizingFlagDUnitTest.assertEquals((long)1L, (long)this.getEvictions(vm0));
        SizingFlagDUnitTest.assertEquals((long)0L, (long)this.getEvictions(vm1));
        this.get(vm1, "b", new TestObject(100, 1000000));
        SizingFlagDUnitTest.assertEquals((long)1L, (long)this.getEvictions(vm1));
    }

    private void doPRMemLRUTest() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPR(vm0, true);
        this.createPR(vm1, true);
        this.put(vm0, 0, new TestObject(100, 100000));
        this.assertValueType(vm0, 0, ValueType.CD_SERIALIZED);
        this.assertValueType(vm1, 0, ValueType.CD_SERIALIZED);
        long origEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long origEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        long origPRSize0 = this.getSizeFromPRStats(vm0);
        long origPRSize1 = this.getSizeFromPRStats(vm1);
        this.put(vm0, 0, new TestObject(200, 200000));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm0));
        long finalEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long finalPRSize0 = this.getSizeFromPRStats(vm0);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        long finalPRSize1 = this.getSizeFromPRStats(vm1);
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalEvictionSize0 - origEvictionSize0));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalEvictionSize1 - origEvictionSize1));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalPRSize0 - origPRSize0));
        SizingFlagDUnitTest.assertEquals((long)100L, (long)(finalPRSize1 - origPRSize1));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        TestObject v = new TestObject(200, 200000);
        this.get(vm0, 0, v);
        int vSize = CachedDeserializableFactory.calcSerializedMemSize((Object)v);
        this.assertValueType(vm0, 0, ValueType.CD_DESERIALIZED);
        this.assertValueType(vm1, 0, ValueType.CD_SERIALIZED);
        long evictionSizeAfterGet = this.getSizeFromEvictionStats(vm0);
        long prSizeAfterGet = this.getSizeFromPRStats(vm0);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        SizingFlagDUnitTest.assertEquals((long)(200000 + CachedDeserializableFactory.overhead() - vSize), (long)(evictionSizeAfterGet - finalEvictionSize0));
        SizingFlagDUnitTest.assertEquals((long)0L, (long)(prSizeAfterGet - finalPRSize0));
        this.put(vm0, 113, new TestObject(100, 0x100000));
        this.assertValueType(vm0, 113, ValueType.CD_SERIALIZED);
        this.assertValueType(vm1, 113, ValueType.CD_SERIALIZED);
        long evictionSizeAfterPutVm1 = this.getSizeFromEvictionStats(vm1);
        SizingFlagDUnitTest.assertEquals((long)0L, (long)this.getEvictions(vm0));
        SizingFlagDUnitTest.assertEquals((long)0L, (long)this.getEvictions(vm1));
        this.get(vm1, 113, new TestObject(100, 0x100000));
        long evictionSizeAfterGetVm1 = this.getSizeFromEvictionStats(vm1);
        this.assertValueType(vm0, 113, ValueType.CD_SERIALIZED);
        this.assertValueType(vm1, 113, ValueType.EVICTED);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((long)0L, (long)this.getEvictions(vm0));
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
        SizingFlagDUnitTest.assertEquals((long)2L, (long)this.getEvictions(vm1));
    }

    private void doRRMemLRUDeltaTest(boolean shouldSizeChange) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.setDeltaRecalculatesSize(vm0, shouldSizeChange);
        this.setDeltaRecalculatesSize(vm1, shouldSizeChange);
        this.createRR(vm0);
        this.createRR(vm1);
        TestDelta delta1 = new TestDelta(false, "12345");
        this.put(vm0, "a", delta1);
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_SERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm0));
        SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
        long origEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long origEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        delta1.info = "1234567890";
        delta1.hasDelta = true;
        this.put(vm0, "a", delta1);
        this.assertValueType(vm0, "a", ValueType.RAW_VALUE);
        this.assertValueType(vm1, "a", ValueType.CD_DESERIALIZED);
        SizingFlagDUnitTest.assertEquals((int)2, (int)this.getObjectSizerInvocations(vm0));
        long finalEvictionSize0 = this.getSizeFromEvictionStats(vm0);
        long finalEvictionSize1 = this.getSizeFromEvictionStats(vm1);
        SizingFlagDUnitTest.assertEquals((long)5L, (long)(finalEvictionSize0 - origEvictionSize0));
        if (shouldSizeChange) {
            SizingFlagDUnitTest.assertEquals((int)1, (int)this.getObjectSizerInvocations(vm1));
            SizingFlagDUnitTest.assertTrue((finalEvictionSize1 - origEvictionSize1 != 0L ? 1 : 0) != 0);
        } else {
            SizingFlagDUnitTest.assertEquals((int)0, (int)this.getObjectSizerInvocations(vm1));
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalEvictionSize1 - origEvictionSize1));
        }
    }

    private void doPRNoLRUDeltaTest(boolean shouldSizeChange) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        shouldSizeChange = this.setDeltaRecalculatesSize(vm0, shouldSizeChange);
        shouldSizeChange = this.setDeltaRecalculatesSize(vm1, shouldSizeChange);
        this.createPR(vm0, false);
        this.createPR(vm1, false);
        TestDelta delta1 = new TestDelta(false, "12345");
        this.put(vm0, "a", delta1);
        long origPRSize0 = this.getSizeFromPRStats(vm0);
        long origPRSize1 = this.getSizeFromPRStats(vm1);
        delta1.info = "1234567890";
        delta1.hasDelta = true;
        this.put(vm0, "a", delta1);
        long finalPRSize0 = this.getSizeFromPRStats(vm0);
        long finalPRSize1 = this.getSizeFromPRStats(vm1);
        if (shouldSizeChange) {
            SizingFlagDUnitTest.assertTrue((finalPRSize0 - origPRSize0 != 0L ? 1 : 0) != 0);
            SizingFlagDUnitTest.assertTrue((finalPRSize1 - origPRSize1 != 0L ? 1 : 0) != 0);
        } else {
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalPRSize0 - origPRSize0));
            SizingFlagDUnitTest.assertEquals((long)0L, (long)(finalPRSize1 - origPRSize1));
        }
    }

    private long getSizeFromPRStats(VM vm0) {
        return (Long)vm0.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                if (region instanceof PartitionedRegion) {
                    long total = 0L;
                    PartitionedRegion pr = (PartitionedRegion)region;
                    for (int i = 0; i < pr.getPartitionAttributes().getTotalNumBuckets(); ++i) {
                        total += pr.getDataStore().getBucketSize(i);
                    }
                    return total;
                }
                return 0L;
            }
        });
    }

    private long getSizeFromEvictionStats(VM vm0) {
        return (Long)vm0.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                return SizingFlagDUnitTest.this.getSizeFromEvictionStats(region);
            }
        });
    }

    private long getEvictions(VM vm0) {
        return (Long)vm0.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                return SizingFlagDUnitTest.this.getEvictions(region);
            }
        });
    }

    private int getObjectSizerInvocations(VM vm0) {
        return (Integer)vm0.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                return SizingFlagDUnitTest.this.getObjectSizerInvocations(region);
            }
        });
    }

    private void assignPRBuckets(VM vm) {
        vm.invoke(new SerializableRunnable("assignPRBuckets"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                PartitionRegionHelper.assignBucketsToPartitions((Region)cache.getRegion("region"));
            }
        });
    }

    private boolean prHostsBucketForKey(VM vm, final Object key) {
        Boolean result = (Boolean)vm.invoke(new SerializableCallable("prHostsBucketForKey"){

            public Object call() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                DistributedMember myId = cache.getDistributedSystem().getDistributedMember();
                Region region = cache.getRegion("region");
                DistributedMember hostMember = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)key);
                if (hostMember == null) {
                    throw new IllegalStateException("bucket for key " + key + " is not hosted!");
                }
                boolean res = myId.equals(hostMember);
                return res;
            }
        });
        return result;
    }

    private void put(VM vm0, final Object key, final Object value) {
        vm0.invoke(new SerializableRunnable("Put data"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                region.put(key, value);
            }
        });
    }

    private void get(VM vm0, final Object key, final Object value) {
        vm0.invoke(new SerializableRunnable("Put data"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
    }

    protected int getObjectSizerInvocations(LocalRegion region) {
        TestObjectSizer sizer = (TestObjectSizer)region.getEvictionAttributes().getObjectSizer();
        int result = sizer.invocations.get();
        region.getCache().getLogger().info("objectSizerInvocations=" + result);
        return result;
    }

    private long getSizeFromEvictionStats(LocalRegion region) {
        long result = region.getEvictionController().getLRUHelper().getStats().getCounter();
        return result;
    }

    private long getEvictions(LocalRegion region) {
        return region.getEvictionController().getLRUHelper().getStats().getEvictions();
    }

    private boolean setDeltaRecalculatesSize(VM vm, final boolean shouldSizeChange) {
        return (Boolean)vm.invoke(new SerializableCallable("setDeltaRecalculatesSize"){

            public Object call() {
                GemFireCacheImpl.DELTAS_RECALCULATE_SIZE = shouldSizeChange;
                if (CachedDeserializableFactory.preferObject()) {
                    return Boolean.TRUE;
                }
                return shouldSizeChange;
            }
        });
    }

    private void createRR(VM vm) {
        vm.invoke(new SerializableRunnable("Create rr"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setDiskSynchronous(true);
                attr.setDataPolicy(DataPolicy.REPLICATE);
                attr.setScope(Scope.DISTRIBUTED_ACK);
                attr.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)1, (ObjectSizer)new TestObjectSizer(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                attr.setDiskDirs(SizingFlagDUnitTest.this.getMyDiskDirs());
                Region region = cache.createRegion("region", attr.create());
            }
        });
    }

    private void assertValueType(VM vm, final Object key, final ValueType expectedType) {
        vm.invoke(new SerializableRunnable("Create rr"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion("region");
                Object value = region.getValueInVM(key);
                ValueType type = expectedType;
                if (CachedDeserializableFactory.preferObject()) {
                    type = ValueType.RAW_VALUE;
                }
                switch (type) {
                    case RAW_VALUE: {
                        TestCase.assertTrue((String)("Value was " + value + " type " + value.getClass()), (!(value instanceof CachedDeserializable) ? 1 : 0) != 0);
                        break;
                    }
                    case CD_SERIALIZED: {
                        TestCase.assertTrue((String)("Value was " + value + " type " + value.getClass()), (boolean)(value instanceof CachedDeserializable));
                        TestCase.assertTrue((String)"Value not serialized", (boolean)(((CachedDeserializable)value).getValue() instanceof byte[]));
                        break;
                    }
                    case CD_DESERIALIZED: {
                        TestCase.assertTrue((String)("Value was " + value + " type " + value.getClass()), (boolean)(value instanceof CachedDeserializable));
                        TestCase.assertTrue((String)"Value was serialized", (!(((CachedDeserializable)value).getValue() instanceof byte[]) ? 1 : 0) != 0);
                        break;
                    }
                    case EVICTED: {
                        TestCase.assertEquals(null, (Object)value);
                    }
                }
            }
        });
    }

    private File[] getMyDiskDirs() {
        long random = new Random().nextLong();
        File file = new File(Long.toString(random));
        file.mkdirs();
        return new File[]{file};
    }

    private void createPR(VM vm, final boolean enableLRU) {
        vm.invoke(new SerializableRunnable("Create pr"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setDiskSynchronous(true);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                if (enableLRU) {
                    paf.setLocalMaxMemory(1);
                    attr.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((ObjectSizer)new TestObjectSizer(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    attr.setDiskDirs(SizingFlagDUnitTest.this.getMyDiskDirs());
                }
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PARTITION);
                attr.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                Region region = cache.createRegion("region", attr.create());
            }
        });
    }

    private void createRRHeapLRU(VM vm) {
        vm.invoke(new SerializableRunnable("Create rr"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                manager.setCriticalHeapPercentage(95.0f);
                manager.setEvictionHeapPercentage(90.0f);
                AttributesFactory attr = new AttributesFactory();
                attr.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes((ObjectSizer)new TestObjectSizer(), (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                attr.setDiskDirs(SizingFlagDUnitTest.this.getMyDiskDirs());
                attr.setDataPolicy(DataPolicy.REPLICATE);
                attr.setScope(Scope.DISTRIBUTED_ACK);
                attr.setDiskDirs(SizingFlagDUnitTest.this.getMyDiskDirs());
                Region region = cache.createRegion("region", attr.create());
            }
        });
    }

    private void createPRHeapLRU(VM vm) {
        vm.invoke(new SerializableRunnable("Create pr"){

            @Override
            public void run() {
                Cache cache = SizingFlagDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                manager.setCriticalHeapPercentage(95.0f);
                manager.setEvictionHeapPercentage(90.0f);
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                attr.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes((ObjectSizer)new TestObjectSizer(), (EvictionAction)EvictionAction.LOCAL_DESTROY));
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PARTITION);
                attr.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                Region region = cache.createRegion("region", attr.create());
            }
        });
    }

    static enum ValueType {
        RAW_VALUE,
        CD_SERIALIZED,
        CD_DESERIALIZED,
        EVICTED;

    }

    public static class TestCacheListener
    extends CacheListenerAdapter {
        public void afterCreate(EntryEvent event) {
            event.getRegion().getCache().getLoggerI18n().fine("invoked afterCreate with " + event);
            event.getRegion().getCache().getLoggerI18n().info(LocalizedStrings.DEBUG, (Object)("value is " + event.getNewValue()));
        }

        public void afterUpdate(EntryEvent event) {
            event.getRegion().getCache().getLoggerI18n().fine("invoked afterUpdate with ");
            event.getRegion().getCache().getLoggerI18n().info(LocalizedStrings.DEBUG, (Object)("value is " + event.getNewValue()));
        }
    }

    private static class TestObject
    implements DataSerializable {
        public int sizeForSizer;
        public int sizeForSerialization;

        public TestObject() {
        }

        public TestObject(int sizeForSerialization, int sizeForSizer) {
            this.sizeForSizer = sizeForSizer;
            this.sizeForSerialization = sizeForSerialization;
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.sizeForSizer = in.readInt();
            this.sizeForSerialization = in.readInt();
            in.skipBytes(this.sizeForSerialization);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.sizeForSizer);
            out.writeInt(this.sizeForSerialization);
            out.write(new byte[this.sizeForSerialization]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.sizeForSerialization;
            result = 31 * result + this.sizeForSizer;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TestObject)) {
                return false;
            }
            TestObject other = (TestObject)obj;
            if (this.sizeForSerialization != other.sizeForSerialization) {
                return false;
            }
            return this.sizeForSizer == other.sizeForSizer;
        }

        public String toString() {
            return "TestObject [sizeForSerialization=" + this.sizeForSerialization + ", sizeForSizer=" + this.sizeForSizer + "]";
        }
    }

    private static class TestKey
    implements DataSerializable {
        String value;

        public TestKey() {
        }

        public TestKey(String value) {
            this.value = value;
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.value = DataSerializer.readString((DataInput)in);
        }

        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeString((String)this.value, (DataOutput)out);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TestKey)) {
                return false;
            }
            TestKey other = (TestKey)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    private static class TestObjectSizer
    implements ObjectSizer {
        private AtomicInteger invocations = new AtomicInteger();

        private TestObjectSizer() {
        }

        public int sizeof(Object o) {
            if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                InternalDistributedSystem.getLoggerI18n().fine("TestObjectSizer invoked");
            }
            if (o instanceof TestObject) {
                this.invocations.incrementAndGet();
                return ((TestObject)o).sizeForSizer;
            }
            if (o instanceof TestDelta) {
                this.invocations.incrementAndGet();
                return ((TestDelta)o).info.length();
            }
            if (o instanceof Integer) {
                return 0;
            }
            if (o instanceof TestKey) {
                this.invocations.incrementAndGet();
                return ((TestKey)o).value.length();
            }
            throw new RuntimeException("Unpected type to be sized " + o.getClass() + ", object=" + o);
        }
    }
}

