/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DistributedCacheTestCase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import util.TestException;

public class SystemFailureDUnitTest
extends DistributedCacheTestCase {
    static final String REGION_NAME = "SystemFailureDUnitTest";
    static final Scope SCOPE = Scope.DISTRIBUTED_ACK;
    static volatile Object newValue;
    static volatile Object oldValue;
    protected static final AtomicInteger listenerCount;
    private static final Runnable listener1;
    private static final long MAX_WAIT = 60000L;
    protected static volatile ArrayList peskyMemory;
    private static final GenericListener listener_stackOverflow;
    private static final GenericListener listener_outOfMemory;
    private static final GenericListener listener_persistentOutOfMemory;
    private static final GenericListener listener_memoryMonitor;
    private static final GenericListener listener_internalError;
    private static final GenericListener listener_unknownError;
    private static final GenericListener listener_error;

    public SystemFailureDUnitTest(String name) {
        super(name);
    }

    public void testNullFailure() {
        SystemFailureDUnitTest.getLogWriter().info("TODO: this test needs to use VM#bounce.");
        try {
            SystemFailure.initiateFailure(null);
            SystemFailureDUnitTest.fail((String)"Null failure set allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testStackOverflow() throws CacheException, InterruptedException {
        String exceptions = StackOverflowError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testStackOverflow";
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testOutOfMemory() throws CacheException, InterruptedException {
        String exceptions = OutOfMemoryError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testOutOfMemory";
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testPersistentOutOfMemory() throws CacheException, InterruptedException {
        String exceptions = OutOfMemoryError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testPersistentOutOfMemory";
            this.doExec("setListener2");
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testMemoryMonitor() throws CacheException, InterruptedException {
        String exceptions = OutOfMemoryError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testMemoryMonitor";
            this.doExec("setListener2");
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testInternalError() throws CacheException, InterruptedException {
        String exceptions = InternalError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testInternalError";
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testUnknownError() throws CacheException, InterruptedException {
        String exceptions = UnknownError.class.getName() + "||" + AssertionError.class.getName();
        try {
            String name = "testUnknownError";
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testError() throws CacheException, InterruptedException {
        String exceptions = Error.class.getName();
        try {
            String name = "testError";
            this.doCreateEntry(name);
            Assert.assertTrue((boolean)this.doVerifyConnected());
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    protected static Integer getListenerCount() {
        return new Integer(listenerCount.get());
    }

    protected static void setListener1() {
        listenerCount.set(0);
        SystemFailure.setFailureAction((Runnable)listener1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setListener2() {
        peskyMemory = null;
        Class<SystemFailureDUnitTest> clazz = SystemFailureDUnitTest.class;
        synchronized (SystemFailureDUnitTest.class) {
            SystemFailureDUnitTest.class.notify();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testListener() throws CacheException, InterruptedException {
        String exceptions = Error.class.getName();
        try {
            String name = "testListener";
            this.doExec("setListener1");
            this.doMessage("<ExpectedException action=add>" + exceptions + "</ExpectedException>");
            this.doCreateEntry(name);
            Integer count = (Integer)this.doExec("getListenerCount");
            Assert.assertEquals((int)1, (int)count);
            this.doVerifyDisconnected();
        }
        finally {
            this.doMessage("<ExpectedException action=remove>" + exceptions + "</ExpectedException>");
            this.resetVM();
        }
    }

    private void resetVM() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.bounce();
    }

    private boolean doVerifyConnected() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        Object o = vm.invoke(this.getClass(), "verifyConnected");
        return (Boolean)o;
    }

    protected static Boolean verifyConnected() {
        if (SystemFailure.getFailure() != null) {
            SystemFailureDUnitTest.fail("System failure present!", SystemFailure.getFailure());
            return Boolean.FALSE;
        }
        GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
        if (gfc.isClosed()) {
            SystemFailureDUnitTest.fail((String)"Cache is closing/closed!");
            return Boolean.FALSE;
        }
        if (system.getCancelCriterion().cancelInProgress() != null) {
            SystemFailureDUnitTest.fail((String)"distributed system cancel in progress");
            return Boolean.FALSE;
        }
        if (!system.isConnected()) {
            SystemFailureDUnitTest.fail((String)"distributed system not connected");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean doVerifyDisconnected() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        return (Boolean)vm.invoke(this.getClass(), "verifyDisconnected");
    }

    protected static Boolean verifyDisconnected() {
        if (SystemFailure.getFailure() == null) {
            SystemFailureDUnitTest.fail((String)"No system failure present!");
            return Boolean.FALSE;
        }
        GemFireCacheImpl gfc = (GemFireCacheImpl)cache;
        long done = System.currentTimeMillis() + 60000L;
        while (true) {
            long now;
            if ((now = System.currentTimeMillis()) >= done) {
                SystemFailureDUnitTest.fail((String)("Time out waiting for cache to close: " + cache.toString()));
                return Boolean.FALSE;
            }
            if (gfc.isClosed()) break;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                SystemFailureDUnitTest.fail((String)"interrupted");
                return Boolean.FALSE;
            }
        }
        Assert.assertTrue((GemFireCacheImpl.getInstance() == null ? 1 : 0) != 0);
        InternalDistributedSystem ids = gfc.getDistributedSystem();
        if (ids == null) {
            return Boolean.TRUE;
        }
        try {
            DistributionManager dm = (DistributionManager)ids.getDistributionManager();
            if (dm == null) {
                return Boolean.TRUE;
            }
            return new Boolean(dm.getCancelCriterion().cancelInProgress() != null);
        }
        catch (CancelException e) {
            return Boolean.TRUE;
        }
    }

    private Object doExec(String method) {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        return vm.invoke(this.getClass(), method);
    }

    private void doMessage(String text) {
        Object[] args = new Object[]{text};
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.invoke(this.getClass(), "message", args);
    }

    protected static void message(String s) {
        System.out.println(s);
        System.err.println(s);
        SystemFailureDUnitTest.getLogWriter().info(s);
        cache.getLogger().info(s);
    }

    private static void createEntry(String name, int ttl, ExpirationAction action, GenericListener l) throws CacheException {
        Region region = SystemFailureDUnitTest.getRegion();
        AttributesFactory factory = new AttributesFactory(region.getAttributes());
        factory.setStatisticsEnabled(true);
        factory.setEntryTimeToLive(new ExpirationAttributes(ttl, action));
        factory.setScope(SCOPE);
        factory.setCacheListener((CacheListener)l);
        Region sub = region.createSubregion(name, factory.create());
        sub.create((Object)name, (Object)new Integer(0), (Object)sub.getCache().getDistributedSystem().getDistributedMember());
    }

    private static GenericListener getListener(String which) {
        GenericListener listener;
        if (which.equals("testStackOverflow")) {
            listener = listener_stackOverflow;
        } else if (which.equals("testOutOfMemory")) {
            listener = listener_outOfMemory;
        } else if (which.equals("testPersistentOutOfMemory")) {
            listener = listener_persistentOutOfMemory;
        } else if (which.equals("testMemoryMonitor")) {
            listener = listener_memoryMonitor;
        } else if (which.equals("testListener")) {
            listener = listener_internalError;
        } else if (which.equals("testInternalError")) {
            listener = listener_internalError;
        } else if (which.equals("testUnknownError")) {
            listener = listener_unknownError;
        } else if (which.equals("testError")) {
            listener = listener_error;
        } else {
            throw new TestException("don't know which listener: " + which);
        }
        return listener;
    }

    protected void doCreateEntry(String name) {
        LogWriter log = SystemFailureDUnitTest.getLogWriter();
        log.info("<ExpectedException action=add>dunit.RMIException</ExpectedException>");
        Object[] args = new Object[]{name};
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invoke(this.getClass(), "createEntry", args);
        }
        catch (RMIException rMIException) {
            // empty catch block
        }
        log.info("<ExpectedException action=add>dunit.RMIException</ExpectedException>");
    }

    protected static void createEntry(String name) throws CacheException {
        GenericListener l = SystemFailureDUnitTest.getListener(name);
        SystemFailureDUnitTest.createEntry(name, 0, ExpirationAction.INVALIDATE, l);
    }

    private static Region getRegion() throws CacheException {
        Region root = SystemFailureDUnitTest.getRootRegion();
        Region region = root.getSubregion(REGION_NAME);
        if (region == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(SCOPE);
            region = root.createSubregion(REGION_NAME, factory.create());
        }
        return region;
    }

    static {
        listenerCount = new AtomicInteger(0);
        listener1 = new Runnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("Inside of preListener1");
                listenerCount.addAndGet(1);
            }
        };
        listener_stackOverflow = new GenericListener(){

            private void forceOverflow() {
                this.forceOverflow();
            }

            @Override
            public void afterCreate(EntryEvent event) {
                this.forceOverflow();
            }
        };
        listener_outOfMemory = new GenericListener(){

            private void forceOutOfMemory() {
                ArrayList<long[]> junk = new ArrayList<long[]>();
                while (true) {
                    junk.add(new long[100000]);
                }
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceOutOfMemory();
            }
        };
        listener_persistentOutOfMemory = new GenericListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            private void forceOutOfMemory() {
                peskyMemory = new ArrayList();
                TestException whoops = new TestException("Timeout!");
                try {
                    while (true) {
                        peskyMemory.add(new long[100000]);
                    }
                }
                catch (OutOfMemoryError e) {
                    SystemFailure.setFailure((Error)e);
                    long fin = System.currentTimeMillis() + 60000L;
                    while (true) {
                        if (peskyMemory == null) {
                            return;
                        }
                        if (System.currentTimeMillis() > fin) {
                            throw whoops;
                        }
                        Class<SystemFailureDUnitTest> clazz = SystemFailureDUnitTest.class;
                        // MONITORENTER : com.gemstone.gemfire.internal.cache.SystemFailureDUnitTest.class
                        try {
                            SystemFailureDUnitTest.class.wait(2000L);
                        }
                        catch (InterruptedException e2) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceOutOfMemory();
            }
        };
        listener_memoryMonitor = new GenericListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            private void forceLowMemory() {
                long maxMem = Runtime.getRuntime().maxMemory();
                long avail = Runtime.getRuntime().freeMemory();
                long thresh = (long)((double)avail * 0.4);
                long ferSure = (long)((double)avail * 0.3);
                SystemFailure.setFailureMemoryThreshold((long)thresh);
                SystemFailure.setFailureAction((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        peskyMemory = null;
                        System.gc();
                        Class<SystemFailure> clazz = SystemFailure.class;
                        synchronized (SystemFailure.class) {
                            SystemFailure.class.notify();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
                peskyMemory = new ArrayList();
                TestException whoops = new TestException("Timeout!");
                do {
                    peskyMemory.add(new long[100000]);
                } while (Runtime.getRuntime().totalMemory() < maxMem || Runtime.getRuntime().freeMemory() >= ferSure);
                long fin = System.currentTimeMillis() + (long)((double)SystemFailure.MEMORY_MAX_WAIT * 1.5 * 1000.0);
                do {
                    long now;
                    if ((now = System.currentTimeMillis()) > fin) {
                        throw whoops;
                    }
                    Class<SystemFailure> clazz = SystemFailure.class;
                    // MONITORENTER : com.gemstone.gemfire.SystemFailure.class
                    try {
                        if (peskyMemory == null) {
                            // MONITOREXIT : clazz
                            return;
                        }
                        SystemFailure.class.wait(fin - now);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                } while (peskyMemory != null);
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceLowMemory();
            }
        };
        listener_internalError = new GenericListener(){

            private void forceInternalError() {
                throw new InternalError("gotcha");
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceInternalError();
            }
        };
        listener_unknownError = new GenericListener(){

            private void forceInternalError() {
                throw new UnknownError("gotcha");
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceInternalError();
            }
        };
        listener_error = new GenericListener(){

            private void forceError() {
                new SickoClass();
            }

            @Override
            public void afterCreate(EntryEvent event) {
                DistributedTestCase.getLogWriter().info("Invoking afterCreate on listener; name=" + event.getKey());
                this.forceError();
            }
        };
    }

    public static class GenericListener
    extends CacheListenerAdapter
    implements Serializable {
        public void close() {
        }

        public void afterCreate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterCreate");
        }

        public void afterInvalidate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterInvalidated");
        }

        public void afterDestroy(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterDestroy");
        }

        public void afterUpdate(EntryEvent oevt) {
            TestCase.fail((String)"Unexpected listener callback: afterUpdate");
        }

        public void afterRegionInvalidate(RegionEvent revt) {
            TestCase.fail((String)"Unexpected listener callback: afterRegionInvalidate");
        }

        public void afterRegionDestroy(RegionEvent revt) {
        }
    }

    static class SickoClass {
        SickoClass() {
        }

        private static boolean threeCardMonte() {
            return true;
        }

        static {
            if (System.currentTimeMillis() != 0L || SickoClass.threeCardMonte()) {
                throw new Error("annoying, aren't I?");
            }
        }
    }
}

