/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.internal.cache.DeltaSizingDUnitTest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class TestDelta
implements Delta,
DataSerializable,
Cloneable {
    public boolean hasDelta;
    public String info;
    public int serializations;
    public int deserializations;
    public int deltas;
    public int clones;

    public TestDelta() {
    }

    public TestDelta(boolean hasDelta, String info) {
        this.hasDelta = hasDelta;
        this.info = info;
    }

    public synchronized void checkFields(int serializations, int deserializations, int deltas, int clones) {
        DeltaSizingDUnitTest.assertEquals((int)serializations, (int)this.serializations);
        DeltaSizingDUnitTest.assertEquals((int)deserializations, (int)this.deserializations);
        DeltaSizingDUnitTest.assertEquals((int)deltas, (int)this.deltas);
        DeltaSizingDUnitTest.assertEquals((int)clones, (int)this.clones);
    }

    public synchronized void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        this.hasDelta = true;
        this.info = DataSerializer.readString((DataInput)in);
        ++this.deltas;
    }

    public boolean hasDelta() {
        return this.hasDelta;
    }

    public synchronized void toDelta(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.info, (DataOutput)out);
    }

    public synchronized void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.info = DataSerializer.readString((DataInput)in);
        this.serializations = in.readInt();
        this.deserializations = in.readInt();
        this.deltas = in.readInt();
        this.clones = in.readInt();
        ++this.deserializations;
    }

    public synchronized void toData(DataOutput out) throws IOException {
        ++this.serializations;
        DataSerializer.writeString((String)this.info, (DataOutput)out);
        out.writeInt(this.serializations);
        out.writeInt(this.deserializations);
        out.writeInt(this.deltas);
        out.writeInt(this.clones);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        ++this.clones;
        return super.clone();
    }
}

