/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtil {
    public static final void unzip(InputStream input, String targetDir) throws IOException {
        ZipEntry entry;
        File dir = new File(targetDir);
        if (!dir.exists() && !dir.mkdir()) {
            throw new IOException("Unable to create dir" + dir);
        }
        ZipInputStream zipInput = new ZipInputStream(input);
        while ((entry = zipInput.getNextEntry()) != null) {
            File newFile = new File(dir, entry.getName());
            if (entry.isDirectory()) {
                if (newFile.mkdirs()) continue;
                throw new IOException("Unable to create directory" + newFile);
            }
            UnzipUtil.copyInputStream(zipInput, new BufferedOutputStream(new FileOutputStream(newFile)));
            zipInput.closeEntry();
        }
        zipInput.close();
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }

    private UnzipUtil() {
    }
}

