/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.control;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import com.gemstone.gemfire.internal.cache.partitioned.BucketCountLoadProbe;
import com.gemstone.gemfire.internal.cache.partitioned.LoadProbe;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class RebalanceOperationDUnitTest
extends CacheTestCase {
    private static final long MAX_WAIT = 60L;

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver(null);
                System.clearProperty("gemfire.resource.manager.threads");
            }
        });
        InternalResourceManager.setResourceObserver(null);
        System.clearProperty("gemfire.resource.manager.threads");
    }

    public RebalanceOperationDUnitTest(String name) {
        super(name);
    }

    public void testRecoverRedundancySimulation() {
        this.recoverRedundancy(true);
    }

    public void testRecoverRedundancy() {
        this.recoverRedundancy(false);
    }

    public void recoverRedundancy(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
                region.put((Object)2, (Object)"A");
                region.put((Object)3, (Object)"A");
                region.put((Object)4, (Object)"A");
                region.put((Object)5, (Object)"A");
                region.put((Object)6, (Object)"A");
            }
        });
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkLowRedundancy);
        vm1.invoke(createPrRegion);
        vm0.invoke(checkLowRedundancy);
        vm0.invoke(new SerializableRunnable("simulateRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)6, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)3, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)6, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)3, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)details.getBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)2, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                }
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
        } else {
            vm0.invoke(checkLowRedundancy);
        }
    }

    public void z_testRedundancyLoop() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(2);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm3.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                for (int i = 0; i < 500; ++i) {
                    region.put((Object)i, (Object)"A");
                }
            }
        });
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)113, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)113, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkLowRedundancy);
        SerializableRunnable closePrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        };
        for (int i = 0; i < 50; ++i) {
            long start = System.nanoTime();
            vm1.invoke(createPrRegion);
            vm2.invoke(createPrRegion);
            vm1.invoke(new SerializableRunnable("simulateRebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, manager);
                }
            });
            vm1.invoke(closePrRegion);
            vm2.invoke(closePrRegion);
            long end = System.nanoTime();
            System.err.println("Elapsed = " + TimeUnit.NANOSECONDS.toMillis(end - start));
        }
    }

    public void testEnforceIP() {
        this.enforceIp(false);
    }

    public void testEnforceIPSimulation() {
        this.enforceIp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceIp(final boolean simulate) {
        RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                Properties props = new Properties();
                props.setProperty("enforce-unique-host", "true");
                RebalanceOperationDUnitTest.this.getSystem(props);
            }
        });
        try {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            VM vm1 = host.getVM(1);
            SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    paf.setRecoveryDelay(-1L);
                    paf.setStartupRecoveryDelay(-1L);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    cache.createRegion("region1", attr.create());
                }
            };
            vm0.invoke(createPrRegion);
            vm0.invoke(new SerializableRunnable("createSomeBuckets"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    region.put((Object)1, (Object)"A");
                    region.put((Object)2, (Object)"A");
                    region.put((Object)3, (Object)"A");
                    region.put((Object)4, (Object)"A");
                    region.put((Object)5, (Object)"A");
                    region.put((Object)6, (Object)"A");
                }
            });
            SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
                }
            };
            vm0.invoke(checkLowRedundancy);
            vm1.invoke(createPrRegion);
            vm0.invoke(checkLowRedundancy);
            vm0.invoke(new SerializableRunnable("simulateRebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                    TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)3, (int)results.getTotalBucketTransfersCompleted());
                    Set detailSet = results.getPartitionRebalanceDetails();
                    TestCase.assertEquals((int)1, (int)detailSet.size());
                    PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                    if (!simulate) {
                        RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                    }
                }
            });
            vm0.invoke(checkLowRedundancy);
            vm1.invoke(checkLowRedundancy);
        }
        catch (Throwable throwable) {
            RebalanceOperationDUnitTest.disconnectFromDS();
            RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                }
            });
            throw throwable;
        }
        RebalanceOperationDUnitTest.disconnectFromDS();
        RebalanceOperationDUnitTest.invokeInEveryVM(new /* invalid duplicate definition of identical inner class */);
    }

    public void testEnforceZone() {
        this.enforceZone(false);
    }

    public void testEnforceZoneSimulation() {
        this.enforceZone(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceZone(final boolean simulate) {
        try {
            Host host = Host.getHost(0);
            VM vm0 = host.getVM(0);
            VM vm1 = host.getVM(1);
            VM vm2 = host.getVM(2);
            this.setRedundancyZone(vm0, "A");
            this.setRedundancyZone(vm1, "A");
            final DistributedMember zoneBMember = this.setRedundancyZone(vm2, "B");
            SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    paf.setRecoveryDelay(-1L);
                    paf.setStartupRecoveryDelay(-1L);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    cache.createRegion("region1", attr.create());
                }
            };
            vm0.invoke(createPrRegion);
            vm0.invoke(new SerializableRunnable("createSomeBuckets"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    region.put((Object)1, (Object)"A");
                    region.put((Object)2, (Object)"A");
                    region.put((Object)3, (Object)"A");
                    region.put((Object)4, (Object)"A");
                    region.put((Object)5, (Object)"A");
                    region.put((Object)6, (Object)"A");
                }
            });
            SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
                }
            };
            vm0.invoke(checkLowRedundancy);
            vm1.invoke(createPrRegion);
            vm2.invoke(createPrRegion);
            vm0.invoke(checkLowRedundancy);
            vm0.invoke(new SerializableRunnable("simulateRebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                    TestCase.assertEquals((int)6, (int)results.getTotalBucketCreatesCompleted());
                    TestCase.assertEquals((int)2, (int)results.getTotalPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)3, (int)results.getTotalBucketTransfersCompleted());
                    Set detailSet = results.getPartitionRebalanceDetails();
                    TestCase.assertEquals((int)1, (int)detailSet.size());
                    PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                    TestCase.assertEquals((int)6, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)2, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    for (PartitionMemberInfo info : afterDetails) {
                        if (info.getDistributedMember().equals(zoneBMember)) {
                            TestCase.assertEquals((int)6, (int)info.getBucketCount());
                        } else {
                            TestCase.assertEquals((int)3, (int)info.getBucketCount());
                        }
                        TestCase.assertEquals((int)2, (int)info.getPrimaryCount());
                    }
                    if (!simulate) {
                        RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                    }
                }
            });
            if (!simulate) {
                this.checkBucketCount(vm0, "region1", 3);
                this.checkBucketCount(vm1, "region1", 3);
                this.checkBucketCount(vm2, "region1", 6);
            }
        }
        catch (Throwable throwable) {
            RebalanceOperationDUnitTest.disconnectFromDS();
            RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                }
            });
            throw throwable;
        }
        RebalanceOperationDUnitTest.disconnectFromDS();
        RebalanceOperationDUnitTest.invokeInEveryVM(new /* invalid duplicate definition of identical inner class */);
    }

    private void createPR(String regionName) {
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        PartitionAttributes prAttr = paf.create();
        attr.setPartitionAttributes(prAttr);
        cache.createRegion(regionName, attr.create());
    }

    private void doPuts(String regionName) {
        Cache cache = this.getCache();
        Region region = cache.getRegion(regionName);
        region.put((Object)1, (Object)"A");
        region.put((Object)2, (Object)"A");
        region.put((Object)3, (Object)"A");
        region.put((Object)4, (Object)"A");
        region.put((Object)5, (Object)"A");
        region.put((Object)6, (Object)"A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnforceZoneWithMultipleRegions() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        try {
            this.setRedundancyZone(vm0, "A");
            this.setRedundancyZone(vm1, "A");
            final DistributedMember zoneBMember = this.setRedundancyZone(vm2, "B");
            SerializableRunnable setRebalanceObserver = new SerializableRunnable("RebalanceObserver"){

                @Override
                public void run() {
                    InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new ParallelRecoveryObserver(2));
                }
            };
            SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                @Override
                public void run() {
                    ParallelRecoveryObserver ob = (ParallelRecoveryObserver)InternalResourceManager.getResourceObserver();
                    ob.observeRegion("region1");
                    ob.observeRegion("region2");
                    RebalanceOperationDUnitTest.this.createPR("region1");
                    RebalanceOperationDUnitTest.this.createPR("region2");
                }
            };
            vm0.invoke(setRebalanceObserver);
            vm0.invoke(createPrRegion);
            vm0.invoke(new SerializableRunnable("createSomeBuckets"){

                @Override
                public void run() {
                    RebalanceOperationDUnitTest.this.doPuts("region1");
                    RebalanceOperationDUnitTest.this.doPuts("region2");
                }
            });
            SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
                    region = cache.getRegion("region2");
                    details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
                }
            };
            vm0.invoke(checkLowRedundancy);
            vm1.invoke(setRebalanceObserver);
            vm1.invoke(createPrRegion);
            vm2.invoke(setRebalanceObserver);
            vm2.invoke(createPrRegion);
            vm0.invoke(checkLowRedundancy);
            vm0.invoke(new SerializableRunnable("simulateRebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, manager);
                    TestCase.assertEquals((int)12, (int)results.getTotalBucketCreatesCompleted());
                    TestCase.assertEquals((int)4, (int)results.getTotalPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)6, (int)results.getTotalBucketTransfersCompleted());
                    Set detailSet = results.getPartitionRebalanceDetails();
                    TestCase.assertEquals((int)2, (int)detailSet.size());
                    for (PartitionRebalanceInfo details : detailSet) {
                        TestCase.assertEquals((int)6, (int)details.getBucketCreatesCompleted());
                        TestCase.assertEquals((int)2, (int)details.getPrimaryTransfersCompleted());
                        TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                        Set afterDetails = details.getPartitionMemberDetailsAfter();
                        for (PartitionMemberInfo info : afterDetails) {
                            if (info.getDistributedMember().equals(zoneBMember)) {
                                TestCase.assertEquals((int)6, (int)info.getBucketCount());
                            } else {
                                TestCase.assertEquals((int)3, (int)info.getBucketCount());
                            }
                            TestCase.assertEquals((int)2, (int)info.getPrimaryCount());
                        }
                    }
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            });
            vm0.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    TestCase.assertTrue((boolean)((ParallelRecoveryObserver)InternalResourceManager.getResourceObserver()).isObserverCalled());
                }
            });
            this.checkBucketCount(vm0, "region1", 3);
            this.checkBucketCount(vm1, "region1", 3);
            this.checkBucketCount(vm2, "region1", 6);
            this.checkBucketCount(vm0, "region2", 3);
            this.checkBucketCount(vm1, "region2", 3);
            this.checkBucketCount(vm2, "region2", 6);
        }
        catch (Throwable throwable) {
            RebalanceOperationDUnitTest.disconnectFromDS();
            RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    CacheTestCase.disconnectFromDS();
                }
            });
            throw throwable;
        }
        RebalanceOperationDUnitTest.disconnectFromDS();
        RebalanceOperationDUnitTest.invokeInEveryVM(new /* invalid duplicate definition of identical inner class */);
    }

    private void checkBucketCount(VM vm0, final String regionName, final int numLocalBuckets) {
        vm0.invoke(new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                TestCase.assertEquals((int)numLocalBuckets, (int)region.getLocalBucketsListTestOnly().size());
            }
        });
    }

    private DistributedMember setRedundancyZone(VM vm, final String zone) {
        return (DistributedMember)vm.invoke(new SerializableCallable("set redundancy zone"){

            public Object call() {
                System.setProperty("gemfire.resource.manager.threads", "2");
                Properties props = new Properties();
                props.setProperty("redundancy-zone", zone);
                InternalDistributedSystem system = RebalanceOperationDUnitTest.this.getSystem(props);
                return system.getDistributedMember();
            }
        });
    }

    private RebalanceResults doRebalance(boolean simulate, ResourceManager manager) {
        return this.doRebalance(simulate, manager, null, null);
    }

    private RebalanceResults doRebalance(boolean simulate, ResourceManager manager, Set<String> includes, Set<String> excludes) {
        RebalanceResults results = null;
        if (simulate) {
            try {
                results = manager.createRebalanceFactory().includeRegions(includes).excludeRegions(excludes).simulate().getResults(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                RebalanceOperationDUnitTest.fail("Interrupted waiting on rebalance", e);
            }
            catch (TimeoutException e) {
                RebalanceOperationDUnitTest.fail("Timeout waiting on rebalance", e);
            }
        } else {
            try {
                results = manager.createRebalanceFactory().includeRegions(includes).excludeRegions(excludes).start().getResults(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                RebalanceOperationDUnitTest.fail("Interrupted waiting on rebalance", e);
            }
            catch (TimeoutException e) {
                RebalanceOperationDUnitTest.fail("Timeout waiting on rebalance", e);
            }
        }
        RebalanceOperationDUnitTest.assertEquals(Collections.emptySet(), (Object)manager.getRebalanceOperations());
        return results;
    }

    public void testRecoverRedundancyBalancingSimulation() {
        this.recoverRedundancyBalancing(true);
    }

    public void testRecoverRedundancyBalancing() {
        this.recoverRedundancyBalancing(false);
    }

    public void recoverRedundancyBalancing(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final DistributedMember member1 = this.createPrRegion(vm0, "region1", 200, null);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A");
                }
            }
        });
        SerializableRunnable checkRedundancy = new SerializableRunnable("checkRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)12, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkRedundancy);
        this.createPrRegion(vm1, "region1", 100, null);
        this.createPrRegion(vm2, "region1", 100, null);
        vm0.invoke(checkRedundancy);
        vm0.invoke(new SerializableRunnable("rebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)12, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)6, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)12, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)6, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)details.getBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)3, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    if (memberDetails.getDistributedMember().equals(member1)) {
                        TestCase.assertEquals((int)12, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)6, (int)memberDetails.getPrimaryCount());
                        continue;
                    }
                    TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                }
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            vm2.invoke(checkRedundancyFixed);
        }
    }

    private DistributedMember createPrRegion(VM vm, final String region, final int localMaxMemory, final String colocatedWith) {
        SerializableCallable createPrRegion = new SerializableCallable("createRegion"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                paf.setLocalMaxMemory(localMaxMemory);
                if (colocatedWith != null) {
                    paf.setColocatedWith(colocatedWith);
                }
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion(region, attr.create());
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        return (DistributedMember)vm.invoke(createPrRegion);
    }

    public void testRecoverRedundancyColocatedRegionsSimulation() {
        this.recoverRedundancyColocatedRegions(true);
    }

    public void testRecoverRedundancyColocatedRegions() {
        this.recoverRedundancyColocatedRegions(false);
    }

    public void recoverRedundancyColocatedRegions(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
                PartitionAttributesFactory paf2 = new PartitionAttributesFactory();
                paf2.setRedundantCopies(2);
                paf2.setRecoveryDelay(-1L);
                paf2.setStartupRecoveryDelay(-1L);
                paf2.setColocatedWith("region1");
                PartitionAttributes prAttr2 = paf2.create();
                AttributesFactory attr2 = new AttributesFactory();
                attr2.setPartitionAttributes(prAttr2);
                cache.createRegion("region2", attr2.create());
            }
        };
        final DistributedMember member1 = this.createPrRegion(vm0, "region1", 200, null);
        this.createPrRegion(vm0, "region2", 200, "region1");
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                Region region2 = cache.getRegion("region2");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A");
                    region2.put((Object)i, (Object)"A");
                }
            }
        });
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)12, (int)details.getLowRedundancyBucketCount());
                region = cache.getRegion("region2");
                details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)12, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkLowRedundancy);
        this.createPrRegion(vm1, "region1", 100, null);
        this.createPrRegion(vm2, "region1", 100, null);
        this.createPrRegion(vm1, "region2", 100, "region1");
        this.createPrRegion(vm2, "region2", 100, "region1");
        vm0.invoke(checkLowRedundancy);
        vm0.invoke(new SerializableRunnable("rebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)24, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)12, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)2, (int)detailSet.size());
                for (PartitionRebalanceInfo details : detailSet) {
                    TestCase.assertEquals((int)12, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)6, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertEquals((long)0L, (long)details.getBucketTransferBytes());
                    TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)3, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        if (memberDetails.getDistributedMember().equals(member1)) {
                            TestCase.assertEquals((int)12, (int)memberDetails.getBucketCount());
                            TestCase.assertEquals((int)6, (int)memberDetails.getPrimaryCount());
                            continue;
                        }
                        TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                    if (simulate) continue;
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                    PartitionedRegion region2 = (PartitionedRegion)cache.getRegion("region2");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)cache.getRegion("region1"));
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    details = PartitionRegionHelper.getPartitionRegionInfo((Region)cache.getRegion("region2"));
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((Object)region1.getLocalPrimaryBucketsListTestOnly(), (Object)region2.getLocalPrimaryBucketsListTestOnly());
                    TestCase.assertEquals((Object)region1.getLocalBucketsListTestOnly(), (Object)region2.getLocalBucketsListTestOnly());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            vm2.invoke(checkRedundancyFixed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoverRedundancyParallelAsyncEventQueueSimulation() throws NoSuchFieldException, SecurityException {
        RebalanceOperationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("gemfire.LOG_REBALANCE", "true");
            }
        });
        try {
            this.recoverRedundancyParallelAsyncEventQueue(true);
        }
        finally {
            System.setProperty("gemfire.LOG_REBALANCE", "false");
        }
    }

    public void testRecoverRedundancyParallelAsyncEventQueue() {
        this.recoverRedundancyParallelAsyncEventQueue(false);
    }

    public void recoverRedundancyParallelAsyncEventQueue(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final DistributedMember member1 = this.createPRRegionWithAsyncQueue(vm0, 200);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                Region region2 = cache.getRegion("region2");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A", (Object)new byte[524288]);
                }
                cache.findDiskStore(null).flush();
            }
        });
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)12, (int)details.getLowRedundancyBucketCount());
                PartitionedRegion region2 = (PartitionedRegion)ColocationHelper.getColocatedChildRegions((PartitionedRegion)((PartitionedRegion)region)).get(0);
                details = PartitionRegionHelper.getPartitionRegionInfo((Region)region2);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)12, (int)details.getLowRedundancyBucketCount());
                AsyncEventQueue queue = cache.getAsyncEventQueue("parallelQueue");
                TestCase.assertEquals((int)12, (int)queue.size());
            }
        };
        vm0.invoke(checkLowRedundancy);
        this.createPRRegionWithAsyncQueue(vm1, 100);
        this.createPRRegionWithAsyncQueue(vm2, 100);
        vm0.invoke(checkLowRedundancy);
        vm0.invoke(new SerializableRunnable("rebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)24, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)12, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)2, (int)detailSet.size());
                for (PartitionRebalanceInfo details : detailSet) {
                    TestCase.assertEquals((int)12, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)6, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertEquals((long)0L, (long)details.getBucketTransferBytes());
                    TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)3, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        if (memberDetails.getDistributedMember().equals(member1)) {
                            TestCase.assertEquals((int)12, (int)memberDetails.getBucketCount());
                            TestCase.assertEquals((int)6, (int)memberDetails.getPrimaryCount());
                            continue;
                        }
                        TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                    if (simulate) continue;
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                    PartitionedRegion region2 = (PartitionedRegion)ColocationHelper.getColocatedChildRegions((PartitionedRegion)region1).get(0);
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)cache.getRegion("region1"));
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    details = PartitionRegionHelper.getPartitionRegionInfo((Region)region2);
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((Object)region1.getLocalPrimaryBucketsListTestOnly(), (Object)region2.getLocalPrimaryBucketsListTestOnly());
                    TestCase.assertEquals((Object)region1.getLocalBucketsListTestOnly(), (Object)region2.getLocalBucketsListTestOnly());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            vm2.invoke(checkRedundancyFixed);
        }
    }

    private DistributedMember createPRRegionWithAsyncQueue(VM vm0, final int localMaxMemory) {
        SerializableCallable createPrRegion = new SerializableCallable("createRegion"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                cache.createAsyncEventQueueFactory().setMaximumQueueMemory(1).setParallel(true).create("parallelQueue", (AsyncEventListener)new AsyncEventListener<Object, Object>(){

                    public void close() {
                    }

                    public boolean processEvents(List<AsyncEvent<Object, Object>> events) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                        return false;
                    }
                });
                AttributesFactory attr = new AttributesFactory();
                attr.addAsyncEventQueueId("parallelQueue");
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                paf.setLocalMaxMemory(localMaxMemory);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        DistributedMember member1 = (DistributedMember)vm0.invoke(createPrRegion);
        return member1;
    }

    public void testCancelOperation() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
            }
        });
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)1, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)1, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkLowRedundancy);
        vm1.invoke(createPrRegion);
        vm0.invoke(checkLowRedundancy);
        vm0.invoke(new SerializableCallable("D rebalance"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)RebalanceOperationDUnitTest.this.getCache();
                InternalResourceManager manager = cache.getResourceManager();
                final CountDownLatch rebalancingCancelled = new CountDownLatch(1);
                final CountDownLatch rebalancingFinished = new CountDownLatch(1);
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new InternalResourceManager.ResourceObserverAdapter(){

                    public void rebalancingOrRecoveryStarted(Region region) {
                        try {
                            rebalancingCancelled.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }

                    public void rebalancingOrRecoveryFinished(Region region) {
                        rebalancingFinished.countDown();
                    }
                });
                RebalanceOperation op = manager.createRebalanceFactory().start();
                TestCase.assertFalse((boolean)op.isCancelled());
                TestCase.assertFalse((boolean)op.isDone());
                TestCase.assertEquals(Collections.singleton(op), (Object)manager.getRebalanceOperations());
                try {
                    op.getResults(5L, TimeUnit.SECONDS);
                    TestCase.fail((String)"Should have received a timeout exception");
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                TestCase.assertTrue((boolean)op.cancel());
                rebalancingCancelled.countDown();
                TestCase.assertTrue((boolean)op.isCancelled());
                TestCase.assertTrue((boolean)op.isDone());
                rebalancingFinished.await();
                try {
                    op.getResults(60L, TimeUnit.SECONDS);
                    TestCase.fail((String)"Should have received a cancellation exception");
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                TestCase.assertEquals(Collections.emptySet(), (Object)manager.getRebalanceOperations());
                return null;
            }
        });
        vm0.invoke(checkLowRedundancy);
    }

    public void testMembershipChange() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final VM vm2 = host.getVM(2);
        final SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
                region.put((Object)2, (Object)"A");
                region.put((Object)3, (Object)"A");
                region.put((Object)4, (Object)"A");
                region.put((Object)5, (Object)"A");
                region.put((Object)6, (Object)"A");
            }
        });
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableCallable("D rebalance"){

            public Object call() throws Exception {
                GemFireCacheImpl cache = (GemFireCacheImpl)RebalanceOperationDUnitTest.this.getCache();
                InternalResourceManager manager = cache.getResourceManager();
                CountDownLatch rebalancingStarted = new CountDownLatch(1);
                CountDownLatch memberAdded = new CountDownLatch(1);
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new InternalResourceManager.ResourceObserverAdapter(){
                    boolean firstBucket = true;

                    public void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
                        if (this.firstBucket) {
                            this.firstBucket = false;
                            vm2.invoke(createPrRegion);
                        }
                    }
                });
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, (ResourceManager)manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((int)4, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)4, (int)details.getBucketTransfersCompleted());
                Set beforeDetails = details.getPartitionMemberDetailsBefore();
                TestCase.assertEquals((int)2, (int)beforeDetails.size());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)3, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)2, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)2, (int)memberDetails.getPrimaryCount());
                }
                RebalanceOperationDUnitTest.this.verifyStats((ResourceManager)manager, results);
                InternalResourceManager mgr = manager;
                ResourceManagerStats stats = mgr.getStats();
                TestCase.assertEquals((int)1, (int)stats.getRebalanceMembershipChanges());
                return null;
            }
        });
    }

    public void testMoveBucketsNoRedundancySimulation() {
        this.moveBucketsNoRedundancy(true);
    }

    public void testMoveBucketsNoRedundancy() {
        this.moveBucketsNoRedundancy(false);
    }

    public void moveBucketsNoRedundancy(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setCacheLoader((CacheLoader)new Bug40228Loader());
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
                region.put((Object)2, (Object)"A");
                region.put((Object)3, (Object)"A");
                region.put((Object)4, (Object)"A");
                region.put((Object)5, (Object)"A");
                region.put((Object)6, (Object)"A");
            }
        });
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("simulateRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((int)3, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)2, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                }
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkRedundancyFixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((int)2, (int)details.getPartitionMemberInfo().size());
                    for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                        TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                    Bug40228Loader loader = (Bug40228Loader)cache.getRegion("region1").getAttributes().getCacheLoader();
                    TestCase.assertFalse((boolean)loader.isClosed());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            SerializableRunnable checkBug40228Fixed = new SerializableRunnable("checkBug40228Fixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Bug40228Loader loader = (Bug40228Loader)cache.getRegion("region1").getAttributes().getCacheLoader();
                    TestCase.assertFalse((boolean)loader.isClosed());
                    cache.getRegion("region1").close();
                    TestCase.assertTrue((boolean)loader.isClosed());
                }
            };
            vm0.invoke(checkBug40228Fixed);
            vm1.invoke(checkBug40228Fixed);
        }
    }

    public void testFilterRegionsSimulation() {
        this.filterRegions(true);
    }

    public void testFilterRegions() {
        this.filterRegions(false);
    }

    public void filterRegions(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int NUM_REGIONS = 4;
        final HashSet<String> INCLUDED = new HashSet<String>();
        INCLUDED.add("region0");
        INCLUDED.add("region1");
        final HashSet<String> EXCLUDED = new HashSet<String>();
        EXCLUDED.add("region0");
        EXCLUDED.add("region3");
        final HashSet<String> EXPECTED_REBALANCED = new HashSet<String>();
        EXPECTED_REBALANCED.add("/region0");
        EXPECTED_REBALANCED.add("/region1");
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                for (int i = 0; i < 4; ++i) {
                    cache.createRegion("region" + i, attr.create());
                }
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                for (int i = 0; i < 4; ++i) {
                    Region region = cache.getRegion("region" + i);
                    for (int j = 0; j < 6; ++j) {
                        region.put((Object)j, (Object)"A");
                    }
                }
            }
        });
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("simulateRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager, INCLUDED, EXCLUDED);
                Set detailSet = results.getPartitionRebalanceDetails();
                HashSet<String> names = new HashSet<String>();
                for (PartitionRebalanceInfo details : detailSet) {
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                    TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                    names.add(details.getRegionPath());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)2, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                }
                TestCase.assertEquals((Object)EXPECTED_REBALANCED, names);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((int)6, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkRedundancyFixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    for (String name : EXPECTED_REBALANCED) {
                        Region region = cache.getRegion(name);
                        PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                        TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                        TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                        TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                        TestCase.assertEquals((int)2, (int)details.getPartitionMemberInfo().size());
                        for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                            TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                            TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                        }
                    }
                    Region region = cache.getRegion("region2");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((int)2, (int)details.getPartitionMemberInfo().size());
                    for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                        int bucketCount = memberDetails.getBucketCount();
                        int primaryCount = memberDetails.getPrimaryCount();
                        TestCase.assertTrue((String)("Wrong number of buckets on non rebalanced region buckets=" + bucketCount + " primarys=" + primaryCount), (bucketCount == 6 && primaryCount == 6 || bucketCount == 0 && primaryCount == 0 ? 1 : 0) != 0);
                    }
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
        }
    }

    public void testMoveBucketsWithRedundancySimulation() {
        this.moveBucketsWithRedundancy(true);
    }

    public void testMoveBucketsWithRedundancy() {
        this.moveBucketsWithRedundancy(false);
    }

    public void moveBucketsWithRedundancy(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A");
                }
            }
        });
        vm2.invoke(createPrRegion);
        final Long totalSize = (Long)vm0.invoke(new SerializableCallable("simulateRebalance"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)8, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)8, (int)details.getBucketTransfersCompleted());
                long totalSize = 0L;
                Set beforeDetails = details.getPartitionMemberDetailsAfter();
                for (PartitionMemberInfo memberDetails : beforeDetails) {
                    totalSize += memberDetails.getSize();
                }
                long afterSize = 0L;
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)3, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    afterSize += memberDetails.getSize();
                }
                TestCase.assertEquals((long)totalSize, (long)afterSize);
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
                return totalSize;
            }
        });
        if (!simulate) {
            SerializableRunnable checkBalance = new SerializableRunnable("checkBalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    DistributedTestCase.getLogWriter().info("details=" + details.getPartitionMemberInfo());
                    long afterSize = 0L;
                    for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                        TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                        afterSize += memberDetails.getSize();
                    }
                    TestCase.assertEquals((long)totalSize, (long)afterSize);
                }
            };
            vm0.invoke(checkBalance);
            vm1.invoke(checkBalance);
            vm2.invoke(checkBalance);
        }
    }

    public void testMoveBucketsOverflowToDisk() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                for (int i = 0; i < 12; ++i) {
                    HashMap<Integer, String> m = new HashMap<Integer, String>();
                    for (int j = 0; j < 200; ++j) {
                        m.put(i + 113 * j, "A");
                    }
                    region.putAll(m);
                }
            }
        });
        SerializableRunnable doOps = new SerializableRunnable("doOps"){

            @Override
            public void run() {
                int key;
                int bucket;
                int count;
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                Random rand = new Random();
                for (count = 0; count < 5000; ++count) {
                    bucket = count % 12;
                    key = rand.nextInt(20);
                    region.put((Object)(bucket + 113 * key), (Object)"B");
                }
                for (count = 0; count < 500; ++count) {
                    bucket = count % 12;
                    key = rand.nextInt(20);
                    region.get((Object)(bucket + 113 * key));
                }
            }
        };
        vm0.invoke(doOps);
        vm2.invoke(createPrRegion);
        Long totalSize = (Long)vm0.invoke(new SerializableCallable("simulateRebalance"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)8, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)8, (int)details.getBucketTransfersCompleted());
                long totalSize = 0L;
                Set beforeDetails = details.getPartitionMemberDetailsAfter();
                for (PartitionMemberInfo memberDetails : beforeDetails) {
                    totalSize += memberDetails.getSize();
                }
                long afterSize = 0L;
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)3, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    afterSize += memberDetails.getSize();
                }
                TestCase.assertEquals((long)totalSize, (long)afterSize);
                RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                return totalSize;
            }
        });
        SerializableRunnable checkBalance = new SerializableRunnable("checkBalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                DistributedTestCase.getLogWriter().info("details=" + details.getPartitionMemberInfo());
                long afterSize = 0L;
                for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                    TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    afterSize += memberDetails.getSize();
                }
            }
        };
        vm0.invoke(checkBalance);
        vm1.invoke(checkBalance);
        vm2.invoke(checkBalance);
        vm3.invoke(createPrRegion);
        vm0.invoke(new SerializableCallable("simulateRebalance"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)6, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)6, (int)details.getBucketTransfersCompleted());
                long totalSize = 0L;
                Set beforeDetails = details.getPartitionMemberDetailsAfter();
                for (PartitionMemberInfo memberDetails : beforeDetails) {
                    totalSize += memberDetails.getSize();
                }
                long afterSize = 0L;
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)4, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                    afterSize += memberDetails.getSize();
                }
                TestCase.assertEquals((long)totalSize, (long)afterSize);
                return totalSize;
            }
        });
        checkBalance = new SerializableRunnable("checkBalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                DistributedTestCase.getLogWriter().info("details=" + details.getPartitionMemberInfo());
                long afterSize = 0L;
                for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                    TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                    afterSize += memberDetails.getSize();
                }
            }
        };
        vm0.invoke(checkBalance);
        vm1.invoke(checkBalance);
        vm2.invoke(checkBalance);
    }

    public void testMoveBucketsNestedPR() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setDataPolicy(DataPolicy.REPLICATE);
                Region parent = cache.createRegion("parent", attr.create());
                attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                parent.createSubregion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("parent/region1");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A");
                }
            }
        });
        vm2.invoke(createPrRegion);
        final Long totalSize = (Long)vm0.invoke(new SerializableCallable("simulateRebalance"){

            public Object call() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(false, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)8, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)8, (int)details.getBucketTransfersCompleted());
                long totalSize = 0L;
                Set beforeDetails = details.getPartitionMemberDetailsAfter();
                for (PartitionMemberInfo memberDetails : beforeDetails) {
                    totalSize += memberDetails.getSize();
                }
                long afterSize = 0L;
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)3, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    afterSize += memberDetails.getSize();
                }
                TestCase.assertEquals((long)totalSize, (long)afterSize);
                RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                return totalSize;
            }
        });
        SerializableRunnable checkBalance = new SerializableRunnable("checkBalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("parent/region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                DistributedTestCase.getLogWriter().info("details=" + details.getPartitionMemberInfo());
                long afterSize = 0L;
                for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                    TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    afterSize += memberDetails.getSize();
                }
                TestCase.assertEquals((long)totalSize, (long)afterSize);
            }
        };
        vm0.invoke(checkBalance);
        vm1.invoke(checkBalance);
        vm2.invoke(checkBalance);
    }

    public void testMoveBucketsColocatedRegionsSimulation() {
        this.moveBucketsColocatedRegions(true);
    }

    public void testMoveBucketsColocatedRegions() {
        this.moveBucketsColocatedRegions(false);
    }

    public void moveBucketsColocatedRegions(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPrRegion(vm0, "region1", 200, null);
        this.createPrRegion(vm0, "region2", 200, "region1");
        this.createPrRegion(vm1, "region1", 200, null);
        this.createPrRegion(vm1, "region2", 200, "region1");
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                Region region2 = cache.getRegion("region2");
                for (int i = 0; i < 12; ++i) {
                    region.put((Object)i, (Object)"A");
                    region2.put((Object)i, (Object)"A");
                }
            }
        });
        this.createPrRegion(vm2, "region1", 200, null);
        vm0.invoke(new SerializableRunnable("rebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)2, (int)detailSet.size());
                for (PartitionRebalanceInfo details : detailSet) {
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertEquals((long)0L, (long)details.getBucketTransferBytes());
                    TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                }
            }
        });
        this.createPrRegion(vm2, "region2", 200, "region1");
        vm0.invoke(new SerializableRunnable("rebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)16, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)2, (int)detailSet.size());
                for (PartitionRebalanceInfo details : detailSet) {
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                    TestCase.assertEquals((int)8, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)3, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        TestCase.assertEquals((int)8, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)4, (int)memberDetails.getPrimaryCount());
                    }
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkLowRedundancy"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    PartitionedRegion region1 = (PartitionedRegion)cache.getRegion("region1");
                    PartitionedRegion region2 = (PartitionedRegion)cache.getRegion("region2");
                    ResourceManager manager = cache.getResourceManager();
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)cache.getRegion("region1"));
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    details = PartitionRegionHelper.getPartitionRegionInfo((Region)cache.getRegion("region2"));
                    TestCase.assertEquals((int)12, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((Object)region1.getLocalPrimaryBucketsListTestOnly(), (Object)region2.getLocalPrimaryBucketsListTestOnly());
                    TestCase.assertEquals((Object)region1.getLocalBucketsListTestOnly(), (Object)region2.getLocalBucketsListTestOnly());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            vm2.invoke(checkRedundancyFixed);
        }
    }

    public void testWaitForPut() throws Exception {
        this.runTestWaitForOperation(new Operation(){

            @Override
            public void execute(Region region, Integer key) {
                region.put((Object)key, (Object)"B");
            }
        });
    }

    public void testWaitForInvalidate() throws Exception {
        this.runTestWaitForOperation(new Operation(){

            @Override
            public void execute(Region region, Integer key) {
                region.invalidate((Object)key);
            }
        });
    }

    public void testWaitForDestroy() throws Exception {
        this.runTestWaitForOperation(new Operation(){

            @Override
            public void execute(Region region, Integer key) {
                region.destroy((Object)key);
            }
        });
    }

    public void testWaitForCacheLoader() throws Exception {
        this.runTestWaitForOperation(new Operation(){

            @Override
            public void execute(Region region, Integer key) {
                PartitionedRegion r = (PartitionedRegion)region;
                region.get((Object)(key + r.getPartitionAttributes().getTotalNumBuckets()));
            }
        });
    }

    public void runTestWaitForOperation(final Operation op) throws CancellationException, InterruptedException, TimeoutException {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        return "anobject";
                    }

                    public void close() {
                    }
                });
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                paf.setLocalMaxMemory(100);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        attr.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                return "anobject";
            }

            public void close() {
            }
        });
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        paf.setLocalMaxMemory(100);
        PartitionAttributes prAttr = paf.create();
        attr.setPartitionAttributes(prAttr);
        final Region region = cache.createRegion("region1", attr.create());
        region.put((Object)1, (Object)"A");
        region.put((Object)2, (Object)"A");
        BlockingCacheListener cacheWriter = new BlockingCacheListener(2);
        region.getAttributesMutator().addCacheListener((CacheListener)cacheWriter);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                op.execute(region, 1);
            }
        };
        thread1.start();
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                op.execute(region, 2);
            }
        };
        thread2.start();
        cacheWriter.waitForOperationsStarted();
        SerializableRunnable checkLowRedundancy = new SerializableRunnable("checkLowRedundancy"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)2, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)2, (int)details.getLowRedundancyBucketCount());
            }
        };
        checkLowRedundancy.run();
        vm1.invoke(createPrRegion);
        checkLowRedundancy.run();
        ResourceManager manager = cache.getResourceManager();
        RebalanceOperation rebalance = manager.createRebalanceFactory().start();
        try {
            rebalance.getResults(5L, TimeUnit.SECONDS);
            RebalanceOperationDUnitTest.fail((String)"Operation should not have completed");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        cacheWriter.release();
        RebalanceOperationDUnitTest.getLogWriter().info("starting wait for rebalance.  Will wait for 60 seconds");
        RebalanceResults results = rebalance.getResults(60L, TimeUnit.SECONDS);
        RebalanceOperationDUnitTest.assertEquals((int)2, (int)results.getTotalBucketCreatesCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)1, (int)results.getTotalPrimaryTransfersCompleted());
        RebalanceOperationDUnitTest.assertEquals((long)0L, (long)results.getTotalBucketTransferBytes());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
        Set detailSet = results.getPartitionRebalanceDetails();
        RebalanceOperationDUnitTest.assertEquals((int)1, (int)detailSet.size());
        PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
        RebalanceOperationDUnitTest.assertEquals((int)2, (int)details.getBucketCreatesCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)1, (int)details.getPrimaryTransfersCompleted());
        RebalanceOperationDUnitTest.assertEquals((long)0L, (long)details.getBucketTransferBytes());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
        Set afterDetails = details.getPartitionMemberDetailsAfter();
        RebalanceOperationDUnitTest.assertEquals((int)2, (int)afterDetails.size());
        for (PartitionMemberInfo memberDetails : afterDetails) {
            RebalanceOperationDUnitTest.assertEquals((int)2, (int)memberDetails.getBucketCount());
            RebalanceOperationDUnitTest.assertEquals((int)1, (int)memberDetails.getPrimaryCount());
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkRedundancyFixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)2, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                }
            };
            checkRedundancyFixed.run();
            vm1.invoke(checkRedundancyFixed);
        }
    }

    public void testRecoverRedundancyWithOfflinePersistenceSimulation() throws Throwable {
        this.recoverRedundancyWithOfflinePersistence(true, false);
    }

    public void testRecoverRedundancyWithOfflinePersistence() throws Throwable {
        this.recoverRedundancyWithOfflinePersistence(false, false);
    }

    public void testRecoverRedundancyWithOfflinePersistenceAccessorSimulation() throws Throwable {
        this.recoverRedundancyWithOfflinePersistence(true, true);
    }

    public void testRecoverRedundancyWithOfflinePersistenceAccessor() throws Throwable {
        this.recoverRedundancyWithOfflinePersistence(false, true);
    }

    public void recoverRedundancyWithOfflinePersistence(final boolean simulate, boolean useAccessor) throws Throwable {
        VM rebalanceVM;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                DiskStore ds1 = dsf.setDiskDirs(CacheTestCase.getDiskDirs()).create(RebalanceOperationDUnitTest.this.getUniqueName());
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                attr.setDiskSynchronous(true);
                attr.setDiskStoreName(RebalanceOperationDUnitTest.this.getUniqueName());
                cache.createRegion("region1", attr.create());
            }
        };
        vm0.invoke(createPrRegion);
        vm1.invoke(createPrRegion);
        SerializableRunnable createAccessor = new SerializableRunnable("createAccessor"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                DiskStore ds1 = dsf.setDiskDirs(CacheTestCase.getDiskDirs()).create("ds1");
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                paf.setLocalMaxMemory(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion("region1", attr.create());
            }
        };
        if (useAccessor) {
            vm3.invoke(createAccessor);
            rebalanceVM = vm3;
        } else {
            rebalanceVM = vm0;
        }
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
                region.put((Object)2, (Object)"A");
                region.put((Object)3, (Object)"A");
                region.put((Object)4, (Object)"A");
                region.put((Object)5, (Object)"A");
                region.put((Object)6, (Object)"A");
            }
        });
        SerializableRunnable closeCache = new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                cache.getRegion("region1").close();
            }
        };
        Set<Integer> vm1Buckets = this.getBucketList("region1", vm1);
        vm1.invoke(closeCache);
        SerializableRunnable checkLowRedundancyBeforeRebalance = new SerializableRunnable("checkLowRedundancyBeforeRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)6, (int)details.getLowRedundancyBucketCount());
            }
        };
        SerializableRunnable checkLowRedundancyAfterRebalance = new SerializableRunnable("checkLowRedundancyAfterRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                TestCase.assertEquals((int)1, (int)details.getActualRedundantCopies());
                TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
            }
        };
        vm0.invoke(checkLowRedundancyBeforeRebalance);
        vm2.invoke(createPrRegion);
        vm0.invoke(checkLowRedundancyBeforeRebalance);
        rebalanceVM.invoke(new SerializableRunnable("simulateRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)6, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)3, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)6, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)3, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)2, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                }
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        Set<Integer> vm0Buckets = this.getBucketList("region1", vm0);
        Set<Integer> vm2Buckets = this.getBucketList("region1", vm2);
        if (!simulate) {
            vm0.invoke(checkLowRedundancyAfterRebalance);
        } else {
            vm0.invoke(checkLowRedundancyBeforeRebalance);
        }
        vm2.invoke(closeCache);
        vm0.invoke(closeCache);
        if (useAccessor) {
            vm3.invoke(closeCache);
        }
        AsyncInvocation async0 = vm0.invokeAsync(createPrRegion);
        AsyncInvocation async2 = vm2.invokeAsync(createPrRegion);
        async0.getResult(30000L);
        async0.getResult(30000L);
        if (useAccessor) {
            vm3.invoke(createAccessor);
        }
        RebalanceOperationDUnitTest.pause(10000);
        if (!simulate) {
            rebalanceVM.invoke(new SerializableRunnable("rebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                    TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)results.getTotalBucketTransfersCompleted());
                    Set detailSet = results.getPartitionRebalanceDetails();
                    TestCase.assertEquals((int)1, (int)detailSet.size());
                    PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)2, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        TestCase.assertEquals((int)6, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                }
            });
            vm0.invoke(checkLowRedundancyAfterRebalance);
        }
        vm1.invoke(createPrRegion);
        RebalanceOperationDUnitTest.assertEquals(vm0Buckets, this.getBucketList("region1", vm0));
        if (!simulate) {
            RebalanceOperationDUnitTest.assertEquals((int)0, (int)this.getBucketList("region1", vm1).size());
        } else {
            this.waitForBucketList("region1", vm1, vm1Buckets);
        }
        RebalanceOperationDUnitTest.assertEquals(vm2Buckets, this.getBucketList("region1", vm2));
    }

    public void testMoveBucketsWithUnrecoveredValues() {
        this.moveBucketsWithUnrecoveredValuesRedundancy(false);
    }

    public void testBalanceBucketsByCountSimulation() {
        this.balanceBucketsByCount(true);
    }

    public void testBalanceBucketsByCount() {
        this.balanceBucketsByCount(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void balanceBucketsByCount(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        LoadProbe oldProbe = this.setLoadProbe(vm0, (LoadProbe)new BucketCountLoadProbe());
        try {
            SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(0);
                    paf.setRecoveryDelay(-1L);
                    paf.setStartupRecoveryDelay(-1L);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    attr.setCacheLoader((CacheLoader)new Bug40228Loader());
                    cache.createRegion("region1", attr.create());
                }
            };
            vm0.invoke(createPrRegion);
            vm0.invoke(new SerializableRunnable("createSomeBuckets"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    region.put((Object)1, (Object)new byte[0x100000]);
                    region.put((Object)2, (Object)"A");
                    region.put((Object)3, (Object)"A");
                    region.put((Object)4, (Object)"A");
                    region.put((Object)5, (Object)"A");
                    region.put((Object)6, (Object)"A");
                }
            });
            vm1.invoke(createPrRegion);
            vm0.invoke(new SerializableRunnable("simulateRebalance"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    ResourceManager manager = cache.getResourceManager();
                    RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                    TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                    TestCase.assertEquals((int)3, (int)results.getTotalBucketTransfersCompleted());
                    TestCase.assertTrue((0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                    Set detailSet = results.getPartitionRebalanceDetails();
                    TestCase.assertEquals((int)1, (int)detailSet.size());
                    PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                    TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                    TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                    TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                    TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                    Set afterDetails = details.getPartitionMemberDetailsAfter();
                    TestCase.assertEquals((int)2, (int)afterDetails.size());
                    for (PartitionMemberInfo memberDetails : afterDetails) {
                        TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                    if (!simulate) {
                        RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                    }
                }
            });
            if (!simulate) {
                SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkRedundancyFixed"){

                    @Override
                    public void run() {
                        Cache cache = RebalanceOperationDUnitTest.this.getCache();
                        Region region = cache.getRegion("region1");
                        PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                        TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                        TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                        TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                        TestCase.assertEquals((int)2, (int)details.getPartitionMemberInfo().size());
                        for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                            TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                            TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                        }
                        Bug40228Loader loader = (Bug40228Loader)cache.getRegion("region1").getAttributes().getCacheLoader();
                        TestCase.assertFalse((boolean)loader.isClosed());
                    }
                };
                vm0.invoke(checkRedundancyFixed);
                vm1.invoke(checkRedundancyFixed);
            }
        }
        finally {
            this.setLoadProbe(vm0, oldProbe);
        }
    }

    private LoadProbe setLoadProbe(VM vm, final LoadProbe probe) {
        LoadProbe oldProbe = (LoadProbe)vm.invoke(new SerializableCallable("set load probe"){

            public Object call() {
                GemFireCacheImpl cache = (GemFireCacheImpl)RebalanceOperationDUnitTest.this.getCache();
                InternalResourceManager mgr = cache.getResourceManager();
                return mgr.setLoadProbe(probe);
            }
        });
        return oldProbe;
    }

    public void moveBucketsWithUnrecoveredValuesRedundancy(final boolean simulate) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPrRegion = new SerializableRunnable("createRegion"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.setProperty(DiskStoreImpl.RECOVER_VALUE_PROPERTY_NAME, "false");
                try {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    if (cache.findDiskStore("store") == null) {
                        cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).setMaxOplogSize(1L).create("store");
                    }
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    attr.setDiskStoreName("store");
                    attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    paf.setRedundantCopies(0);
                    paf.setRecoveryDelay(-1L);
                    paf.setStartupRecoveryDelay(-1L);
                    PartitionAttributes prAttr = paf.create();
                    attr.setPartitionAttributes(prAttr);
                    attr.setCacheLoader((CacheLoader)new Bug40228Loader());
                    cache.createRegion("region1", attr.create());
                }
                finally {
                    System.setProperty(DiskStoreImpl.RECOVER_VALUE_PROPERTY_NAME, "true");
                }
            }
        };
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("createSomeBuckets"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)1, (Object)"A");
                region.put((Object)2, (Object)"A");
                region.put((Object)3, (Object)"A");
                region.put((Object)4, (Object)"A");
                region.put((Object)5, (Object)"A");
                region.put((Object)6, (Object)"A");
            }
        });
        long[] bucketSizes = (long[])vm0.invoke(new SerializableCallable("get sizes and close cache"){

            public Object call() {
                PartitionedRegion region = (PartitionedRegion)RebalanceOperationDUnitTest.this.getCache().getRegion("region1");
                PartitionedRegionDataStore dataStore = region.getDataStore();
                long[] bucketSizes = new long[7];
                for (int i = 1; i <= 6; ++i) {
                    BucketRegion bucket = dataStore.getLocalBucketById(Integer.valueOf(i));
                    bucketSizes[i] = bucket.getTotalBytes();
                    TestCase.assertEquals((long)0L, (long)bucket.getNumOverflowBytesOnDisk());
                    TestCase.assertEquals((long)0L, (long)bucket.getNumOverflowOnDisk());
                    TestCase.assertEquals((long)1L, (long)bucket.getNumEntriesInVM());
                }
                RebalanceOperationDUnitTest.this.getCache().close();
                return bucketSizes;
            }
        });
        vm0.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("check sizes"){

            @Override
            public void run() {
                PartitionedRegion region = (PartitionedRegion)RebalanceOperationDUnitTest.this.getCache().getRegion("region1");
                PartitionedRegionDataStore dataStore = region.getDataStore();
                for (int i = 1; i <= 6; ++i) {
                    BucketRegion bucket = dataStore.getLocalBucketById(Integer.valueOf(i));
                    TestCase.assertEquals((long)1L, (long)bucket.getNumOverflowOnDisk());
                    TestCase.assertEquals((long)0L, (long)bucket.getNumEntriesInVM());
                    TestCase.assertTrue((String)("Bucket size was " + bucket.getNumOverflowBytesOnDisk()), (1L < bucket.getNumOverflowBytesOnDisk() ? 1 : 0) != 0);
                    TestCase.assertEquals((long)bucket.getNumOverflowBytesOnDisk(), (long)bucket.getTotalBytes());
                }
            }
        });
        vm1.invoke(createPrRegion);
        vm0.invoke(new SerializableRunnable("simulateRebalance"){

            @Override
            public void run() {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                ResourceManager manager = cache.getResourceManager();
                RebalanceResults results = RebalanceOperationDUnitTest.this.doRebalance(simulate, manager);
                TestCase.assertEquals((int)0, (int)results.getTotalBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)results.getTotalPrimaryTransfersCompleted());
                TestCase.assertEquals((int)3, (int)results.getTotalBucketTransfersCompleted());
                TestCase.assertTrue((String)("Transfered Bytes = " + results.getTotalBucketTransferBytes()), (0L < results.getTotalBucketTransferBytes() ? 1 : 0) != 0);
                Set detailSet = results.getPartitionRebalanceDetails();
                TestCase.assertEquals((int)1, (int)detailSet.size());
                PartitionRebalanceInfo details = (PartitionRebalanceInfo)detailSet.iterator().next();
                TestCase.assertEquals((int)0, (int)details.getBucketCreatesCompleted());
                TestCase.assertEquals((int)0, (int)details.getPrimaryTransfersCompleted());
                TestCase.assertTrue((0L < details.getBucketTransferBytes() ? 1 : 0) != 0);
                TestCase.assertEquals((int)3, (int)details.getBucketTransfersCompleted());
                Set afterDetails = details.getPartitionMemberDetailsAfter();
                TestCase.assertEquals((int)2, (int)afterDetails.size());
                for (PartitionMemberInfo memberDetails : afterDetails) {
                    TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                    TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                }
                if (!simulate) {
                    RebalanceOperationDUnitTest.this.verifyStats(manager, results);
                }
            }
        });
        if (!simulate) {
            SerializableRunnable checkRedundancyFixed = new SerializableRunnable("checkRedundancyFixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Region region = cache.getRegion("region1");
                    PartitionRegionInfo details = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                    TestCase.assertEquals((int)6, (int)details.getCreatedBucketCount());
                    TestCase.assertEquals((int)0, (int)details.getActualRedundantCopies());
                    TestCase.assertEquals((int)0, (int)details.getLowRedundancyBucketCount());
                    TestCase.assertEquals((int)2, (int)details.getPartitionMemberInfo().size());
                    for (PartitionMemberInfo memberDetails : details.getPartitionMemberInfo()) {
                        TestCase.assertEquals((int)3, (int)memberDetails.getBucketCount());
                        TestCase.assertEquals((int)3, (int)memberDetails.getPrimaryCount());
                    }
                    Bug40228Loader loader = (Bug40228Loader)cache.getRegion("region1").getAttributes().getCacheLoader();
                    TestCase.assertFalse((boolean)loader.isClosed());
                }
            };
            vm0.invoke(checkRedundancyFixed);
            vm1.invoke(checkRedundancyFixed);
            SerializableRunnable checkBug40228Fixed = new SerializableRunnable("checkBug40228Fixed"){

                @Override
                public void run() {
                    Cache cache = RebalanceOperationDUnitTest.this.getCache();
                    Bug40228Loader loader = (Bug40228Loader)cache.getRegion("region1").getAttributes().getCacheLoader();
                    TestCase.assertFalse((boolean)loader.isClosed());
                    cache.getRegion("region1").close();
                    TestCase.assertTrue((boolean)loader.isClosed());
                }
            };
            vm0.invoke(checkBug40228Fixed);
            vm1.invoke(checkBug40228Fixed);
        }
    }

    private void verifyStats(ResourceManager manager, RebalanceResults results) {
        InternalResourceManager mgr = (InternalResourceManager)manager;
        ResourceManagerStats stats = mgr.getStats();
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalancesInProgress());
        RebalanceOperationDUnitTest.assertEquals((int)1, (int)stats.getRebalancesCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalanceBucketCreatesInProgress());
        RebalanceOperationDUnitTest.assertEquals((int)results.getTotalBucketCreatesCompleted(), (int)stats.getRebalanceBucketCreatesCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalanceBucketCreatesFailed());
        RebalanceOperationDUnitTest.assertEquals((float)results.getTotalBucketCreateTime(), (float)TimeUnit.NANOSECONDS.toMillis(stats.getRebalanceBucketCreateTime()), (float)2000.0f);
        RebalanceOperationDUnitTest.assertEquals((long)results.getTotalBucketCreateBytes(), (long)stats.getRebalanceBucketCreateBytes());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalanceBucketTransfersInProgress());
        RebalanceOperationDUnitTest.assertEquals((int)results.getTotalBucketTransfersCompleted(), (int)stats.getRebalanceBucketTransfersCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalanceBucketTransfersFailed());
        RebalanceOperationDUnitTest.assertEquals((float)results.getTotalBucketTransferTime(), (float)TimeUnit.NANOSECONDS.toMillis(stats.getRebalanceBucketTransfersTime()), (float)2000.0f);
        RebalanceOperationDUnitTest.assertEquals((long)results.getTotalBucketTransferBytes(), (long)stats.getRebalanceBucketTransfersBytes());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalancePrimaryTransfersInProgress());
        RebalanceOperationDUnitTest.assertEquals((int)results.getTotalPrimaryTransfersCompleted(), (int)stats.getRebalancePrimaryTransfersCompleted());
        RebalanceOperationDUnitTest.assertEquals((int)0, (int)stats.getRebalancePrimaryTransfersFailed());
        RebalanceOperationDUnitTest.assertEquals((float)results.getTotalPrimaryTransferTime(), (float)TimeUnit.NANOSECONDS.toMillis(stats.getRebalancePrimaryTransferTime()), (float)2000.0f);
    }

    private Set<Integer> getBucketList(final String regionName, VM vm0) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                return new TreeSet(region.getDataStore().getAllLocalBucketIds());
            }
        };
        return (Set)vm0.invoke(getBuckets);
    }

    private void waitForBucketList(final String regionName, VM vm0, final Collection<Integer> expected) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = RebalanceOperationDUnitTest.this.getCache();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        TreeSet<Integer> results = this.getBuckets();
                        return results.equals(expected);
                    }

                    protected TreeSet<Integer> getBuckets() {
                        TreeSet<Integer> results = new TreeSet<Integer>(region.getDataStore().getAllLocalBucketIds());
                        return results;
                    }

                    @Override
                    public String description() {
                        return "Timeout waiting for buckets to match. Expected " + expected + " but got " + this.getBuckets();
                    }
                }, 60000L, 100L, true);
                return null;
            }
        };
        vm0.invoke(getBuckets);
    }

    private static class Bug40228Loader
    implements CacheLoader {
        private volatile boolean closed = false;

        private Bug40228Loader() {
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return null;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            this.closed = true;
        }
    }

    private static interface Operation {
        public void execute(Region var1, Integer var2);
    }

    private static class BlockingCacheListener
    extends CacheListenerAdapter {
        CountDownLatch operationStartedLatch;
        CountDownLatch resumeOperationLatch = new CountDownLatch(1);

        public BlockingCacheListener(int threads) {
            this.operationStartedLatch = new CountDownLatch(threads);
        }

        public void waitForOperationsStarted() throws InterruptedException {
            this.operationStartedLatch.await(60L, TimeUnit.SECONDS);
        }

        public void close() {
        }

        private void doWait() {
            this.operationStartedLatch.countDown();
            try {
                this.resumeOperationLatch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheWriterException((Throwable)e);
            }
        }

        public void afterUpdate(EntryEvent event) throws CacheWriterException {
            this.doWait();
        }

        public void afterCreate(EntryEvent event) {
            this.doWait();
        }

        public void afterDestroy(EntryEvent event) {
            this.doWait();
        }

        public void afterInvalidate(EntryEvent event) {
            this.doWait();
        }

        public void release() {
            this.resumeOperationLatch.countDown();
        }
    }

    public static class ParallelRecoveryObserver
    extends InternalResourceManager.ResourceObserverAdapter {
        HashSet<String> regions = new HashSet();
        private volatile boolean observerCalled;
        private CyclicBarrier barrier;

        public ParallelRecoveryObserver(int numRegions) {
            this.barrier = new CyclicBarrier(numRegions);
        }

        public void observeRegion(String region) {
            this.regions.add(region);
        }

        private void checkAllRegionRecoveryOrRebalanceStarted(String rn) {
            if (this.regions.contains(rn)) {
                try {
                    this.barrier.await(60L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("failed waiting for barrier", e);
                }
            } else {
                throw new RuntimeException("region not registered " + rn);
            }
            this.observerCalled = true;
        }

        public boolean isObserverCalled() {
            return this.observerCalled;
        }

        public void rebalancingStarted(Region region) {
            super.rebalancingStarted(region);
            this.checkAllRegionRecoveryOrRebalanceStarted(region.getName());
        }

        public void recoveryStarted(Region region) {
            super.recoveryStarted(region);
            this.checkAllRegionRecoveryOrRebalanceStarted(region.getName());
        }
    }
}

