/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ClientServerFunctionExecutionDUnitTest
extends PRClientServerTestBase {
    private static final String TEST_FUNCTION1 = "TestFunction1";
    static Boolean isByName = null;
    static Function function = null;
    static Boolean toRegister = null;
    static final String retryRegionName = "RetryDataRegion";
    static Region metaDataRegion;

    public ClientServerFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void test_Bug_43126_Function_Not_Registered() throws InterruptedException {
        this.createScenario();
        try {
            client.invoke(ClientServerFunctionExecutionDUnitTest.class, "executeRegisteredFunction");
        }
        catch (Exception e) {
            ClientServerFunctionExecutionDUnitTest.assertEquals((boolean)true, (boolean)(e.getCause() instanceof ServerOperationException));
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)e.getCause().getMessage().contains("The function is not registered for function id"));
        }
    }

    public void test_Bug43126() throws InterruptedException {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION1);
        this.registerFunctionAtServer((Function)function);
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "executeRegisteredFunction");
    }

    public void testServerExecution_byName() {
        this.createScenario();
        function = new TestFunction(true, TEST_FUNCTION1);
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution", new Object[]{isByName, function, toRegister});
    }

    public void testServerExecution_sendException() {
        this.createScenario();
        function = new TestFunction(true, "executeFunction_SendException");
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution_SendException", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution_SendException", new Object[]{isByName, function, toRegister});
    }

    public void testServerExecution_NoLastResult() {
        this.createScenario();
        function = new TestFunction(true, "executeFunctionWithoutLastResult");
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution_NoLastResult", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution_NoLastResult", new Object[]{isByName, function, toRegister});
    }

    public void testServerExecution_byName_WithoutRegister() {
        this.createScenario();
        function = new TestFunction(true, TEST_FUNCTION1);
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(false);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution", new Object[]{isByName, function, toRegister});
    }

    public void testServerExecution_byInlineFunction() {
        this.createScenario();
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution_Inline");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution_Inline");
    }

    public void testServerExecution_byInlineFunction_InvalidAttrbiutes() {
        this.createScenario();
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution_Inline_InvalidAttributes");
    }

    public void testBug40714() {
        this.createScenario();
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFunctionExecutionDUnitTest#testBug40714 : Starting test");
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "registerFunction");
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "registerFunction");
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "registerFunction");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "registerFunction");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "FunctionExecution_Inline_Bug40714");
    }

    public static void registerFunction() {
        FunctionService.registerFunction((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Failure");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.FALSE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        });
    }

    public static void FunctionExecution_Inline_Bug40714() {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return "Function";
                }

                public boolean hasResult() {
                    return true;
                }
            });
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)3, (int)resultList.size());
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(0));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(1));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation.");
        }
    }

    public void testServerExecution_SocketTimeOut() {
        this.createScenario();
        function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution", new Object[]{isByName, function, toRegister});
    }

    public void testServerExecution_SocketTimeOut_WithoutRegister() {
        this.createScenario();
        function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer(function);
        isByName = new Boolean(true);
        toRegister = new Boolean(false);
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#testServerSingleKeyExecution_byName : Starting test");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecution", new Object[]{isByName, function, toRegister});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "allServerExecution", new Object[]{isByName, function, toRegister});
    }

    public void testOnServerFailoverWithOneServerDownHA() throws InterruptedException {
        this.createScenario();
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{ClientServerFunctionExecutionDUnitTest.getServerHostName(server1.getHost())});
        function = new TestFunction(true, "executeFunctionHAOnServer");
        this.registerFunctionAtServer(function);
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecutionHAOneServerDown", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(1), new Integer(1)});
    }

    public void testOnServerFailoverWithTwoServerDownHA() throws InterruptedException {
        this.createScenario();
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{ClientServerFunctionExecutionDUnitTest.getServerHostName(server1.getHost())});
        function = new TestFunction(true, "executeFunctionHAOnServer");
        this.registerFunctionAtServer(function);
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecutionHATwoServerDown", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(2), new Integer(0)});
    }

    public void testOnServerFailoverNonHA() throws InterruptedException {
        this.createScenario();
        server1.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invoke(ClientServerFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{ClientServerFunctionExecutionDUnitTest.getServerHostName(server1.getHost())});
        function = new TestFunction(true, "executeFunctionNonHAOnServer");
        this.registerFunctionAtServer(function);
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverExecutionNonHA", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(1), new Integer(0)});
    }

    public void testOnServerExecution_FunctionInvocationTargetException() {
        this.createScenario();
        function = new TestFunction(true, "executeFunctionReexecuteExceptionOnServer");
        this.registerFunctionAtServer(function);
        client.invoke(ClientServerFunctionExecutionDUnitTest.class, "serverFunctionExecution_FunctionInvocationTargetException", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
    }

    private void createScenario() {
        ClientServerFunctionExecutionDUnitTest.getLogWriter().info("ClientServerFFunctionExecutionDUnitTest#createScenario : creating scenario");
        this.createClientServerScenarionWithoutRegion();
    }

    public static void serverExecution(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        }
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            HashSet<String> testKeysSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, testKeysSet, function, isByName);
            List resultList = (List)rs.getResult();
            for (int i = 0; i < 20; ++i) {
                ClientServerFunctionExecutionDUnitTest.assertEquals((boolean)true, (boolean)((List)resultList.get(0)).contains("execKey-" + i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operations");
        }
    }

    public static void executeRegisteredFunction() {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution member = FunctionService.onServer((Pool)pool);
        ((AbstractExecution)member).removeFunctionAttributes(TEST_FUNCTION1);
        ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute(TEST_FUNCTION1);
        ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
        byte[] functionAttributes = ((AbstractExecution)member).getFunctionAttributes(TEST_FUNCTION1);
        ClientServerFunctionExecutionDUnitTest.assertNotNull((Object)functionAttributes);
    }

    public static void serverExecution_SendException(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        }
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)(((List)rs.getResult()).get(0) instanceof MyFunctionExecutionException));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            HashSet<String> testKeysSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, testKeysSet, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)(testKeysSet.size() + 1), (int)resultList.size());
            Iterator resultIterator = resultList.iterator();
            int exceptionCount = 0;
            while (resultIterator.hasNext()) {
                Object o = resultIterator.next();
                if (!(o instanceof MyFunctionExecutionException)) continue;
                ++exceptionCount;
            }
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)1, (int)exceptionCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operations");
        }
    }

    public static void createReplicatedRegion() {
        metaDataRegion = cache.createRegionFactory(RegionShortcut.REPLICATE).create(retryRegionName);
    }

    public static void createProxyRegion(String hostName) {
        CacheServerTestUtil.disableShufflingOfEndpoints();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(pool.getName());
        RegionAttributes attrs = factory.create();
        metaDataRegion = cache.createRegion(retryRegionName, attrs);
        ClientServerFunctionExecutionDUnitTest.assertNotNull((Object)metaDataRegion);
    }

    public static void verifyMetaData(Integer arg1, Integer arg2) {
        try {
            if (arg1 == 0) {
                ClientServerFunctionExecutionDUnitTest.assertNull((Object)metaDataRegion.get((Object)"stopped"));
            } else {
                ClientServerFunctionExecutionDUnitTest.assertEquals((Object)metaDataRegion.get((Object)"stopped"), (Object)arg1);
            }
            if (arg2 == 0) {
                ClientServerFunctionExecutionDUnitTest.assertNull((Object)metaDataRegion.get((Object)"sentresult"));
            } else {
                ClientServerFunctionExecutionDUnitTest.assertEquals((Object)metaDataRegion.get((Object)"sentresult"), (Object)arg2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.fail((String)"The metadata doesn't match with the expected value.");
        }
    }

    public static void verifyDeadAndLiveServers(Integer expectedDeadServers, final Integer expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int sz = PRClientServerTestBase.pool.getConnectedServerCount();
                DistributedTestCase.getLogWriter().info("Checking for the Live Servers : Expected  : " + expectedLiveServers + " Available :" + sz);
                if (sz == expectedLiveServers) {
                    return true;
                }
                this.excuse = "Expected " + expectedLiveServers + " but found " + sz;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
    }

    public static Object serverExecutionHAOneServerDown(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        }
        Execution member = FunctionService.onServer((Pool)pool);
        ResultCollector rs = null;
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(retryRegionName);
            args.add("serverExecutionHAOneServerDown");
            rs = ClientServerFunctionExecutionDUnitTest.execute(member, args, function, isByName);
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)retryRegionName, ((List)rs.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
        return rs.getResult();
    }

    public static void serverExecutionHATwoServerDown(Boolean isByName, Function function, Boolean toRegister) {
        block3: {
            DistributedSystem.setThreadsSocketPolicy((boolean)false);
            if (toRegister.booleanValue()) {
                FunctionService.registerFunction((Function)function);
            }
            Execution member = FunctionService.onServer((Pool)pool);
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(retryRegionName);
                args.add("serverExecutionHATwoServerDown");
                ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, args, function, isByName);
                ClientServerFunctionExecutionDUnitTest.fail((String)"Expected ServerConnectivityException not thrown!");
            }
            catch (Exception ex) {
                if (ex instanceof ServerConnectivityException) break block3;
                ex.printStackTrace();
                ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
                ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
            }
        }
    }

    public static Object serverExecutionNonHA(Boolean isByName, Function function, Boolean toRegister) {
        block3: {
            DistributedSystem.setThreadsSocketPolicy((boolean)false);
            if (toRegister.booleanValue()) {
                FunctionService.registerFunction((Function)function);
            }
            Execution member = FunctionService.onServer((Pool)pool);
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(retryRegionName);
                args.add("serverExecutionNonHA");
                ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, args, function, isByName);
                ClientServerFunctionExecutionDUnitTest.fail((String)"Expected ServerConnectivityException not thrown!");
            }
            catch (Exception ex) {
                if (ex instanceof ServerConnectivityException) break block3;
                ex.printStackTrace();
                ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
                ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
            }
        }
        return null;
    }

    public static void serverFunctionExecution_FunctionInvocationTargetException(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        }
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            ArrayList list = (ArrayList)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertTrue(((Integer)list.get(0) == 1 ? 1 : 0) != 0);
            ClientServerFunctionExecutionDUnitTest.assertTrue(((Integer)list.get(1) == 5 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.fail("This is not expected Exception", ex);
        }
    }

    public static void serverExecution_NoLastResult(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        }
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            ClientServerFunctionExecutionDUnitTest.fail((String)"Expected FunctionException : Function did not send last result");
        }
        catch (Exception ex) {
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().contains("did not send last result"));
        }
    }

    public static void serverExecution_Inline() {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation nn TRUE");
        }
    }

    public static void serverExecution_Inline_InvalidAttributes() {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution member = FunctionService.onServer((Pool)pool);
        try {
            ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return false;
                }

                public boolean isHA() {
                    return true;
                }
            });
            ClientServerFunctionExecutionDUnitTest.fail((String)"Should have failed with Invalid attributes.");
        }
        catch (Exception ex) {
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().contains("For Functions with isHA true, hasResult must also be true."));
        }
    }

    public static void allServerExecution(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            ClientServerFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(0));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(1));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            HashSet<String> testKeysSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, testKeysSet, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)3, (int)resultList.size());
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 20; ++k) {
                    ClientServerFunctionExecutionDUnitTest.assertEquals((boolean)true, (boolean)((List)resultList.get(j)).contains("execKey-" + k));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
    }

    public static void allServerExecution_SendException(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            ClientServerFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)(resultList.get(0) instanceof MyFunctionExecutionException));
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)(resultList.get(1) instanceof MyFunctionExecutionException));
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)(resultList.get(2) instanceof MyFunctionExecutionException));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
        try {
            HashSet<String> testKeysSet = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                testKeysSet.add("execKey-" + i);
            }
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, testKeysSet, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)(testKeysSet.size() * 3 + 3), (int)resultList.size());
            Iterator resultIterator = resultList.iterator();
            int exceptionCount = 0;
            while (resultIterator.hasNext()) {
                Object o = resultIterator.next();
                if (!(o instanceof MyFunctionExecutionException)) continue;
                ++exceptionCount;
            }
            ClientServerFunctionExecutionDUnitTest.assertEquals((int)3, (int)exceptionCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
    }

    public static void allServerExecution_NoLastResult(Boolean isByName, Function function, Boolean toRegister) {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            ClientServerFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            ResultCollector rs = ClientServerFunctionExecutionDUnitTest.execute(member, Boolean.TRUE, function, isByName);
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.fail((String)"Expected FunctionException : Function did not send last result");
        }
        catch (Exception ex) {
            ClientServerFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().contains("did not send last result"));
        }
    }

    public static void allServerExecution_Inline() {
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution member = FunctionService.onServers((Pool)pool);
        try {
            ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            List resultList = (List)rs.getResult();
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(0));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(1));
            ClientServerFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, resultList.get(2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            ClientServerFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation asdfasdfa   ");
        }
    }

    private static ResultCollector execute(Execution member, Serializable args, Function function, Boolean isByName) throws Exception {
        if (isByName.booleanValue()) {
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("The function name to execute : " + function.getId());
            Execution me = member.withArgs((Object)args);
            ClientServerFunctionExecutionDUnitTest.getLogWriter().info("The args passed  : " + args);
            return me.execute(function.getId());
        }
        return member.withArgs((Object)args).execute(function);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

