/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.KeyPartitionResolver;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class ColocationFailoverDUnitTest
extends DistributedTestCase {
    private static final long serialVersionUID = 1L;
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;
    protected static VM dataStore3 = null;
    protected static VM dataStore4 = null;
    protected static Region customerPR = null;
    protected static Region orderPR = null;
    protected static Region shipmentPR = null;
    public static String customerPR_Name = "ColocationFailoverDUnitTest_CustomerPR";
    public static String orderPR_Name = "ColocationFailoverDUnitTest_OrderPR";
    public static String shipmentPR_Name = "ColocationFailoverDUnitTest_ShipmentPR";
    protected static String excuse;

    public ColocationFailoverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
        dataStore3 = host.getVM(2);
        dataStore4 = host.getVM(3);
    }

    public void testPrimaryColocationFailover() throws Throwable {
        ColocationFailoverDUnitTest.createCacheInAllVms();
        ColocationFailoverDUnitTest.createCustomerPR();
        ColocationFailoverDUnitTest.createOrderPR();
        ColocationFailoverDUnitTest.createShipmentPR();
        ColocationFailoverDUnitTest.putInPRs();
        this.verifyColocationInAllVms();
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "closeCache");
        this.verifyPrimaryColocationAfterFailover();
    }

    public void testColocationFailover() throws Throwable {
        ColocationFailoverDUnitTest.createCacheInAllVms();
        ColocationFailoverDUnitTest.createCustomerPR();
        ColocationFailoverDUnitTest.createOrderPR();
        ColocationFailoverDUnitTest.createShipmentPR();
        ColocationFailoverDUnitTest.putInPRs();
        this.verifyColocationInAllVms();
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "closeCache");
        ColocationFailoverDUnitTest.pause(5000);
        this.verifyColocationAfterFailover();
    }

    private void verifyColocationInAllVms() {
        ColocationFailoverDUnitTest.verifyColocation();
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
    }

    private void verifyPrimaryColocationAfterFailover() {
        ColocationFailoverDUnitTest.verifyPrimaryColocation();
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "verifyPrimaryColocation");
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "verifyPrimaryColocation");
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "verifyPrimaryColocation");
    }

    private void verifyColocationAfterFailover() {
        ColocationFailoverDUnitTest.verifyColocation();
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "verifyColocation");
    }

    public static void closeCache() {
        cache.close();
    }

    protected static boolean tryVerifyPrimaryColocation() {
        int s2;
        HashMap<Integer, String> customerPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor customeAdvisor = ((PartitionedRegion)customerPR).getRegionAdvisor();
        for (Integer bucketId : customeAdvisor.getBucketSet()) {
            if (!customeAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            customerPrimaryMap.put(bucketId, customeAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        HashMap<Integer, String> orderPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor orderAdvisor = ((PartitionedRegion)orderPR).getRegionAdvisor();
        for (Integer bucketId : orderAdvisor.getBucketSet()) {
            if (!orderAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            orderPrimaryMap.put(bucketId, orderAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        HashMap<Integer, String> shipmentPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor shipmentAdvisor = ((PartitionedRegion)shipmentPR).getRegionAdvisor();
        for (Integer bucketId : shipmentAdvisor.getBucketSet()) {
            if (!shipmentAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            shipmentPrimaryMap.put(bucketId, shipmentAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        int s1 = customerPrimaryMap.size();
        if (s1 != (s2 = orderPrimaryMap.size())) {
            excuse = "customerPrimaryMap size (" + s1 + ") != orderPrimaryMap size (" + s2 + ")";
            return false;
        }
        if (!customerPrimaryMap.entrySet().equals(orderPrimaryMap.entrySet())) {
            excuse = "customerPrimaryMap entrySet != orderPrimaryMap entrySet";
            return false;
        }
        if (!customerPrimaryMap.entrySet().equals(shipmentPrimaryMap.entrySet())) {
            excuse = "customerPrimaryMap entrySet != shipmentPrimaryMap entrySet";
            return false;
        }
        if (!customerPrimaryMap.equals(orderPrimaryMap)) {
            excuse = "customerPrimaryMap != orderPrimaryMap";
            return false;
        }
        if (!customerPrimaryMap.equals(shipmentPrimaryMap)) {
            excuse = "customerPrimaryMap != shipmentPrimaryMap";
            return false;
        }
        return true;
    }

    private static void verifyPrimaryColocation() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ColocationFailoverDUnitTest.tryVerifyPrimaryColocation();
            }

            @Override
            public String description() {
                return excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    protected static void dump() {
        int i;
        LogWriterI18n logger = ColocationFailoverDUnitTest.getLogWriter().convertToLogWriterI18n();
        ((PartitionedRegion)customerPR).dumpAllBuckets(false, logger);
        ((PartitionedRegion)orderPR).dumpAllBuckets(false, logger);
        ((PartitionedRegion)shipmentPR).dumpAllBuckets(false, logger);
        for (i = 0; i < 6; ++i) {
            ((PartitionedRegion)customerPR).dumpB2NForBucket(i);
        }
        for (i = 0; i < 6; ++i) {
            ((PartitionedRegion)orderPR).dumpB2NForBucket(i);
        }
        for (i = 0; i < 6; ++i) {
            ((PartitionedRegion)shipmentPR).dumpB2NForBucket(i);
        }
    }

    protected static boolean tryVerifyColocation() {
        HashMap<Integer, Set> customerMap = new HashMap<Integer, Set>();
        HashMap<Integer, String> customerPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor customeAdvisor = ((PartitionedRegion)customerPR).getRegionAdvisor();
        for (Integer bucketId : customeAdvisor.getBucketSet()) {
            Set someOwners = customeAdvisor.getBucketOwners(bucketId.intValue());
            customerMap.put(bucketId, someOwners);
            if (!customeAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            customerPrimaryMap.put(bucketId, customeAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        HashMap<Integer, Set> orderMap = new HashMap<Integer, Set>();
        HashMap<Integer, String> orderPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor orderAdvisor = ((PartitionedRegion)orderPR).getRegionAdvisor();
        for (Integer bucketId : orderAdvisor.getBucketSet()) {
            Set someOwners = orderAdvisor.getBucketOwners(bucketId.intValue());
            orderMap.put(bucketId, someOwners);
            if (!orderAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            orderPrimaryMap.put(bucketId, orderAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        HashMap<Integer, Set> shipmentMap = new HashMap<Integer, Set>();
        HashMap<Integer, String> shipmentPrimaryMap = new HashMap<Integer, String>();
        RegionAdvisor shipmentAdvisor = ((PartitionedRegion)shipmentPR).getRegionAdvisor();
        for (Integer bucketId : shipmentAdvisor.getBucketSet()) {
            Set someOwners = shipmentAdvisor.getBucketOwners(bucketId.intValue());
            shipmentMap.put(bucketId, someOwners);
            if (!customerMap.get(bucketId).equals(someOwners)) {
                excuse = "customerMap at " + bucketId + " has wrong owners";
                return false;
            }
            if (!orderMap.get(bucketId).equals(someOwners)) {
                excuse = "orderMap at " + bucketId + " has wrong owners";
                return false;
            }
            if (!shipmentAdvisor.isPrimaryForBucket(bucketId.intValue())) continue;
            shipmentPrimaryMap.put(bucketId, shipmentAdvisor.getPrimaryMemberForBucket(bucketId.intValue()).getId());
        }
        if (customerPrimaryMap.size() != orderPrimaryMap.size()) {
            excuse = "customerPrimaryMap and orderPrimaryMap have different sizes";
            return false;
        }
        if (customerPrimaryMap.size() != shipmentPrimaryMap.size()) {
            excuse = "customerPrimaryMap and shipmentPrimaryMap have different sizes";
            return false;
        }
        if (!customerPrimaryMap.entrySet().equals(orderPrimaryMap.entrySet())) {
            excuse = "customerPrimaryMap and orderPrimaryMap have different entrySets";
            return false;
        }
        if (!customerPrimaryMap.entrySet().equals(shipmentPrimaryMap.entrySet())) {
            excuse = "customerPrimaryMap and shipmentPrimaryMap have different entrySets";
            return false;
        }
        if (!customerPrimaryMap.equals(orderPrimaryMap)) {
            excuse = "customerPrimaryMap and orderPrimaryMap not equal";
            return false;
        }
        if (!customerPrimaryMap.equals(shipmentPrimaryMap)) {
            excuse = "customerPrimaryMap and shipmentPrimaryMap not equal";
            return false;
        }
        if (customerMap.size() != orderMap.size()) {
            excuse = "customerMap and orderMap have different sizes";
            return false;
        }
        if (customerMap.size() != shipmentMap.size()) {
            excuse = "customerMap and shipmentMap have different sizes";
            return false;
        }
        if (!customerMap.entrySet().equals(orderMap.entrySet())) {
            excuse = "customerMap and orderMap have different entrySets";
            return false;
        }
        if (!customerMap.entrySet().equals(shipmentMap.entrySet())) {
            excuse = "customerMap and shipmentMap have different entrySets";
            return false;
        }
        if (!customerMap.equals(orderMap)) {
            excuse = "customerMap and orderMap not equal";
            return false;
        }
        if (!customerMap.equals(shipmentMap)) {
            excuse = "customerMap and shipmentMap not equal";
            return false;
        }
        return true;
    }

    private static void verifyColocation() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ColocationFailoverDUnitTest.tryVerifyColocation();
            }

            @Override
            public String description() {
                return excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    public static void createCacheInAllVms() {
        ColocationFailoverDUnitTest.createCacheInVm();
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "createCacheInVm");
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "createCacheInVm");
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "createCacheInVm");
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "createCacheInVm");
    }

    public static void createCacheInVm() {
        new ColocationFailoverDUnitTest("temp").createCache();
    }

    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            ColocationFailoverDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            ColocationFailoverDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            ColocationFailoverDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    private static void createCustomerPR() {
        Object[] args = new Object[]{customerPR_Name, new Integer(1), new Integer(50), new Integer(6), null};
        ColocationFailoverDUnitTest.createPR(customerPR_Name, new Integer(1), new Integer(50), new Integer(6), null);
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
    }

    private static void createOrderPR() {
        Object[] args = new Object[]{orderPR_Name, new Integer(1), new Integer(50), new Integer(6), customerPR_Name};
        ColocationFailoverDUnitTest.createPR(orderPR_Name, new Integer(1), new Integer(50), new Integer(6), customerPR_Name);
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
    }

    private static void createShipmentPR() {
        Object[] args = new Object[]{shipmentPR_Name, new Integer(1), new Integer(50), new Integer(6), orderPR_Name};
        ColocationFailoverDUnitTest.createPR(shipmentPR_Name, new Integer(1), new Integer(50), new Integer(6), orderPR_Name);
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "createPR", args);
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, String colocatedWith) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith(colocatedWith).setPartitionResolver((PartitionResolver)new KeyPartitionResolver()).create();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(prAttr);
        ColocationFailoverDUnitTest.assertNotNull((Object)cache);
        if (partitionedRegionName.equals(customerPR_Name)) {
            customerPR = cache.createRegion(partitionedRegionName, attr.create());
            ColocationFailoverDUnitTest.assertNotNull((Object)customerPR);
            ColocationFailoverDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + customerPR);
        }
        if (partitionedRegionName.equals(orderPR_Name)) {
            orderPR = cache.createRegion(partitionedRegionName, attr.create());
            ColocationFailoverDUnitTest.assertNotNull((Object)orderPR);
            ColocationFailoverDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + orderPR);
        }
        if (partitionedRegionName.equals(shipmentPR_Name)) {
            shipmentPR = cache.createRegion(partitionedRegionName, attr.create());
            ColocationFailoverDUnitTest.assertNotNull((Object)shipmentPR);
            ColocationFailoverDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + shipmentPR);
        }
    }

    private static void putInPRs() {
        ColocationFailoverDUnitTest.put();
        dataStore1.invoke(ColocationFailoverDUnitTest.class, "put");
        dataStore2.invoke(ColocationFailoverDUnitTest.class, "put");
        dataStore3.invoke(ColocationFailoverDUnitTest.class, "put");
        dataStore4.invoke(ColocationFailoverDUnitTest.class, "put");
    }

    public static void put() {
        for (int i = 0; i < 20; ++i) {
            customerPR.put((Object)("CPing--" + i), (Object)("CPong--" + i));
            orderPR.put((Object)("OPing--" + i), (Object)("OPong--" + i));
            shipmentPR.put((Object)("SPing--" + i), (Object)("SPong--" + i));
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

