/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import com.gemstone.gemfire.internal.cache.execute.FunctionServiceStats;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class FunctionServiceStatsDUnitTest
extends PRClientServerTestBase {
    static Boolean isByName = null;
    static InternalDistributedSystem ds = null;
    static int noOfExecutionCalls_Aggregate = 0;
    static int noOfExecutionsCompleted_Aggregate = 0;
    static int resultReceived_Aggregate = 0;
    static int noOfExecutionExceptions_Aggregate = 0;
    static int noOfExecutionCalls_TESTFUNCTION1 = 0;
    static int noOfExecutionsCompleted_TESTFUNCTION1 = 0;
    static int resultReceived_TESTFUNCTION1 = 0;
    static int noOfExecutionExceptions_TESTFUNCTION1 = 0;
    static int noOfExecutionCalls_TESTFUNCTION2 = 0;
    static int noOfExecutionsCompleted_TESTFUNCTION2 = 0;
    static int resultReceived_TESTFUNCTION2 = 0;
    static int noOfExecutionExceptions_TESTFUNCTION2 = 0;
    static int noOfExecutionCalls_TESTFUNCTION3 = 0;
    static int noOfExecutionsCompleted_TESTFUNCTION3 = 0;
    static int resultReceived_TESTFUNCTION3 = 0;
    static int noOfExecutionExceptions_TESTFUNCTION3 = 0;
    static int noOfExecutionCalls_TESTFUNCTION5 = 0;
    static int noOfExecutionsCompleted_TESTFUNCTION5 = 0;
    static int resultReceived_TESTFUNCTION5 = 0;
    static int noOfExecutionExceptions_TESTFUNCTION5 = 0;
    static int noOfExecutionCalls_Inline = 0;
    static int noOfExecutionsCompleted_Inline = 0;
    static int resultReceived_Inline = 0;
    static int noOfExecutionExceptions_Inline = 0;
    static int noOfExecutionCalls_TestFunctionException = 0;
    static int noOfExecutionsCompleted_TestFunctionException = 0;
    static int resultReceived_TestFunctionException = 0;
    static int noOfExecutionExceptions_TestFunctionException = 0;
    final SerializableCallable initializeStats = new SerializableCallable("initializeStats"){

        public Object call() throws Exception {
            noOfExecutionCalls_Aggregate = 0;
            noOfExecutionsCompleted_Aggregate = 0;
            resultReceived_Aggregate = 0;
            noOfExecutionExceptions_Aggregate = 0;
            noOfExecutionCalls_TESTFUNCTION1 = 0;
            noOfExecutionsCompleted_TESTFUNCTION1 = 0;
            resultReceived_TESTFUNCTION1 = 0;
            noOfExecutionExceptions_TESTFUNCTION1 = 0;
            noOfExecutionCalls_TESTFUNCTION2 = 0;
            noOfExecutionsCompleted_TESTFUNCTION2 = 0;
            resultReceived_TESTFUNCTION2 = 0;
            noOfExecutionExceptions_TESTFUNCTION2 = 0;
            noOfExecutionCalls_TESTFUNCTION3 = 0;
            noOfExecutionsCompleted_TESTFUNCTION3 = 0;
            resultReceived_TESTFUNCTION3 = 0;
            noOfExecutionExceptions_TESTFUNCTION3 = 0;
            noOfExecutionCalls_TESTFUNCTION5 = 0;
            noOfExecutionsCompleted_TESTFUNCTION5 = 0;
            resultReceived_TESTFUNCTION5 = 0;
            noOfExecutionExceptions_TESTFUNCTION5 = 0;
            noOfExecutionCalls_Inline = 0;
            noOfExecutionsCompleted_Inline = 0;
            resultReceived_Inline = 0;
            noOfExecutionExceptions_Inline = 0;
            noOfExecutionCalls_TestFunctionException = 0;
            noOfExecutionsCompleted_TestFunctionException = 0;
            resultReceived_TestFunctionException = 0;
            noOfExecutionExceptions_TestFunctionException = 0;
            return Boolean.TRUE;
        }
    };

    public FunctionServiceStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testClientServerPartitonedRegionFunctionExecutionStats() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "TestFunction2");
        this.registerFunctionAtServer((Function)function);
        function = new TestFunction(true, "TestFunction3");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(this.initializeStats);
        server1.invoke(this.initializeStats);
        server2.invoke(this.initializeStats);
        server3.invoke(this.initializeStats);
        SerializableCallable PopulateRegionAndExecuteFunctions = new SerializableCallable("PopulateRegionAndExecuteFunctions"){

            public Object call() throws Exception {
                Region region = PRClientServerTestBase.cache.getRegion(PRClientServerTestBase.PartitionedRegionName);
                TestCase.assertNotNull((Object)region);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = PRClientServerTestBase.totalNumBuckets * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "TestFunction2");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)region);
                try {
                    int j = 0;
                    HashSet<Integer> origVals = new HashSet<Integer>();
                    Iterator i = testKeysSet.iterator();
                    while (i.hasNext()) {
                        Integer val = new Integer(j++);
                        origVals.add(val);
                        region.put(i.next(), (Object)val);
                    }
                    ResultCollector rc = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    int resultSize = ((List)rc.getResult()).size();
                    resultReceived_Aggregate += resultSize;
                    resultReceived_TESTFUNCTION2 += resultSize;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionCalls_TESTFUNCTION2;
                    ++noOfExecutionsCompleted_Aggregate;
                    ++noOfExecutionsCompleted_TESTFUNCTION2;
                    rc = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute(function.getId());
                    resultSize = ((List)rc.getResult()).size();
                    resultReceived_Aggregate += resultSize;
                    resultReceived_TESTFUNCTION2 += resultSize;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionCalls_TESTFUNCTION2;
                    ++noOfExecutionsCompleted_Aggregate;
                    ++noOfExecutionsCompleted_TESTFUNCTION2;
                    function = new TestFunction(true, "TestFunction3");
                    FunctionService.registerFunction((Function)function);
                    rc = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    resultSize = ((List)rc.getResult()).size();
                    resultReceived_Aggregate += resultSize;
                    resultReceived_TESTFUNCTION3 += resultSize;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionCalls_TESTFUNCTION3;
                    ++noOfExecutionsCompleted_Aggregate;
                    ++noOfExecutionsCompleted_TESTFUNCTION3;
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().info("Exception : " + e.getMessage());
                    e.printStackTrace();
                    TestCase.fail((String)"Test failed after the put operation");
                }
                return Boolean.TRUE;
            }
        };
        client.invoke(PopulateRegionAndExecuteFunctions);
        SerializableCallable checkStatsOnClient = new SerializableCallable("checkStatsOnClient"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)PRClientServerTestBase.cache.getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertTrue((functionServiceStats.getResultsReceived() >= resultReceived_Aggregate ? 1 : 0) != 0);
                DistributedTestCase.getLogWriter().info("Calling FunctionStats for  TEST_FUNCTION2 :");
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction2", (InternalDistributedSystem)iDS);
                DistributedTestCase.getLogWriter().info("Called FunctionStats for  TEST_FUNCTION2 :");
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION2, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION2, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertTrue((functionStats.getResultsReceived() >= resultReceived_TESTFUNCTION2 ? 1 : 0) != 0);
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction3", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION3, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION3, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertTrue((functionStats.getResultsReceived() >= resultReceived_TESTFUNCTION3 ? 1 : 0) != 0);
                return Boolean.TRUE;
            }
        };
        client.invoke(checkStatsOnClient);
        SerializableCallable checkStatsOnServer = new SerializableCallable("checkStatsOnClient"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)PRClientServerTestBase.cache.getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertTrue((functionServiceStats.getFunctionExecutionCalls() >= (noOfExecutionCalls_Aggregate += 3) ? 1 : 0) != 0);
                TestCase.assertTrue((functionServiceStats.getFunctionExecutionsCompleted() >= (noOfExecutionsCompleted_Aggregate += 3) ? 1 : 0) != 0);
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction2", (InternalDistributedSystem)iDS);
                TestCase.assertTrue((functionStats.getFunctionExecutionCalls() >= (noOfExecutionCalls_TESTFUNCTION2 += 2) ? 1 : 0) != 0);
                TestCase.assertTrue((functionStats.getFunctionExecutionsCompletedDN() >= (noOfExecutionsCompleted_TESTFUNCTION2 += 2) ? 1 : 0) != 0);
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction3", (InternalDistributedSystem)iDS);
                TestCase.assertTrue((functionStats.getFunctionExecutionCalls() >= ++noOfExecutionCalls_TESTFUNCTION3 ? 1 : 0) != 0);
                TestCase.assertTrue((functionStats.getFunctionExecutionsCompletedDN() >= ++noOfExecutionsCompleted_TESTFUNCTION3 ? 1 : 0) != 0);
                return Boolean.TRUE;
            }
        };
        server1.invoke(checkStatsOnServer);
        server2.invoke(checkStatsOnServer);
        server3.invoke(checkStatsOnServer);
    }

    public void testClientServerDistributedRegionFunctionExecutionStats() {
        String regionName = "FunctionServiceStatsDUnitTest";
        SerializableCallable createCahenServer = new SerializableCallable("createCahenServer"){

            public Object call() throws Exception {
                try {
                    Properties props = new Properties();
                    InternalDistributedSystem ds = FunctionServiceStatsDUnitTest.this.getSystem(props);
                    TestCase.assertNotNull((Object)ds);
                    ds.disconnect();
                    ds = FunctionServiceStatsDUnitTest.this.getSystem(props);
                    PRClientServerTestBase.cache = CacheFactory.create((DistributedSystem)ds);
                    DistributedTestCase.getLogWriter().info("Created Cache on Server");
                    TestCase.assertNotNull((Object)PRClientServerTestBase.cache);
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.DISTRIBUTED_ACK);
                    factory.setDataPolicy(DataPolicy.REPLICATE);
                    TestCase.assertNotNull((Object)PRClientServerTestBase.cache);
                    Region region = PRClientServerTestBase.cache.createRegion("FunctionServiceStatsDUnitTest", factory.create());
                    DistributedTestCase.getLogWriter().info("Region Created :" + region);
                    TestCase.assertNotNull((Object)region);
                    for (int i = 1; i <= 200; ++i) {
                        region.put((Object)("execKey-" + i), (Object)new Integer(i));
                    }
                    CacheServer server = PRClientServerTestBase.cache.addCacheServer();
                    TestCase.assertNotNull((Object)server);
                    int port = AvailablePort.getRandomAvailablePort((int)0);
                    server.setPort(port);
                    try {
                        server.start();
                    }
                    catch (IOException e) {
                        DistributedTestCase.fail("Failed to start the Server", e);
                    }
                    TestCase.assertTrue((boolean)server.isRunning());
                    return new Integer(server.getPort());
                }
                catch (Exception e) {
                    DistributedTestCase.fail("FunctionServiceStatsDUnitTest#createCache() Failed while creating the cache", e);
                    throw e;
                }
            }
        };
        final Integer port1 = (Integer)server1.invoke(createCahenServer);
        final Integer port2 = (Integer)server2.invoke(createCahenServer);
        final Integer port3 = (Integer)server3.invoke(createCahenServer);
        SerializableCallable createCaheInClient = new SerializableCallable("createCaheInClient"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                try {
                    Pool p;
                    Properties props = new Properties();
                    props.put("mcast-port", "0");
                    props.put("locators", "");
                    InternalDistributedSystem ds = FunctionServiceStatsDUnitTest.this.getSystem(props);
                    TestCase.assertNotNull((Object)ds);
                    ds.disconnect();
                    ds = FunctionServiceStatsDUnitTest.this.getSystem(props);
                    PRClientServerTestBase.cache = CacheFactory.create((DistributedSystem)ds);
                    DistributedTestCase.getLogWriter().info("Created Cache on Client");
                    TestCase.assertNotNull((Object)PRClientServerTestBase.cache);
                    CacheServerTestUtil.disableShufflingOfEndpoints();
                    try {
                        p = PoolManager.createFactory().addServer("localhost", port1.intValue()).addServer("localhost", port2.intValue()).addServer("localhost", port3.intValue()).setPingInterval(250L).setSubscriptionEnabled(false).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create("FunctionServiceStatsDUnitTest_pool");
                    }
                    finally {
                        CacheServerTestUtil.enableShufflingOfEndpoints();
                    }
                    AttributesFactory factory = new AttributesFactory();
                    factory.setScope(Scope.LOCAL);
                    factory.setDataPolicy(DataPolicy.EMPTY);
                    factory.setPoolName(p.getName());
                    TestCase.assertNotNull((Object)PRClientServerTestBase.cache);
                    Region region = PRClientServerTestBase.cache.createRegion("FunctionServiceStatsDUnitTest", factory.create());
                    DistributedTestCase.getLogWriter().info("Client Region Created :" + region);
                    TestCase.assertNotNull((Object)region);
                    for (int i = 1; i <= 200; ++i) {
                        region.put((Object)("execKey-" + i), (Object)new Integer(i));
                    }
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    DistributedTestCase.fail("FunctionServiceStatsDUnitTest#createCache() Failed while creating the cache", e);
                    throw e;
                }
            }
        };
        client.invoke(createCaheInClient);
        client.invoke(this.initializeStats);
        server1.invoke(this.initializeStats);
        server2.invoke(this.initializeStats);
        server3.invoke(this.initializeStats);
        TestFunction function = new TestFunction(true, "TestFunction2");
        this.registerFunctionAtServer((Function)function);
        function = new TestFunction(true, "TestFunction3");
        this.registerFunctionAtServer((Function)function);
        SerializableCallable ExecuteFunctions = new SerializableCallable("PopulateRegionAndExecuteFunctions"){

            public Object call() throws Exception {
                TestFunction function2 = new TestFunction(true, "TestFunction2");
                FunctionService.registerFunction((Function)function2);
                TestFunction function3 = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function3);
                Region region = PRClientServerTestBase.cache.getRegion("FunctionServiceStatsDUnitTest");
                HashSet<String> filter = new HashSet<String>();
                for (int i = 100; i < 120; ++i) {
                    filter.add("execKey-" + i);
                }
                try {
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionCalls_TESTFUNCTION2;
                    List list = (List)FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)function2).getResult();
                    ++noOfExecutionsCompleted_Aggregate;
                    ++noOfExecutionsCompleted_TESTFUNCTION2;
                    int size = list.size();
                    resultReceived_Aggregate += size;
                    resultReceived_TESTFUNCTION2 += size;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionCalls_TESTFUNCTION2;
                    list = (List)FunctionService.onRegion((Region)region).withFilter(filter).execute((Function)function2).getResult();
                    ++noOfExecutionsCompleted_Aggregate;
                    ++noOfExecutionsCompleted_TESTFUNCTION2;
                    size = list.size();
                    resultReceived_Aggregate += size;
                    resultReceived_TESTFUNCTION2 += size;
                    return Boolean.TRUE;
                }
                catch (FunctionException e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("test failed due to", e);
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("test failed due to", e);
                    throw e;
                }
            }
        };
        client.invoke(ExecuteFunctions);
        SerializableCallable checkStatsOnClient = new SerializableCallable("checkStatsOnClient"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)PRClientServerTestBase.cache.getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_Aggregate, (int)functionServiceStats.getResultsReceived());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction2", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION2, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION2, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertEquals((int)resultReceived_TESTFUNCTION2, (int)functionStats.getResultsReceived());
                return Boolean.TRUE;
            }
        };
        client.invoke(checkStatsOnClient);
    }

    public void testClientServerwithoutRegion() {
        this.createClientServerScenarionWithoutRegion();
        TestFunction function = new TestFunction(true, "TestFunction1");
        this.registerFunctionAtServer((Function)function);
        function = new TestFunction(true, "TestFunction5");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(this.initializeStats);
        server1.invoke(this.initializeStats);
        server2.invoke(this.initializeStats);
        server3.invoke(this.initializeStats);
        SerializableCallable ExecuteFunction = new SerializableCallable("ExecuteFunction"){

            public Object call() throws Exception {
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "TestFunction1");
                FunctionService.registerFunction((Function)function);
                Execution member = FunctionService.onServers((Pool)PRClientServerTestBase.pool);
                try {
                    ResultCollector rs = member.withArgs((Object)Boolean.TRUE).execute(function.getId());
                    int size = ((List)rs.getResult()).size();
                    resultReceived_Aggregate += size;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionsCompleted_Aggregate;
                    resultReceived_TESTFUNCTION1 += size;
                    ++noOfExecutionCalls_TESTFUNCTION1;
                    ++noOfExecutionsCompleted_TESTFUNCTION1;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Exception : ", (Throwable)ex);
                    TestCase.fail((String)"Test failed after the execute operation nn TRUE");
                }
                function = new TestFunction(true, "TestFunction5");
                FunctionService.registerFunction((Function)function);
                try {
                    HashSet<String> testKeysSet = new HashSet<String>();
                    for (int i = 0; i < 20; ++i) {
                        testKeysSet.add("execKey-" + i);
                    }
                    ResultCollector rs = member.withArgs((Object)"Success").execute(function.getId());
                    int size = ((List)rs.getResult()).size();
                    resultReceived_Aggregate += size;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionsCompleted_Aggregate;
                    resultReceived_TESTFUNCTION5 += size;
                    ++noOfExecutionCalls_TESTFUNCTION5;
                    ++noOfExecutionsCompleted_TESTFUNCTION5;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Exception : ", (Throwable)ex);
                    TestCase.fail((String)"Test failed after the execute operationssssss");
                }
                return Boolean.TRUE;
            }
        };
        client.invoke(ExecuteFunction);
        SerializableCallable checkStatsOnClient = new SerializableCallable("checkStatsOnClient"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)PRClientServerTestBase.cache.getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_Aggregate, (int)functionServiceStats.getResultsReceived());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction1", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION1, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION1, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertEquals((int)resultReceived_TESTFUNCTION1, (int)functionStats.getResultsReceived());
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction5", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION5, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION5, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertEquals((int)resultReceived_TESTFUNCTION5, (int)functionStats.getResultsReceived());
                return Boolean.TRUE;
            }
        };
        client.invoke(checkStatsOnClient);
        SerializableCallable checkStatsOnServer = new SerializableCallable("checkStatsOnClient"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)PRClientServerTestBase.cache.getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)(noOfExecutionCalls_Aggregate += 2), (int)functionServiceStats.getFunctionExecutionCalls());
                noOfExecutionsCompleted_Aggregate += 2;
                for (int i = 0; i < 10; ++i) {
                    try {
                        TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                        continue;
                    }
                    catch (RuntimeException r) {
                        if (i == 9) {
                            throw r;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw r;
                        }
                    }
                }
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction1", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)(++noOfExecutionCalls_TESTFUNCTION1), (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)(++noOfExecutionsCompleted_TESTFUNCTION1), (int)functionStats.getFunctionExecutionsCompletedDN());
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction5", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)(++noOfExecutionCalls_TESTFUNCTION5), (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)(++noOfExecutionsCompleted_TESTFUNCTION5), (int)functionStats.getFunctionExecutionsCompletedDN());
                return Boolean.TRUE;
            }
        };
        server1.invoke(checkStatsOnServer);
        server2.invoke(checkStatsOnServer);
        server3.invoke(checkStatsOnServer);
    }

    public void testP2PDummyExecutionStats() throws Exception {
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM accessor = host.getVM(3);
        SerializableCallable closeDistributedSystem = new SerializableCallable("closeDistributedSystem"){

            public Object call() throws Exception {
                if (FunctionServiceStatsDUnitTest.this.getCache() != null && !FunctionServiceStatsDUnitTest.this.getCache().isClosed()) {
                    FunctionServiceStatsDUnitTest.this.getCache().close();
                    FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem().disconnect();
                }
                return Boolean.TRUE;
            }
        };
        accessor.invoke(closeDistributedSystem);
        datastore0.invoke(closeDistributedSystem);
        datastore1.invoke(closeDistributedSystem);
        datastore2.invoke(closeDistributedSystem);
    }

    public void testP2PPartitionedRegionsFunctionExecutionStats() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM accessor = host.getVM(3);
        datastore0.invoke(this.initializeStats);
        datastore1.invoke(this.initializeStats);
        datastore2.invoke(this.initializeStats);
        accessor.invoke(this.initializeStats);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)FunctionServiceStatsDUnitTest.this.getCache().createRegion(rName, raf.create());
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)FunctionServiceStatsDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "TestFunction2");
                FunctionService.registerFunction((Function)function);
                function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionServiceStatsDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                TestFunction function = new TestFunction(true, "TestFunction2");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute((Function)function);
                int size = ((List)rc1.getResult()).size();
                resultReceived_Aggregate += size;
                resultReceived_TESTFUNCTION2 += size;
                rc1 = dataSet.withArgs(testKeys).execute((Function)function);
                size = ((List)rc1.getResult()).size();
                resultReceived_Aggregate += size;
                resultReceived_TESTFUNCTION2 += size;
                function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute((Function)function);
                size = ((List)rc1.getResult()).size();
                resultReceived_Aggregate += size;
                resultReceived_TESTFUNCTION3 += size;
                return Boolean.TRUE;
            }
        });
        accessor.invoke(new SerializableCallable("checkFunctionExecutionStatsForAccessor"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_Aggregate, (int)functionServiceStats.getResultsReceived());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction2", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION2, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION2, (int)functionStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_TESTFUNCTION2, (int)functionStats.getResultsReceived());
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction3", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)noOfExecutionCalls_TESTFUNCTION3, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TESTFUNCTION3, (int)functionStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_TESTFUNCTION3, (int)functionStats.getResultsReceived());
                return Boolean.TRUE;
            }
        });
        SerializableCallable checkFunctionExecutionStatsForDataStore = new SerializableCallable("checkFunctionExecutionStatsForDataStore"){

            public Object call() throws Exception {
                InternalDistributedSystem iDS = (InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem();
                FunctionServiceStats functionServiceStats = iDS.getFunctionServiceStats();
                TestCase.assertEquals((int)(noOfExecutionCalls_Aggregate += 3), (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)(noOfExecutionsCompleted_Aggregate += 3), (int)functionServiceStats.getFunctionExecutionsCompleted());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunction2", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)(noOfExecutionCalls_TESTFUNCTION2 += 2), (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)(noOfExecutionsCompleted_TESTFUNCTION2 += 2), (int)functionStats.getFunctionExecutionsCompletedDN());
                functionStats = FunctionStats.getFunctionStats((String)"TestFunction3", (InternalDistributedSystem)iDS);
                TestCase.assertEquals((int)(++noOfExecutionCalls_TESTFUNCTION3), (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)(++noOfExecutionsCompleted_TESTFUNCTION3), (int)functionStats.getFunctionExecutionsCompletedDN());
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(checkFunctionExecutionStatsForDataStore);
        datastore1.invoke(checkFunctionExecutionStatsForDataStore);
        datastore2.invoke(checkFunctionExecutionStatsForDataStore);
        SerializableCallable closeDistributedSystem = new SerializableCallable("closeDistributedSystem"){

            public Object call() throws Exception {
                if (FunctionServiceStatsDUnitTest.this.getCache() != null && !FunctionServiceStatsDUnitTest.this.getCache().isClosed()) {
                    FunctionServiceStatsDUnitTest.this.getCache().close();
                    FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem().disconnect();
                }
                return Boolean.TRUE;
            }
        };
        accessor.invoke(closeDistributedSystem);
        datastore0.invoke(closeDistributedSystem);
        datastore1.invoke(closeDistributedSystem);
        datastore2.invoke(closeDistributedSystem);
    }

    public void testP2PDistributedRegionFunctionExecutionStats() {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        datastore0.invoke(this.initializeStats);
        datastore1.invoke(this.initializeStats);
        datastore2.invoke(this.initializeStats);
        datastore3.invoke(this.initializeStats);
        SerializableCallable createAndPopulateRegionWithEmpty = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                Region region = FunctionServiceStatsDUnitTest.this.getCache().createRegion(rName, factory.create());
                DistributedTestCase.getLogWriter().info("Region Created :" + region);
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)new TestFunction(true, "TestFunction2"));
                for (int i = 1; i <= 200; ++i) {
                    region.put((Object)("execKey-" + i), (Object)new Integer(i));
                }
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(createAndPopulateRegionWithEmpty);
        SerializableCallable createAndPopulateRegionWithReplicate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                Region region = FunctionServiceStatsDUnitTest.this.getCache().createRegion(rName, factory.create());
                DistributedTestCase.getLogWriter().info("Region Created :" + region);
                TestCase.assertNotNull((Object)region);
                FunctionService.registerFunction((Function)new TestFunction(true, "TestFunction2"));
                for (int i = 1; i <= 200; ++i) {
                    region.put((Object)("execKey-" + i), (Object)new Integer(i));
                }
                return Boolean.TRUE;
            }
        };
        datastore1.invoke(createAndPopulateRegionWithReplicate);
        datastore2.invoke(createAndPopulateRegionWithReplicate);
        datastore3.invoke(createAndPopulateRegionWithReplicate);
        SerializableCallable executeFunction = new SerializableCallable("ExecuteFunction from Normal Region"){

            public Object call() throws Exception {
                Region region = FunctionServiceStatsDUnitTest.this.getCache().getRegion(rName);
                try {
                    List list = (List)FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute("TestFunction2").getResult();
                    TestCase.assertEquals((int)(resultReceived_Aggregate += list.size()), (int)((InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem()).getFunctionServiceStats().getResultsReceived());
                    TestCase.assertEquals((int)(resultReceived_TESTFUNCTION2 += list.size()), (int)((InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem()).getFunctionServiceStats().getResultsReceived());
                    return Boolean.TRUE;
                }
                catch (FunctionException e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("test failed due to", e);
                    return Boolean.FALSE;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("test failed due to", e);
                    return Boolean.FALSE;
                }
            }
        };
        datastore0.invoke(executeFunction);
        SerializableCallable closeDistributedSystem = new SerializableCallable("closeDistributedSystem"){

            public Object call() throws Exception {
                if (FunctionServiceStatsDUnitTest.this.getCache() != null && !FunctionServiceStatsDUnitTest.this.getCache().isClosed()) {
                    FunctionServiceStatsDUnitTest.this.getCache().close();
                    FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem().disconnect();
                }
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(closeDistributedSystem);
        datastore1.invoke(closeDistributedSystem);
        datastore2.invoke(closeDistributedSystem);
        datastore3.invoke(closeDistributedSystem);
    }

    public void testP2PMembersFunctionExecutionStats() throws Exception {
        Host host = Host.getHost(0);
        VM member1 = host.getVM(0);
        VM member2 = host.getVM(1);
        VM member3 = host.getVM(2);
        VM member4 = host.getVM(3);
        SerializableCallable connectToDistributedSystem = new SerializableCallable("connectToDistributedSystem"){

            public Object call() throws Exception {
                Properties props = new Properties();
                try {
                    ds = FunctionServiceStatsDUnitTest.this.getSystem(props);
                    TestCase.assertNotNull((Object)ds);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed while creating the Distribued System", e);
                }
                return Boolean.TRUE;
            }
        };
        member1.invoke(connectToDistributedSystem);
        member2.invoke(connectToDistributedSystem);
        member3.invoke(connectToDistributedSystem);
        member4.invoke(connectToDistributedSystem);
        member1.invoke(this.initializeStats);
        member2.invoke(this.initializeStats);
        member3.invoke(this.initializeStats);
        member4.invoke(this.initializeStats);
        boolean noOfMembers = true;
        FunctionAdapter inlineFunction = new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Success");
                } else {
                    context.getResultSender().lastResult((Object)"Failure");
                }
            }

            public String getId() {
                return ((Object)((Object)this)).getClass().getName();
            }

            public boolean hasResult() {
                return true;
            }
        };
        member1.invoke(new SerializableCallable("excuteOnMembers_InlineFunction", (Function)inlineFunction){
            final /* synthetic */ Function val$inlineFunction;
            {
                this.val$inlineFunction = function;
                super(x0);
            }

            public Object call() throws Exception {
                TestCase.assertNotNull((Object)ds);
                Execution memberExecution = null;
                InternalDistributedMember localmember = ds.getDistributedMember();
                memberExecution = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)localmember);
                memberExecution.withArgs((Object)"Key");
                try {
                    ResultCollector rc = memberExecution.execute(this.val$inlineFunction);
                    int size = ((List)rc.getResult()).size();
                    resultReceived_Aggregate += size;
                    ++noOfExecutionCalls_Aggregate;
                    ++noOfExecutionsCompleted_Aggregate;
                    resultReceived_Inline += size;
                    ++noOfExecutionCalls_Inline;
                    ++noOfExecutionsCompleted_Inline;
                }
                catch (Exception e) {
                    DistributedTestCase.getLogWriter().info("Exception Occured : " + e.getMessage());
                    e.printStackTrace();
                    DistributedTestCase.fail("Test failed", e);
                }
                return Boolean.TRUE;
            }
        });
        member1.invoke(new SerializableCallable("checkFunctionExecutionStatsForMember1", (Function)inlineFunction){
            final /* synthetic */ Function val$inlineFunction;
            {
                this.val$inlineFunction = function;
                super(x0);
            }

            public Object call() throws Exception {
                FunctionServiceStats functionServiceStats = ds.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)resultReceived_Aggregate, (int)functionServiceStats.getResultsReceived());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)this.val$inlineFunction.getId(), (InternalDistributedSystem)ds);
                TestCase.assertEquals((int)noOfExecutionCalls_Inline, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Inline, (int)functionStats.getFunctionExecutionsCompletedDN());
                TestCase.assertEquals((int)resultReceived_Inline, (int)functionStats.getResultsReceived());
                return Boolean.TRUE;
            }
        });
        SerializableCallable checkFunctionExecutionStatsForOtherMember = new SerializableCallable("checkFunctionExecutionStatsForOtherMember", (Function)inlineFunction){
            final /* synthetic */ Function val$inlineFunction;
            {
                this.val$inlineFunction = function;
                super(x0);
            }

            public Object call() throws Exception {
                FunctionServiceStats functionServiceStats = ds.getFunctionServiceStats();
                TestCase.assertEquals((int)noOfExecutionCalls_Aggregate, (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)this.val$inlineFunction.getId(), (InternalDistributedSystem)ds);
                TestCase.assertEquals((int)noOfExecutionCalls_Inline, (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Inline, (int)functionStats.getFunctionExecutionsCompleted());
                return Boolean.TRUE;
            }
        };
        member2.invoke(checkFunctionExecutionStatsForOtherMember);
        member3.invoke(checkFunctionExecutionStatsForOtherMember);
        member4.invoke(checkFunctionExecutionStatsForOtherMember);
        SerializableCallable closeDistributedSystem = new SerializableCallable("closeDistributedSystem"){

            public Object call() throws Exception {
                if (FunctionServiceStatsDUnitTest.this.getCache() != null && !FunctionServiceStatsDUnitTest.this.getCache().isClosed()) {
                    FunctionServiceStatsDUnitTest.this.getCache().close();
                    FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem().disconnect();
                }
                return Boolean.TRUE;
            }
        };
        member1.invoke(closeDistributedSystem);
        member2.invoke(closeDistributedSystem);
        member3.invoke(closeDistributedSystem);
        member4.invoke(closeDistributedSystem);
    }

    public void testFunctionExecutionExceptionStatsOnAllNodesPRegion() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        datastore0.invoke(this.initializeStats);
        datastore1.invoke(this.initializeStats);
        datastore2.invoke(this.initializeStats);
        datastore3.invoke(this.initializeStats);
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionServiceStatsDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "TestFunctionException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionServiceStatsDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer key = new Integer(j++);
                    pr.put((Object)key, i.next());
                }
                try {
                    TestFunction function = new TestFunction(true, "TestFunctionException");
                    FunctionService.registerFunction((Function)function);
                    Execution dataSet = FunctionService.onRegion((Region)pr);
                    ResultCollector rc = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                        String excuse;

                        @Override
                        public boolean done() {
                            return false;
                        }

                        @Override
                        public String description() {
                            return this.excuse;
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 20000L, 1000L, false);
                    rc.getResult();
                }
                catch (Exception expected) {
                    return Boolean.TRUE;
                }
                TestCase.fail((String)"No exception Occured");
                return Boolean.FALSE;
            }
        });
        FunctionServiceStatsDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
        SerializableCallable checkFunctionExecutionStatsForDataStore = new SerializableCallable("checkFunctionExecutionStatsForDataStore"){

            public Object call() throws Exception {
                FunctionStats functionStats = FunctionStats.getFunctionStats((String)"TestFunctionException", (InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getSystem());
                TestCase.assertEquals((int)(++noOfExecutionCalls_TestFunctionException), (int)functionStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_TestFunctionException, (int)functionStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)(++noOfExecutionExceptions_TestFunctionException), (int)functionStats.getFunctionExecutionExceptions());
                FunctionServiceStats functionServiceStats = ((InternalDistributedSystem)FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem()).getFunctionServiceStats();
                TestCase.assertEquals((int)(++noOfExecutionCalls_Aggregate), (int)functionServiceStats.getFunctionExecutionCalls());
                TestCase.assertEquals((int)noOfExecutionsCompleted_Aggregate, (int)functionServiceStats.getFunctionExecutionsCompleted());
                TestCase.assertEquals((int)(++noOfExecutionExceptions_Aggregate), (int)functionServiceStats.getFunctionExecutionExceptions());
                return Boolean.TRUE;
            }
        };
        SerializableCallable closeDistributedSystem = new SerializableCallable("closeDistributedSystem"){

            public Object call() throws Exception {
                if (FunctionServiceStatsDUnitTest.this.getCache() != null && !FunctionServiceStatsDUnitTest.this.getCache().isClosed()) {
                    FunctionServiceStatsDUnitTest.this.getCache().close();
                    FunctionServiceStatsDUnitTest.this.getCache().getDistributedSystem().disconnect();
                }
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(closeDistributedSystem);
        datastore1.invoke(closeDistributedSystem);
        datastore2.invoke(closeDistributedSystem);
        datastore3.invoke(closeDistributedSystem);
    }

    private void createScenario() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

