/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.LDSPartitionResolver;
import com.gemstone.gemfire.internal.cache.functions.LocalDataSetFunction;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Iterator;

public class LocalDataSetDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;
    protected static VM dataStore3 = null;
    protected static VM accessor = null;
    protected static Region customerPR = null;
    protected static Region orderPR = null;
    protected static Region shipmentPR = null;
    static volatile boolean invoked = false;

    public LocalDataSetDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
        dataStore3 = host.getVM(2);
        accessor = host.getVM(3);
    }

    public void testLocalDataSet() {
        LocalDataSetDUnitTest.createCacheInAllVms();
        LocalDataSetDUnitTest.createCustomerPR();
        LocalDataSetDUnitTest.createOrderPR();
        LocalDataSetDUnitTest.createShipmentPR();
        LocalDataSetDUnitTest.putInPRs();
        this.registerFunctions();
        this.executeFunctions();
    }

    public void testLocalDataSetIteration() {
        LocalDataSetDUnitTest.createCacheInAllVms();
        LocalDataSetDUnitTest.createCustomerPR();
        LocalDataSetDUnitTest.createOrderPR();
        LocalDataSetDUnitTest.createShipmentPR();
        LocalDataSetDUnitTest.putInPRs();
        this.registerIteratorFunctionOnAll();
        SerializableCallable installHook = new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion("CustomerPR");
                ReadHook r = new ReadHook();
                pr.getDataStore().setBucketReadHook((Runnable)r);
                return null;
            }
        };
        this.invokeInAllDataStores(installHook);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = cache.getRegion("CustomerPR");
                HashSet<String> filter = new HashSet<String>();
                filter.add("1");
                FunctionService.onRegion((Region)region).withFilter(filter).execute("IteratorFunction", true, false, true).getResult();
                return null;
            }
        });
        SerializableCallable bucketRead = new SerializableCallable(){

            public Object call() throws Exception {
                return LocalDataSetDUnitTest.this.getHookInvoked();
            }
        };
        Integer ds1 = (Integer)dataStore1.invoke(bucketRead);
        Integer ds2 = (Integer)dataStore2.invoke(bucketRead);
        Integer ds3 = (Integer)dataStore3.invoke(bucketRead);
        LocalDataSetDUnitTest.assertEquals((int)1, (int)(ds1 + ds2 + ds3));
    }

    private void invokeInAllDataStores(SerializableCallable installHook) {
        dataStore1.invoke(installHook);
        dataStore2.invoke(installHook);
        dataStore3.invoke(installHook);
    }

    public static void setHookInvoked() {
        invoked = true;
    }

    public Integer getHookInvoked() {
        if (invoked) {
            return 1;
        }
        return 0;
    }

    private void executeFunctions() {
        dataStore1.invoke(LocalDataSetDUnitTest.class, "executeFunction");
    }

    public static void executeFunction() {
        try {
            FunctionService.onRegion((Region)customerPR).execute("LocalDataSetFunctiontrue", true, false, true).getResult();
            FunctionService.onRegion((Region)customerPR).execute("LocalDataSetFunctionfalse", true, false, false).getResult();
            HashSet<String> filter = new HashSet<String>();
            filter.add("YOYO-CUST-KEY-0");
            FunctionService.onRegion((Region)customerPR).withFilter(filter).execute("LocalDataSetFunctiontrue", true, false, true).getResult();
            FunctionService.onRegion((Region)customerPR).withFilter(filter).execute("LocalDataSetFunctionfalse", true, false, false).getResult();
            filter.clear();
            for (int i = 0; i < 6; ++i) {
                filter.add("YOYO-CUST-KEY-" + i);
            }
            FunctionService.onRegion((Region)customerPR).withFilter(filter).execute("LocalDataSetFunctiontrue", true, false, true).getResult();
            FunctionService.onRegion((Region)customerPR).withFilter(filter).execute("LocalDataSetFunctionfalse", true, false, false).getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            LocalDataSetDUnitTest.fail("Test failed due to ", e);
        }
    }

    private void registerFunctions() {
        dataStore1.invoke(LocalDataSetDUnitTest.class, "registerFunction");
        dataStore2.invoke(LocalDataSetDUnitTest.class, "registerFunction");
        dataStore3.invoke(LocalDataSetDUnitTest.class, "registerFunction");
    }

    public static void registerFunction() {
        LocalDataSetFunction function1 = new LocalDataSetFunction(false);
        LocalDataSetFunction function2 = new LocalDataSetFunction(true);
        FunctionService.registerFunction((Function)function1);
        FunctionService.registerFunction((Function)function2);
    }

    private void registerIteratorFunctionOnAll() {
        accessor.invoke(LocalDataSetDUnitTest.class, "registerIteratorFunction");
        dataStore1.invoke(LocalDataSetDUnitTest.class, "registerIteratorFunction");
        dataStore2.invoke(LocalDataSetDUnitTest.class, "registerIteratorFunction");
        dataStore3.invoke(LocalDataSetDUnitTest.class, "registerIteratorFunction");
    }

    public static void registerIteratorFunction() {
        IterateFunction function = new IterateFunction();
        FunctionService.registerFunction((Function)function);
    }

    public static void createCacheInAllVms() {
        dataStore1.invoke(LocalDataSetDUnitTest.class, "createCacheInVm");
        dataStore2.invoke(LocalDataSetDUnitTest.class, "createCacheInVm");
        dataStore3.invoke(LocalDataSetDUnitTest.class, "createCacheInVm");
        accessor.invoke(LocalDataSetDUnitTest.class, "createCacheInVm");
    }

    public static void createCacheInVm() {
        new LocalDataSetDUnitTest("temp").createCache();
    }

    public void createCache() {
        try {
            cache = this.getCache();
            LocalDataSetDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            LocalDataSetDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    private static void createCustomerPR() {
        Object[] args = new Object[]{"CustomerPR", new Integer(1), new Integer(0), new Integer(10), null};
        accessor.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        args = new Object[]{"CustomerPR", new Integer(1), new Integer(50), new Integer(10), null};
        dataStore1.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore2.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore3.invoke(LocalDataSetDUnitTest.class, "createPR", args);
    }

    private static void createOrderPR() {
        Object[] args = new Object[]{"OrderPR", new Integer(1), new Integer(0), new Integer(10), "CustomerPR"};
        accessor.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        args = new Object[]{"OrderPR", new Integer(1), new Integer(50), new Integer(10), "CustomerPR"};
        dataStore1.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore2.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore3.invoke(LocalDataSetDUnitTest.class, "createPR", args);
    }

    private static void createShipmentPR() {
        Object[] args = new Object[]{"ShipmentPR", new Integer(1), new Integer(0), new Integer(10), "OrderPR"};
        accessor.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        args = new Object[]{"ShipmentPR", new Integer(1), new Integer(50), new Integer(10), "OrderPR"};
        dataStore1.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore2.invoke(LocalDataSetDUnitTest.class, "createPR", args);
        dataStore3.invoke(LocalDataSetDUnitTest.class, "createPR", args);
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, String colocatedWith) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith(colocatedWith).setPartitionResolver((PartitionResolver)new LDSPartitionResolver()).create();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(prAttr);
        LocalDataSetDUnitTest.assertNotNull((Object)cache);
        if (partitionedRegionName.equals("CustomerPR")) {
            customerPR = cache.createRegion(partitionedRegionName, attr.create());
            LocalDataSetDUnitTest.assertNotNull((Object)customerPR);
            LocalDataSetDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + customerPR);
        }
        if (partitionedRegionName.equals("OrderPR")) {
            orderPR = cache.createRegion(partitionedRegionName, attr.create());
            LocalDataSetDUnitTest.assertNotNull((Object)orderPR);
            LocalDataSetDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + orderPR);
        }
        if (partitionedRegionName.equals("ShipmentPR")) {
            shipmentPR = cache.createRegion(partitionedRegionName, attr.create());
            LocalDataSetDUnitTest.assertNotNull((Object)shipmentPR);
            LocalDataSetDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + shipmentPR);
        }
    }

    private static void putInPRs() {
        accessor.invoke(LocalDataSetDUnitTest.class, "put");
    }

    public static void put() {
        for (int i = 0; i < 120; ++i) {
            customerPR.put((Object)("YOYO-CUST-KEY-" + i), (Object)("YOYO-CUST-VAL-" + i));
            orderPR.put((Object)("YOYO-ORD-KEY-" + i), (Object)("YOYO-ORD-VAL-" + i));
            shipmentPR.put((Object)("YOYO-SHIP-KEY-" + i), (Object)("YOYO-SHIP-VAL-" + i));
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        cache = null;
        LocalDataSetDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    protected static class ReadHook
    implements Runnable {
        protected ReadHook() {
        }

        @Override
        public void run() {
            System.out.println("SWAP:invokedHook");
            LocalDataSetDUnitTest.setHookInvoked();
        }
    }

    protected static class IterateFunction
    implements Function {
        public static final String id = "IteratorFunction";

        protected IterateFunction() {
        }

        public void execute(FunctionContext context) {
            Region localRegion = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)((RegionFunctionContext)context));
            Iterator it = localRegion.keySet().iterator();
            while (it.hasNext()) {
                DistributedTestCase.getLogWriter().info("LocalKeys:" + it.next());
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public String getId() {
            return id;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return true;
        }

        public boolean isHA() {
            return false;
        }
    }
}

