/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import java.util.Map;
import java.util.Set;

public class LocalDataSetFunction
extends FunctionAdapter {
    private volatile boolean optimizeForWrite;

    public LocalDataSetFunction(boolean optimizeForWrite) {
        this.optimizeForWrite = optimizeForWrite;
    }

    public void execute(FunctionContext context) {
        RegionFunctionContext rContext = (RegionFunctionContext)context;
        Region cust = rContext.getDataSet();
        LocalDataSet localCust = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rContext);
        Map localColocatedRegions = PartitionRegionHelper.getLocalColocatedRegions((RegionFunctionContext)rContext);
        Map colocatedRegions = PartitionRegionHelper.getColocatedRegions((Region)cust);
        Assert.assertTrue((colocatedRegions.size() == 2 ? 1 : 0) != 0);
        Set custKeySet = cust.keySet();
        Set localCustKeySet = localCust.keySet();
        Region ord = (Region)colocatedRegions.get("/OrderPR");
        Region localOrd = (Region)localColocatedRegions.get("/OrderPR");
        Set ordKeySet = ord.keySet();
        Set localOrdKeySet = localOrd.keySet();
        Region ship = (Region)colocatedRegions.get("/ShipmentPR");
        Region localShip = (Region)localColocatedRegions.get("/ShipmentPR");
        Set shipKeySet = ship.keySet();
        Set localShipKeySet = localShip.keySet();
        Assert.assertTrue((localCust.getBucketSet().size() == ((LocalDataSet)localOrd).getBucketSet().size() ? 1 : 0) != 0);
        Assert.assertTrue((localCust.getBucketSet().size() == ((LocalDataSet)localShip).getBucketSet().size() ? 1 : 0) != 0);
        Assert.assertTrue((custKeySet.size() == 120 ? 1 : 0) != 0);
        Assert.assertTrue((ordKeySet.size() == 120 ? 1 : 0) != 0);
        Assert.assertTrue((shipKeySet.size() == 120 ? 1 : 0) != 0);
        Assert.assertTrue((localCustKeySet.size() == localOrdKeySet.size() ? 1 : 0) != 0);
        Assert.assertTrue((localCustKeySet.size() == localShipKeySet.size() ? 1 : 0) != 0);
        context.getResultSender().lastResult(null);
    }

    public String getId() {
        return "LocalDataSetFunction" + this.optimizeForWrite;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return this.optimizeForWrite;
    }

    public boolean isHA() {
        return false;
    }
}

