/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.QueryObserverImpl;
import com.gemstone.gemfire.internal.cache.execute.RegionValue;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LocalDataSetIndexingDUnitTest
extends CacheTestCase {
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;

    public LocalDataSetIndexingDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
    }

    public void testLocalDataSetIndexing() {
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("create prs "){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(8).create());
                PartitionedRegion pr1 = (PartitionedRegion)LocalDataSetIndexingDUnitTest.this.createRootRegion("pr1", factory.create());
                factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(8).setColocatedWith(pr1.getName()).create());
                PartitionedRegion pr2 = (PartitionedRegion)LocalDataSetIndexingDUnitTest.this.createRootRegion("pr2", factory.create());
            }
        };
        CacheSerializableRunnable createIndexesOnPRs = new CacheSerializableRunnable("create prs "){

            @Override
            public void run2() {
                try {
                    QueryService qs = LocalDataSetIndexingDUnitTest.this.getCache().getQueryService();
                    qs.createIndex("valueIndex1", IndexType.FUNCTIONAL, "e1.value", "/pr1 e1");
                    qs.createIndex("valueIndex2", IndexType.FUNCTIONAL, "e2.value", "/pr2 e2");
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Test failed due to Exception in index creation ", e);
                }
            }
        };
        CacheSerializableRunnable execute = new CacheSerializableRunnable("execute function"){

            @Override
            public void run2() {
                PartitionedRegion pr1 = (PartitionedRegion)LocalDataSetIndexingDUnitTest.this.getRootRegion("pr1");
                PartitionedRegion pr2 = (PartitionedRegion)LocalDataSetIndexingDUnitTest.this.getRootRegion("pr2");
                HashSet<Integer> filter = new HashSet<Integer>();
                for (int i = 1; i <= 80; ++i) {
                    pr1.put((Object)i, (Object)new RegionValue(i));
                    if (i > 20) continue;
                    pr2.put((Object)i, (Object)new RegionValue(i));
                    if (i % 5 != 0) continue;
                    filter.add(i);
                }
                ArrayList result = (ArrayList)FunctionService.onRegion((Region)pr1).withFilter(filter).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        try {
                            String val;
                            BucketRegion br;
                            RegionFunctionContext rContext = (RegionFunctionContext)context;
                            Region pr1 = rContext.getDataSet();
                            LocalDataSet localCust = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rContext);
                            Map colocatedRegions = PartitionRegionHelper.getColocatedRegions((Region)pr1);
                            Map localColocatedRegions = PartitionRegionHelper.getLocalColocatedRegions((RegionFunctionContext)rContext);
                            Region pr2 = (Region)colocatedRegions.get("/pr2");
                            LocalDataSet localOrd = (LocalDataSet)localColocatedRegions.get("/pr2");
                            QueryObserverImpl observer = new QueryObserverImpl();
                            QueryObserverHolder.setInstance((QueryObserver)observer);
                            QueryService qs = pr1.getCache().getQueryService();
                            DefaultQuery query = (DefaultQuery)qs.newQuery("select distinct e1.value from /pr1 e1, /pr2  e2 where e1.value=e2.value");
                            GemFireCacheImpl.getInstance().getLogger().fine(" Num BUCKET SET: " + localCust.getBucketSet());
                            GemFireCacheImpl.getInstance().getLogger().fine("VALUES FROM PR1 bucket:");
                            for (Integer bId : localCust.getBucketSet()) {
                                br = ((PartitionedRegion)pr1).getDataStore().getLocalBucketById(bId);
                                val = "";
                                for (Object e : br.values()) {
                                    val = val + e + ",";
                                }
                                GemFireCacheImpl.getInstance().getLogger().fine(": " + val);
                            }
                            GemFireCacheImpl.getInstance().getLogger().fine("VALUES FROM PR2 bucket:");
                            for (Integer bId : localCust.getBucketSet()) {
                                br = ((PartitionedRegion)pr2).getDataStore().getLocalBucketById(bId);
                                val = "";
                                for (Object e : br.values()) {
                                    val = val + e + ",";
                                }
                                GemFireCacheImpl.getInstance().getLogger().fine(": " + val);
                            }
                            SelectResults r = (SelectResults)localCust.executeQuery(query, null, localCust.getBucketSet());
                            GemFireCacheImpl.getInstance().getLogger().fine("Result :" + r.asList());
                            Assert.assertTrue((boolean)observer.isIndexesUsed);
                            pr1.getCache().getLogger().fine("Index Used: " + observer.numIndexesUsed());
                            Assert.assertTrue((2 == observer.numIndexesUsed() ? 1 : 0) != 0);
                            context.getResultSender().lastResult((Object)((Serializable)((Object)r.asList())));
                        }
                        catch (Exception e) {
                            context.getResultSender().lastResult((Object)Boolean.TRUE);
                        }
                    }

                    public String getId() {
                        return "ok";
                    }

                    public boolean optimizeForWrite() {
                        return false;
                    }
                }).getResult();
                int numResults = 0;
                for (List oneNodeResult : result) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Result :" + numResults + " oneNodeResult.size(): " + oneNodeResult.size() + " oneNodeResult :" + oneNodeResult);
                    numResults = oneNodeResult.size();
                }
                Assert.assertTrue((10 == numResults ? 1 : 0) != 0);
            }
        };
        dataStore1.invoke(createPRs);
        dataStore2.invoke(createPRs);
        dataStore1.invoke(createIndexesOnPRs);
        dataStore1.invoke(execute);
    }
}

