/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class LocalFunctionExecutionDUnitTest
extends DistributedTestCase {
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static Region region = null;

    public LocalFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
    }

    public void testLocalDataSetPR() {
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "createCacheInVm");
        Object[] args = new Object[]{"testRegion", new Integer(1), new Integer(50), new Integer(10), null};
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "createPR", args);
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "put");
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "executeFunction");
    }

    public void testLocalDataSetDR() {
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "createCacheInVm");
        Object[] args = new Object[]{"testRegion", DataPolicy.REPLICATE};
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "createDR", args);
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "put");
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "executeFunction");
    }

    public void testLocalMember() {
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "createCacheInVm");
        dataStore1.invoke(LocalFunctionExecutionDUnitTest.class, "executeFunctionOnMember");
    }

    public static void createCacheInVm() {
        new LocalFunctionExecutionDUnitTest("temp").createCache();
    }

    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            LocalFunctionExecutionDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            LocalFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            LocalFunctionExecutionDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, String colocatedWith) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith(colocatedWith).create();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(prAttr);
        LocalFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(partitionedRegionName, attr.create());
        LocalFunctionExecutionDUnitTest.assertNotNull((Object)region);
        LocalFunctionExecutionDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + region);
    }

    public static void createDR(String distributedRegionName, DataPolicy dataPolicy) {
        AttributesFactory attr = new AttributesFactory();
        attr.setScope(Scope.DISTRIBUTED_ACK);
        attr.setDataPolicy(dataPolicy);
        LocalFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        region = cache.createRegion(distributedRegionName, attr.create());
        LocalFunctionExecutionDUnitTest.assertNotNull((Object)region);
        LocalFunctionExecutionDUnitTest.getLogWriter().info("Distributed Region " + distributedRegionName + " created Successfully :" + region);
    }

    public static void put() {
        for (int i = 0; i < 120; ++i) {
            region.put((Object)("YOYO-CUST-KEY-" + i), (Object)("YOYO-CUST-VAL-" + i));
        }
    }

    public static void executeFunction() {
        try {
            TestFunction function1 = new TestFunction(true, "TestFunctionException");
            FunctionService.registerFunction((Function)function1);
            ResultCollector rc = FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute(function1.getId());
            rc.getResult();
            LocalFunctionExecutionDUnitTest.fail("Exception should occur", new Exception("Test Failed"));
        }
        catch (Exception e) {
            LocalFunctionExecutionDUnitTest.assertTrue((boolean)e.getMessage().contains("I have been thrown from TestFunction"));
        }
    }

    public static void executeFunctionOnMember() {
        try {
            TestFunction function1 = new TestFunction(true, "TestFunctionException");
            FunctionService.registerFunction((Function)function1);
            InternalDistributedMember localmember = system.getDistributedMember();
            ResultCollector rc = FunctionService.onMember((DistributedSystem)system, (DistributedMember)localmember).withArgs((Object)Boolean.TRUE).execute(function1.getId());
            rc.getResult();
            LocalFunctionExecutionDUnitTest.fail("Exception should occur", new Exception("Test Failed"));
        }
        catch (Exception e) {
            LocalFunctionExecutionDUnitTest.assertTrue((boolean)e.getMessage().contains("I have been thrown from TestFunction"));
            return;
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        cache = null;
        LocalFunctionExecutionDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }
}

