/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionService;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionContext;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class MultiRegionFunctionExecutionDUnitTest
extends CacheTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    static Region PR1 = null;
    static Region PR2 = null;
    static Region RR1 = null;
    static Region RR2 = null;
    static Region LR1 = null;
    static Cache cache = null;

    public MultiRegionFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        cache = null;
        MultiRegionFunctionExecutionDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public void testMultiRegionFunctionExecution() {
        this.vm0.invoke(MultiRegionFunctionExecutionDUnitTest.class, "createRegionsOnVm0");
        this.vm1.invoke(MultiRegionFunctionExecutionDUnitTest.class, "createRegionsOnVm1");
        this.vm2.invoke(MultiRegionFunctionExecutionDUnitTest.class, "createRegionsOnVm2");
        this.vm3.invoke(MultiRegionFunctionExecutionDUnitTest.class, "createRegionsOnVm3");
        MultiRegionFunctionExecutionDUnitTest.createRegionsOnUnitControllerVm();
        HashSet<Region> regions = new HashSet<Region>();
        regions.add(PR1);
        InternalFunctionService.onRegions(regions).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                MultiRegionFunctionContext mrContext = (MultiRegionFunctionContext)context;
                Set regions = mrContext.getRegions();
                Assert.assertTrue((1 == regions.size() ? 1 : 0) != 0);
                context.getResultSender().lastResult((Object)Boolean.TRUE);
            }

            public String getId() {
                return ((Object)((Object)this)).getClass().getName();
            }
        }).getResult();
        regions.add(PR2);
        InternalFunctionService.onRegions(regions).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                MultiRegionFunctionContext mrContext = (MultiRegionFunctionContext)context;
                Set regions = mrContext.getRegions();
                Assert.assertTrue((0 != regions.size() ? 1 : 0) != 0);
                context.getResultSender().lastResult((Object)Boolean.TRUE);
            }

            public String getId() {
                return ((Object)((Object)this)).getClass().getName();
            }
        }).getResult();
        regions.add(PR2);
        regions.add(RR1);
        regions.add(RR2);
        regions.add(LR1);
        InternalFunctionService.onRegions(regions).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                MultiRegionFunctionContext mrContext = (MultiRegionFunctionContext)context;
                Set regions = mrContext.getRegions();
                Assert.assertTrue((0 != regions.size() ? 1 : 0) != 0);
                context.getResultSender().lastResult((Object)Boolean.TRUE);
            }

            public String getId() {
                return ((Object)((Object)this)).getClass().getName();
            }
        }).getResult();
    }

    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            MultiRegionFunctionExecutionDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            MultiRegionFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            MultiRegionFunctionExecutionDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    public static void createRegionsOnVm0() {
        new MultiRegionFunctionExecutionDUnitTest("temp").createCache();
        PartitionAttributesFactory pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        AttributesFactory factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        cache.createRegion("RR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        cache.createRegion("RR2", factory.create());
    }

    public static void createRegionsOnVm1() {
        new MultiRegionFunctionExecutionDUnitTest("temp").createCache();
        PartitionAttributesFactory pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        AttributesFactory factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.NORMAL);
        cache.createRegion("RR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        cache.createRegion("RR2", factory.create());
    }

    public static void createRegionsOnVm2() {
        new MultiRegionFunctionExecutionDUnitTest("temp").createCache();
        PartitionAttributesFactory pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        pf.setLocalMaxMemory(0);
        AttributesFactory factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR1", factory.create());
        pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR2", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        cache.createRegion("RR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.NORMAL);
        cache.createRegion("RR2", factory.create());
    }

    public static void createRegionsOnVm3() {
        new MultiRegionFunctionExecutionDUnitTest("temp").createCache();
        PartitionAttributesFactory pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        AttributesFactory factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR1", factory.create());
        pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        cache.createRegion("PR2", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        cache.createRegion("RR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        cache.createRegion("RR2", factory.create());
    }

    public static void createRegionsOnUnitControllerVm() {
        new MultiRegionFunctionExecutionDUnitTest("temp").createCache();
        PartitionAttributesFactory pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        AttributesFactory factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        PR1 = cache.createRegion("PR1", factory.create());
        pf = new PartitionAttributesFactory();
        pf.setTotalNumBuckets(12);
        pf.setRedundantCopies(1);
        pf.setLocalMaxMemory(0);
        factory = new AttributesFactory();
        factory.setPartitionAttributes(pf.create());
        PR2 = cache.createRegion("PR2", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RR1 = cache.createRegion("RR1", factory.create());
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        RR2 = cache.createRegion("RR2", factory.create());
        factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        LR1 = cache.createRegion("LR1", factory.create());
        for (int i = 0; i < 24; ++i) {
            PR1.put((Object)new Integer(i), (Object)new Integer(i));
            PR2.put((Object)new Integer(i), (Object)new Integer(i));
            RR1.put((Object)new Integer(i), (Object)new Integer(i));
            RR2.put((Object)new Integer(i), (Object)new Integer(i));
            LR1.put((Object)new Integer(i), (Object)new Integer(i));
        }
    }
}

