/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.PRTransactionDUnitTest;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import util.TestException;

public class MyTransactionFunction
implements Function {
    public void execute(FunctionContext context) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        this.verifyExecutionOnPrimary(ctx);
        ArrayList args = (ArrayList)ctx.getArguments();
        Integer testOperation = (Integer)args.get(0);
        int op = testOperation;
        switch (op) {
            case 0: {
                this.verifyTransactionExecution(ctx);
                ctx.getDataSet().getCache().getLogger().info("verifyTransactionExecution Passed");
                break;
            }
            case 1: {
                this.verifyTransactionRollback(ctx);
                ctx.getDataSet().getCache().getLogger().info("verifyTransactionRollback Passed");
                break;
            }
            case 4: {
                this.verifyDestroyOperation(ctx, true);
                ctx.getDataSet().getCache().getLogger().info("verifyDestroy Passed");
                break;
            }
            case 6: {
                this.verifyInvalidateOperation(ctx, true);
                ctx.getDataSet().getCache().getLogger().info("verifyInvalidate Passed");
                break;
            }
            case 2: {
                this.verifyNonCoLocatedSuccess(ctx);
                ctx.getDataSet().getCache().getLogger().info("verifyNonCoLocatedOpsRejection Passed");
                break;
            }
            case 5: {
                this.verifyListenerCallback(ctx);
                break;
            }
            case 7: {
                this.verifyTxStateAndConflicts(ctx);
                break;
            }
            case 8: {
                this.verifyRepeatableRead(ctx);
            }
        }
        context.getResultSender().lastResult(null);
    }

    public String getId() {
        return "txFuntion";
    }

    private void verifyTransactionExecution(RegionFunctionContext ctx) {
        Region custPR = ctx.getDataSet();
        Region orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
        CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        Customer newCus = (Customer)args.get(2);
        OrderId orderId = (OrderId)args.get(3);
        Order order = (Order)args.get(4);
        mgr.begin();
        custPR.put((Object)custId, (Object)newCus);
        Assert.assertTrue((boolean)custPR.containsKey((Object)custId));
        Assert.assertTrue((boolean)custPR.containsValueForKey((Object)custId));
        orderPR.put((Object)orderId, (Object)order);
        Assert.assertTrue((boolean)orderPR.containsKey((Object)orderId));
        Assert.assertTrue((boolean)orderPR.containsValueForKey((Object)orderId));
        mgr.commit();
        Customer commitedCust = (Customer)custPR.get((Object)custId);
        Assert.assertTrue((boolean)newCus.equals(commitedCust), (Object)("Expected Customer to be:" + newCus + " but was:" + commitedCust));
        Order commitedOrder = (Order)orderPR.get((Object)orderId);
        Assert.assertTrue((boolean)order.equals(commitedOrder), (Object)("Expected Order to be:" + order + " but was:" + commitedOrder));
        OrderId newOrderId = new OrderId(4000, custId);
        Order newOrder = new Order("NewOrder");
        mgr.begin();
        custPR.put((Object)custId, (Object)newCus);
        orderPR.put((Object)newOrderId, (Object)newOrder);
        mgr.commit();
        commitedOrder = (Order)orderPR.get((Object)newOrderId);
        Assert.assertTrue((boolean)newOrder.equals(commitedOrder), (Object)("Expected Order to be:" + order + " but was:" + commitedOrder));
    }

    private void verifyDestroyOperation(RegionFunctionContext ctx, boolean remote) {
        Customer commitedCust;
        Order order;
        OrderId orderId;
        Customer newCus;
        CustId custId;
        CacheTransactionManager mgr;
        Region orderPR;
        Region custPR;
        block7: {
            custPR = ctx.getDataSet();
            orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
            mgr = custPR.getCache().getCacheTransactionManager();
            ArrayList args = (ArrayList)ctx.getArguments();
            custId = (CustId)args.get(1);
            newCus = (Customer)args.get(2);
            orderId = (OrderId)args.get(3);
            order = (Order)args.get(4);
            Customer oldCustomer = (Customer)custPR.get((Object)custId);
            commitedCust = null;
            mgr.begin();
            custPR.put((Object)custId, (Object)newCus);
            custPR.destroy((Object)custId);
            orderPR.put((Object)orderId, (Object)order);
            mgr.rollback();
            commitedCust = (Customer)custPR.get((Object)custId);
            Assert.assertTrue((boolean)oldCustomer.equals(commitedCust), (Object)("Expected customer to rollback to:" + oldCustomer + " but was:" + commitedCust));
            mgr.begin();
            custPR.destroy((Object)custId);
            orderPR.put((Object)orderId, (Object)order);
            mgr.rollback();
            commitedCust = (Customer)custPR.get((Object)custId);
            Assert.assertTrue((boolean)oldCustomer.equals(commitedCust), (Object)("Expected customer to rollback to:" + oldCustomer + " but was:" + commitedCust));
            if (remote) {
                boolean hasData = custPR.containsKey((Object)new CustId(1));
                mgr.begin();
                Customer cust = new Customer("foo", "bar");
                Assert.assertTrue((boolean)oldCustomer.equals(custPR.get((Object)custId)));
                custPR.put((Object)custId, (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)custId)));
                custPR.destroy((Object)custId);
                Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
                custPR.putIfAbsent((Object)custId, (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)custId)));
                custPR.remove((Object)custId, (Object)cust);
                Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
                if (hasData) {
                    Customer expectedCust2 = new Customer("name1", "Address1");
                    custPR.putIfAbsent((Object)new CustId(1), (Object)cust);
                    Assert.assertTrue((boolean)expectedCust2.equals(custPR.get((Object)new CustId(1))), (Object)("expected [" + expectedCust2 + "] but got: " + custPR.get((Object)new CustId(1))));
                }
                custPR.put((Object)new CustId(1), (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                custPR.remove((Object)new CustId(1), (Object)cust);
                Assert.assertTrue((custPR.get((Object)new CustId(1)) == null ? 1 : 0) != 0);
                custPR.putIfAbsent((Object)new CustId(1), (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                Assert.assertTrue((custPR.get((Object)new CustId(13)) == null ? 1 : 0) != 0);
                try {
                    custPR.destroy((Object)new CustId(13));
                    throw new TestException("expected EntryNotFoundException");
                }
                catch (EntryNotFoundException expectedCust2) {
                    Assert.assertTrue((custPR.get((Object)new CustId(13)) == null ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                    custPR.destroy((Object)new CustId(1));
                    Assert.assertTrue((custPR.get((Object)new CustId(1)) == null ? 1 : 0) != 0);
                    if (hasData) {
                        Assert.assertTrue((boolean)new Customer("name7", "Address7").equals(custPR.get((Object)new CustId(7))));
                        custPR.destroy((Object)new CustId(7));
                    }
                    Assert.assertTrue((custPR.get((Object)new CustId(7)) == null ? 1 : 0) != 0);
                    try {
                        custPR.destroy((Object)new CustId(7));
                        throw new TestException("expected EntryNotFoundException");
                    }
                    catch (EntryNotFoundException expectedCust2) {
                        mgr.commit();
                        custPR.put((Object)custId, (Object)cust);
                        if (!hasData) break block7;
                        custPR.putIfAbsent((Object)new CustId(1), (Object)new Customer("name1", "Address1"));
                        custPR.put((Object)new CustId(7), (Object)new Customer("name7", "Address7"));
                    }
                }
            }
        }
        mgr.begin();
        custPR.destroy((Object)custId);
        orderPR.put((Object)orderId, (Object)order);
        mgr.commit();
        commitedCust = (Customer)custPR.get((Object)custId);
        Assert.assertTrue((commitedCust == null ? 1 : 0) != 0, (Object)("Expected Customer to be null but was:" + commitedCust));
        Order commitedOrder = (Order)orderPR.get((Object)orderId);
        Assert.assertTrue((boolean)order.equals(commitedOrder), (Object)("Expected Order to be:" + order + " but was:" + commitedOrder));
        mgr.begin();
        custPR.putIfAbsent((Object)custId, (Object)newCus);
        mgr.commit();
        OrderId newOrderId = new OrderId(5000, custId);
        mgr.begin();
        Order newOrder = new Order("New Order to be destroyed");
        orderPR.put((Object)newOrderId, (Object)newOrder);
        orderPR.destroy((Object)newOrderId);
        mgr.commit();
        Assert.assertTrue((orderPR.get((Object)newOrderId) == null ? 1 : 0) != 0, (Object)"Did not expect orderId to be present");
        mgr.begin();
        Order order1 = new Order("New Order to be replaced");
        Order order2 = new Order("New Order to be destroyed");
        orderPR.putIfAbsent((Object)newOrderId, (Object)order1);
        Assert.assertTrue((boolean)order1.equals(orderPR.replace((Object)newOrderId, (Object)order2)));
        mgr.commit();
        Assert.assertTrue((boolean)order2.equals(orderPR.get((Object)newOrderId)));
        mgr.begin();
        Assert.assertTrue((boolean)orderPR.replace((Object)newOrderId, (Object)order2, (Object)order1));
        mgr.commit();
        Assert.assertTrue((boolean)orderPR.get((Object)newOrderId).equals(order1));
        mgr.begin();
        Assert.assertTrue((!orderPR.remove((Object)newOrderId, (Object)new Serializable(){}) ? 1 : 0) != 0);
        mgr.commit();
        Assert.assertTrue((boolean)orderPR.get((Object)newOrderId).equals(order1));
        mgr.begin();
        Assert.assertTrue((boolean)orderPR.remove((Object)newOrderId, (Object)order1));
        mgr.commit();
        Assert.assertTrue((orderPR.get((Object)newOrderId) == null ? 1 : 0) != 0);
    }

    private void verifyInvalidateOperation(RegionFunctionContext ctx, boolean remote) {
        Customer commitedCust;
        Order order;
        OrderId orderId;
        CustId custId;
        CacheTransactionManager mgr;
        Region orderPR;
        Region custPR;
        block4: {
            custPR = ctx.getDataSet();
            orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
            mgr = custPR.getCache().getCacheTransactionManager();
            ArrayList args = (ArrayList)ctx.getArguments();
            custId = (CustId)args.get(1);
            Customer newCus = (Customer)args.get(2);
            orderId = (OrderId)args.get(3);
            order = (Order)args.get(4);
            Customer oldCustomer = (Customer)custPR.get((Object)custId);
            commitedCust = null;
            mgr.begin();
            custPR.put((Object)custId, (Object)newCus);
            custPR.invalidate((Object)custId);
            orderPR.put((Object)orderId, (Object)order);
            mgr.rollback();
            commitedCust = (Customer)custPR.get((Object)custId);
            Assert.assertTrue((boolean)oldCustomer.equals(commitedCust), (Object)("Expected customer to rollback to:" + oldCustomer + " but was:" + commitedCust));
            mgr.begin();
            custPR.invalidate((Object)custId);
            orderPR.put((Object)orderId, (Object)order);
            mgr.rollback();
            commitedCust = (Customer)custPR.get((Object)custId);
            Assert.assertTrue((boolean)oldCustomer.equals(commitedCust), (Object)("Expected customer to rollback to:" + oldCustomer + " but was:" + commitedCust));
            if (remote) {
                boolean hasData = custPR.containsKey((Object)new CustId(1));
                mgr.begin();
                Customer cust = new Customer("foo", "bar");
                Assert.assertTrue((boolean)oldCustomer.equals(custPR.get((Object)custId)));
                custPR.put((Object)custId, (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)custId)));
                custPR.invalidate((Object)custId);
                Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
                custPR.put((Object)custId, (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)custId)));
                custPR.invalidate((Object)custId);
                Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
                custPR.put((Object)new CustId(1), (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                custPR.invalidate((Object)new CustId(1));
                Assert.assertTrue((custPR.get((Object)new CustId(1)) == null ? 1 : 0) != 0);
                custPR.put((Object)new CustId(1), (Object)cust);
                Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                Assert.assertTrue((custPR.get((Object)new CustId(13)) == null ? 1 : 0) != 0);
                try {
                    custPR.invalidate((Object)new CustId(13));
                    throw new TestException("expected EntryNotFoundException");
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    Assert.assertTrue((custPR.get((Object)new CustId(13)) == null ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)cust.equals(custPR.get((Object)new CustId(1))));
                    custPR.invalidate((Object)new CustId(1));
                    Assert.assertTrue((custPR.get((Object)new CustId(1)) == null ? 1 : 0) != 0);
                    if (hasData) {
                        Assert.assertTrue((boolean)new Customer("name7", "Address7").equals(custPR.get((Object)new CustId(7))));
                        custPR.invalidate((Object)new CustId(7));
                    }
                    Assert.assertTrue((custPR.get((Object)new CustId(7)) == null ? 1 : 0) != 0);
                    mgr.commit();
                    custPR.put((Object)custId, (Object)cust);
                    if (!hasData) break block4;
                    custPR.put((Object)new CustId(1), (Object)new Customer("name1", "Address1"));
                    custPR.put((Object)new CustId(7), (Object)new Customer("name7", "Address7"));
                }
            }
        }
        mgr.begin();
        custPR.invalidate((Object)custId);
        orderPR.put((Object)orderId, (Object)order);
        mgr.commit();
        commitedCust = (Customer)custPR.get((Object)custId);
        Assert.assertTrue((commitedCust == null ? 1 : 0) != 0, (Object)("Expected Customer to be null but was:" + commitedCust));
        Order commitedOrder = (Order)orderPR.get((Object)orderId);
        Assert.assertTrue((boolean)order.equals(commitedOrder), (Object)("Expected Order to be:" + order + " but was:" + commitedOrder));
    }

    private void verifyTransactionRollback(RegionFunctionContext ctx) {
        Region custPR = ctx.getDataSet();
        Region orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
        CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        Customer newCus = (Customer)args.get(2);
        OrderId orderId = (OrderId)args.get(3);
        Order order = (Order)args.get(4);
        Customer oldCustomer = (Customer)custPR.get((Object)custId);
        Order oldOrder = (Order)orderPR.get((Object)orderId);
        mgr.begin();
        custPR.put((Object)custId, (Object)newCus);
        Customer txCust = (Customer)custPR.get((Object)custId);
        orderPR.put((Object)orderId, (Object)order);
        Order txOrder = (Order)orderPR.get((Object)orderId);
        Assert.assertTrue((boolean)newCus.equals(txCust), (Object)("Expected Customer to be:" + newCus + " but was:" + txCust));
        Assert.assertTrue((boolean)txOrder.equals(order), (Object)("Expected Order to be:" + order + " but was:" + txOrder));
        mgr.rollback();
        Customer commitedCust = (Customer)custPR.get((Object)custId);
        Assert.assertTrue((boolean)oldCustomer.equals(commitedCust), (Object)("Expected Customer to be:" + oldCustomer + " but was:" + commitedCust));
        Order commitedOrder = (Order)orderPR.get((Object)orderId);
        Assert.assertTrue((boolean)oldOrder.equals(commitedOrder), (Object)("Expected Order to be:" + oldOrder + " but was:" + commitedOrder));
        mgr.begin();
        Assert.assertTrue((boolean)custPR.remove((Object)custId, (Object)oldCustomer));
        orderPR.replace((Object)orderId, (Object)order);
        mgr.rollback();
        Assert.assertTrue((boolean)oldCustomer.equals(custPR.get((Object)custId)));
        Assert.assertTrue((boolean)oldOrder.equals(orderPR.get((Object)orderId)));
        mgr.begin();
        Assert.assertTrue((boolean)custPR.replace((Object)custId, (Object)oldCustomer, (Object)newCus));
        orderPR.remove((Object)orderId, (Object)oldOrder);
        Assert.assertTrue((null == orderPR.putIfAbsent((Object)orderId, (Object)order) ? 1 : 0) != 0);
        mgr.rollback();
        Assert.assertTrue((boolean)oldCustomer.equals(custPR.get((Object)custId)));
        Assert.assertTrue((boolean)oldOrder.equals(orderPR.get((Object)orderId)));
    }

    private void verifyNonCoLocatedSuccess(RegionFunctionContext ctx) {
        Region custPR = ctx.getDataSet();
        Region orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
        CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        Customer newCus = (Customer)args.get(2);
        OrderId orderId = (OrderId)args.get(3);
        Order order = (Order)args.get(4);
        mgr.begin();
        custPR.put((Object)custId, (Object)newCus);
        custPR.put((Object)new CustId(4), (Object)"foo4");
        custPR.put((Object)new CustId(5), (Object)"foo5");
        custPR.put((Object)new CustId(6), (Object)"foo6");
        orderPR.put((Object)orderId, (Object)order);
        mgr.commit();
    }

    private void verifyListenerCallback(RegionFunctionContext ctx) {
        this.verifyTransactionExecution(ctx);
        PRTransactionDUnitTest.TransactionListener2 listener = (PRTransactionDUnitTest.TransactionListener2)ctx.getDataSet().getAttributes().getCacheListeners()[0];
        Assert.assertTrue((listener.getNumberOfPutCallbacks() == 2 ? 1 : 0) != 0, (Object)("Expected 2 put callback, but got " + listener.getNumberOfPutCallbacks()));
        this.verifyDestroyOperation(ctx, false);
        Assert.assertTrue((listener.getNumberOfDestroyCallbacks() == 1 ? 1 : 0) != 0, (Object)("Expected 1 destroy callbacks, but got " + listener.getNumberOfDestroyCallbacks()));
        this.verifyInvalidateOperation(ctx, false);
        Assert.assertTrue((listener.getNumberOfInvalidateCallbacks() == 1 ? 1 : 0) != 0, (Object)("Expected 1 invalidate callbacks, but got " + listener.getNumberOfInvalidateCallbacks()));
    }

    private void verifyExecutionOnPrimary(RegionFunctionContext ctx) {
        PartitionedRegion pr = (PartitionedRegion)ctx.getDataSet();
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)custId, null, null);
        InternalDistributedMember primary = pr.getRegionAdvisor().getPrimaryMemberForBucket(bucketId);
        InternalDistributedMember me = pr.getCache().getDistributedSystem().getDistributedMember();
        Assert.assertTrue((boolean)me.equals(primary), (Object)("Function should have been executed on primary:" + primary + " but was executed on member:" + me));
    }

    private void verifyTxStateAndConflicts(RegionFunctionContext ctx) {
        Region custPR = ctx.getDataSet();
        Region orderPR = custPR.getCache().getRegion("OrderPartitionedRegion");
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
        OrderId vOrderId = new OrderId(3000, custId);
        Order vOrder = new Order("vOrder");
        TXManagerImpl mImp = (TXManagerImpl)mgr;
        mImp.begin();
        orderPR.put((Object)vOrderId, (Object)vOrder);
        TXStateInterface txState = mImp.internalSuspend();
        Collection regions = txState.getLocalTXState().getRegions();
        Iterator it = regions.iterator();
        Assert.assertTrue((regions.size() == 1 ? 1 : 0) != 0, (Object)("Expected 1 region; found:" + regions));
        LocalRegion lr = (LocalRegion)it.next();
        Assert.assertTrue((boolean)(lr instanceof BucketRegion));
        TXRegionState txRegion = txState.readRegion(lr);
        TXEntryState txEntry = (TXEntryState)txRegion.readEntry(txRegion.getEntryKeys().iterator().next());
        mImp.resume(txState);
        orderPR.put((Object)vOrderId, (Object)new Order("foo"));
        txState = mImp.internalSuspend();
        LocalRegion lr1 = (LocalRegion)txState.getLocalTXState().getRegions().iterator().next();
        Assert.assertTrue((lr == lr1 ? 1 : 0) != 0);
        TXRegionState txRegion1 = txState.readRegion(lr);
        TXEntryState txEntry1 = (TXEntryState)txRegion1.readEntry(txRegion.getEntryKeys().iterator().next());
        Assert.assertTrue((txEntry == txEntry1 ? 1 : 0) != 0);
        mImp.begin();
        try {
            orderPR.put((Object)vOrderId, (Object)new Order("foobar"));
            throw new TestException("An expected exception was not thrown");
        }
        catch (ConflictException ce) {
            mImp.rollback();
            mImp.resume(txState);
            mImp.commit();
            return;
        }
    }

    private void verifyRepeatableRead(RegionFunctionContext ctx) {
        Region custPR = ctx.getDataSet();
        custPR.getCache().getRegion("OrderPartitionedRegion");
        ArrayList args = (ArrayList)ctx.getArguments();
        CustId custId = (CustId)args.get(1);
        Customer cust = (Customer)args.get(2);
        Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
        CacheTransactionManager mgr = custPR.getCache().getCacheTransactionManager();
        TXManagerImpl mImp = (TXManagerImpl)mgr;
        mImp.begin();
        custPR.put((Object)custId, (Object)cust);
        Assert.assertTrue((boolean)cust.equals(custPR.get((Object)custId)));
        TXStateInterface txState = mImp.internalSuspend();
        Assert.assertTrue((custPR.get((Object)custId) == null ? 1 : 0) != 0);
        mImp.resume(txState);
        mImp.commit();
        mImp.begin();
        Customer oldCust = (Customer)custPR.get((Object)custId);
        Assert.assertTrue((boolean)oldCust.equals(cust));
        txState = mImp.internalSuspend();
        Customer newCust = new Customer("fooNew", "barNew");
        custPR.put((Object)custId, (Object)newCust);
        mImp.resume(txState);
        Assert.assertTrue((boolean)oldCust.equals(custPR.get((Object)custId)));
        mImp.commit();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }
}

