/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionService;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import junit.framework.TestCase;

public class OnGroupsFunctionExecutionDUnitTest
extends DistributedTestCase {
    public OnGroupsFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        OnGroupsFunctionExecutionDUnitTest.invokeInEveryVM(new SerializableCallable(){

            public Object call() throws Exception {
                Cache c = null;
                try {
                    c = CacheFactory.getAnyInstance();
                    if (c != null) {
                        c.close();
                    }
                }
                catch (CacheClosedException cacheClosedException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private void initVM(VM vm, final String groups, final String regionName, final boolean startServer) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.put("groups", groups);
                if (regionName != null) {
                    Cache c = null;
                    try {
                        c = CacheFactory.getInstance((DistributedSystem)OnGroupsFunctionExecutionDUnitTest.this.getSystem(props));
                        c.close();
                    }
                    catch (CacheClosedException cacheClosedException) {
                        // empty catch block
                    }
                    c = CacheFactory.create((DistributedSystem)OnGroupsFunctionExecutionDUnitTest.this.getSystem(props));
                    c.createRegionFactory(RegionShortcut.PARTITION).create(regionName);
                    if (startServer) {
                        CacheServer s = c.addCacheServer();
                        s.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
                        s.start();
                    }
                } else {
                    OnGroupsFunctionExecutionDUnitTest.this.getSystem(props);
                }
                return null;
            }
        });
    }

    private void registerFunction(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)new OnGroupsFunction());
                return null;
            }
        });
    }

    private void verifyAndResetInvocationCount(VM vm, final int count) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                OnGroupsFunction f = (OnGroupsFunction)FunctionService.getFunction((String)"OnGroupsFunction");
                TestCase.assertEquals((int)count, (int)OnGroupsFunction.invocationCount);
                OnGroupsFunction.invocationCount = 0;
                return null;
            }
        });
    }

    private int getAndResetInvocationCount(VM vm) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                OnGroupsFunction f = (OnGroupsFunction)FunctionService.getFunction((String)"OnGroupsFunction");
                int count = OnGroupsFunction.invocationCount;
                OnGroupsFunction.invocationCount = 0;
                return count;
            }
        });
    }

    private int getInvocationCount(VM vm) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                OnGroupsFunction f = (OnGroupsFunction)FunctionService.getFunction((String)"OnGroupsFunction");
                int count = OnGroupsFunction.invocationCount;
                OnGroupsFunction.invocationCount = 0;
                return count;
            }
        });
    }

    private void resetInvocationCount(VM vm) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                OnGroupsFunction f = (OnGroupsFunction)FunctionService.getFunction((String)"OnGroupsFunction");
                OnGroupsFunction.invocationCount = 0;
                return null;
            }
        });
    }

    public void testBasicP2PFunctionNoCache() {
        this.doBasicP2PFunctionNoCache(false);
    }

    public void testBasicP2pRegisteredFunctionNoCache() {
        this.doBasicP2PFunctionNoCache(true);
    }

    private void doBasicP2PFunctionNoCache(final boolean registerFunction) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.initVM(vm0, "g0,gm", null, false);
        this.initVM(vm1, "g1", null, false);
        this.initVM(vm2, "g0,g1", null, false);
        if (registerFunction) {
            this.registerFunction(vm0);
            this.registerFunction(vm1);
            this.registerFunction(vm2);
        }
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().fine("SWAP:invoking on gm");
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                try {
                    FunctionService.onMember((String[])new String[]{"no such group"});
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException functionException) {
                    // empty catch block
                }
                Execution e = FunctionService.onMembers((String[])new String[]{"gm"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("gm");
                e = e.withArgs(args);
                if (registerFunction) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(vm0, 1);
        this.verifyAndResetInvocationCount(vm1, 0);
        this.verifyAndResetInvocationCount(vm2, 0);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                DistributedTestCase.getLogWriter().fine("SWAP:invoking on g0");
                Execution e = FunctionService.onMembers((String[])new String[]{"g0"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("g0");
                e = e.withArgs(args);
                if (registerFunction) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(vm0, 1);
        this.verifyAndResetInvocationCount(vm1, 0);
        this.verifyAndResetInvocationCount(vm2, 1);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e = FunctionService.onMembers((String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("g1");
                e = e.withArgs(args);
                if (registerFunction) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(vm0, 0);
        this.verifyAndResetInvocationCount(vm1, 1);
        this.verifyAndResetInvocationCount(vm2, 1);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedTestCase.getLogWriter().fine("SWAP:invoking on g0 g1");
                InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
                Execution e = FunctionService.onMembers((String[])new String[]{"g0", "g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("g0");
                args.add("g1");
                e = e.withArgs(args);
                if (registerFunction) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(vm0, 1);
        this.verifyAndResetInvocationCount(vm1, 1);
        this.verifyAndResetInvocationCount(vm2, 1);
    }

    public void testonMember() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.initVM(vm0, "g0,gm", null, false);
        this.initVM(vm1, "g1", null, false);
        this.initVM(vm2, "g0,g1", null, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                try {
                    FunctionService.onMember((String[])new String[]{"no such group"});
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException functionException) {
                    // empty catch block
                }
                try {
                    FunctionService.onMember((String[])new String[0]);
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException functionException) {
                    // empty catch block
                }
                FunctionService.onMember((String[])new String[]{"g1"}).execute((Function)new OnGroupsFunction()).getResult();
                return null;
            }
        });
        int c0 = this.getAndResetInvocationCount(vm0);
        int c1 = this.getAndResetInvocationCount(vm1);
        int c2 = this.getAndResetInvocationCount(vm2);
        OnGroupsFunctionExecutionDUnitTest.assertEquals((int)1, (int)(c0 + c1 + c2));
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                FunctionService.onMember((String[])new String[]{"g0"}).execute((Function)new OnGroupsFunction()).getResult();
                return null;
            }
        });
        this.verifyAndResetInvocationCount(vm0, 1);
        this.verifyAndResetInvocationCount(vm1, 0);
        this.verifyAndResetInvocationCount(vm2, 0);
    }

    public void testBasicP2PFunction() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String regionName = this.getName();
        this.initVM(vm0, "g0,mg", regionName, false);
        this.initVM(vm1, "g1", regionName, false);
        this.initVM(vm2, "g0,g1", regionName, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e = FunctionService.onMembers((String[])new String[]{"mg"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)5, (int)sum);
                return null;
            }
        });
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e = FunctionService.onMembers((String[])new String[]{"g0"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)10, (int)sum);
                return null;
            }
        });
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e = FunctionService.onMembers((String[])new String[]{"g0", "g1"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)15, (int)sum);
                return null;
            }
        });
    }

    private int getLocatorPort(VM locator) {
        return (Integer)locator.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return Locator.getLocator().getPort();
            }
        });
    }

    public void testP2PException() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String regionName = this.getName();
        this.initVM(vm0, "g0,mg", regionName, false);
        this.initVM(vm1, "g1", regionName, false);
        this.initVM(vm2, "g0,g1,g2", regionName, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e = FunctionService.onMembers((String[])new String[]{"mg"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("runtime");
                e = e.withArgs(args);
                try {
                    e.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                Execution e1 = FunctionService.onMembers((String[])new String[]{"g1"});
                e1 = e1.withArgs(args);
                try {
                    e1.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                Execution e2 = FunctionService.onMembers((String[])new String[]{"g1"});
                args.add("g2");
                e2 = e2.withArgs(args);
                try {
                    e2.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                return null;
            }
        });
    }

    public void testP2PMemberFailure() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String regionName = this.getName();
        this.initVM(vm0, "g0,mg", regionName, false);
        this.initVM(vm1, "g1", regionName, false);
        this.initVM(vm2, "g0,g1,g2", regionName, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e1 = FunctionService.onMembers((String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("shutdown");
                e1 = e1.withArgs(args);
                try {
                    e1.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof FunctionInvocationTargetException));
                }
                return null;
            }
        });
    }

    public void testP2POneMemberFailure() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String regionName = this.getName();
        this.initVM(vm0, "g0,mg", regionName, false);
        this.initVM(vm1, "g1", regionName, false);
        this.initVM(vm2, "g0,g1,g2", regionName, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e1 = FunctionService.onMembers((String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("shutdown");
                args.add("g2");
                e1 = e1.withArgs(args);
                try {
                    e1.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof FunctionInvocationTargetException));
                }
                return null;
            }
        });
    }

    public void testP2PIgnoreMemberFailure() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String regionName = this.getName();
        this.initVM(vm0, "g0,mg", regionName, false);
        this.initVM(vm1, "g1", regionName, false);
        this.initVM(vm2, "g0,g1,g2", regionName, false);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = OnGroupsFunctionExecutionDUnitTest.this.getSystem();
                Execution e1 = FunctionService.onMembers((String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("shutdown");
                args.add("g2");
                e1 = e1.withArgs(args);
                ((AbstractExecution)e1).setIgnoreDepartedMembers(true);
                ArrayList l = (ArrayList)e1.execute((Function)new OnGroupsExceptionFunction()).getResult();
                TestCase.assertEquals((int)2, (int)l.size());
                if (l.get(0) instanceof FunctionInvocationTargetException) {
                    TestCase.assertTrue((boolean)((Boolean)l.get(1)));
                } else if (l.get(0) instanceof Boolean) {
                    TestCase.assertTrue((boolean)(l.get(1) instanceof FunctionInvocationTargetException));
                } else {
                    TestCase.fail((String)"expected to find a Boolean or throwable at index 0");
                }
                return null;
            }
        });
    }

    public void testBasicClientServerFunction() {
        this.dotestBasicClientServerFunction(false, true);
    }

    public void testBasicClientServerRegisteredFunction() {
        this.dotestBasicClientServerFunction(true, true);
    }

    public void testBasicClientServerFunctionNoArgs() {
        this.dotestBasicClientServerFunction(false, false);
    }

    public void testBasicClientServerRegisteredFunctionNoArgs() {
        this.dotestBasicClientServerFunction(true, false);
    }

    private void dotestBasicClientServerFunction(final boolean register, final boolean withArgs) {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1", regionName, true);
        if (register) {
            this.registerFunction(server0);
            this.registerFunction(server1);
            this.registerFunction(server2);
        }
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                c.getLogger().info("SWAP:invoking function from client on g0");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g0"});
                if (withArgs) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("g0");
                    e = e.withArgs(args);
                }
                if (register) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(server0, 1);
        this.verifyAndResetInvocationCount(server1, 0);
        this.verifyAndResetInvocationCount(server2, 1);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                c.getLogger().fine("SWAP:invoking function from client on mg");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"mg"});
                if (withArgs) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("mg");
                    e = e.withArgs(args);
                }
                if (register) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(server0, 1);
        this.verifyAndResetInvocationCount(server1, 0);
        this.verifyAndResetInvocationCount(server2, 0);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                c.getLogger().fine("SWAP:invoking function from client on g0 g1");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g0", "g1"});
                if (withArgs) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("g0");
                    args.add("g1");
                    e = e.withArgs(args);
                }
                if (register) {
                    e.execute("OnGroupsFunction").getResult();
                } else {
                    e.execute((Function)new OnGroupsFunction()).getResult();
                }
                return null;
            }
        });
        this.verifyAndResetInvocationCount(server0, 1);
        this.verifyAndResetInvocationCount(server1, 1);
        this.verifyAndResetInvocationCount(server2, 1);
    }

    public void testStreamingClientServerFunction() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                c.getLogger().info("SWAP:invoking function from client on g0");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g0"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)10, (int)sum);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                c.getLogger().fine("SWAP:invoking function from client on mg");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"mg"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)5, (int)sum);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                c.getLogger().fine("SWAP:invoking function from client on g0 g1");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g0", "g1"});
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupMultiResultFunction()).getResult();
                int sum = 0;
                for (int i = 0; i < l.size(); ++i) {
                    sum += ((Integer)l.get(i)).intValue();
                }
                TestCase.assertEquals((int)15, (int)sum);
                return null;
            }
        });
    }

    public void testOnServer() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1,g2", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                try {
                    InternalFunctionService.onServer((RegionService)c, (String[])new String[]{"no such group"}).execute((Function)new OnGroupsFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException functionException) {
                    // empty catch block
                }
                InternalFunctionService.onServer((RegionService)c, (String[])new String[]{"g1"}).execute((Function)new OnGroupsFunction()).getResult();
                return null;
            }
        });
        int c0 = this.getAndResetInvocationCount(server0);
        int c1 = this.getAndResetInvocationCount(server1);
        int c2 = this.getAndResetInvocationCount(server2);
        OnGroupsFunctionExecutionDUnitTest.assertEquals((int)1, (int)(c0 + c1 + c2));
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                InternalFunctionService.onServer((RegionService)c, (String[])new String[]{"g0"}).execute((Function)new OnGroupsFunction()).getResult();
                return null;
            }
        });
        this.verifyAndResetInvocationCount(server0, 1);
        this.verifyAndResetInvocationCount(server1, 0);
        this.verifyAndResetInvocationCount(server2, 0);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                InternalFunctionService.onServer((RegionService)c, (String[])new String[]{"mg", "g1"}).execute((Function)new OnGroupsFunction()).getResult();
                return null;
            }
        });
        c0 = this.getAndResetInvocationCount(server0);
        c1 = this.getAndResetInvocationCount(server1);
        c2 = this.getAndResetInvocationCount(server2);
        OnGroupsFunctionExecutionDUnitTest.assertEquals((int)2, (int)(c0 + c1 + c2));
    }

    public void testClientServerException() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1,g2", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                try {
                    InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"no such group"}).execute((Function)new OnGroupsFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException functionException) {
                    // empty catch block
                }
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"mg"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("runtime");
                e = e.withArgs(args);
                try {
                    e.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                Execution e1 = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g1"});
                e1 = e1.withArgs(args);
                try {
                    e1.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                Execution e2 = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g1"});
                args.add("g2");
                e2 = e2.withArgs(args);
                try {
                    e2.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof NullPointerException));
                }
                return null;
            }
        });
    }

    public void testClientServerMemberFailure() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1,g2", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("disconnect");
                e = e.withArgs(args);
                try {
                    e.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof FunctionInvocationTargetException));
                }
                return null;
            }
        });
    }

    public void testClientServerOneMemberFailure() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1,g2", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("disconnect");
                args.add("g2");
                e = e.withArgs(args);
                try {
                    e.execute((Function)new OnGroupsExceptionFunction()).getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (FunctionException ex) {
                    TestCase.assertTrue((boolean)(ex.getCause() instanceof FunctionInvocationTargetException));
                }
                return null;
            }
        });
    }

    public void testClientServerIgnoreMemberFailure() {
        Host host = Host.getHost(0);
        VM server0 = host.getVM(0);
        VM server1 = host.getVM(1);
        VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1,g2", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g1"});
                ArrayList<String> args = new ArrayList<String>();
                args.add("disconnect");
                args.add("g2");
                e = e.withArgs(args);
                ((AbstractExecution)e).setIgnoreDepartedMembers(true);
                ArrayList l = (ArrayList)e.execute((Function)new OnGroupsExceptionFunction()).getResult();
                DistributedTestCase.getLogWriter().info("SWAP:result:" + l);
                TestCase.assertEquals((int)2, (int)l.size());
                if (l.get(0) instanceof Throwable) {
                    TestCase.assertTrue((boolean)((Boolean)l.get(1)));
                } else if (l.get(0) instanceof Boolean) {
                    TestCase.assertTrue((boolean)(l.get(1) instanceof Throwable));
                } else {
                    TestCase.fail((String)"expected to find a Boolean or throwable at index 0");
                }
                return null;
            }
        });
    }

    public void xtestNoAckGroupsFunction() {
        Host host = Host.getHost(0);
        final VM server0 = host.getVM(0);
        final VM server1 = host.getVM(1);
        final VM server2 = host.getVM(2);
        VM client = host.getVM(3);
        VM locator = Host.getLocator();
        String regionName = this.getName();
        this.initVM(server0, "mg,g0", regionName, true);
        this.initVM(server1, "g1", regionName, true);
        this.initVM(server2, "g0,g1", regionName, true);
        final int locatorPort = this.getLocatorPort(locator);
        final String hostName = host.getHostName();
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache c = CacheFactory.getAnyInstance();
                    c.close();
                }
                catch (CacheClosedException c) {
                    // empty catch block
                }
                DistributedTestCase.getLogWriter().fine("SWAP:creating client cache");
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolLocator(hostName, locatorPort);
                ccf.setPoolServerGroup("mg");
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache c = ccf.create();
                c.getLogger().info("SWAP:invoking function from client on g0");
                Execution e = InternalFunctionService.onServers((RegionService)c, (String[])new String[]{"g0"});
                e.execute((Function)new OnGroupsNoAckFunction());
                return null;
            }
        });
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int c2;
                int c1;
                int c0 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server0);
                return c0 + (c1 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server1)) + (c2 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server2)) == 2;
            }

            @Override
            public String description() {
                return "OnGroupsNoAck invocation count mismatch";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
        this.resetInvocationCount(server0);
        this.resetInvocationCount(server1);
        this.resetInvocationCount(server2);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCache c = ClientCacheFactory.getAnyInstance();
                Execution e = InternalFunctionService.onServer((RegionService)c, (String[])new String[]{"g1"});
                e.execute((Function)new OnGroupsNoAckFunction());
                return null;
            }
        });
        DistributedTestCase.pause(5000);
        DistributedTestCase.WaitCriterion wc2 = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int c2;
                int c1;
                int c0 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server0);
                return c0 + (c1 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server1)) + (c2 = OnGroupsFunctionExecutionDUnitTest.this.getInvocationCount(server2)) == 1;
            }

            @Override
            public String description() {
                return "OnGroupsNoAck invocation count mismatch";
            }
        };
        DistributedTestCase.waitForCriterion(wc2, 30000L, 1000L, true);
    }

    static class OnGroupsNoAckFunction
    extends OnGroupsFunction {
        OnGroupsNoAckFunction() {
        }

        public boolean hasResult() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }

    static class OnGroupsExceptionFunction
    extends FunctionAdapter {
        private static final long serialVersionUID = 6488843931404616442L;
        public static final String Id = "OnGroupsExceptionFunction";

        OnGroupsExceptionFunction() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(FunctionContext context) {
            ArrayList args = (ArrayList)context.getArguments();
            if (((String)args.get(0)).equals("runtime")) {
                if (args.size() <= 1) throw new NullPointerException();
                String group = (String)args.get(1);
                InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
                if (ds.getDistributedMember().getGroups().contains(group)) {
                    throw new NullPointerException();
                }
            } else {
                InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
                if (args.size() > 1) {
                    String group = (String)args.get(1);
                    if (ds.getDistributedMember().getGroups().contains(group)) {
                        ds.disconnect();
                    }
                } else {
                    ds.disconnect();
                }
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public String getId() {
            return Id;
        }
    }

    static class OnGroupMultiResultFunction
    extends FunctionAdapter {
        private static final long serialVersionUID = 8190290175486881994L;
        public static final String Id = "OnGroupMultiResultFunction";

        OnGroupMultiResultFunction() {
        }

        public void execute(FunctionContext context) {
            for (int i = 0; i < 4; ++i) {
                context.getResultSender().sendResult((Object)1);
            }
            context.getResultSender().lastResult((Object)1);
        }

        public String getId() {
            return Id;
        }
    }

    static class OnGroupsFunction
    extends FunctionAdapter {
        private static final long serialVersionUID = -1032915440862585532L;
        public static final String Id = "OnGroupsFunction";
        public static int invocationCount;

        OnGroupsFunction() {
        }

        public void execute(FunctionContext context) {
            DistributedTestCase.getLogWriter().fine("SWAP:1:executing OnGroupsFunction:" + invocationCount);
            InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
            ++invocationCount;
            ArrayList l = (ArrayList)context.getArguments();
            if (l != null) {
                TestCase.assertFalse((boolean)Collections.disjoint(l, ds.getDistributedMember().getGroups()));
            }
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public String getId() {
            return Id;
        }
    }
}

