/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PRClientServerRegionFunctionExecutionDUnitTest
extends PRClientServerTestBase {
    private static final String TEST_FUNCTION7 = "TestFunction7";
    private static final String TEST_FUNCTION2 = "TestFunction2";
    static Boolean isByName = null;
    private static int retryCount = 0;
    static Boolean toRegister = null;
    private static Region metaDataRegion;
    static final String retryRegionName = "RetryDataRegion";

    public PRClientServerRegionFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void test_Bug_43126_Function_Not_Registered() throws InterruptedException {
        this.createScenario();
        try {
            client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "executeRegisteredFunction");
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((boolean)true, (boolean)(e.getCause() instanceof ServerOperationException));
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)e.getCause().getMessage().contains("The function is not registered for function id"));
        }
    }

    public void test_Bug43126() throws InterruptedException {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "executeRegisteredFunction");
    }

    public void testServerSingleKeyExecution_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        SerializableRunnable suspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(suspect);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution", new Object[]{isByName, toRegister});
        SerializableRunnable endSuspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(endSuspect);
    }

    public void testServerSingleKeyExecution_Bug43513_OnRegion() {
        this.createScenario_SingleConnection();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecutionOnRegion_SingleConnection");
    }

    public void Bug47584_testServerSingleKeyExecution_Bug43513_OnServer() {
        this.createScenario_SingleConnection();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecutionOnServer_SingleConnection");
    }

    public void testServerSingleKeyExecution_SendException() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution_SendException", new Object[]{isByName, toRegister});
    }

    public void testServerSingleKeyExecution_ThrowException() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution_ThrowException", new Object[]{isByName, toRegister});
    }

    public void testClientWithoutPool_Bug41832() {
        this.createScenarioWith2Regions();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        SerializableRunnable suspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(suspect);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecutionWith2Regions", new Object[]{isByName, toRegister});
        SerializableRunnable endSuspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(endSuspect);
    }

    public void testServerExecution_NoLastResult() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(true);
        DistributedTestCase.ExpectedException ex = PRClientServerRegionFunctionExecutionDUnitTest.addExpectedException("did not send last result");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution_NoLastResult", new Object[]{isByName, toRegister});
        ex.remove();
    }

    public void testServerSingleKeyExecution_byName_WithoutRegister() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        toRegister = new Boolean(false);
        SerializableRunnable suspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(suspect);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution", new Object[]{isByName, toRegister});
        SerializableRunnable endSuspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(endSuspect);
    }

    public void testserverSingleKeyExecution_FunctionInvocationTargetException() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution_FunctionInvocationTargetException");
    }

    public void testServerSingleKeyExecution_SocketTimeOut() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecutionSocketTimeOut", new Object[]{isByName});
    }

    public void testServerSingleKeyExecution_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution", new Object[]{isByName, toRegister});
    }

    public void testServerSingleKeyExecution_byInlineFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverSingleKeyExecution_Inline");
    }

    public void testserverMultiKeyExecution_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution", new Object[]{isByName});
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "checkBucketsOnServer");
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "checkBucketsOnServer");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "checkBucketsOnServer");
    }

    public void testserverMultiKeyExecution_SendException() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution_SendException", new Object[]{isByName});
    }

    public void testserverMultiKeyExecution_ThrowException() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution_ThrowException", new Object[]{isByName});
    }

    public void testserverMultiKeyExecution_byInlineFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution_Inline");
    }

    public void testserverMultiKeyExecution_FunctionInvocationTargetException() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution_FunctionInvocationTargetException");
    }

    public void testserverMultiKeyExecutionNoResult_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(false, TEST_FUNCTION7);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecutionNoResult", new Object[]{isByName});
    }

    public void testserverMultiKeyExecution_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecution", new Object[]{isByName});
    }

    public void testserverMultiKeyExecutionOnASingleBucket_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecutionOnASingleBucket", new Object[]{isByName});
    }

    public void testserverMultiKeyExecutionOnASingleBucket_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecutionOnASingleBucket", new Object[]{isByName});
    }

    public static void regionSingleKeyExecutionNonHA(Boolean isByName, Function function, Boolean toRegister) {
        block4: {
            Region region = cache.getRegion(PartitionedRegionName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
            String testKey = "execKey";
            HashSet<String> testKeysSet = new HashSet<String>();
            testKeysSet.add("execKey");
            DistributedSystem.setThreadsSocketPolicy((boolean)false);
            if (toRegister.booleanValue()) {
                FunctionService.registerFunction((Function)function);
            } else {
                FunctionService.unregisterFunction((String)function.getId());
                PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
            }
            Execution dataSet = FunctionService.onRegion((Region)region);
            region.put((Object)"execKey", (Object)new Integer(1));
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(retryRegionName);
                args.add("regionSingleKeyExecutionNonHA");
                ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, args, function, isByName);
                PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Expected ServerConnectivityException not thrown!");
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof ServerConnectivityException || ex.getCause() instanceof FunctionInvocationTargetException) break block4;
                ex.printStackTrace();
                PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
                PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
            }
        }
    }

    public static void regionExecutionHAOneServerDown(Boolean isByName, Function function, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(retryRegionName);
            args.add("regionExecutionHAOneServerDown");
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, args, function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)((List)rs.getResult()).size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
    }

    public static void regionExecutionHATwoServerDown(Boolean isByName, Function function, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(retryRegionName);
            args.add("regionExecutionHATwoServerDown");
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, args, function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)((List)rs.getResult()).size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the execute operation");
        }
    }

    public static void createReplicatedRegion() {
        metaDataRegion = cache.createRegionFactory(RegionShortcut.REPLICATE).create(retryRegionName);
    }

    public static void createProxyRegion(String hostName) {
        CacheServerTestUtil.disableShufflingOfEndpoints();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(pool.getName());
        RegionAttributes attrs = factory.create();
        metaDataRegion = cache.createRegion(retryRegionName, attrs);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)metaDataRegion);
    }

    public static void verifyMetaData(Integer arg1, Integer arg2) {
        try {
            if (arg1 == 0) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)metaDataRegion.get((Object)"stopped"));
            } else {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)metaDataRegion.get((Object)"stopped"), (Object)arg1);
            }
            if (arg2 == 0) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)metaDataRegion.get((Object)"sentresult"));
            } else {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)metaDataRegion.get((Object)"sentresult"), (Object)arg2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"The metadata doesn't match with the expected value.");
        }
    }

    public static void registerFunction() {
        FunctionService.registerFunction((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Failure");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.FALSE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        });
    }

    public static void FunctionExecution_Inline_Bug40714() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            region.put(i.next(), (Object)val);
        }
        List list = (List)FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Success");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.TRUE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        }).getResult();
        PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)list.size());
        Iterator iterator = list.iterator();
        for (int i2 = 0; i2 < 3; ++i2) {
            Boolean res = (Boolean)iterator.next();
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)res);
        }
    }

    public static void verifyDeadAndLiveServers(Integer expectedDeadServers, final Integer expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int sz = PRClientServerTestBase.pool.getConnectedServerCount();
                DistributedTestCase.getLogWriter().info("Checking for the Live Servers : Expected  : " + expectedLiveServers + " Available :" + sz);
                if (sz == expectedLiveServers) {
                    return true;
                }
                this.excuse = "Expected " + expectedLiveServers + " but found " + sz;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
    }

    public static void executeFunction() throws ServerException, InterruptedException {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
            List l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i = l.iterator();
            while (i.hasNext()) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, i.next());
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Got an exception : " + e.getMessage());
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((e instanceof EOFException || e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ServerException || e instanceof IOException || e instanceof CacheClosedException ? 1 : 0) != 0);
        }
    }

    public static Object executeFunctionHA() throws Exception {
        Region region = cache.getRegion(PartitionedRegionName);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
        List l = (List)rc1.getResult();
        PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
        return l;
    }

    public static void putOperation() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
    }

    protected void createScenario() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
    }

    private void createScenario_SingleConnection() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 13, null);
        this.createClientServerScenarion_SingleConnection(commonAttributes, 0, 20, 20);
    }

    private void createScenarioWith2Regions() {
        ArrayList commonAttributes = this.createCommonServerAttributes(PartitionedRegionName, null, 0, 13, null);
        this.createClientServerScenarionWith2Regions(commonAttributes, 20, 20, 20);
    }

    public static void checkBucketsOnServer() {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(PartitionedRegionName);
        HashMap localBucket2RegionMap = (HashMap)region.getDataStore().getSizeLocally();
        PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Size of the " + PartitionedRegionName + " in this VM :- " + localBucket2RegionMap.size());
        Set entrySet = localBucket2RegionMap.entrySet();
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull(entrySet);
    }

    public static void serverMultiKeyExecutionOnASingleBucket(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            region.put(i.next(), (Object)val);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Iterator kiter = testKeysSet.iterator();
        while (kiter.hasNext()) {
            try {
                Set singleKeySet = Collections.singleton(kiter.next());
                TestFunction function = new TestFunction(true, TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)region);
                ResultCollector rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, singleKeySet, Boolean.TRUE, (Function)function, isByName);
                List l = null;
                l = (List)rc1.getResult();
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)l.size());
                ResultCollector rc2 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, singleKeySet, new HashSet(singleKeySet), (Function)function, isByName);
                List l2 = null;
                l2 = (List)rc2.getResult();
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)l2.size());
                List subList = (List)l2.iterator().next();
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)subList.size());
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)region.get(singleKeySet.iterator().next()), subList.iterator().next());
            }
            catch (Exception expected) {
                PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : " + expected.getMessage());
                expected.printStackTrace();
                PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the put operation");
            }
        }
    }

    public static void serverMultiKeyExecution(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
            List l2 = null;
            ResultCollector rc2 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, testKeysSet, (Function)function, isByName);
            l2 = (List)rc2.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l2.size());
            HashSet foundVals = new HashSet();
            for (ArrayList subL : l2) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                Iterator subI = subL.iterator();
                while (subI.hasNext()) {
                    PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)foundVals.add(subI.next()));
                }
            }
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals(origVals, foundVals);
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void serverMultiKeyExecution_SendException(Boolean isByName) {
        ResultCollector rc1;
        List l;
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
        try {
            l = null;
            rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)(i2.next() instanceof MyFunctionExecutionException));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"No Exception Expected");
        }
        try {
            l = null;
            rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, testKeysSet, (Function)function, isByName);
            List resultList = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)(testKeysSet.size() * 3 + 3), (int)resultList.size());
            Iterator resultIterator = resultList.iterator();
            int exceptionCount = 0;
            while (resultIterator.hasNext()) {
                Object o = resultIterator.next();
                if (!(o instanceof MyFunctionExecutionException)) continue;
                ++exceptionCount;
            }
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)exceptionCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"No Exception Expected");
        }
    }

    public static void serverMultiKeyExecution_ThrowException(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
        try {
            Object l = null;
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Exception Expected");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void serverMultiKeyExecutionSocketTimeOut(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void serverSingleKeyExecutionSocketTimeOut(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            ResultCollector rs2 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, (Serializable)((Object)"execKey"), (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)"execKey", ((List)rs2.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    public static void serverMultiKeyExecution_Inline() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : " + e.getMessage());
            e.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the put operation");
        }
    }

    public static void serverMultiKeyExecution_FunctionInvocationTargetException() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
        ResultCollector rc1 = null;
        try {
            rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (((RegionFunctionContext)context).isPossibleDuplicate()) {
                        context.getResultSender().lastResult((Object)new Integer(retryCount));
                        return;
                    }
                    if (context.getArguments() instanceof Boolean) {
                        throw new FunctionInvocationTargetException("I have been thrown from TestFunction");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            ArrayList list = (ArrayList)rc1.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals(list.get(0), (Object)0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail("This is not expected Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverMultiKeyExecutionNoResult(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(false, TEST_FUNCTION7);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            String msg = "<ExpectedException action=add>FunctionException</ExpectedException>";
            cache.getLogger().info(msg);
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            rc1.getResult();
            Thread.sleep(20000L);
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Test failed after the put operation");
        }
        catch (FunctionException expected) {
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)expected.getMessage().startsWith(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
        }
        catch (Exception notexpected) {
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed during execute or sleeping", notexpected);
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>FunctionException</ExpectedException>");
        }
    }

    public static void serverSingleKeyExecutionOnRegion_SingleConnection() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        for (int i = 0; i < 13; ++i) {
            region.put((Object)new Integer(i), (Object)("KB_" + i));
        }
        TestFunction function = new TestFunction(false, TEST_FUNCTION2);
        Execution dataSet = FunctionService.onRegion((Region)region);
        dataSet.withArgs((Object)Boolean.TRUE).execute((Function)function);
        region.put((Object)new Integer(2), (Object)"KB_2");
        PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)"KB_2", (Object)region.get((Object)new Integer(2)));
    }

    public static void serverSingleKeyExecutionOnServer_SingleConnection() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        TestFunction function = new TestFunction(false, TEST_FUNCTION2);
        Execution dataSet = FunctionService.onServer((Pool)pool);
        dataSet.withArgs((Object)Boolean.TRUE).execute((Function)function);
        region.put((Object)new Integer(1), (Object)"KB_1");
        PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)"KB_1", (Object)region.get((Object)new Integer(1)));
    }

    public static void serverSingleKeyExecution(Boolean isByName, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
        }
        catch (Exception expected) {
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((expected.getMessage().contains("No target node found for KEY = execKey") || expected.getMessage().startsWith("Server could not send the reply") || expected.getMessage().startsWith("Unexpected exception during") ? 1 : 0) != 0);
        }
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            ResultCollector rs2 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, (Serializable)((Object)"execKey"), (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)new Integer(1), ((List)rs2.getResult()).get(0));
            HashMap<String, Integer> putData = new HashMap<String, Integer>();
            putData.put("execKey1", new Integer(2));
            putData.put("execKey2", new Integer(3));
            ResultCollector rs1 = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, putData, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)new Integer(2), (Object)region.get((Object)"execKey1"));
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)new Integer(3), (Object)region.get((Object)"execKey2"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    public static void executeRegisteredFunction() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        ((AbstractExecution)dataSet).removeFunctionAttributes(TEST_FUNCTION2);
        ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(TEST_FUNCTION2);
        PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
        byte[] functionAttributes = ((AbstractExecution)dataSet).getFunctionAttributes(TEST_FUNCTION2);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)functionAttributes);
        rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(TEST_FUNCTION2);
        PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)functionAttributes);
    }

    public static void serverSingleKeyExecution_SendException(Boolean isByName, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunction_SendException");
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        ResultCollector rs = null;
        try {
            rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)(((List)rs.getResult()).get(0) instanceof MyFunctionExecutionException));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
        try {
            rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, testKeysSet, (Function)function, isByName);
            List resultList = (List)rs.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)(testKeysSet.size() + 1), (int)resultList.size());
            Iterator resultIterator = resultList.iterator();
            int exceptionCount = 0;
            while (resultIterator.hasNext()) {
                Object o = resultIterator.next();
                if (!(o instanceof MyFunctionExecutionException)) continue;
                ++exceptionCount;
            }
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((int)1, (int)exceptionCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    public static void serverSingleKeyExecution_ThrowException(Boolean isByName, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        ResultCollector rs = null;
        try {
            rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Exception Expected");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)(ex instanceof Exception));
        }
    }

    public static void serverSingleKeyExecutionWith2Regions(Boolean isByName, Boolean toRegister) {
        Region region1 = cache.getRegion(PartitionedRegionName + "1");
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region1);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet1 = FunctionService.onRegion((Region)region1);
        region1.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = dataSet1.execute(function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.FALSE, ((List)rs.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
        Region region2 = cache.getRegion(PartitionedRegionName + "2");
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region2);
        Execution dataSet2 = FunctionService.onRegion((Region)region2);
        region2.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = dataSet2.execute(function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Expected FunctionException");
        }
        catch (Exception ex) {
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().startsWith("No Replicated Region found for executing function"));
        }
    }

    public static void serverSingleKeyExecution_NoLastResult(Boolean isByName, Boolean toRegister) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
        if (toRegister.booleanValue()) {
            FunctionService.registerFunction((Function)function);
        } else {
            FunctionService.unregisterFunction((String)function.getId());
            PRClientServerRegionFunctionExecutionDUnitTest.assertNull((Object)FunctionService.getFunction((String)function.getId()));
        }
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            PRClientServerRegionFunctionExecutionDUnitTest.fail((String)"Expected FunctionException : Function did not send last result");
        }
        catch (Exception ex) {
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)ex.getMessage().contains("did not send last result"));
        }
    }

    public static void serverSingleKeyExecution_FunctionInvocationTargetException() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, false);
            ArrayList list = (ArrayList)rs.getResult();
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue(((Integer)list.get(0) >= 5 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.fail("This is not expected Exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverSingleKeyExecution_Inline() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    }
                    context.getResultSender().lastResult((Object)"Failure");
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
        }
        catch (Exception expected) {
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().fine("Exception occured : " + expected.getMessage());
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((expected.getMessage().contains("No target node found for KEY = execKey") || expected.getMessage().startsWith("Server could not send the reply") || expected.getMessage().startsWith("Unexpected exception during") ? 1 : 0) != 0);
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
        }
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)"Failure", ((List)rs.getResult()).get(0));
            ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            PRClientServerRegionFunctionExecutionDUnitTest.assertEquals((Object)"Success", ((List)rs2.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverBug43430() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            cache.getLogger().info("<ExpectedException action=add>Could not create an instance of  com.gemstone.gemfire.internal.cache.execute.PRClientServerRegionFunctionExecutionDUnitTest$UnDeserializable</ExpectedException>");
            dataSet.withFilter(testKeysSet).withArgs((Object)new UnDeserializable()).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    }
                    context.getResultSender().lastResult((Object)"Failure");
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
        }
        catch (Exception expected) {
            PRClientServerRegionFunctionExecutionDUnitTest.getLogWriter().fine("Exception occured : " + expected.getMessage());
            PRClientServerRegionFunctionExecutionDUnitTest.assertTrue((boolean)expected.getCause().getMessage().contains("Could not create an instance of  com.gemstone.gemfire.internal.cache.execute.PRClientServerRegionFunctionExecutionDUnitTest$UnDeserializable"));
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>Could not create an instance of  com.gemstone.gemfire.internal.cache.execute.PRClientServerRegionFunctionExecutionDUnitTest$UnDeserializable</ExpectedException>");
        }
    }

    private static ResultCollector execute(Execution dataSet, Set testKeysSet, Serializable args, Function function, Boolean isByName) throws Exception {
        if (isByName.booleanValue()) {
            return dataSet.withFilter(testKeysSet).withArgs((Object)args).execute(function.getId());
        }
        return dataSet.withFilter(testKeysSet).withArgs((Object)args).execute(function);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testBug43430() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        SerializableRunnable suspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(suspect);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverBug43430", new Object[0]);
        SerializableRunnable endSuspect = new SerializableRunnable(){

            @Override
            public void run() {
                PRClientServerTestBase.cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            }
        };
        this.runOnAllServers(endSuspect);
    }

    private static class UnDeserializable
    implements DataSerializable {
        private UnDeserializable() {
        }

        public void toData(DataOutput out) throws IOException {
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new RuntimeException("deserialization is not allowed on this class");
        }
    }
}

