/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerRegionFunctionExecutionDUnitTest;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PRClientServerRegionFunctionExecutionFailoverDUnitTest
extends PRClientServerTestBase {
    private static Locator locator = null;
    private static Region region = null;

    public PRClientServerRegionFunctionExecutionFailoverDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testserverMultiKeyExecution_SocektTimeOut() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer((Function)function);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "serverMultiKeyExecutionSocketTimeOut", new Object[]{new Boolean(true)});
    }

    public void testServerFailoverWithTwoServerAliveHA() throws InterruptedException {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        this.registerFunctionAtServer((Function)function);
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "putOperation");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = client.invokeAsync(PRClientServerRegionFunctionExecutionDUnitTest.class, "executeFunctionHA");
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "startServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "startServerHA");
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(1), new Integer(2)});
        DistributedTestCase.join(async[0], 360000L, PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testServerCacheClosedFailoverWithTwoServerAliveHA() throws InterruptedException {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        this.registerFunctionAtServer((Function)function);
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "putOperation");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = client.invokeAsync(PRClientServerRegionFunctionExecutionDUnitTest.class, "executeFunctionHA");
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "startServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "startServerHA");
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "closeCacheHA");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(1), new Integer(2)});
        DistributedTestCase.join(async[0], 300000L, PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testBug40714() {
        this.createScenario();
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "registerFunction");
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "registerFunction");
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "registerFunction");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "registerFunction");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "FunctionExecution_Inline_Bug40714");
    }

    public void testOnRegionFailoverWithTwoServerDownHA() throws InterruptedException {
        this.createScenario();
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{PRClientServerRegionFunctionExecutionFailoverDUnitTest.getServerHostName(server1.getHost())});
        TestFunction function = new TestFunction(true, "executeFunctionHAOnRegion");
        this.registerFunctionAtServer((Function)function);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "regionExecutionHATwoServerDown", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(2), new Integer(1)});
    }

    public void xtestOnRegionFailoverWithOneServerDownHA() throws InterruptedException {
        this.createScenario();
        server1.invokeAsync(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invokeAsync(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invokeAsync(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{PRClientServerRegionFunctionExecutionFailoverDUnitTest.getServerHostName(server1.getHost())});
        TestFunction function = new TestFunction(true, "executeFunctionHAOnRegion");
        this.registerFunctionAtServer((Function)function);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "regionExecutionHAOneServerDown", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(1), new Integer(1)});
    }

    public void testOnRegionFailoverNonHA() throws InterruptedException {
        this.createScenario();
        server1.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server2.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        server3.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createReplicatedRegion");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "createProxyRegion", new Object[]{PRClientServerRegionFunctionExecutionFailoverDUnitTest.getServerHostName(server1.getHost())});
        TestFunction function = new TestFunction(true, "executeFunctionNonHAOnRegion");
        this.registerFunctionAtServer((Function)function);
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "regionSingleKeyExecutionNonHA", new Object[]{Boolean.FALSE, function, Boolean.FALSE});
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyMetaData", new Object[]{new Integer(1), new Integer(0)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerBucketMovedException() throws InterruptedException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.disconnectAllFromDS();
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 113, null);
        int portLocator = AvailablePort.getRandomAvailablePort((int)0);
        String hostLocator = PRClientServerRegionFunctionExecutionFailoverDUnitTest.getServerHostName(server1.getHost());
        String locator = hostLocator + "[" + portLocator + "]";
        this.startLocatorInVM(portLocator);
        try {
            Integer port1 = (Integer)server1.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, commonAttributes});
            Integer port2 = (Integer)server2.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, commonAttributes});
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createClientWithLocator", new Object[]{hostLocator, portLocator});
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "putIntoRegion");
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "fetchMetaData");
            Integer port3 = (Integer)server3.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, commonAttributes});
            Object result = server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "executeFunction");
            List l = (List)result;
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertEquals((int)2, (int)l.size());
        }
        finally {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.stopLocator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerBucketMovedException_LocalServer() throws InterruptedException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 113, null);
        int portLocator = AvailablePort.getRandomAvailablePort((int)0);
        String hostLocator = PRClientServerRegionFunctionExecutionFailoverDUnitTest.getServerHostName(server1.getHost());
        String locator = hostLocator + "[" + portLocator + "]";
        this.startLocatorInVM(portLocator);
        try {
            Integer port1 = (Integer)server1.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, commonAttributes});
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createClientWithLocator", new Object[]{hostLocator, portLocator});
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "putIntoRegion");
            server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "fetchMetaData");
            Integer port2 = (Integer)server2.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "createServerWithLocator", new Object[]{locator, false, commonAttributes});
            Object result = server4.invoke(PRClientServerRegionFunctionExecutionFailoverDUnitTest.class, "executeFunction");
            List l = (List)result;
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertEquals((int)2, (int)l.size());
        }
        finally {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.stopLocator();
        }
    }

    public static void fetchMetaData() {
        ((GemFireCacheImpl)cache).getClientMetadataService().getClientPRMetadata((LocalRegion)region);
    }

    public void startLocatorInVM(int locatorPort) {
        File logFile = new File("locator-" + locatorPort + ".log");
        Properties props = new Properties();
        props = this.getAllDistributedSystemProperties(props);
        try {
            locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, null, (Properties)props);
        }
        catch (IOException e) {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.fail("Unable to start locator ", e);
        }
    }

    public static void stopLocator() {
        locator.stop();
    }

    public static int createServerWithLocator(String locator, boolean isAccessor, ArrayList commonAttrs) {
        PRClientServerRegionFunctionExecutionFailoverDUnitTest test = new PRClientServerRegionFunctionExecutionFailoverDUnitTest("PRClientServerRegionFunctionExecutionFailoverDUnitTest");
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("locators", locator);
        InternalDistributedSystem ds = test.getSystem(props);
        new CacheFactory(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PRClientServerRegionFunctionExecutionFailoverDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        if (isAccessor) {
            paf.setLocalMaxMemory(0);
        }
        paf.setTotalNumBuckets(((Integer)commonAttrs.get(3)).intValue()).setRedundantCopies(((Integer)commonAttrs.get(2)).intValue());
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(regionName, attr.create());
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertNotNull((Object)region);
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter().info("Partitioned Region " + regionName + " created Successfully :" + region.toString());
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocator(String host, int port0) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PRClientServerRegionFunctionExecutionFailoverDUnitTest test = new PRClientServerRegionFunctionExecutionFailoverDUnitTest("PRClientServerRegionFunctionExecutionFailoverDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create("Pool_" + regionName);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(p.getName());
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(regionName, attrs);
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.assertNotNull((Object)region);
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter().info("Distributed Region " + regionName + " created Successfully :" + region.toString());
    }

    public static void putIntoRegion() {
        for (int i = 0; i < 113; ++i) {
            region.put((Object)i, (Object)("KB_" + i));
        }
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter().info("Distributed Region " + regionName + " Have size :" + region.size());
    }

    public static Object executeFunction() {
        Execution execute = FunctionService.onRegion((Region)region);
        ResultCollector rc = execute.withArgs((Object)Boolean.TRUE).execute((Function)new TestFunction(true, "executeFunctionWithLastResult"));
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter().info("Exeuction Result :" + rc.getResult());
        List l = (List)rc.getResult();
        return l;
    }

    public static void checkSize() {
        PRClientServerRegionFunctionExecutionFailoverDUnitTest.getLogWriter().info("Partitioned Region " + regionName + " Have size :" + region.size());
    }

    protected void createScenario() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
    }
}

