/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerRegionFunctionExecutionDUnitTest;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PRClientServerRegionFunctionExecutionSingleHopDUnitTest
extends PRClientServerTestBase {
    private static final String TEST_FUNCTION7 = "TestFunction7";
    private static final String TEST_FUNCTION2 = "TestFunction2";
    static Boolean isByName = null;
    private static int retryCount = 0;

    public PRClientServerRegionFunctionExecutionSingleHopDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testServerAllKeyExecution_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverAllKeyExecution", new Object[]{isByName});
    }

    public void testServerGetAllFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "getAll");
    }

    public void testServerPutAllFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "putAll");
    }

    public void testServerSingleKeyExecution_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverSingleKeyExecution", new Object[]{isByName});
    }

    public void testserverSingleKeyExecution_FunctionInvocationTargetException() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverSingleKeyExecution_FunctionInvocationTargetException");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerSingleKeyExecution_SocketTimeOut() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer((Function)function);
        isByName = Boolean.TRUE;
        DistributedTestCase.ExpectedException expectedEx = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.addExpectedException(DistributedSystemDisconnectedException.class.getName(), server1);
        try {
            client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverSingleKeyExecutionSocketTimeOut", new Object[]{isByName});
        }
        finally {
            expectedEx.remove();
        }
    }

    public void testServerSingleKeyExecution_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverSingleKeyExecution", new Object[]{isByName});
    }

    public void testServerSingleKeyExecution_byInlineFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverSingleKeyExecution_Inline");
    }

    public void testserverMultiKeyExecution_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecution", new Object[]{isByName});
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "checkBucketsOnServer");
        server2.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "checkBucketsOnServer");
        server3.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "checkBucketsOnServer");
    }

    public void testserverMultiKeyExecution_SocektTimeOut() {
        this.createScenario();
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecutionSocketTimeOut", new Object[]{isByName});
    }

    public void testserverMultiKeyExecution_byInlineFunction() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecution_Inline");
    }

    public void testserverMultiKeyExecution_FunctionInvocationTargetException() {
        this.createScenario();
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecution_FunctionInvocationTargetException");
    }

    public void testserverMultiKeyExecutionNoResult_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(false, TEST_FUNCTION7);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecutionNoResult", new Object[]{isByName});
    }

    public void testserverMultiKeyExecution_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecution", new Object[]{isByName});
    }

    public void testserverMultiKeyExecutionOnASingleBucket_byName() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(true);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecutionOnASingleBucket", new Object[]{isByName});
    }

    public void testserverMultiKeyExecutionOnASingleBucket_byInstance() {
        this.createScenario();
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        this.registerFunctionAtServer((Function)function);
        isByName = new Boolean(false);
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "serverMultiKeyExecutionOnASingleBucket", new Object[]{isByName});
    }

    public void testServerFailoverWithTwoServerAliveHA() throws InterruptedException {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        this.registerFunctionAtServer((Function)function);
        server2.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "stopServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "putOperation");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = client.invokeAsync(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "executeFunctionHA");
        server2.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "startServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "startServerHA");
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(1), new Integer(2)});
        DistributedTestCase.join(async[0], 360000L, PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testServerCacheClosedFailoverWithTwoServerAliveHA() throws InterruptedException {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 13, null);
        this.createClientServerScenarion(commonAttributes, 20, 20, 20);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        this.registerFunctionAtServer((Function)function);
        server2.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "stopServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "stopServerHA");
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "putOperation");
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = client.invokeAsync(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "executeFunctionHA");
        server2.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "startServerHA");
        server3.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "startServerHA");
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "closeCacheHA");
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "verifyDeadAndLiveServers", new Object[]{new Integer(1), new Integer(2)});
        DistributedTestCase.join(async[0], 300000L, PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testBug40714() {
        this.createScenario();
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "registerFunction");
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "registerFunction");
        server1.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "registerFunction");
        client.invoke(PRClientServerRegionFunctionExecutionSingleHopDUnitTest.class, "registerFunction");
        client.invoke(PRClientServerRegionFunctionExecutionDUnitTest.class, "FunctionExecution_Inline_Bug40714");
    }

    public static void registerFunction() {
        FunctionService.registerFunction((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Failure");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.FALSE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        });
    }

    public static void FunctionExecution_Inline_Bug40714() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            region.put(i.next(), (Object)val);
        }
        HashMap resultMap = (HashMap)FunctionService.onRegion((Region)region).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

            public void execute(FunctionContext context) {
                if (context.getArguments() instanceof String) {
                    context.getResultSender().lastResult((Object)"Success");
                } else if (context.getArguments() instanceof Boolean) {
                    context.getResultSender().lastResult((Object)Boolean.TRUE);
                }
            }

            public String getId() {
                return "Function";
            }

            public boolean hasResult() {
                return true;
            }
        }).getResult();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)resultMap.size());
        Iterator mapIterator = resultMap.entrySet().iterator();
        Map.Entry entry = null;
        ArrayList resultListForMember = null;
        while (mapIterator.hasNext()) {
            entry = mapIterator.next();
            resultListForMember = (ArrayList)entry.getValue();
            for (Object result : resultListForMember) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, result);
            }
        }
    }

    public static void verifyDeadAndLiveServers(Integer expectedDeadServers, final Integer expectedLiveServers) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int sz = PRClientServerTestBase.pool.getConnectedServerCount();
                DistributedTestCase.getLogWriter().info("Checking for the Live Servers : Expected  : " + expectedLiveServers + " Available :" + sz);
                if (sz == expectedLiveServers) {
                    return true;
                }
                this.excuse = "Expected " + expectedLiveServers + " but found " + sz;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 180000L, 1000L, true);
    }

    public static void executeFunction() throws ServerException, InterruptedException {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
            HashMap resultMap = (HashMap)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)resultMap.size());
            Iterator mapIterator = resultMap.entrySet().iterator();
            Map.Entry entry = null;
            ArrayList resultListForMember = null;
            while (mapIterator.hasNext()) {
                entry = mapIterator.next();
                resultListForMember = (ArrayList)entry.getValue();
                for (Object result : resultListForMember) {
                    PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, result);
                }
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Got an exception : " + e.getMessage());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((e instanceof EOFException || e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ServerException || e instanceof IOException || e instanceof CacheClosedException ? 1 : 0) != 0);
        }
    }

    public static Object executeFunctionHA() throws Exception {
        Region region = cache.getRegion(PartitionedRegionName);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
        List l = (List)rc1.getResult();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result size : " + l.size());
        return l;
    }

    public static void putOperation() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 10; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
    }

    private void createScenario() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 0, 13, null);
        this.createClientServerScenarioSingleHop(commonAttributes, 20, 20, 20);
    }

    public static void checkBucketsOnServer() {
        PartitionedRegion region = (PartitionedRegion)cache.getRegion(PartitionedRegionName);
        HashMap localBucket2RegionMap = (HashMap)region.getDataStore().getSizeLocally();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Size of the " + PartitionedRegionName + " in this VM :- " + localBucket2RegionMap.size());
        Set entrySet = localBucket2RegionMap.entrySet();
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull(entrySet);
    }

    public static void serverAllKeyExecution(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets / 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.executeOnAll(dataSet, Boolean.TRUE, (Function)function, isByName);
            List resultList = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result size : " + resultList.size());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result are SSSS : " + resultList);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)resultList.size());
            for (Object result : resultList) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, result);
            }
            List l2 = null;
            ResultCollector rc2 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.executeOnAll(dataSet, testKeysSet, (Function)function, isByName);
            l2 = (List)rc2.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)l2.size());
            HashSet foundVals = new HashSet();
            for (ArrayList subL : l2) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                Iterator subI = subL.iterator();
                while (subI.hasNext()) {
                    PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)foundVals.add(subI.next()));
                }
            }
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals(origVals, foundVals);
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void getAll() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        ArrayList<String> testKeysList = new ArrayList<String>();
        for (int i = totalNumBuckets * 3; i > 0; --i) {
            testKeysList.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        try {
            int j = 0;
            HashMap origVals = new HashMap();
            Iterator i = testKeysList.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                Object key = i.next();
                origVals.put(key, val);
                region.put(key, (Object)val);
            }
            Map resultMap = region.getAll(testKeysList);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)resultMap.equals(origVals));
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.pause(2000);
            Map secondResultMap = region.getAll(testKeysList);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)secondResultMap.equals(origVals));
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void putAll() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        ArrayList<String> testKeysList = new ArrayList<String>();
        for (int i = totalNumBuckets * 3; i > 0; --i) {
            testKeysList.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        try {
            int j = 0;
            HashMap origVals = new HashMap();
            Iterator i = testKeysList.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                Object key = i.next();
                origVals.put(key, val);
                region.put(key, (Object)val);
            }
            Map resultMap = region.getAll(testKeysList);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)resultMap.equals(origVals));
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.pause(2000);
            Map secondResultMap = region.getAll(testKeysList);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)secondResultMap.equals(origVals));
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void serverMultiKeyExecutionOnASingleBucket(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        int j = 0;
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            region.put(i.next(), (Object)val);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Iterator kiter = testKeysSet.iterator();
        while (kiter.hasNext()) {
            try {
                Set singleKeySet = Collections.singleton(kiter.next());
                TestFunction function = new TestFunction(true, TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)region);
                ResultCollector rc1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, singleKeySet, Boolean.TRUE, (Function)function, isByName);
                List l = null;
                l = (List)rc1.getResult();
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)1, (int)l.size());
                ResultCollector rc2 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, singleKeySet, new HashSet(singleKeySet), (Function)function, isByName);
                List l2 = null;
                l2 = (List)rc2.getResult();
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)1, (int)l2.size());
                List subList = (List)l2.iterator().next();
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)1, (int)subList.size());
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)region.get(singleKeySet.iterator().next()), subList.iterator().next());
            }
            catch (Exception expected) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : " + expected.getMessage());
                expected.printStackTrace();
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail((String)"Test failed after the put operation");
            }
        }
    }

    public static void serverMultiKeyExecution(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
            List l2 = null;
            ResultCollector rc2 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, testKeysSet, (Function)function, isByName);
            l2 = (List)rc2.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)l2.size());
            HashSet foundVals = new HashSet();
            for (ArrayList subL : l2) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                Iterator subI = subL.iterator();
                while (subI.hasNext()) {
                    PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)foundVals.add(subI.next()));
                }
            }
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals(origVals, foundVals);
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", e);
        }
    }

    public static void serverMultiKeyExecutionSocketTimeOut(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the function execution", e);
        }
    }

    public static void serverSingleKeyExecutionSocketTimeOut(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "SocketTimeOutFunction");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            ResultCollector rs2 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, (Serializable)((Object)"execKey"), (Function)function, isByName);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)"execKey", ((List)rs2.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    public static void serverMultiKeyExecution_Inline() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            List l = null;
            ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else if (context.getArguments() instanceof Boolean) {
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            l = (List)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Result size : " + l.size());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((int)3, (int)l.size());
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, i2.next());
            }
        }
        catch (Exception e) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : " + e.getMessage());
            e.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail((String)"Test failed after the put operation");
        }
    }

    public static void serverMultiKeyExecution_FunctionInvocationTargetException() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        int j = 0;
        HashSet<Integer> origVals = new HashSet<Integer>();
        Iterator i = testKeysSet.iterator();
        while (i.hasNext()) {
            Integer val = new Integer(j++);
            origVals.add(val);
            region.put(i.next(), (Object)val);
        }
        ResultCollector rc1 = null;
        try {
            rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (((RegionFunctionContext)context).isPossibleDuplicate()) {
                        context.getResultSender().lastResult((Object)new Integer(retryCount));
                        return;
                    }
                    if (context.getArguments() instanceof Boolean) {
                        throw new FunctionInvocationTargetException("I have been thrown from TestFunction");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            ArrayList list = (ArrayList)rc1.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals(list.get(0), (Object)0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("This is not expected Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverMultiKeyExecutionNoResult(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = totalNumBuckets * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(false, TEST_FUNCTION7);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            String msg = "<ExpectedException action=add>FunctionException</ExpectedException>";
            cache.getLogger().info(msg);
            int j = 0;
            HashSet<Integer> origVals = new HashSet<Integer>();
            Iterator i = testKeysSet.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                origVals.add(val);
                region.put(i.next(), (Object)val);
            }
            ResultCollector rc1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            rc1.getResult();
            Thread.sleep(20000L);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail((String)"Test failed after the put operation");
        }
        catch (FunctionException expected) {
            expected.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : " + expected.getMessage());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((boolean)expected.getMessage().startsWith(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
        }
        catch (Exception notexpected) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed during execute or sleeping", notexpected);
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>FunctionException</ExpectedException>");
        }
    }

    public static void serverSingleKeyExecution(Boolean isByName) {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, TEST_FUNCTION2);
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
        }
        catch (Exception expected) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((expected.getMessage().contains("No target node found for KEY = execKey") || expected.getMessage().startsWith("Server could not send the reply") || expected.getMessage().startsWith("Unexpected exception during") ? 1 : 0) != 0);
        }
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs.getResult()).get(0));
            ResultCollector rs2 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, (Serializable)((Object)"execKey"), (Function)function, isByName);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)new Integer(1), ((List)rs2.getResult()).get(0));
            HashMap<String, Integer> putData = new HashMap<String, Integer>();
            putData.put("execKey1", new Integer(2));
            putData.put("execKey2", new Integer(3));
            ResultCollector rs1 = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, putData, (Function)function, isByName);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)new Integer(2), (Object)region.get((Object)"execKey1"));
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)new Integer(3), (Object)region.get((Object)"execKey2"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    public static void serverSingleKeyExecution_FunctionInvocationTargetException() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)region);
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = PRClientServerRegionFunctionExecutionSingleHopDUnitTest.execute(dataSet, testKeysSet, Boolean.TRUE, (Function)function, false);
            ArrayList list = (ArrayList)rs.getResult();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue(((Integer)list.get(0) >= 5 ? 1 : 0) != 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("This is not expected Exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serverSingleKeyExecution_Inline() {
        Region region = cache.getRegion(PartitionedRegionName);
        PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertNotNull((Object)region);
        String testKey = "execKey";
        HashSet<String> testKeysSet = new HashSet<String>();
        testKeysSet.add("execKey");
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        Execution dataSet = FunctionService.onRegion((Region)region);
        try {
            cache.getLogger().info("<ExpectedException action=add>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
            dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    }
                    context.getResultSender().lastResult((Object)"Failure");
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
        }
        catch (Exception expected) {
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().fine("Exception occured : " + expected.getMessage());
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertTrue((expected.getMessage().contains("No target node found for KEY = execKey") || expected.getMessage().startsWith("Server could not send the reply") || expected.getMessage().startsWith("Unexpected exception during") ? 1 : 0) != 0);
        }
        finally {
            cache.getLogger().info("<ExpectedException action=remove>No target node found for KEY = |Server could not send the reply|Unexpected exception during</ExpectedException>");
        }
        region.put((Object)"execKey", (Object)new Integer(1));
        try {
            ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)"Failure", ((List)rs.getResult()).get(0));
            ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext context) {
                    if (context.getArguments() instanceof String) {
                        context.getResultSender().lastResult((Object)"Success");
                    } else {
                        context.getResultSender().lastResult((Object)"Failure");
                    }
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public boolean hasResult() {
                    return true;
                }
            });
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.assertEquals((Object)"Success", ((List)rs2.getResult()).get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.getLogWriter().info("Exception : ", (Throwable)ex);
            PRClientServerRegionFunctionExecutionSingleHopDUnitTest.fail("Test failed after the put operation", ex);
        }
    }

    private static ResultCollector execute(Execution dataSet, Set testKeysSet, Serializable args, Function function, Boolean isByName) throws Exception {
        if (isByName.booleanValue()) {
            return dataSet.withFilter(testKeysSet).withArgs((Object)args).execute(function.getId());
        }
        return dataSet.withFilter(testKeysSet).withArgs((Object)args).execute(function);
    }

    private static ResultCollector executeOnAll(Execution dataSet, Serializable args, Function function, Boolean isByName) throws Exception {
        if (isByName.booleanValue()) {
            return dataSet.withArgs((Object)args).execute(function.getId());
        }
        return dataSet.withArgs((Object)args).execute(function);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

