/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PRClientServerTestBase
extends CacheTestCase {
    static VM server1 = null;
    static VM server2 = null;
    static VM server3 = null;
    static VM client = null;
    static Cache cache = null;
    static String PartitionedRegionName = "TestPartitionedRegion";
    static String regionName = "TestRegion";
    private static Region metaDataRegion;
    static PartitionResolver partitionResolver;
    static Integer redundancy;
    static Integer totalNumBuckets;
    static String colocatedWith;
    static Integer serverPort1;
    static Integer serverPort2;
    static Integer serverPort3;
    protected static PoolImpl pool;
    private boolean isSingleHop = false;
    private boolean isSelector = false;

    public PRClientServerTestBase(String name, boolean isSingleHop, boolean isSelector) {
        super(name);
        this.isSingleHop = isSingleHop;
        this.isSelector = isSelector;
    }

    public PRClientServerTestBase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        server3 = host.getVM(2);
        client = host.getVM(3);
    }

    public ArrayList createCommonServerAttributes(String regionName, PartitionResolver pr, int red, int numBuckets, String colocatedWithRegion) {
        ArrayList<Object> commonAttributes = new ArrayList<Object>();
        commonAttributes.add(regionName);
        commonAttributes.add(pr);
        commonAttributes.add(new Integer(red));
        commonAttributes.add(new Integer(totalNumBuckets));
        commonAttributes.add(colocatedWithRegion);
        return commonAttributes;
    }

    public static Integer createCacheServer(ArrayList commonAttributes, Integer localMaxMemory) {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setPartitionResolver((PartitionResolver)commonAttributes.get(1));
        paf.setRedundantCopies(((Integer)commonAttributes.get(2)).intValue());
        paf.setTotalNumBuckets(((Integer)commonAttributes.get(3)).intValue());
        paf.setColocatedWith((String)commonAttributes.get(4));
        paf.setLocalMaxMemory(localMaxMemory.intValue());
        PartitionAttributes partitionAttributes = paf.create();
        factory.setDataPolicy(DataPolicy.PARTITION);
        factory.setPartitionAttributes(partitionAttributes);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion((String)commonAttributes.get(0), attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
        CacheServer server1 = cache.addCacheServer();
        PRClientServerTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail("Failed to start the Server", e);
        }
        PRClientServerTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Integer createSelectorCacheServer(ArrayList commonAttributes, Integer localMaxMemory) {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setPartitionResolver((PartitionResolver)commonAttributes.get(1));
        paf.setRedundantCopies(((Integer)commonAttributes.get(2)).intValue());
        paf.setTotalNumBuckets(((Integer)commonAttributes.get(3)).intValue());
        paf.setColocatedWith((String)commonAttributes.get(4));
        paf.setLocalMaxMemory(localMaxMemory.intValue());
        PartitionAttributes partitionAttributes = paf.create();
        factory.setDataPolicy(DataPolicy.PARTITION);
        factory.setPartitionAttributes(partitionAttributes);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion((String)commonAttributes.get(0), attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
        CacheServer server1 = cache.addCacheServer();
        PRClientServerTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setMaxThreads(16);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail("Failed to start the Server", e);
        }
        PRClientServerTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Integer createCacheServerWith2Regions(ArrayList commonAttributes, Integer localMaxMemory) {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setPartitionResolver((PartitionResolver)commonAttributes.get(1));
        paf.setRedundantCopies(((Integer)commonAttributes.get(2)).intValue());
        paf.setTotalNumBuckets(((Integer)commonAttributes.get(3)).intValue());
        paf.setColocatedWith((String)commonAttributes.get(4));
        paf.setLocalMaxMemory(localMaxMemory.intValue());
        PartitionAttributes partitionAttributes = paf.create();
        factory.setDataPolicy(DataPolicy.PARTITION);
        factory.setPartitionAttributes(partitionAttributes);
        RegionAttributes attrs = factory.create();
        Region region1 = cache.createRegion(PartitionedRegionName + "1", attrs);
        PRClientServerTestBase.assertNotNull((Object)region1);
        Region region2 = cache.createRegion(PartitionedRegionName + "2", attrs);
        PRClientServerTestBase.assertNotNull((Object)region2);
        CacheServer server1 = cache.addCacheServer();
        PRClientServerTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail("Failed to start the Server", e);
        }
        PRClientServerTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Integer createCacheServer() {
        CacheServer server1 = cache.addCacheServer();
        PRClientServerTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail("Failed to start the Server", e);
        }
        PRClientServerTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Integer createCacheServerWithDR() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        PRClientServerTestBase.assertNotNull((Object)cache);
        Region region = cache.createRegion(regionName, factory.create());
        PRClientServerTestBase.assertNotNull((Object)region);
        CacheServer server1 = cache.addCacheServer();
        PRClientServerTestBase.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail("Failed to start the Server", e);
        }
        PRClientServerTestBase.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheClient(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(2000L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(2).setPRSingleHopEnabled(false).create("PRClientServerTestBase");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(PartitionedRegionName, attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheClient_SingleConnection(String host, Integer port1) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        serverPort1 = port1;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).setPingInterval(2000L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(0).setMaxConnections(1).setRetryAttempts(0).setPRSingleHopEnabled(false).create("PRClientServerTestBase");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(PartitionedRegionName, attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheClientWith2Regions(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(2000L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(2).create("PRClientServerTestBase");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region1 = cache.createRegion(PartitionedRegionName + "1", attrs);
        PRClientServerTestBase.assertNotNull((Object)region1);
        factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.EMPTY);
        attrs = factory.create();
        Region region2 = cache.createRegion(PartitionedRegionName + "2", attrs);
        PRClientServerTestBase.assertNotNull((Object)region2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSingleHopCacheClient(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(2000L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(2).setPRSingleHopEnabled(true).create("PRClientServerTestBase");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(PartitionedRegionName, attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNoSingleHopCacheClient(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(2000L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(2).setPRSingleHopEnabled(false).create("PRClientServerTestBase");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setDataPolicy(DataPolicy.EMPTY);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(PartitionedRegionName, attrs);
        PRClientServerTestBase.assertNotNull((Object)region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheClientWithoutRegion(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        PRClientServerTestBase.getLogWriter().info("PRClientServerTestBase#createCacheClientWithoutRegion : creating pool");
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(1).create("PRClientServerTestBaseWithoutRegion");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCacheClientWithDistributedRegion(String host, Integer port1, Integer port2, Integer port3) throws Exception {
        Pool p;
        CacheServerTestUtil.disableShufflingOfEndpoints();
        PRClientServerTestBase.getLogWriter().info("PRClientServerTestBase#createCacheClientWithoutRegion : creating pool");
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        try {
            p = PoolManager.createFactory().addServer(host, port1.intValue()).addServer(host, port2.intValue()).addServer(host, port3.intValue()).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(0).create("PRClientServerTestBaseWithoutRegion");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        pool = (PoolImpl)p;
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        PRClientServerTestBase.assertNotNull((Object)cache);
        Region region = cache.createRegion(regionName, factory.create());
        PRClientServerTestBase.assertNotNull((Object)region);
    }

    protected void createClientServerScenarion(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer3)});
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createCacheClient", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarion_SingleConnection(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        server2.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        serverPort1 = port1;
        client.invoke(PRClientServerTestBase.class, "createCacheClient_SingleConnection", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1});
    }

    protected void createClientServerScenarionWith2Regions(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServerWith2Regions", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServerWith2Regions", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServerWith2Regions", new Object[]{commonAttributes, new Integer(localMaxMemoryServer3)});
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createCacheClientWith2Regions", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarioSingleHop(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer3)});
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createSingleHopCacheClient", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarioNoSingleHop(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer3)});
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createNoSingleHopCacheClient", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarioSelectorNoSingleHop(ArrayList commonAttributes, int localMaxMemoryServer1, int localMaxMemoryServer2, int localMaxMemoryServer3) {
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createSelectorCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer1)});
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createSelectorCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer2)});
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createSelectorCacheServer", new Object[]{commonAttributes, new Integer(localMaxMemoryServer3)});
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createNoSingleHopCacheClient", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarionWithoutRegion() {
        PRClientServerTestBase.getLogWriter().info("PRClientServerTestBase#createClientServerScenarionWithoutRegion : creating client server");
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServer");
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServer");
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServer");
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createCacheClientWithoutRegion", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void createClientServerScenarionWithDistributedtRegion() {
        PRClientServerTestBase.getLogWriter().info("PRClientServerTestBase#createClientServerScenarionWithoutRegion : creating client server");
        this.createCacheInClientServer();
        Integer port1 = (Integer)server1.invoke(PRClientServerTestBase.class, "createCacheServerWithDR");
        Integer port2 = (Integer)server2.invoke(PRClientServerTestBase.class, "createCacheServerWithDR");
        Integer port3 = (Integer)server3.invoke(PRClientServerTestBase.class, "createCacheServerWithDR");
        serverPort1 = port1;
        serverPort2 = port2;
        serverPort3 = port3;
        client.invoke(PRClientServerTestBase.class, "createCacheClientWithDistributedRegion", new Object[]{PRClientServerTestBase.getServerHostName(server1.getHost()), port1, port2, port3});
    }

    protected void runOnAllServers(SerializableRunnable runnable) {
        server1.invoke(runnable);
        server2.invoke(runnable);
        server3.invoke(runnable);
    }

    protected void registerFunctionAtServer(Function function) {
        server1.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
        server2.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
        server3.invoke(PRClientServerTestBase.class, "registerFunction", new Object[]{function});
    }

    public static void registerFunction(Function function) {
        FunctionService.registerFunction((Function)function);
    }

    private void createCacheInClientServer() {
        Properties props = new Properties();
        server1.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server2.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        server3.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        client.invoke(PRClientServerTestBase.class, "createCacheInVm", new Object[]{props});
    }

    public static void createCacheInVm(Properties props) {
        new PRClientServerTestBase("temp").createCache(props);
    }

    private void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            PRClientServerTestBase.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            PRClientServerTestBase.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            PRClientServerTestBase.fail("Failed while creating the cache", e);
        }
    }

    public static void startServerHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 2000L, 500L, false);
        List bridgeServers = cache.getCacheServers();
        PRClientServerTestBase.getLogWriter().info("Start Server Bridge Servers list : " + bridgeServers.size());
        Iterator bridgeIterator = bridgeServers.iterator();
        CacheServer bridgeServer = (CacheServer)bridgeIterator.next();
        PRClientServerTestBase.getLogWriter().info("start Server Bridge Server" + bridgeServer);
        try {
            bridgeServer.start();
        }
        catch (IOException e) {
            PRClientServerTestBase.fail((String)"not able to start the server");
        }
    }

    public static void stopServerHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 1000L, 200L, false);
        try {
            Iterator iter = cache.getCacheServers().iterator();
            if (iter.hasNext()) {
                CacheServer server = (CacheServer)iter.next();
                server.stop();
            }
        }
        catch (Exception e) {
            PRClientServerTestBase.fail((String)("failed while stopServer()" + e));
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PRClientServerTestBase.closeCache();
        client.invoke(PRClientServerTestBase.class, "closeCache");
        server1.invoke(PRClientServerTestBase.class, "closeCache");
        server2.invoke(PRClientServerTestBase.class, "closeCache");
        server3.invoke(PRClientServerTestBase.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void closeCacheHA() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 1000L, 200L, false);
        if (cache != null && !cache.isClosed()) {
            cache.close();
        }
    }

    static {
        partitionResolver = null;
        redundancy = new Integer(0);
        totalNumBuckets = new Integer(13);
        colocatedWith = null;
        serverPort1 = null;
        serverPort2 = null;
        serverPort3 = null;
        pool = null;
    }
}

