/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import com.gemstone.gemfire.internal.cache.execute.CustomResultCollector;
import com.gemstone.gemfire.internal.cache.execute.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PRFunctionExecutionDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static final String TEST_FUNCTION7 = "TestFunction7";
    private static final String TEST_FUNCTION2 = "TestFunction2";
    static Cache cache = null;
    static String regionName = null;
    private static final long serialVersionUID = 1L;

    public PRFunctionExecutionDUnitTest(String name) {
        super(name);
    }

    public void testFunctionExecution() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                Properties props = new Properties();
                props.setProperty("mcast-port", "0");
                props.setProperty("locators", "");
                InternalDistributedSystem ds = PRFunctionExecutionDUnitTest.this.getSystem(props);
                TestCase.assertNotNull((Object)ds);
                ds.disconnect();
                ds = PRFunctionExecutionDUnitTest.this.getSystem(props);
                cache = CacheFactory.create((DistributedSystem)ds);
                TestCase.assertNotNull((Object)cache);
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                Region pr = cache.createRegion(rName, raf.create());
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                TestFunction function = new TestFunction(true, "TestFunction1");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector result = dataSet.withArgs((Object)Boolean.TRUE).withFilter(testKeysSet).execute((Function)function);
                System.out.println("KBKBKB : Result I got : " + result.getResult());
                return Boolean.TRUE;
            }
        });
    }

    public void testHAFunctionExecution() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        this.getCache();
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                Region pr = PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                TestFunction function = new TestFunction(false, "TestFunction10");
                try {
                    FunctionService.registerFunction((Function)function);
                    TestCase.fail((String)"It should have failed with Function attributes don't match");
                }
                catch (Exception expected) {
                    expected.printStackTrace();
                    TestCase.assertTrue((boolean)expected.getMessage().contains("For Functions with isHA true, hasResult must also be true."));
                }
                try {
                    Execution dataSet = FunctionService.onRegion((Region)pr);
                    dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute((Function)function);
                    TestCase.fail((String)"It should have failed with Function attributes don't match");
                }
                catch (Exception expected) {
                    expected.printStackTrace();
                    TestCase.assertTrue((boolean)expected.getMessage().contains("For Functions with isHA true, hasResult must also be true."));
                }
                return Boolean.TRUE;
            }
        });
    }

    public void testRemoteSingleKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute(function.getId());
                TestCase.assertEquals((Object)new Integer(1), ((List)rs2.getResult()).get(0));
                HashMap<String, Integer> putData = new HashMap<String, Integer>();
                putData.put("execKey1", new Integer(2));
                putData.put("execKey2", new Integer(3));
                ResultCollector rs3 = dataSet.withFilter(testKeysSet).withArgs(putData).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs3.getResult()).get(0));
                TestCase.assertEquals((Object)new Integer(2), (Object)pr.get((Object)"execKey1"));
                TestCase.assertEquals((Object)new Integer(3), (Object)pr.get((Object)"execKey2"));
                return Boolean.TRUE;
            }
        });
    }

    public void testLocalSingleKeyExecution_byName_FunctionInvocationTargetException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        this.getCache();
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                Region pr = PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                try {
                    ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    ArrayList list = (ArrayList)rs1.getResult();
                    TestCase.assertEquals(list.get(0), (Object)5);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("This is not expected Exception", e);
                }
                return Boolean.TRUE;
            }
        });
    }

    public void testRemoteSingleKeyExecution_byName_FunctionInvocationTargetException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                try {
                    ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    ArrayList list = (ArrayList)rs1.getResult();
                    TestCase.assertEquals(list.get(0), (Object)5);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("This is not expected Exception", e);
                }
                return Boolean.TRUE;
            }
        });
    }

    public void testRemoteSingleKeyExecution_byInstance() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute((Function)function);
                TestCase.assertEquals((Object)new Integer(1), ((List)rs2.getResult()).get(0));
                HashMap<String, Integer> putData = new HashMap<String, Integer>();
                putData.put("execKey1", new Integer(2));
                putData.put("execKey2", new Integer(3));
                ResultCollector rs3 = dataSet.withFilter(testKeysSet).withArgs(putData).execute((Function)function);
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs3.getResult()).get(0));
                TestCase.assertEquals((Object)new Integer(2), (Object)pr.get((Object)"execKey1"));
                TestCase.assertEquals((Object)new Integer(3), (Object)pr.get((Object)"execKey2"));
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteSingleKeyExecution_byInlineFunction() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context.getArguments() instanceof String) {
                            context.getResultSender().lastResult((Object)"Success");
                        } else if (context.getArguments() instanceof Boolean) {
                            context.getResultSender().lastResult((Object)Boolean.TRUE);
                        }
                    }

                    public String getId() {
                        return ((Object)((Object)this)).getClass().getName();
                    }

                    public boolean hasResult() {
                        return true;
                    }
                });
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("No target node found for KEY"));
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)3, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_BucketMoved() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(113);
                paf.setLocalMaxMemory(0);
                paf.setRedundantCopies(1);
                paf.setStartupRecoveryDelay(0L);
                PartitionAttributes partitionAttributes = paf.create();
                factory.setDataPolicy(DataPolicy.PARTITION);
                factory.setPartitionAttributes(partitionAttributes);
                RegionAttributes attrs = factory.create();
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, attrs);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(113);
                paf.setLocalMaxMemory(40);
                paf.setRedundantCopies(1);
                paf.setStartupRecoveryDelay(0L);
                PartitionAttributes partitionAttributes = paf.create();
                factory.setDataPolicy(DataPolicy.PARTITION);
                factory.setPartitionAttributes(partitionAttributes);
                RegionAttributes attrs = factory.create();
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, attrs);
                TestFunction function = new TestFunction(true, "executeFunctionWithLastResult");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        SerializableCallable put = new SerializableCallable("put in PR"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                for (int i = 0; i < 113; ++i) {
                    pr.put((Object)i, (Object)("execKey-" + i));
                }
                return Boolean.TRUE;
            }
        };
        accessor.invoke(put);
        datastore2.invoke(dataStoreCreate);
        Object result = accessor.invoke(new SerializableCallable("invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionWithLastResult");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc2 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc2.getResult();
                return l;
            }
        });
        List l = (List)result;
        PRFunctionExecutionDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testLocalMultiKeyExecution_BucketMoved() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                AttributesFactory factory = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setTotalNumBuckets(113);
                paf.setLocalMaxMemory(40);
                paf.setRedundantCopies(0);
                paf.setStartupRecoveryDelay(0L);
                PartitionAttributes partitionAttributes = paf.create();
                factory.setDataPolicy(DataPolicy.PARTITION);
                factory.setPartitionAttributes(partitionAttributes);
                RegionAttributes attrs = factory.create();
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, attrs);
                TestFunction function = new TestFunction(true, "executeFunctionWithLastResult");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        SerializableCallable put = new SerializableCallable("put in PR"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                for (int i = 0; i < 113; ++i) {
                    pr.put((Object)i, (Object)("execKey-" + i));
                }
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(put);
        datastore1.invoke(dataStoreCreate);
        Object result = datastore0.invoke(new SerializableCallable("invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionWithLastResult");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc2 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc2.getResult();
                return l;
            }
        });
        List l = (List)result;
        PRFunctionExecutionDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testRemoteMultipleKeyExecution_byName_FunctionInvocationTargetException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionReexecuteException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                try {
                    ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    ArrayList list = (ArrayList)rs.getResult();
                    TestCase.assertEquals(list.get(0), (Object)5);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("This is not expected Exception", e);
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionHA_CacheClose() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                cache = PRFunctionExecutionDUnitTest.this.getCache();
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)1, (int)0);
                cache.createRegion(rName, ra);
                regionName = rName;
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)1, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionHA");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = accessor.invokeAsync(PRFunctionExecutionDUnitTest.class, "executeFunction");
        o = datastore0.invoke(new SerializableCallable("close cache"){

            public Object call() throws Exception {
                long startTime = System.currentTimeMillis();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        return false;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 200L, false);
                long endTime = System.currentTimeMillis();
                PRFunctionExecutionDUnitTest.this.getCache().getLogger().fine("Time wait for Cache Close = " + (endTime - startTime));
                PRFunctionExecutionDUnitTest.this.getCache().close();
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
        DistributedTestCase.join(async[0], 60000L, PRFunctionExecutionDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRFunctionExecutionDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRFunctionExecutionDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public void testRemoteMultiKeyExecutionHA_Disconnect() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                cache = PRFunctionExecutionDUnitTest.this.getCache();
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)1, (int)0);
                cache.createRegion(rName, ra);
                regionName = rName;
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)1, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionHA");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
        int AsyncInvocationArrSize = 1;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = accessor.invokeAsync(PRFunctionExecutionDUnitTest.class, "executeFunction");
        o = datastore0.invoke(new SerializableCallable("disconnect"){

            public Object call() throws Exception {
                long startTime = System.currentTimeMillis();
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        return false;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 3000L, 200L, false);
                long endTime = System.currentTimeMillis();
                PRFunctionExecutionDUnitTest.this.getCache().getLogger().fine("Time wait for Cache Close = " + (endTime - startTime));
                PRFunctionExecutionDUnitTest.this.getCache().getDistributedSystem().disconnect();
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
        DistributedTestCase.join(async[0], 60000L, PRFunctionExecutionDUnitTest.getLogWriter());
        if (async[0].getException() != null) {
            PRFunctionExecutionDUnitTest.fail("UnExpected Exception Occured : ", async[0].getException());
        }
        List l = (List)async[0].getReturnValue();
        PRFunctionExecutionDUnitTest.assertEquals((int)2, (int)l.size());
    }

    public static Object executeFunction() {
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionName);
        HashSet<String> testKeysSet = new HashSet<String>();
        for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
            testKeysSet.add("execKey-" + i);
        }
        TestFunction function = new TestFunction(true, "executeFunctionHA");
        FunctionService.registerFunction((Function)function);
        Execution dataSet = FunctionService.onRegion((Region)pr);
        ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
        List l = (List)rs.getResult();
        return l;
    }

    public void testRemoteMultiKeyExecution_byInlineFunction() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context.getArguments() instanceof String) {
                            context.getResultSender().lastResult((Object)"Success");
                        } else if (context.getArguments() instanceof Boolean) {
                            context.getResultSender().lastResult((Object)Boolean.TRUE);
                        }
                    }

                    public String getId() {
                        return ((Object)((Object)this)).getClass().getName();
                    }

                    public boolean hasResult() {
                        return true;
                    }
                });
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionWithCollector_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                dataSet.withCollector((ResultCollector)new CustomResultCollector());
                int j = 0;
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionNoResult_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(false, PRFunctionExecutionDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(false, PRFunctionExecutionDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                try {
                    ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    rs.getResult();
                }
                catch (Exception expected) {
                    expected.printStackTrace();
                    TestCase.assertTrue((boolean)expected.getMessage().startsWith(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_timeout() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)"TestingTimeOut").execute(function.getId());
                List l = (List)rs.getResult(10000L, TimeUnit.MILLISECONDS);
                TestCase.assertEquals((int)3, (int)l.size());
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionWithCollectorNoResult_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(false, PRFunctionExecutionDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(false, PRFunctionExecutionDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                dataSet.withCollector((ResultCollector)new CustomResultCollector());
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                try {
                    ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    rs.getResult();
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().startsWith(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_byInstance() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                }
                catch (Exception expected) {
                    DistributedTestCase.getLogWriter().warning("Exception Occured : " + expected.getMessage());
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute((Function)function);
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)3, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM localOnly = host.getVM(3);
        this.getCache();
        Object o = localOnly.invoke(new SerializableCallable("Create PR, validate local execution)"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)1, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeys).withArgs(testKeys).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)1, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalMultiKeyExecution_byInstance() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM localOnly = host.getVM(3);
        this.getCache();
        Object o = localOnly.invoke(new SerializableCallable("Create PR, validate local execution)"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute((Function)function);
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)1, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeys).withArgs(testKeys).execute((Function)function);
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)1, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testMultiKeyExecutionOnASingleBucket_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                Iterator kiter = testKeys.iterator();
                while (kiter.hasNext()) {
                    Set singleKeySet = Collections.singleton(kiter.next());
                    TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                    FunctionService.registerFunction((Function)function);
                    Execution dataSet = FunctionService.onRegion((Region)pr);
                    ResultCollector rc1 = dataSet.withFilter(singleKeySet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    List l = (List)rc1.getResult();
                    TestCase.assertEquals((int)1, (int)l.size());
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                    ResultCollector rc2 = dataSet.withFilter(singleKeySet).withArgs(new HashSet(singleKeySet)).execute(function.getId());
                    List l2 = (List)rc2.getResult();
                    TestCase.assertEquals((int)1, (int)l2.size());
                    List subList = (List)l2.iterator().next();
                    TestCase.assertEquals((int)1, (int)subList.size());
                    TestCase.assertEquals((Object)pr.get(singleKeySet.iterator().next()), subList.iterator().next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testMultiKeyExecutionOnASingleBucket_byInstance() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                Iterator kiter = testKeys.iterator();
                while (kiter.hasNext()) {
                    Set singleKeySet = Collections.singleton(kiter.next());
                    TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                    FunctionService.registerFunction((Function)function);
                    Execution dataSet = FunctionService.onRegion((Region)pr);
                    ResultCollector rc1 = dataSet.withFilter(singleKeySet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                    List l = (List)rc1.getResult();
                    TestCase.assertEquals((int)1, (int)l.size());
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                    ResultCollector rc2 = dataSet.withFilter(singleKeySet).withArgs(new HashSet(singleKeySet)).execute((Function)function);
                    List l2 = (List)rc2.getResult();
                    TestCase.assertEquals((int)1, (int)l2.size());
                    List subList = (List)l2.iterator().next();
                    TestCase.assertEquals((int)1, (int)subList.size());
                    TestCase.assertEquals((Object)pr.get(singleKeySet.iterator().next()), subList.iterator().next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                DistributedTestCase.getLogWriter().info("PRFunctionExecutionDUnitTest#testExecutionOnAllNodes_byName : Result size :" + l.size() + " Result : " + l);
                TestCase.assertEquals((int)4, (int)l.size());
                for (int i2 = 0; i2 < 4; ++i2) {
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_byInstance() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM accessor = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                TestFunction function = new TestFunction(true, PRFunctionExecutionDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute((Function)function);
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                for (int i2 = 0; i2 < 3; ++i2) {
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_byInlineFunction() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context.getArguments() instanceof String) {
                            context.getResultSender().lastResult((Object)"Success");
                        } else if (context.getArguments() instanceof Boolean) {
                            context.getResultSender().lastResult((Object)Boolean.TRUE);
                        }
                    }

                    public String getId() {
                        return ((Object)((Object)this)).getClass().getName();
                    }

                    public boolean hasResult() {
                        return true;
                    }
                });
                List l = (List)rc1.getResult();
                DistributedTestCase.getLogWriter().info("PRFunctionExecutionDUnitTest#testExecutionOnAllNodes_byName : Result size :" + l.size() + " Result : " + l);
                TestCase.assertEquals((int)4, (int)l.size());
                Iterator iterator = l.iterator();
                for (int i2 = 0; i2 < 4; ++i2) {
                    TestCase.assertEquals((Object)Boolean.TRUE, iterator.next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testBug40714() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                FunctionService.registerFunction((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context.getArguments() instanceof String) {
                            context.getResultSender().lastResult((Object)"Failure");
                        } else if (context.getArguments() instanceof Boolean) {
                            context.getResultSender().lastResult((Object)Boolean.FALSE);
                        }
                    }

                    public String getId() {
                        return "Function";
                    }

                    public boolean hasResult() {
                        return true;
                    }
                });
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute((Function)new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        if (context.getArguments() instanceof String) {
                            context.getResultSender().lastResult((Object)"Success");
                        } else if (context.getArguments() instanceof Boolean) {
                            context.getResultSender().lastResult((Object)Boolean.TRUE);
                        }
                    }

                    public String getId() {
                        return "Function";
                    }

                    public boolean hasResult() {
                        return true;
                    }
                });
                List l = (List)rc1.getResult();
                DistributedTestCase.getLogWriter().info("PRFunctionExecutionDUnitTest#testExecutionOnAllNodes_byName : Result size :" + l.size() + " Result : " + l);
                TestCase.assertEquals((int)4, (int)l.size());
                Iterator iterator = l.iterator();
                for (int i2 = 0; i2 < 4; ++i2) {
                    Boolean res = (Boolean)iterator.next();
                    TestCase.assertEquals((Object)Boolean.TRUE, (Object)res);
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_LocalReadPR() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                pa.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<CustId> testKeys = new HashSet<CustId>();
                for (int i = 1; i <= 10; ++i) {
                    CustId custid = new CustId(i);
                    Customer customer = new Customer("name" + i, "Address" + i);
                    try {
                        pr.put((Object)custid, (Object)customer);
                        TestCase.assertNotNull((Object)pr.get((Object)custid));
                        TestCase.assertEquals((Object)customer, (Object)pr.get((Object)custid));
                        testKeys.add(custid);
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
                    }
                }
                TestFunction function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs(testKeys).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)4, (int)l.size());
                ArrayList vals = new ArrayList();
                Iterator itr = l.iterator();
                for (int i = 0; i < 4; ++i) {
                    vals.addAll((ArrayList)itr.next());
                }
                TestCase.assertEquals((int)vals.size(), (int)testKeys.size());
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnMultiNodes_LocalReadPR() throws Exception {
        String rName1 = "CustomerPartitionedRegionName";
        String rName2 = "OrderPartitionedRegionName";
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate1 = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                pa.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion("CustomerPartitionedRegionName", raf.create());
                TestFunction function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        SerializableCallable dataStoreCreate2 = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                pa.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                pa.setColocatedWith("CustomerPartitionedRegionName");
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion("OrderPartitionedRegionName", raf.create());
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate1);
        datastore1.invoke(dataStoreCreate1);
        datastore2.invoke(dataStoreCreate1);
        datastore3.invoke(dataStoreCreate1);
        datastore0.invoke(dataStoreCreate2);
        datastore1.invoke(dataStoreCreate2);
        datastore2.invoke(dataStoreCreate2);
        datastore3.invoke(dataStoreCreate2);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion("CustomerPartitionedRegionName");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<CustId> testKeys = new HashSet<CustId>();
                for (int i = 1; i <= 100; ++i) {
                    CustId custid = new CustId(i);
                    Customer customer = new Customer("name" + i, "Address" + i);
                    try {
                        pr.put((Object)custid, (Object)customer);
                        TestCase.assertNotNull((Object)pr.get((Object)custid));
                        TestCase.assertEquals((Object)customer, (Object)pr.get((Object)custid));
                        if (i <= 5) continue;
                        testKeys.add(custid);
                        continue;
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
                    }
                }
                PartitionedRegion partitionedregion = (PartitionedRegion)PRFunctionExecutionDUnitTest.this.getCache().getRegion("OrderPartitionedRegionName");
                TestCase.assertNotNull((Object)partitionedregion);
                for (int i = 1; i <= 100; ++i) {
                    CustId custid = new CustId(i);
                    for (int j = 1; j <= 10; ++j) {
                        int oid = i * 10 + j;
                        OrderId orderId = new OrderId(oid, custid);
                        Order order = new Order("OREDR" + oid);
                        try {
                            partitionedregion.put((Object)orderId, (Object)order);
                            continue;
                        }
                        catch (Exception e) {
                            DistributedTestCase.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                        }
                    }
                }
                TestFunction function = new TestFunction(true, "TestFunction3");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withFilter(testKeys).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertTrue((4 >= l.size() ? 1 : 0) != 0);
                ArrayList vals = new ArrayList();
                Iterator itr = l.iterator();
                for (int i = 0; i < l.size(); ++i) {
                    vals.addAll((ArrayList)itr.next());
                }
                TestCase.assertEquals((int)testKeys.size(), (int)vals.size());
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalDataContext() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(1);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        this.getCache();
        final Integer key1 = new Integer(1);
        final Integer key2 = new Integer(2);
        SerializableCallable createDataStore = new SerializableCallable("Create datastore for " + rName){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        };
        datastore1.invoke(createDataStore);
        datastore2.invoke(createDataStore);
        accessor.invoke(new SerializableCallable("Create accessor for " + rName + ", create buckets"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                Region pr = PRFunctionExecutionDUnitTest.this.getCache().createRegion(rName, ra);
                pr.put((Object)key1, (Object)key1);
                pr.put((Object)key2, (Object)key2);
                return Boolean.TRUE;
            }
        });
        SerializableCallable assertFuncionContext = new SerializableCallable("Invoke function, assert context"){

            public Object call() throws Exception {
                Region r = PRFunctionExecutionDUnitTest.this.getCache().getRegion(rName);
                FunctionAdapter f = new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        RegionFunctionContext rContext = (RegionFunctionContext)context;
                        TestCase.assertEquals(Collections.singleton(key1), (Object)rContext.getFilter());
                        TestCase.assertTrue((boolean)PartitionRegionHelper.isPartitionedRegion((Region)rContext.getDataSet()));
                        Region ld = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rContext);
                        TestCase.assertTrue((boolean)PartitionRegionHelper.getColocatedRegions((Region)ld).isEmpty());
                        TestCase.assertNull((Object)ld.get((Object)key2));
                        TestCase.assertEquals((Object)key1, (Object)ld.get((Object)key1));
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, ld.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, ld.values());
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, ld.entrySet());
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }

                    public String getId() {
                        return ((Object)((Object)this)).getClass().getName();
                    }
                };
                ArrayList res = (ArrayList)FunctionService.onRegion((Region)r).withFilter(Collections.singleton(key1)).execute((Function)f).getResult();
                TestCase.assertEquals((int)1, (int)res.size());
                return res.get(0);
            }
        };
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)accessor.invoke(assertFuncionContext)));
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)datastore1.invoke(assertFuncionContext)));
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)datastore2.invoke(assertFuncionContext)));
    }

    public void testLocalDataContextWithColocation() throws Exception {
        String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(1);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        this.getCache();
        final Integer key1 = new Integer(1);
        final Integer key2 = new Integer(2);
        final String rName_top = rName + "_top";
        final String rName_colo1 = rName + "_colo1";
        final String rName_colo2 = rName + "_colo2";
        SerializableCallable createDataStore = new SerializableCallable("Create datastore for " + rName + " with colocated Regions"){

            public Object call() throws Exception {
                PRFunctionExecutionDUnitTest.this.createRootRegion(rName_top, PRFunctionExecutionDUnitTest.this.createColoRegionAttrs(0, 10, null));
                RegionAttributes colo = PRFunctionExecutionDUnitTest.this.createColoRegionAttrs(0, 10, rName_top);
                PRFunctionExecutionDUnitTest.this.createRootRegion(rName_colo1, colo);
                PRFunctionExecutionDUnitTest.this.createRegion(rName_colo2, colo);
                return Boolean.TRUE;
            }
        };
        datastore1.invoke(createDataStore);
        datastore2.invoke(createDataStore);
        accessor.invoke(new SerializableCallable("Create accessor for " + rName + " with colocated Regions and create buckets"){

            public Object call() throws Exception {
                Region rtop = PRFunctionExecutionDUnitTest.this.createRootRegion(rName_top, PRFunctionExecutionDUnitTest.this.createColoRegionAttrs(0, 0, null));
                RegionAttributes colo = PRFunctionExecutionDUnitTest.this.createColoRegionAttrs(0, 0, rName_top);
                Region rc1 = PRFunctionExecutionDUnitTest.this.createRootRegion(rName_colo1, colo);
                Region rc2 = PRFunctionExecutionDUnitTest.this.createRegion(rName_colo2, colo);
                rtop.put((Object)key1, (Object)key1);
                rtop.put((Object)key2, (Object)key2);
                rc1.put((Object)key1, (Object)key1);
                rc1.put((Object)key2, (Object)key2);
                rc2.put((Object)key1, (Object)key1);
                rc2.put((Object)key2, (Object)key2);
                return Boolean.TRUE;
            }
        });
        SerializableCallable assertFuncionContext = new SerializableCallable("Invoke function, assert context with colocation"){

            public Object call() throws Exception {
                Region r = PRFunctionExecutionDUnitTest.this.getRootRegion(rName_top);
                FunctionAdapter f = new FunctionAdapter(){

                    public void execute(FunctionContext context) {
                        RegionFunctionContext rContext = (RegionFunctionContext)context;
                        TestCase.assertEquals(Collections.singleton(key1), (Object)rContext.getFilter());
                        TestCase.assertTrue((boolean)PartitionRegionHelper.isPartitionedRegion((Region)rContext.getDataSet()));
                        Region pr = rContext.getDataSet();
                        Map prColos = PartitionRegionHelper.getColocatedRegions((Region)pr);
                        Region ld = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)rContext);
                        Map ldColos = PartitionRegionHelper.getColocatedRegions((Region)ld);
                        TestCase.assertFalse((boolean)prColos.containsKey(rName_top));
                        TestCase.assertFalse((boolean)ldColos.containsKey(rName_top));
                        Region c1 = PRFunctionExecutionDUnitTest.this.getRootRegion(rName_colo1);
                        Region c2 = PRFunctionExecutionDUnitTest.this.getRootRegion().getSubregion(rName_colo2);
                        TestCase.assertSame((Object)c1, prColos.get(c1.getFullPath()));
                        Region lc = PartitionRegionHelper.getLocalData((Region)c1);
                        TestCase.assertTrue((boolean)(lc instanceof LocalDataSet));
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, lc.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, lc.values());
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, lc.entrySet());
                        TestCase.assertSame((Object)c2, prColos.get(c2.getFullPath()));
                        lc = PartitionRegionHelper.getLocalData((Region)c2);
                        TestCase.assertTrue((boolean)(lc instanceof LocalDataSet));
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, lc.entrySet());
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, lc.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, lc.values());
                        Region lc1 = (Region)ldColos.get(c1.getFullPath());
                        TestCase.assertEquals((String)c1.getFullPath(), (String)lc1.getFullPath());
                        TestCase.assertTrue((boolean)(lc1 instanceof LocalDataSet));
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, lc1.entrySet());
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, lc1.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, lc1.values());
                        Region lc2 = (Region)ldColos.get(c2.getFullPath());
                        TestCase.assertEquals((String)c2.getFullPath(), (String)lc2.getFullPath());
                        TestCase.assertTrue((boolean)(lc2 instanceof LocalDataSet));
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, lc2.entrySet());
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, lc2.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, lc2.values());
                        TestCase.assertNull((Object)ld.get((Object)key2));
                        TestCase.assertEquals((Object)key1, (Object)ld.get((Object)key1));
                        PRFunctionExecutionDUnitTest.assertLocalEntrySet(key1, ld.entrySet());
                        PRFunctionExecutionDUnitTest.assertLocalKeySet(key1, ld.keySet());
                        PRFunctionExecutionDUnitTest.assertLocalValues(key1, ld.values());
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }

                    public String getId() {
                        return ((Object)((Object)this)).getClass().getName();
                    }
                };
                ArrayList res = (ArrayList)FunctionService.onRegion((Region)r).withFilter(Collections.singleton(key1)).execute((Function)f).getResult();
                TestCase.assertEquals((int)1, (int)res.size());
                return res.get(0);
            }
        };
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)accessor.invoke(assertFuncionContext)));
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)datastore1.invoke(assertFuncionContext)));
        PRFunctionExecutionDUnitTest.assertTrue((boolean)((Boolean)datastore2.invoke(assertFuncionContext)));
    }

    public void testBug41118() {
        Host host = Host.getHost(0);
        VM lonerVM = host.getVM(1);
        lonerVM.invoke(PRFunctionExecutionDUnitTest.class, "bug41118");
    }

    public static void bug41118() {
        InternalDistributedSystem ds = new PRFunctionExecutionDUnitTest("temp").getSystem();
        PRFunctionExecutionDUnitTest.assertNotNull((Object)ds);
        ds.disconnect();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        ds = (InternalDistributedSystem)DistributedSystem.connect((Properties)props);
        DM dm = ds.getDistributionManager();
        PRFunctionExecutionDUnitTest.assertEquals((String)"Distributed System is not loner", (boolean)true, (boolean)(dm instanceof LonerDistributionManager));
        Cache cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.PARTITION);
        PRFunctionExecutionDUnitTest.assertNotNull((Object)cache);
        Region region = cache.createRegion("PartitonedRegion", factory.create());
        for (int i = 0; i < 20; ++i) {
            region.put((Object)("KEY_" + i), (Object)("VALUE_" + i));
        }
        HashSet<String> keysForGet = new HashSet<String>();
        keysForGet.add("KEY_4");
        keysForGet.add("KEY_9");
        keysForGet.add("KEY_7");
        try {
            Execution execution = FunctionService.onRegion((Region)region).withFilter(keysForGet).withArgs((Object)Boolean.TRUE);
            ResultCollector rc = execution.execute((Function)new FunctionAdapter(){

                public void execute(FunctionContext fc) {
                    RegionFunctionContext context = (RegionFunctionContext)fc;
                    Set keys = context.getFilter();
                    HashSet keysTillSecondLast = new HashSet();
                    int setSize = keys.size();
                    Iterator keysIterator = keys.iterator();
                    for (int i = 0; i < setSize - 1; ++i) {
                        keysTillSecondLast.add(keysIterator.next());
                    }
                    for (Object k : keysTillSecondLast) {
                        context.getResultSender().sendResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context).get(k)));
                    }
                    Object lastResult = keysIterator.next();
                    context.getResultSender().lastResult((Object)((Serializable)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context).get(lastResult)));
                }

                public String getId() {
                    return ((Object)((Object)this)).getClass().getName();
                }
            });
            rc.getResult();
            ds.disconnect();
        }
        catch (Exception e) {
            PRFunctionExecutionDUnitTest.getLogWriter().info("Exception Occured : " + e.getMessage());
            e.printStackTrace();
            PRFunctionExecutionDUnitTest.fail("Test failed", e);
        }
    }

    public void testFunctionExecutionException_41779() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore1 = host.getVM(0);
        VM datastore2 = host.getVM(1);
        VM datastore3 = host.getVM(2);
        VM datastore4 = host.getVM(3);
        Cache cache = this.getCache();
        SerializableRunnable createFact = new SerializableRunnable("Create PR with Function Factory"){

            @Override
            public void run() {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionDUnitTest.this.getCache().createRegionFactory(raf.create()).create(rName);
                TestFunctionException function = new TestFunctionException();
                FunctionService.registerFunction((Function)function);
            }
        };
        datastore1.invoke(createFact);
        datastore2.invoke(createFact);
        datastore3.invoke(createFact);
        datastore4.invoke(createFact);
        createFact.run();
        InternalExecution exec = (InternalExecution)FunctionService.onRegion((Region)cache.getRegion(rName));
        exec.setWaitOnExceptionFlag(true);
        try {
            List results = (List)exec.execute("TestFunctionException").getResult();
            PRFunctionExecutionDUnitTest.fail((String)"expected a function exception");
        }
        catch (FunctionException fe) {
            PRFunctionExecutionDUnitTest.assertEquals((String)("did not get expected number of exceptions: " + fe.getExceptions()), (int)5, (int)fe.getExceptions().size());
        }
    }

    protected static void assertLocalValues(Integer value, Collection values) {
        PRFunctionExecutionDUnitTest.assertEquals((Object)values, Collections.singleton(value));
        PRFunctionExecutionDUnitTest.assertTrue((boolean)values.contains(value));
        PRFunctionExecutionDUnitTest.assertEquals((int)1, (int)values.size());
        Iterator vsi = values.iterator();
        PRFunctionExecutionDUnitTest.assertTrue((boolean)vsi.hasNext());
        PRFunctionExecutionDUnitTest.assertEquals((Object)value, vsi.next());
        PRFunctionExecutionDUnitTest.assertFalse((boolean)vsi.hasNext());
    }

    protected static void assertLocalKeySet(Integer key, Set keySet) {
        PRFunctionExecutionDUnitTest.assertEquals((Object)keySet, Collections.singleton(key));
        PRFunctionExecutionDUnitTest.assertEquals((int)1, (int)keySet.size());
    }

    protected static void assertLocalEntrySet(Integer key, Set entrySet) {
        PRFunctionExecutionDUnitTest.assertEquals((int)1, (int)entrySet.size());
        Iterator esi = entrySet.iterator();
        PRFunctionExecutionDUnitTest.assertTrue((boolean)esi.hasNext());
        Region.Entry re = (Region.Entry)esi.next();
        if (re instanceof EntrySnapshot) {
            PRFunctionExecutionDUnitTest.assertTrue((boolean)((EntrySnapshot)re).wasInitiallyLocal());
        } else {
            PRFunctionExecutionDUnitTest.assertTrue((boolean)re.isLocal());
        }
        PRFunctionExecutionDUnitTest.assertEquals((Object)key, (Object)re.getKey());
        PRFunctionExecutionDUnitTest.assertEquals((Object)key, (Object)re.getValue());
        PRFunctionExecutionDUnitTest.assertFalse((boolean)esi.hasNext());
    }

    protected RegionAttributes createColoRegionAttrs(int red, int mem, String coloRegion) {
        TestResolver resolver = new TestResolver();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setRedundantCopies(red).setLocalMaxMemory(mem).setColocatedWith(coloRegion).create());
        return attr.create();
    }

    public static class TestResolver
    implements PartitionResolver,
    Serializable {
        public String getName() {
            return "ResolverName_" + this.getClass().getName();
        }

        public Serializable getRoutingObject(EntryOperation opDetails) {
            return (Serializable)opDetails.getKey();
        }

        public void close() {
        }

        public Properties getProperties() {
            return new Properties();
        }
    }

    public static class TestFunctionException
    implements Function {
        private static final long serialVersionUID = 3745637361374073217L;
        static final String ID = "TestFunctionException";

        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            for (int index = 0; index < 5; ++index) {
                context.getResultSender().sendResult((Object)index);
            }
            throw new NullPointerException("simulated exception with myId: " + GemFireCacheImpl.getInstance().getMyId());
        }

        public String getId() {
            return ID;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }
}

