/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import com.gemstone.gemfire.internal.cache.execute.CustomResultCollector;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PRFunctionExecutionTimeOutDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static final String TEST_FUNCTION_TIMEOUT = "executeTimeOut";
    private static final String TEST_FUNCTION7 = "TestFunction7";
    private static final long serialVersionUID = 1L;

    public PRFunctionExecutionTimeOutDUnitTest(String name) {
        super(name);
    }

    public void testRemoteSingleKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                try {
                    rs1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute(function.getId());
                TestCase.assertEquals((Object)new Integer(1), ((List)rs2.getResult()).get(0));
                try {
                    rs1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                HashMap<String, Integer> putData = new HashMap<String, Integer>();
                putData.put("execKey1", new Integer(2));
                putData.put("execKey2", new Integer(3));
                ResultCollector rs3 = dataSet.withFilter(testKeysSet).withArgs(putData).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs3.getResult(4000L, TimeUnit.MILLISECONDS)).get(0));
                try {
                    rs1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                TestCase.assertEquals((Object)new Integer(2), (Object)pr.get((Object)"execKey1"));
                TestCase.assertEquals((Object)new Integer(3), (Object)pr.get((Object)"execKey2"));
                ResultCollector rst1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    rst1.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected timeout exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rst1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                ResultCollector rst2 = dataSet.withFilter(testKeysSet).withArgs((Object)"execKey").execute(function.getId());
                try {
                    rst2.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected timeout exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rst2.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                HashMap<String, Integer> putDataTimeOut = new HashMap<String, Integer>();
                putDataTimeOut.put("execKey4", new Integer(4));
                putDataTimeOut.put("execKey5", new Integer(5));
                ResultCollector rst3 = dataSet.withFilter(testKeysSet).withArgs(putDataTimeOut).execute(function.getId());
                try {
                    rst3.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected timeout exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rst3.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((String)expected.getMessage(), (boolean)expected.getMessage().contains("No target node found for KEY"));
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                try {
                    rs.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                ResultCollector rc2 = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)3, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                try {
                    rc2.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                ResultCollector rst = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    rst.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rst.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                ResultCollector rct2 = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute(function.getId());
                try {
                    rct2.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rct2.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionWithCollector_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                dataSet.withCollector((ResultCollector)new CustomResultCollector());
                int j = 0;
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rst = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    rst.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rst.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecutionNoResult_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(false, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(false, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION7);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                try {
                    ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                    rs.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().startsWith(LocalizedStrings.ExecuteFunction_CANNOT_0_RESULTS_HASRESULT_FALSE.toLocalizedString(new Object[]{"return any"})));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_timeout() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)"TestingTimeOut").execute(function.getId());
                List l = (List)rs.getResult(8000L, TimeUnit.MILLISECONDS);
                TestCase.assertEquals((int)3, (int)l.size());
                ResultCollector rst = dataSet.withFilter(testKeysSet).withArgs((Object)"TestingTimeOut").execute(function.getId());
                rst.getResult(8000L, TimeUnit.MILLISECONDS);
                TestCase.assertEquals((int)3, (int)l.size());
                try {
                    rs.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM localOnly = host.getVM(3);
        this.getCache();
        Object o = localOnly.invoke(new SerializableCallable("Create PR, validate local execution)"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)1, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeys).withArgs(testKeys).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)1, (int)l2.size());
                HashSet foundVals = new HashSet();
                for (ArrayList subL : l2) {
                    TestCase.assertTrue((subL.size() > 0 ? 1 : 0) != 0);
                    Iterator subI = subL.iterator();
                    while (subI.hasNext()) {
                        TestCase.assertTrue((boolean)foundVals.add(subI.next()));
                    }
                }
                TestCase.assertEquals(origVals, foundVals);
                ResultCollector rct1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    rct1.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains(LocalizedStrings.ExecuteFunction_RESULTS_NOT_COLLECTED_IN_TIME_PROVIDED.toLocalizedString()));
                }
                try {
                    rct1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString()));
                }
                ResultCollector rct2 = dataSet.withFilter(testKeys).withArgs(testKeys).execute(function.getId());
                try {
                    rct2.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains(LocalizedStrings.ExecuteFunction_RESULTS_NOT_COLLECTED_IN_TIME_PROVIDED.toLocalizedString()));
                }
                try {
                    rct2.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains(LocalizedStrings.ExecuteFunction_RESULTS_ALREADY_COLLECTED.toLocalizedString()));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionTimeOutDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionTimeOutDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                TestFunction function = new TestFunction(true, PRFunctionExecutionTimeOutDUnitTest.TEST_FUNCTION_TIMEOUT);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)4, (int)l.size());
                for (int i2 = 0; i2 < 4; ++i2) {
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                }
                ResultCollector rct1 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    rct1.getResult(1000L, TimeUnit.MILLISECONDS);
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("All results not recieved in time provided."));
                }
                try {
                    rct1.getResult();
                    TestCase.fail((String)"Did not get the expected exception.");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((String)fe.getMessage(), (boolean)fe.getMessage().contains("Result already collected"));
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionTimeOutDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }
}

