/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class PRFunctionExecutionWithResultSenderDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static final String TEST_FUNCTION7 = "TestFunction7";
    private static final String TEST_FUNCTION2 = "TestFunction2";
    private static final long serialVersionUID = 1L;

    public PRFunctionExecutionWithResultSenderDUnitTest(String name) {
        super(name);
    }

    public void testRemoteSingleKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        Cache c = this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionWithResultSenderDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, PRFunctionExecutionWithResultSenderDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                pr.put((Object)"execKey", (Object)new Integer(1));
                pr.put((Object)"execKey3", (Object)new Integer(3));
                pr.put((Object)"execKey4", (Object)new Integer(4));
                testKeysSet.add("execKey3");
                testKeysSet.add("execKey4");
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                ResultCollector rs2 = dataSet.withFilter(testKeysSet).withArgs((Object)testKeysSet).execute(function.getId());
                HashMap<String, Integer> putData = new HashMap<String, Integer>();
                putData.put("execKey1", new Integer(2));
                putData.put("execKey2", new Integer(3));
                ResultCollector rs3 = dataSet.withFilter(testKeysSet).withArgs(putData).execute(function.getId());
                TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs3.getResult()).get(0));
                TestCase.assertEquals((Object)new Integer(2), (Object)pr.get((Object)"execKey1"));
                TestCase.assertEquals((Object)new Integer(3), (Object)pr.get((Object)"execKey2"));
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteExecution_NoLastResult() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        Cache c = this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                pr.put((Object)"execKey3", (Object)new Integer(3));
                pr.put((Object)"execKey4", (Object)new Integer(4));
                testKeysSet.add("execKey3");
                testKeysSet.add("execKey4");
                ResultCollector rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    TestCase.assertEquals((Object)Boolean.TRUE, ((List)rs1.getResult()).get(0));
                    TestCase.fail((String)"Expected FunctionException : Function did not send last result");
                }
                catch (FunctionException fe) {
                    TestCase.assertTrue((boolean)fe.getMessage().contains("did not send last result"));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        Cache c = this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "TestFunction9");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().getRegion(rName);
                HashSet<String> testKeysSet = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeysSet.add("execKey-" + i);
                }
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "TestFunction9");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = "));
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeysSet.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rs = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rs.getResult();
                TestCase.assertEquals((int)3, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeysSet).withArgs(testKeysSet).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)(pr.getTotalNumberOfBuckets() * 2 * 3), (int)l2.size());
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalMultiKeyExecution_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM localOnly = host.getVM(3);
        Cache c = this.getCache();
        Object o = localOnly.invoke(new SerializableCallable("Create PR, validate local execution)"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "TestFunction9");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                try {
                    dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute(function.getId());
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().contains("No target node found for KEY = execKey"));
                }
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                TestCase.assertEquals((int)1, (int)l.size());
                Iterator i2 = l.iterator();
                while (i2.hasNext()) {
                    TestCase.assertEquals((Object)Boolean.TRUE, i2.next());
                }
                ResultCollector rc2 = dataSet.withFilter(testKeys).withArgs(testKeys).execute(function.getId());
                List l2 = (List)rc2.getResult();
                TestCase.assertEquals((int)226, (int)l2.size());
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testLocalExecution_NoLastResult() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM localOnly = host.getVM(0);
        Cache c = this.getCache();
        Object o = localOnly.invoke(new SerializableCallable("Create PR, validate local execution)"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                String testKey = "execKey";
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 2; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                HashSet<Integer> origVals = new HashSet<Integer>();
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    origVals.add(val);
                    pr.put(i.next(), (Object)val);
                }
                ResultCollector rc1 = dataSet.withFilter(testKeys).withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    TestCase.assertEquals((Object)Boolean.TRUE, ((List)rc1.getResult()).get(0));
                    TestCase.fail((String)"Expected FunctionException : Function did not send last result");
                }
                catch (Exception fe) {
                    TestCase.assertTrue((boolean)fe.getMessage().contains("did not send last result"));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_NoLastResult() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                TestFunction function = new TestFunction(true, "executeFunctionWithoutLastResult");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                try {
                    TestCase.assertEquals((Object)Boolean.TRUE, ((List)rc1.getResult()).get(0));
                    TestCase.fail((String)"Expected FunctionException : Function did not send last result");
                }
                catch (Exception fe) {
                    TestCase.assertTrue((boolean)fe.getMessage().contains("did not send last result"));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testExecutionOnAllNodes_byName() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                pa.setTotalNumBuckets(17);
                raf.setPartitionAttributes((PartitionAttributes)pa);
                PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "TestFunction9");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore3.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                HashSet<String> testKeys = new HashSet<String>();
                for (int i = pr.getTotalNumberOfBuckets() * 3; i > 0; --i) {
                    testKeys.add("execKey-" + i);
                }
                int j = 0;
                Iterator i = testKeys.iterator();
                while (i.hasNext()) {
                    Integer val = new Integer(j++);
                    pr.put(i.next(), (Object)val);
                }
                for (int bid = 0; bid < pr.getTotalNumberOfBuckets(); ++bid) {
                    TestCase.assertTrue((pr.getBucketKeys(bid).size() > 0 ? 1 : 0) != 0);
                }
                TestFunction function = new TestFunction(true, "TestFunction9");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                ResultCollector rc1 = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                List l = (List)rc1.getResult();
                DistributedTestCase.getLogWriter().info("PRFunctionExecutionDUnitTest#testExecutionOnAllNodes_byName : Result size :" + l.size() + " Result : " + l);
                TestCase.assertEquals((int)4, (int)l.size());
                for (int i2 = 0; i2 < 4; ++i2) {
                    TestCase.assertEquals((Object)Boolean.TRUE, l.iterator().next());
                }
                return Boolean.TRUE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    private RegionAttributes createColoRegionAttrs(int red, int mem, String coloRegion) {
        TestResolver resolver = new TestResolver();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)resolver).setRedundantCopies(red).setLocalMaxMemory(mem).setColocatedWith(coloRegion).create());
        return attr.create();
    }

    public void testlonerSystem_Bug41832() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        Object o = datastore.invoke(new SerializableCallable("Create region"){

            public Object call() throws Exception {
                PRFunctionExecutionWithResultSenderDUnitTest.this.createLonerCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setDataPolicy(DataPolicy.EMPTY);
                Region region = PRFunctionExecutionWithResultSenderDUnitTest.this.getCache().createRegion(rName, factory.create());
                TestFunction function = new TestFunction(true, PRFunctionExecutionWithResultSenderDUnitTest.TEST_FUNCTION2);
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)region);
                try {
                    ResultCollector rc = dataSet.withArgs((Object)Boolean.TRUE).execute(function.getId());
                    Object o = rc.getResult();
                    TestCase.fail((String)"Expected Function Exception");
                }
                catch (Exception expected) {
                    TestCase.assertTrue((boolean)expected.getMessage().startsWith("No Replicated Region found for executing function"));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        PRFunctionExecutionWithResultSenderDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public static class TestResolver
    implements PartitionResolver,
    Serializable {
        public String getName() {
            return "ResolverName_" + this.getClass().getName();
        }

        public Serializable getRoutingObject(EntryOperation opDetails) {
            return (Serializable)opDetails.getKey();
        }

        public void close() {
        }

        public Properties getProperties() {
            return new Properties();
        }
    }
}

