/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class TestFunction
extends FunctionAdapter {
    public static final String TEST_FUNCTION1 = "TestFunction1";
    public static final String TEST_FUNCTION2 = "TestFunction2";
    public static final String TEST_FUNCTION3 = "TestFunction3";
    public static final String TEST_FUNCTION4 = "TestFunction4";
    public static final String TEST_FUNCTION5 = "TestFunction5";
    private final Properties props = new Properties();
    private static final String ID = "id";
    private static final String HAVE_RESULTS = "haveResults";

    public TestFunction() {
    }

    public Properties getProps() {
        return this.props;
    }

    public TestFunction(boolean haveResults, String id) {
        this.props.setProperty(HAVE_RESULTS, Boolean.toString(haveResults));
        this.props.setProperty(ID, id);
    }

    public void execute(FunctionContext context) {
        String id = this.props.getProperty(ID);
        if (id.equals(TEST_FUNCTION1)) {
            this.execute1(context);
        } else if (id.equals(TEST_FUNCTION2)) {
            this.execute2(context);
        } else if (id.equals(TEST_FUNCTION3)) {
            this.execute2(context);
        } else if (id.equals(TEST_FUNCTION4)) {
            this.execute2(context);
        } else if (id.equals(TEST_FUNCTION5)) {
            this.execute5(context);
        }
    }

    public void execute1(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        logger.info("Executing executeException in TestFunction on Member : " + ds.getDistributedMember() + "with Context : " + context);
        context.getResultSender().lastResult((Object)((Serializable)context.getArguments()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute2(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        try {
            TestFunction testFunction = this;
            synchronized (testFunction) {
                ((Object)((Object)this)).wait(20000000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute5(FunctionContext context) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        LogWriter logger = ds.getLogWriter();
        if (this.props.get("TERMINATE") != null && this.props.get("TERMINATE").equals("YES")) {
            logger.info("Function Terminated");
        } else {
            try {
                TestFunction testFunction = this;
                synchronized (testFunction) {
                    logger.info("Function Running");
                    ((Object)((Object)this)).wait(20000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    public String getId() {
        return this.props.getProperty(ID);
    }

    public boolean hasResult() {
        return Boolean.valueOf(this.props.getProperty(HAVE_RESULTS));
    }

    public Properties getConfig() {
        return this.props;
    }

    public void init(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }
}

