/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute.data;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ShipmentId
implements DataSerializable {
    Integer shipmentId;
    OrderId orderId;

    public ShipmentId() {
    }

    public ShipmentId(int shipmentId, OrderId orderId) {
        this.shipmentId = new Integer(shipmentId);
        this.orderId = orderId;
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.shipmentId = DataSerializer.readInteger((DataInput)in);
        this.orderId = (OrderId)DataSerializer.readObject((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeInteger((Integer)this.shipmentId, (DataOutput)out);
        DataSerializer.writeObject((Object)this.orderId, (DataOutput)out);
    }

    public String toString() {
        return "(ShipmentId:" + this.shipmentId + " , " + this.orderId;
    }

    public OrderId getOrderId() {
        return this.orderId;
    }

    public void setOrderId(OrderId orderId) {
        this.orderId = orderId;
    }

    public Integer getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(Integer shipmentId) {
        this.shipmentId = shipmentId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShipmentId) {
            ShipmentId other = (ShipmentId)obj;
            if (this.orderId.equals(other.orderId) && this.shipmentId.equals(other.shipmentId)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.orderId.getCustId().hashCode();
    }
}

