/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.functions;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import dunit.DistributedTestCase;

public class DistributedRegionFunction
extends FunctionAdapter {
    public void execute(FunctionContext context) {
        RegionFunctionContext rcontext = (RegionFunctionContext)context;
        Region region = rcontext.getDataSet();
        InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
        sys.getLogWriter().fine("DistributedRegionFunction#execute( " + rcontext + " )");
        Assert.assertTrue((boolean)region.getAttributes().getDataPolicy().withStorage());
        Assert.assertTrue((region.getAttributes().getDataPolicy() != DataPolicy.NORMAL ? 1 : 0) != 0);
        Assert.assertTrue((rcontext.getFilter().size() == 20 ? 1 : 0) != 0);
        long startTime = System.currentTimeMillis();
        if (Boolean.TRUE.equals(rcontext.getArguments())) {
            if (!rcontext.isPossibleDuplicate()) {
                sys.disconnect();
                throw new CacheClosedException("Throwing CacheClosedException to simulate failover during function exception");
            }
        } else {
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                String excuse;

                @Override
                public boolean done() {
                    return false;
                }

                @Override
                public String description() {
                    return this.excuse;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 12000L, 500L, false);
        }
        long endTime = System.currentTimeMillis();
        region.put((Object)"execKey-201", (Object)new Integer(201));
        if (rcontext.isPossibleDuplicate()) {
            region.put((Object)"execKey-202", (Object)new Integer(202));
            region.put((Object)"execKey-203", (Object)new Integer(203));
        }
        sys.getLogWriter().fine("Time wait for Function Execution = " + (endTime - startTime));
        for (int i = 0; i < 5000; ++i) {
            context.getResultSender().sendResult((Object)Boolean.TRUE);
        }
        context.getResultSender().lastResult((Object)Boolean.TRUE);
    }

    public String getId() {
        return "DistributedRegionFunction";
    }

    public boolean isHA() {
        return true;
    }
}

